<!-- PHP Section Header -->
<?php 
    // if(isset($_REQUEST['id'])){
    //      $param_id = intval($_REQUEST['id']) ;  
    // }else{ 
    //     echo "Invalid request.";
    //     exit;
    // }  

        $request = array_keys($_REQUEST);
        $param_id = $request[2]; 
 
?>
<div class="tab-container bg-light">
    <div class="mb-3 mt-3" id="ticket_information_view">

        <div class="row">
            <div class="col-sm-8 p-0 m-0">
                <div class="embed-responsive embed-responsive-16by9" width="320" height="240">
                    <video controls controlsList="nodownload" id="video_el" class="video_el">
                        <!-- <source id="video_src"  type="video/mp4"> -->
                    </video>
                </div>

                <div class="mt-2 d-flex align-items-center">
                    <!-- Share Link Button -->
                    <button id="shareBtn" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-share-alt"></i> Share Link
                    </button>
                    <!-- Status message (hidden by default) -->
                    <span id="shareStatus" class="ms-2 text-success" style="display:none;">Link copied!</span>
                </div>


                <div class="mt-2">
                </div>
                <!-- <br> -->
                <span class="font-weight-bold text-lg" id="title"></span>
                <br>
                <span class="font-xs text-sm font-italic left-margin-5" id="user"></span>

                <hr class="mt-0 mb-2">
                <span class="font-weight-normal text-md">Category:</span>
                <span class="font-weight-bold text-md word-wrap m-0" id="lbl_category"> </span>
                <hr class="mt-0 mb-2">

                <div id="vehicle_info">
                    <span class="font-weight-bold text-md">VEHICLE INFORMATION</span>
                    <p class="font-weight-normal text-md m-0" id="v_view_brand_div">Brand: <span class="font-weight-bold" id="v_view_brand"></span> </p>
                    <p class="font-weight-normal text-md m-0" id="v_view_model_div">Model: <span class="font-weight-bold" id="v_view_model"></span></p>
                    <p class="font-weight-normal text-md m-0" id="v_view_model_variant_div">Model Variant: <span class="font-weight-bold" id="v_view_model_variant"></span></p>
                    <hr class="mt-0 mb-2">
                </div>
                <span class="font-weight-bold text-md">DESCRIPTION</span>
                <p class="font-weight-normal text-md word-wrap m-0" id="lbl_description">
                </p>
                <hr class="mt-0 mb-2">
                <span class="font-weight-bold text-md">IMPORTANT ADDITIONAL DATA</span>
                <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_fault_codes_divv">
                    <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Fault Codes:</label>
                    <div class="col">
                        <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                        <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_fault_codes"><span class="text-md text-muted font-italic">Loading...</span></label>
                    </div>
                </div>
                <hr class="mt-0 mb-2">


                <div id="video_attachment " class="mb-3">
                    <span class="font-weight-bold text-md">FILES:</span>
                    <br>
                    <div id="video_attachment_container">

                    </div>

                </div>


            </div>
            <div class="bg-white px-lg-4 col-sm-4 p-0 m-0">

                <div class="row py-2">
                    <div class="col-4">
                        <span class=" font-weight-bold text-md">VIEWERS</span>

                    </div>

                    <div class="col-8 ">
                        <div class="row float-right pr-2">
                            <div class="input-group  search-transition " style="width: 170px;" id="video-search-div">
                                <div class="input-group-prepend">
                                    <span class="input-group-text pr-2 pl-2 pt-0 pb-0"><i class="fas fa-search"></i></span>
                                </div>
                                <input type="search" id="video-search" class="form-control form-control-sm pr-0" autocomplete="off" placeholder="Search viewers...">
                            </div>
                            <i class=" cursor-pointer  tooltip-me pt-1 pl-1 fas fa-question-circle text-primary " title="Search name or id number."></i>
                        </div>
                    </div>
                </div>

                <div class="" id="ticket_activities">

                </div>

                <div class="row d-flex justify-content-center hideEl bg-light" id="view_more_activities">
                    <div class="p-1 col-12 text-center">
                        <span class="cursor-pointer text-primary" id="video_viewers_view_more">
                            <i class="fas fa-plus mr-1"></i>View More</span>
                    </div>
                </div>

            </div>
        </div>



    </div>
    <div id="sidebar-remove"></div>
</div>


<!-- Common scripts -->
<!-- dropzonejs -->
<script src="plugins/dropzone/min/dropzone.min.js"></script>
<!-- Select2 -->
<script src="plugins/select2/js/select2.full.min.js"></script>
<!-- SweetAlert2 -->
<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
<!-- Toastr -->
<script src="plugins/toastr/toastr.min.js"></script>
<!-- AutoCommplete -->
<script src="dist/js/bootstrap-autocomplete/bootstrap-autocomplete.min.js"></script>
<!-- daterangepicker -->
<script src="plugins/moment/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script>
<!-- Ekko Lightbox -->
<script src="plugins/ekko-lightbox/ekko-lightbox.min.js"></script>

<?php 
    include('resources/views/common/script/function.php'); 
?>
<!-- custom scripts for this page only -->

<script>
// GLOBALS
var selected_video_data = <?php echo $param_id; ?>;
var is_user_watched = false;

// Ticket viewers
var video_viewers_display_limit_const = 10;
var video_viewers_display_limit = video_viewers_display_limit_const;
var video_viewers_display_count = 0;

function initVideoData() {
    return $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_video_information',
            video_id: selected_video_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            var has_vehicle_info = false;


            $.each(result.rows, function(i, n) {

                if (i.startsWith('v_')) {
                    if (!isEmpty(n)) {
                        has_vehicle_info = true;
                    }
                }

                if (i == "lbl_description") {
                    $("#" + i).html(n);
                } else {
                    $("#" + i).text(n);
                }

                if (isEmpty(n)) {
                    $("#" + i + "_div").hide();
                } else {
                    $("#" + i + "_div").show();
                }
            });

            if (has_vehicle_info) {
                $('#vehicle_info').show();
            } else {
                $('#vehicle_info').hide();
            }


            if (result.attachments.length > 0) {
                $('#video_attachment_container').html('');
                $.each(result.attachments, function(i, n) {

                    var fileExt = n.change_name.split('.').pop();
                    var filename = n.change_name.replace(/\.[^/.]+$/, "")
                    switch (fileExt) {
                        case 'png':
                        case 'jpg':
                        case 'jpeg':
                            $('#video_attachment_container').append(`<a  data-type="image" data-toggle="lightbox"  href="viewer/image.php?token=` + filename + `@4" > 
                                <u><span>` + n.original_name + `</span></u>
                            </a><br>`);

                            break;
                        case 'pdf':
                            $('#video_attachment_container').append(`<a target="_blank"  href="pdf/pdf.php?token=` + filename + `@4" > 
                                                            <u><span>` + n.original_name + `</span></u>
                                                        </a><br>
                             `);
                            break;
                        default:
                            $('#video_attachment_container').append(`<a href="javascript:void(0);" onclick="downloadTicketAttachment('` + n.change_name + `','4')">
                                    <u><span>` + n.original_name + `</span></u>
                            </a>
                            <br>
                             `);
                    }



                });
            } else {
                $('#video_attachment').hide();
            }


            var src_vid = 'dist/videos/' + result.rows.attachment_name;
            $("#video_el").html('<source src="' + src_vid + '" type="video/mp4"></source>');

            var i = setInterval(function() {
                var video = document.getElementById('video_el')
                if (video.readyState > 0) {
                    var minutes = parseInt(video.duration / 60, 10);
                    var seconds = video.duration % 60;
                    // (Put the minutes and seconds in the display)
                    // console.log(parseInt(minutes)+' '+parseInt(seconds));

                    clearInterval(i);

                    $("#video_el").on(
                        "timeupdate",
                        function(event) {
                            onTrackedVideoFrame(this.currentTime, this.duration);
                        }
                    );

                }
            }, 200);


        },
        error: function() {}
    });
}

function onTrackedVideoFrame(currentTime, duration) {
    /* Here you can get both currentTIme and duration */
    // console.log(parseInt(currentTime) + ' ' +parseInt(duration));
    requiredTime = (duration / 3) * 2;
    // console.log(requiredTime);
    if (!is_user_watched && currentTime > requiredTime) {
        is_user_watched = true;

        $.ajax({
            url: "app/models/knowledgebase.php",
            data: {
                model: 'create_watched_video',
                video_id: selected_video_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                console.log('watched');
            },
            error: function() {}
        });
    }
}


function initWatchers() {
    $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_video_viewers',
            video_id: selected_video_data,
            order: 'ASC',
            offset: video_viewers_display_limit - video_viewers_display_limit_const,
            limit: video_viewers_display_limit_const,
            search: $('#video-search').val()
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            // $('#ticket_activities').html('')
        },
        success: function(result) {
            $.each(result['rows'], function(i, n) {

                $('#ticket_activities').append(`        
                            <div class="direct-chat-textt mr-0 ml-0 custom-left-border py-1">
                                <div class="direct-chat-infos clearfix my-0">
                                    <span class="direct-chat-name float-left">` + n.user + ` - (` + n.id_number + `)</span> 
                                    <br>
                                    <span class="direct-chat-name float-left">` + n.date_added + `</span>
                                </div>
                            </div>
                        `);



                video_viewers_display_count++;

            });

            if (result['rows'].length == 0) {
                // $('#view_more_activities').addClass('hideEl');
            } else {
                $('#view_more_activities').removeClass('hideEl');
            }
            if (video_viewers_display_count == 0) {
                  $('#view_more_activities').addClass('hideEl');
                $('#ticket_activities').html('<div class="col-12 text-center"><span class="text-center">No results</span></div>')
            } else if (video_viewers_display_count != 0 && result['rows'].length == 0) {
                toastr.remove();
                toastr.info("No more viewers.")
            }
        },
        error: function() {}
    });
}

$(function() {
    // initLightBox();
    initVideoData();


    $('.video_el').mousedown(function(event) {
        if (event.which === 3) {
            $('.video_el').bind('contextmenu', function() {
                return false;
            });
        } else {
            $('.video_el').unbind('contextmenu');
        }
    });


    initWatchers();
    $('#video_viewers_view_more').on('click', function() {
        video_viewers_display_limit =
            video_viewers_display_limit +
            video_viewers_display_limit_const;
        initWatchers();
    });

     $('#video-search').on('keyup', delay(function(e) { 
     video_viewers_display_limit = video_viewers_display_limit_const;
     video_viewers_display_count = 0;
    $('#ticket_activities').html('')
    initWatchers();
    }, 500));

    // setTimeout(function() {
    //     var videoDuration =  document.getElementById('video_el')
    //     var duration = videoDuration.duration;
    //     var minutes = parseInt(duration / 60, 10);
    // 	   var seconds = duration % 60;
    //     alert(parseInt(minutes)+' '+parseInt(seconds));
    // }, 2000);




    // $("#video_el").on(
    //     "timeupdate", 
    //     function(event){
    //       onTrackedVideoFrame(this.currentTime, this.duration);
    //     });

     // Share Link Functionality
    document.getElementById('shareBtn').addEventListener('click', function() {
        // Get the current page URL (or customize if needed)
        const pageUrl = window.location.href;
        
        // Use the Clipboard API to copy
        navigator.clipboard.writeText(pageUrl)
            .then(() => {
                const statusEl = document.getElementById('shareStatus');
                statusEl.style.display = 'inline';
                setTimeout(() => statusEl.style.display = 'none', 2000); // Hide after 2 sec
            })
            .catch(err => {
                console.error('Failed to copy: ', err);
                alert('Press Ctrl+C to copy the link manually.');
            });
    });


});
</script>