<?php
        if(!isset($session_access['3']) || !in_array('3_2', $session_access['3'])){
            include $error_404;
        exit;
}
?>


<div class="tab-container bg-light">
    <ul class="nav nav-tabs hide-sm">
        <?php  
            if(in_array('3_2', $session_access['3'])){
                ?>
        <li class="active">
            <a class="" href="#tickets-new">New Ticket</a>
        </li>
        <?php
            }
        ?>
        <li class="">
            <a class="" href="#tickets-list">All Tickets</a>
        </li>
        <li class="">
            <a class="" href="#tickets-own">My Tickets</a>
        </li>
    </ul>

    <div id="ticket_information_view">
        <div class="d-flex justify-content-center">

            <div class="col-lg-8 col-sm-12">

                <!-- /.row -->
                <div class="row">
                    <div class="col-md-12">
                        <!-- <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">bs-stepper</h3>
              </div>
              <div class="card-body p-0"> -->

                        <div class="bs-stepper">
                            <div class="bs-stepper-header" role="tablist">
                                <!-- your steps here -->
                                <!-- <div onclick="stepper.to(1)" class="step cursor-pointer" data-target="#step-one"> -->
                                <div onclick="" class="step" data-target="#step-one">
                                    <button type="button" class="step-trigger" role="tab" aria-controls="step-one" id="step-one-trigger">
                                        <span class="bs-stepper-circle m-0">1</span>
                                        <!-- <span class="bs-stepper-label">Logins</span> -->
                                    </button>
                                </div>
                                <div class="line"></div>
                                <!-- <div onclick="stepper.to(2)" class="step cursor-pointer" data-target="#step-two"> -->
                                <div onclick="" class="step" data-target="#step-two">
                                    <button type="button" class="step-trigger" role="tab" aria-controls="step-two" id="step-two-trigger">
                                        <span class="bs-stepper-circle m-0">2</span>
                                        <!-- <span class="bs-stepper-label">Various information</span> -->
                                    </button>
                                </div>
                                <div class="line"></div>
                                <!-- <div onclick="stepper.to(3)" class="step cursor-pointer" data-target="#step-three"> -->
                                <div onclick="" class="step" data-target="#step-three">
                                    <button type="button" class="step-trigger" role="tab" aria-controls="step-three" id="step-three-trigger">
                                        <span class="bs-stepper-circle m-0">3</span>
                                        <!-- <span class="bs-stepper-label">Various information</span> -->
                                    </button>
                                </div>
                                <div class="line"></div>
                                <!-- <div onclick="stepper.to(4)" class="step cursor-pointer" data-target="#step-four"> -->
                                <div onclick="" class="step" data-target="#step-four">
                                    <button type="button" class="step-trigger" role="tab" aria-controls="step-four" id="step-four-trigger">
                                        <span class="bs-stepper-circle m-0">4</span>
                                        <!-- <span class="bs-stepper-label">Various information</span> -->
                                    </button>
                                </div>
                                <div class="line"></div>
                                <!-- <div onclick="stepper.to(5)" class="step cursor-pointer" data-target="#step-five"> -->
                                <div onclick="" class="step" data-target="#step-five">
                                    <button type="button" class="step-trigger" role="tab" aria-controls="step-five" id="step-five-trigger">
                                        <span class="bs-stepper-circle m-0">5</span>
                                        <!-- <span class="bs-stepper-label">Various information</span> -->
                                    </button>
                                </div>
                            </div>
                            <div class="bs-stepper-content">
                                <!-- your steps content here -->

                                <div id="step-one" class="content" role="tabpanel" aria-labelledby="step-one-trigger">

                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            CASE DATA
                                        </label>
                                    </div>
                                    <div class="col-12">

                                        <div class="form-group row mb-1">
                                            <label for="title" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Title<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <input type="text" class="form-control form-control-sm " json-ticket-modal="true" json-ticket-modal-one="true" id="title" placeholder="">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-1">
                                            <label for="category" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Area<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <select class="form-control form-control-sm  select2bs4" id="category" json-ticket-modal="true" json-ticket-modal-one="true" style="width: 100%;">
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-1" style="display:none;">
                                            <label for="description" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Case Description<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <textarea oninput="auto_grow(this)" style="height:calc(1.8125rem + 2px);" type="text" class="custom-text-area form-control form-control-sm " json-ticket-modal-one="true"
                                                    id="description"></textarea>
                                            </div>
                                        </div>

                                        <!-- <div class="form-group row mb-1">
                                            <label for="description" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Description<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">

                                                <textarea style="height: 102px;" type="text" class="form-control form-control-sm " json-ticket-modal-one="true" id="description"></textarea>

                                            </div>
                                        </div> -->
                                    </div>
                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            VEHICLE INFORMATION
                                        </label>
                                    </div>

                                    <div class="col-12">
                                        <!-- <div class="col-sm-4">
                                                <div class="form-group row mb-1">
                                                    <label for="priority_level" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Priority Level<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                                    <div class="col-sm-12">
                                                        <select class="form-control form-control-sm  select2bs4" id="priority_level" json-ticket-modal="true" style="width: 100%;">
                                                        </select>
                                                    </div>
                                                </div>
                                            </div> -->
                                        <div class="form-group row mb-1" id="brand_div" style="display:;">
                                            <label for="brand" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Brand<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <select class="form-control form-control-sm  select2bs4" id="brand" json-ticket-modal="true" json-ticket-modal-one="true" style="width: 100%;">
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-1" id="model_div" style="display:;">
                                            <label for="model" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Model<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <select class="form-control form-control-sm  select2bs4" id="model" json-ticket-modal="true" json-ticket-modal-one="true" style="width: 100%;">
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group row mb-1" id="plate_cs_div" style="display:;">
                                            <label for="plate_cs" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Plate/CS<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <input type="text" class="no-sp-ch form-control form-control-sm uppercase" style="text-transform:uppercase" json-ticket-modal-one="true" id="plate_cs" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row mb-1" id="mileage_div" style="display:;">
                                            <label for="mileage" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Mileage (km)</label>
                                            <div class="col-sm-12">
                                                <input type="number" min="0" class=" form-control form-control-sm uppercase" style="text-transform:uppercase" json-ticket-modal-one="true" id="mileage" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row mb-1" id="vin_div" style="display:;">
                                            <label for="vin" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">VIN</label>
                                            <div class="col-sm-12">
                                                <input type="text" class=" form-control form-control-sm uppercase" style="text-transform:uppercase" json-ticket-modal-one="true" id="vin" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row mb-1" id="model_variant_div" style="display:none;">
                                            <label for="model_variant" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Model Variant</label>
                                            <div class="col-sm-12">
                                                <input type="text" class="form-control form-control-sm uppercase" json-ticket-modal-one="true" autocomplete="off" id="model_variant" placeholder="">
                                                <input type="text" json-ticket-modal="true" json-ticket-modal-one="true" id="model_variant_id" style="display:none;">
                                            </div>
                                        </div>
                                        <div class="form-group row mb-1" id="year_model_div" style="display:;">
                                            <label for="year_model" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Year Model</label>
                                            <div class="col-sm-12">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-ticket-modal-one="true" id="year_model" placeholder=""> -->
                                                <input type="number" class="form-control form-control-sm no-arrow uppercase" id="year_model" oninput="this.value=this.value.slice(0,this.maxLength)" maxlength="4" json-ticket-modal-one="true"
                                                    placeholder="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            CASE DETAILS
                                        </label>
                                    </div>
                                    <div class="col-12">

                                        <div class="form-group row mb-1">
                                            <label for="workshop_visit" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Number of workshop visit<span class="text-danger font-weight-bold">&nbsp;</span></label>
                                            <div class="col-sm-12">
                                                <input type="number" min="0" class="form-control form-control-sm " json-ticket-modal-one="true" id="workshop_visit" placeholder="">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12 ">
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="form-check ticket-final-status" style="">
                                                    <input id="chk_breakdown" json-ticket-modal-one="true" name="vehicle_location_status" value="" class="custom-chk-rdo-size form-check-input mt-2" type="checkbox">
                                                    <label for="chk_breakdown" class="text-md form-check-label mt-1">Breakdown
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-check ticket-final-status" style="">
                                                    <input checked value="1" json-ticket-modal-one="true" id="chk_on_site" name="vehicle_location_status" value="" class="custom-chk-rdo-size form-check-input mt-2" type="checkbox">
                                                    <label for="chk_on_site" class="text-md form-check-label mt-1">Vehicle on site
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            PRIORITY
                                        </label>
                                    </div>
                                    <div class="col-12 ">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-check ticket-final-status" style="">
                                                    <input value="1" json-ticket-modal-one="true" id="rdo_info" value="" name="priority" class="custom-chk-rdo-size form-check-input mt-2" type="radio">
                                                    <label for="rdo_info" class="text-md form-check-label mt-1">Info
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-check ticket-final-status" style="">
                                                    <input checked value="3" json-ticket-modal-one="true" id="rdo_urgent" value="" name="priority" class="custom-chk-rdo-size form-check-input mt-2" type="radio">
                                                    <label for="rdo_urgent" class="text-md form-check-label mt-1">Urgent
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-4" hidden>
                                                <div class="form-check ticket-final-status" style="">
                                                    <input  value="2" json-ticket-modal-one="true" id="rdo_reply_req" value="" name="priority" class="custom-chk-rdo-size form-check-input mt-2" type="radio">
                                                    <label for="rdo_reply_req" class="text-md form-check-label mt-1">Reply requested
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row py-3 px-2">
                                        <!-- <div class="col text-left">
                                            <button type="button" onclick="stepper.previous()" class="btn btn-sm btn-primary " id="">< Previous</button>
                                        </div> -->
                                        <div class="col text-right">
                                            <button type="button" onclick="" class="btn btn-sm btn-primary " id="step-one-next">Next ></button>
                                        </div>
                                    </div>

                                </div>

                                <div id="step-two" class="content" role="tabpanel" aria-labelledby="step-two-trigger">
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            COMPLAINT
                                        </label>
                                    </div>

                                    <div class="col-12">

                                        <!-- <div class="form-group row mb-1">
                                            <label for="title" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Describe customer<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <input type="text" class="form-control form-control-sm " json-ticket-modal="true" id="title" placeholder="">
                                            </div>
                                        </div> -->

                                        <div class="form-group row mb-1">
                                            <label for="complaint" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Describe customer complaint<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <textarea oninput="auto_grow(this)" style="height:calc(1.8125rem + 2px);" type="text" class="custom-text-area form-control form-control-sm " json-ticket-modal-two="true"
                                                    id="complaint"></textarea>
                                            </div>
                                        </div>

                                        <!-- <div class="form-group row mb-1">
                                            <label for="description" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Description<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <textarea style="height: 102px;" type="text" class="form-control form-control-sm " json-ticket-modal="true" id="description"></textarea>
                                            </div>
                                        </div> -->
                                    </div>
                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            WORK PERFORMED
                                        </label>
                                    </div>
                                    <div class="col-12">

                                        <div class="form-group row mb-1">
                                            <label for="work_performed" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Describe work done in workshop<span class="text-danger font-weight-bold">&nbsp;*</span></label>
                                            <div class="col-sm-12">
                                                <textarea oninput="auto_grow(this)" style="height:calc(1.8125rem + 2px);" type="text" class="custom-text-area form-control form-control-sm " json-ticket-modal-two="true"
                                                    id="work_performed"></textarea>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            IMPORTANT ADDITIONAL DATA
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row mb-1">
                                            <label for="fault_codes" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-normal">Fault Codes (separated by comma)<span class="text-danger font-weight-bold">&nbsp;</span></label>
                                            <div class="col-sm-12">
                                                <input type="text" class="form-control form-control-sm " json-ticket-modal="true" json-ticket-modal-two="true" id="fault_codes" placeholder="">
                                            </div>
                                        </div>


                                    </div>

                                    <div class="row py-3 px-2">
                                        <div class="col text-left">
                                            <button type="button" onclick="stepper.previous()" class="btn btn-sm btn-primary " id="">
                                                < Previous</button>
                                        </div>
                                        <div class="col text-right">
                                            <button type="button" onclick="" class="btn btn-sm btn-primary " id="step-two-next">Next ></button>
                                        </div>
                                    </div>

                                </div>

                                <div id="step-three" class="content" role="tabpanel" aria-labelledby="step-three-trigger">
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            ATTACHMENTS
                                        </label>
                                    </div>
                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <div class="card-body p-0">
                                            <div id="ticket_actions" class="row">
                                                <div class="col-lg-3">
                                                    <div class="btn-group w-100">
                                                        <span class="btn btn-success  col btn-sm fileinput-button">
                                                            <i class="fas fa-plus"></i>
                                                            <span>Browse/Drag Files</span>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="table table-striped files" id="ticket_previews">
                                                <div id="ticket_template" class="row mt-2">
                                                    <div class="col-auto p-0">
                                                        <span class="preview"><img src="data:," alt="" data-dz-thumbnail /></span>
                                                    </div>
                                                    <div class="col d-flex align-items-center word-wrap">
                                                        <p class="mb-0">
                                                            <span class="lead text-md" data-dz-name></span>
                                                            (<span data-dz-size></span>)
                                                        </p>
                                                        <strong class="error text-danger" data-dz-errormessage></strong>
                                                    </div>
                                                    <div class="col-sm-6 d-flex align-items-center">
                                                        <div class="progress progress-striped active w-100 my-2" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
                                                            <div class="progress-bar progress-bar-success" style="width:0%;" data-dz-uploadprogress></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-auto d-flex align-items-center">
                                                        <div class="btn-group">

                                                            <button data-dz-remove class="btn btn-sm btn-danger delete">
                                                                <i class="fas fa-trash"></i>
                                                                <span>Remove</span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row py-3 px-2">
                                        <div class="col text-left">
                                            <button type="button" onclick="stepper.previous()" class="btn btn-sm btn-primary " id="">
                                                < Previous</button>
                                        </div>
                                        <div class="col text-right">
                                            <button type="button" onclick="stepper.next()" class="btn btn-sm btn-primary " id="step-three-next">Next ></button>
                                        </div>
                                    </div>

                                </div>
                                <div id="step-four" class="content" role="tabpanel" aria-labelledby="step-four-trigger">
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            RELATED KNOWLEDGEBASE AND TICKET ARTICLES
                                        </label>
                                    </div>
                                    <div class="col-12">
                                        <div class="coveo-result-list-container coveo-list-layout-container">

                                        </div>

                                        <div class="row d-flex justify-content-center  bg-light" id="view_more_kb_search">
                                            <div class="p-1 col-12 text-center">
                                                <span class="cursor-pointer text-primary" id="kb_search_view_more">
                                                    <i class="fas fa-plus mr-1"></i>View More</span>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row py-3 px-2">
                                        <div class="col text-left">
                                            <button type="button" onclick="stepper.previous()" class="btn btn-sm btn-primary " id="">
                                                < Previous</button>
                                        </div>
                                        <div class="col text-right">
                                            <button type="button" onclick="stepper.next()" class="btn btn-sm btn-primary " id="step-four-next">Next ></button>
                                        </div>
                                    </div>
                                </div>
                                <div id="step-five" class="content" role="tabpanel" aria-labelledby="step-five-trigger">
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            CASE DATA
                                        </label>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group row col mb-0 " id="lbl_ticket_subject_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Title</label>
                                            <div class="col">
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_subject"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 " id="lbl_ticket_category_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Area</label>
                                            <div class="col">
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_category"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 person-field" id="lbl_ticket_priority_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Priority</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_priority"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_plate_cs_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Plate/CS</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_plate_cs"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_vin_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">VIN</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_vin"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_mileage_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Mileage</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_mileage"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_brand_div">
                                            <label for="" style="width: 115px;" class=" pb-0 pt-1 col-form-label font-weight-normal">Brand</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1  col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_brand"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_model_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Model</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_model"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_mv_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Model Variant</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_mv"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_ym_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Year Model</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_ym"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_workshop_visit_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Workshop visits</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_workshop_visit"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_breakdown_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Breakdown</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_breakdown"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_on_site_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Vehicle on site</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_on_site"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>
                                        <div class="form-group row col mb-0 " id="lbl_ticket_created_by_div">
                                            <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Created By</label>
                                            <div class="col">
                                                <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_created_by"><span class="text-md text-muted font-italic">Loading...</span></label>
                                            </div>
                                        </div>

                                    </div>


                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <div class="card mb-2">
                                            <div class="card-header bg-light pl-2 pt-1 pb-1">
                                                <h3 class="card-title text-md pt-1">COMPLAINT</h3>
                                                <div class="card-tools">
                                                    <button type="button" class="btn btn-tool role-toggle" data-card-widget="collapse">
                                                        <i class="fas fa-minus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <!-- /.card-header pl-2 pt-1 pb-1 -->
                                            <div class="card-body p-0" style="display: block;">
                                                <ul class="products-list product-list-in-card pl-2 pr-2">
                                                    <li class="item p-1">
                                                        <div class="">
                                                            <span class="product-description" id="lbl_ticket_complaint">

                                                            </span>
                                                        </div>
                                                    </li>
                                                    <!-- /.item -->
                                                </ul>
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                    </div>

                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <div class="card mb-2">
                                            <div class="card-header bg-light pl-2 pt-1 pb-1">
                                                <h3 class="card-title text-md pt-1">DESCRIBE WORK DONE IN WORKSHOP</h3>
                                                <div class="card-tools">
                                                    <button type="button" class="btn btn-tool role-toggle" data-card-widget="collapse">
                                                        <i class="fas fa-minus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <!-- /.card-header pl-2 pt-1 pb-1 -->
                                            <div class="card-body p-0" style="display: block;">
                                                <ul class="products-list product-list-in-card pl-2 pr-2">
                                                    <li class="item p-1">
                                                        <div class="">
                                                            <span class="product-description" id="lbl_ticket_work_done">

                                                            </span>
                                                        </div>
                                                    </li>
                                                    <!-- /.item -->
                                                </ul>
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                    </div>

                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <div class="card mb-2">
                                            <div class="card-header bg-light pl-2 pt-1 pb-1">
                                                <h3 class="card-title text-md pt-1">IMPORTANT ADDITIONAL DATA</h3>
                                                <div class="card-tools">
                                                    <button type="button" class="btn btn-tool role-toggle" data-card-widget="collapse">
                                                        <i class="fas fa-minus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <!-- /.card-header pl-2 pt-1 pb-1 -->
                                            <div class="card-body p-0" style="display: block;">
                                                <ul class="products-list product-list-in-card pl-2 pr-2">
                                                    <li class="item p-1">
                                                        <div class="">
                                                            <div class="form-group row col mb-0 type_vehicle_reply_modal" id="lbl_ticket_fault_codes_divv">
                                                                <label for="" style="width: 115px;" class="pb-0 pt-1 col-form-label font-weight-normal">Fault Codes</label>
                                                                <div class="col">
                                                                    <!-- <input type="text" class="form-control form-control-sm uppercase" json-lead-modal="true" id="txt_lead_mname" placeholder=""> -->
                                                                    <label class=" pb-0 pt-1 col-form-label font-weight-bold" ticket-info-data placeholder="" id="lbl_ticket_fault_codes"><span
                                                                            class="text-md text-muted font-italic">Loading...</span></label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <!-- /.item -->
                                                </ul>
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                    </div>

                                    <div class="m-3"> </div>
                                    <div class="col-12">
                                        <label class="text-lg m-0 p-0">
                                            ATTACHMENTS
                                        </label>
                                    </div>

                                    <div class="col-12">
                                        <!-- START FILE EXPLORER -->

                                        <div id="main-content-attach" class="file_manager">
                                            <div id="ticket_info_attachment_container" class="container p-0">
                                                <div class="row clearfix " id="ticket_attachment">



                                                </div>

                                            </div>
                                        </div>
                                        <!-- END FILE EXPLORER -->
                                    </div>


                                    <div class="row py-3 px-2">
                                        <div class="col text-left">
                                            <button type="button" onclick="stepper.previous()" class="btn btn-sm btn-primary " id="">
                                                < Previous</button>
                                        </div>
                                        <div class="col text-right">
                                            <button type="button" onclick="" class="btn btn-sm btn-primary " id="step-five-next">Submit Ticket</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- </div> -->
                        <!-- /.card-body -->
                        <!-- <div class="card-footer">
                Visit <a href="https://github.com/Johann-S/bs-stepper/#how-to-use-it">bs-stepper documentation</a> for more examples and information about the plugin.
              </div>
            </div> -->
                        <!-- /.card -->
                    </div>
                </div>
                <!-- /.row -->



            </div>

        </div>
    </div>
    <div id="sidebar-remove"></div>
</div>

<!-- Common scripts -->
<!-- dropzonejs -->
<script src="plugins/dropzone/min/dropzone.min.js"></script>
<!-- Select2 -->
<script src="plugins/select2/js/select2.full.min.js"></script>
<!-- SweetAlert2 -->
<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
<!-- Toastr -->
<script src="plugins/toastr/toastr.min.js"></script>
<!-- AutoCommplete -->
<script src="dist/js/bootstrap-autocomplete/bootstrap-autocomplete.min.js"></script>
<!-- daterangepicker -->
<!-- <script src="plugins/moment/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script> -->
<!-- Ekko Lightbox -->
<script src="plugins/ekko-lightbox/ekko-lightbox.min.js"></script>
<!-- BS-Stepper -->
<script src="plugins/bs-stepper/js/bs-stepper.min.js"></script>

<?php 
    include('resources/views/common/script/function.php'); 
?>
<!-- custom scripts for this page only -->

<?php 
    include('resources/views/common/script/ticket_list_functions.php');
    // include('resources/views/common/script/ticket_list.php');
?>

<script>
var stepper = new Stepper($('.bs-stepper')[0]);
selected_ticket_data = null; //nullified to work on php model
var json_data_one = null;
var json_data_two = null;
var priority_level = 3;

// DROPZONE START
// Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument

try {
    var previewNode = document.querySelector("#ticket_template")
    previewNode.id = ""
    var previewTemplate = previewNode.parentNode.innerHTML
    previewNode.parentNode.removeChild(previewNode)

    //   $valid_ext_doc = array('pdf','doc','docx','txt','html','htm','ppt','pptx','xls','csv','xlsx'); 
    //                 $valid_ext_img = array('png','jpeg','jpg'); 
    //                 $valid_ext_vid = array('mp4','mkv','mov','avi','wmv');  


    var myDropzone = new Dropzone("#step-three", {
        removedfile: function(file) {
            // alert(file.id) 
            // console.log(file)
            // if (!isEmpty(file.id)) {
            //     remove_ticket_attachment_mock_files.push(file.id);
            // }
            //    console.log(remove_ticket_attachment_mock_files)
            // delete uploaded_ticket_attachments_arr[file.upload.uuid];
            //  console.log(file.upload.uuid)
            var index = uploaded_ticket_attachments_arr.findIndex(function(obj) {
                return obj.uuid == file.upload.uuid
            });
            if (index > -1) {
                uploaded_ticket_attachments_arr.splice(index, 1);
            }

            // console.log(uploaded_ticket_attachments_arr)

            var _ref;
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
        },
        url: "app/models/file.php",
        paramName: "file",
        maxFilesize: 1024,
        maxFiles: 20,
        autoProcessQueue: true,
        acceptedFiles: '.pdf, .doc, .docx, .txt, .html, .htm, .ppt, .pptx, .xls, .csv, .xlsx, .png, .jpeg, .jpg, .mp4, .mkv, .mov, .avi, .wmv',
        init: function() {
            this.on('sending', function(file, xhr, formData) {
                formData.append("model", "create_file");
                formData.append("file", "file");
                $('#step-three-next').prop(
                    'disabled', true);
            });
        },
        thumbnailWidth: 50,
        thumbnailHeight: 50,
        parallelUploads: 20,
        previewTemplate: previewTemplate,
        autoQueue: true, // Make sure the files aren't queued until manually added
        previewsContainer: "#ticket_previews", // Define the container to display the previews
        clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
    });


    myDropzone.on('success', function(file, result) {
        $('#step-three-next').prop(
            'disabled', false);
        try {
            result = JSON.parse(result)
            if (parseInt(result.status) === 1) {
                // alert(result.change_name); 
                var uploaded_ticket_attachments_obj = {
                    "change_name": result.change_name,
                    "original_name": result.orig_name,
                    "uuid": file.upload.uuid
                }
                uploaded_ticket_attachments_arr.push(uploaded_ticket_attachments_obj);
                // console.log(uploaded_ticket_attachments_arr);
                // uploaded_ticket_attachments = {change_name: result.change_name , original_name: result.orig_name};
            } else if (parseInt(result.status) === 0) {
                //put the first error only
                if (!uploaded_ticket_attachments_has_error) {
                    uploaded_ticket_attachments_has_error = true;
                    uploaded_ticket_attachments_error_msg = {
                        filename: result.orig_name,
                        message: result.message
                    };
                }
            }
            if (!result.error) {
                if (myDropzone.getQueuedFiles().length === 0 && myDropzone.getUploadingFiles().length === 0) {
                    // console.log(uploaded_ticket_attachments_arr)
                    if (uploaded_ticket_attachments_has_error) {
                        toastr.remove();
                        toastr.error(uploaded_ticket_attachments_error_msg.filename + ' - ' + uploaded_ticket_attachments_error_msg.message)
                        //remove uploaded files
                        $.ajax({
                            url: "app/models/file.php",
                            data: {
                                model: 'delete_file',
                                file: '',
                                file_names: JSON.stringify(uploaded_ticket_attachments_arr)
                            },
                            type: "POST",
                            dataType: 'json',
                            beforeSend: function() {},
                            success: function(result) {},
                            error: function() {}
                        });
                    } else {
                        // myDropzone.removeAllFiles(true);
                        // createTicket();
                        // console.log(uploaded_ticket_attachments_arr);
                        // updateVehicleAttachments();

                    }

                    //put this line below to finish area
                    // uploaded_ticket_attachments_has_error = false;
                    // uploaded_ticket_attachments_arr = [];
                }
            }
            //TODO - 
        } catch (e) {
            //TODO -
            console.log(e)
        }
    });
} catch (e) {}

function startUpload() {
    if (myDropzone.getAcceptedFiles().length < 1) {
        stepper.next()
    }

    for (var i = 0; i < myDropzone.getAcceptedFiles().length; i++) {
        myDropzone.processFile(myDropzone.getAcceptedFiles()[i]);
    }
}

function updateVehicleAttachments() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'update_ticket_attachments',
            attachments: JSON.stringify(uploaded_ticket_attachments_arr),
            id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#step-three-next').prop(
                'disabled', true);
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                //  stepper.next()
            } else {
                toastr.remove();
                toastr.error(result.message);
            }

            $('#step-three-next').prop(
                'disabled', false);
        },
        error: function() {
            $('#step-three-next').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}
// DROPZONE END

function initStepsButton() {
    stepOne();
    stepTwo();
    stepThree();
    stepFour();
    stepFive();
}

function stepFour() {
    $('#step-four-next').on('click', function(e) {
        readTicketInformationData();
        readTicketAttachments();
    });
}

function readTicketInformationData() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_information',
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('.type_vehicle_reply_modal').hide();
        },
        success: function(result) {

            if (parseInt(result.show_vehicle) === 1) {
                $('.type_vehicle_reply_modal').show();
            }

            $.each(result, function(i, n) {

                if (i.startsWith("lbl_")) {
                    if (i == "lbl_ticket_description") {
                        $("#" + i).html(n);
                    } else if (i == "lbl_ticket_complaint") {
                        $("#" + i).html(n);
                    } else if (i == "lbl_ticket_work_done") {
                        $("#" + i).html(n);
                    } else {
                        $("#" + i).text(n);
                        $("#" + i).val(n);
                        $("#" + i).trigger('change')
                    }

                    if (isEmpty(n)) {
                        $("#" + i + "_div").hide();
                    } else {
                        $("#" + i + "_div").show();
                    }
                }
            });
        },
        error: function() {}
    });
}

function stepOne() {
    $('#step-one-next').on('click', function(e) {
        if (check_if_empty_field($('#title'),
                'Title is required.')) {
            return;
        }

        if ($('#title').val().length <= 4) {
            toastr.remove();
            toastr.error("Title is too short...");
            $('#title').trigger('focus');
            return;
        }

        if (check_if_empty_field($('#category'),
                'Category is required.')) {
            return;
        }

        if (!isEmpty($('#year_model').val())) {
            if ($('#year_model').val().length != 4) {
                toastr.remove();
                toastr.error("Invalid year model...");
                $('#year_model').trigger('focus');
                return;
            }
        }

        var $element = $("[json-ticket-modal-one]");
        json_data_one = generate_json(
            'json-ticket-modal-one',
            $element);

        // alert(json_data_one);
        // return;
        createTicket();


    })

}

function createTicket() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'create_ticket_header',
            json_data: json_data_one,
            priority_id: priority_level,
            id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#step-one-next').prop(
                'disabled', true);
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                selected_ticket_data = result.id;
                stepper.next()
            } else {
                toastr.remove();
                toastr.error(result.message);
            }

            $('#step-one-next').prop(
                'disabled', false);
        },
        error: function() {
            $('#step-one-next').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}

function stepTwo() {
    $('#step-two-next').on('click', function(e) {
        if (check_if_empty_field($('#complaint'),
                'Customer complaint is required.')) {
            return;
        }

        if (check_if_empty_field($('#work_performed'),
                'Work performed is required.')) {
            return;
        }

        var $element = $("[json-ticket-modal-two]");
        json_data_two = generate_json(
            'json-ticket-modal-two',
            $element);

        // alert(json_data_two);
        // return;

        updateVehicleData();

    })
}

function updateVehicleData() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'update_ticket_vehicle_customer',
            json_data: json_data_two,
            id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#step-two-next').prop(
                'disabled', true);
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                stepper.next()
            } else {
                toastr.remove();
                toastr.error(result.message);
            }

            $('#step-two-next').prop(
                'disabled', false);
        },
        error: function() {
            $('#step-two-next').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}

function stepThree() {
    $('#step-three-next').on('click', function(e) {

        updateVehicleAttachments();
        // startUpload();
        var $element = $("[json-ticket-modal]");
        ticket_json_data = generate_json(
            'json-ticket-modal',
            $element);

        // alert(ticket_json_data);
        // return;
        // createTicket();
        resetRelatedArticleResult();
        read_related_kb_tickets_v2();

    })
}

function read_related_kb_tickets_v2() {
    return $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_related_articles',
            json_data: ticket_json_data,
            offset: kb_display_limit - kb_display_limit_const,
            limit: kb_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {

        },
        success: function(result) {
            if (parseInt(result.total) > 0) {

                $.each(result['rows'], function(i, n) {
                    $('#search-result-lbl').show();
                    var html = n.descriptionf;
                    html = html.replace(/<style([\s\S]*?)<\/style>/gi, '');
                    html = html.replace(/<script([\s\S]*?)<\/script>/gi, '');
                    html = html.replace(/<\/div>/ig, '\n');
                    html = html.replace(/<\/li>/ig, '\n');
                    html = html.replace(/<li>/ig, '  *  ');
                    html = html.replace(/<\/ul>/ig, '\n');
                    html = html.replace(/<\/p>/ig, '\n');
                    html = html.replace(/<br\s*[\/]?>/gi, "\n");
                    html = html.replace(/<[^>]+>/ig, '');
 
                        uri = "#knowledgebase-view-"+n.id;
                    if(parseInt(n.source) === 2){
                        uri = "#tickets-view-"+n.id;
                    }
                    $('.coveo-result-list-container').append(`
                    <div class="coveo-list-layout CoveoResult p-2">
                        <div>
                            <div class="coveo-title">
                            <a class="CoveoResultLink cursor-pointer" tabindex="0" role="heading" aria-level="2"  href="`+uri+`" target="_blank" >` + n.title + `</a>
                            </div>
                            <div class="CoveoExcerpt">` + html + `</div>
                        </div>
                    </div>
                        `);

                    // $('.coveo-result-list-container').append(`
                    // <div class="coveo-list-layout CoveoResult p-2">
                    //     <div>
                    //         <div class="coveo-title"><a class="CoveoResultLink cursor-pointer" tabindex="0" role="heading" aria-level="2"  href="index.php?category=knowledgebase&action=information&id=` + n.id + `&src=` + n.source +
                    //     `" target="_blank" >` + n.title + `</a>
                    //         </div>
                    //         <div class="CoveoExcerpt">` + html + `</div>
                    //     </div>
                    // </div>
                    //     `);
                    kb_display_count++;

                });


                if (result['rows'].length == 0) {
                    $('#view_more_kb_search').addClass('hideEl');
                } else {
                    $('#view_more_kb_search').removeClass('hideEl');
                }
                if (kb_display_count == 0) {
                    // $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
                    toastr.remove();
                    toastr.info("No result found...");
                    toastr.remove
                } else if (kb_display_count != 0 && result['rows'].length == 0) {
                    toastr.remove();
                    toastr.info("No more result.")
                }

                if (parseInt(result.total) > kb_display_limit_const) {
                    $('#view_more_kb_search').removeClass('hideEl');
                } else {
                    $('#view_more_kb_search').addClass('hideEl');
                }

            } else {
                // startUpload();
                $('.coveo-result-list-container').append(`
                <div class="col-12 text-center"><span class="text-center">No diagnostics data</span></div>
                 `);
            }

        },
        error: function() {
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });

}


function initChkRdoBtn() {
    $("input[name*='priority']").each(function() {
        $(this).on('change', function() {
            if (this.checked) {
                priority_level = $(this).val();
                // $(this).val("");
            } else {
                // $(this).val("2");
            }
        });
    });

    $("input[name*='vehicle_location_status']").each(function() {
        $(this).on('change', function() {
            if (this.checked) {
                // priority_level = $(this).val();
                $(this).val("1");
            } else {
                $(this).val("");
            }
        });
    });
}

function stepFive() {
    $('#step-five-next').on('click', function(e) {

        return $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'create_ticket_final',
                id: selected_ticket_data,
                status: 1
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                $('#step-five-next').prop(
                    'disabled', true);
            },
            success: function(result) {
                if (parseInt(result.status) === 1) {
                    // redirect to the next step
                    toastr.remove();
                    toastr.success('Successfully created...');
                    window.location.hash = 'tickets-list';

                } else {
                    toastr.remove();
                    toastr.error(result.message);
                }

                $('#step-five-next').prop(
                    'disabled', false);
            },
            error: function() {
                $('#step-five-next').prop(
                    'disabled', false);
                toastr.remove();
                toastr.error(
                    "Error has occurred. Try again."
                )
            }
        });
    });
}
$(document).ready(function() {
    //from common functios
    initSelect2Element();
    initSelect2UnselectElement();
    modelVariantEvt();
    ticketSubjectEvt();
    ticketSearchEvt();
    addSelectChangeEvt();

    initStepsButton();
    initChkRdoBtn();

    // stepper.next()
})
</script>