<?php
if (!isset($session_access['1']) || !in_array('1_5', $session_access['1'])) {
    include $error_404;
    exit;
}
?>

<div class="tab-container bg-light">

    <ul class="nav nav-tabs hide-sm">
        <?php
        if (in_array('1_1', $session_access['1'])) {
        ?>
            <li class="">
                <a class="" href="#settings-system">System</a>
            </li>
        <?php
        }
        ?>
        <?php
        if (in_array('1_5', $session_access['1'])) {
        ?>
            <li class="active">
                <a class="" href="#settings-users">Users</a>
            </li>
        <?php
        }
        ?>
        <?php
        if (in_array('1_2', $session_access['1'])) {
        ?>
            <li class="">
                <a class="" href="#settings-role">Roles</a>
            </li>
        <?php
        }
        ?>
        <?php
        if (in_array('1_3', $session_access['1'])) {
        ?>
            <li class="">
                <a class="" href="#settings-sms">SMS</a>
            </li>
        <?php
        }
        ?>
        <?php
        if (in_array('1_4', $session_access['1'])) {
        ?>
            <li class="">
                <a class="" href="#settings-notification">Notification</a>
            </li>
        <?php
        }
        ?>
    </ul>

    <div class="tab-content bg-white m-0 p-3">
        <div class="tab-pane active cont min-height-400">
            <div class="mb-0">
                <nav class="navbar navbar-expand-md navbar-light justify-content-start pb-1 px-0" style=" background-color:transparent;">

                    <button class="navbar-toggler hide-sm" type="button" data-toggle="collapse" data-target="#navbarNav">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse show" id="navbarNav">
                        <ul class="nav nav-tabs navbar-nav mr-auto" style="border-bottom: 0px solid #dee2e6;">

                        </ul>
                        <ul class="nav nav-tabs navbar-nav ml-auto-md" style="border-bottom: 0px solid #dee2e6;">
                            <li class="nav-item mr-2 mb-1">
                                <div class="tooltip-me" title="Filters">
                                    <button type="button" class="btn dropdown-toggle pl-0 pr-2" data-toggle="dropdown">
                                        <i class="fas fa-filter"></i><u>Filters</u>
                                    </button>
                                    <ul class="ticket-more-filter dropdown-menu white-bg" style="width:100px;">
                                        <li class=" dropdown-item cursor-pointer py-0 px-2 mb-1">
                                            <select name="role-filter" id="role-filter" class="form-control form-control-sm select2" style="width: 100%;">
                                                <option></option>
                                            </select>
                                        </li>

                                    </ul>
                                </div>
                            </li>
                            <li class="nav-item mr-0 mb-1">
                                <div class="row">
                                    <div class="input-group  search-transition default-search-size" id="ticket-search-div">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text pr-2 pl-2 pt-0 pb-0"><i class="fas fa-search"></i></span>
                                        </div>
                                        <input type="search" id="ticket-search" class="form-control form-control-sm pr-0" placeholder="Search...">
                                    </div>
                                    <i class=" cursor-pointer  tooltip-me pt-1 pl-1 fas fa-question-circle text-primary " title="Search name, email or mobile."></i>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>

            <table id="table_users" data-search="false" data-show-refresh="false" data-show-header="true" class="table table-bordered table-hover table-sm small" data-show-export="false" data-page-size="15" data-page-list="[15, 30, 50, 100, all]" data-query-params="ticketsQueryParams" data-pagination="true">
                <thead>
                    <tr>
                        <th data-field="no" data-width="5">
                            No.</th>
                        <th data-field="user_id" data-width="100">
                            Employee ID
                        </th>
                        <th data-field="name" data-width="300">
                            Name
                        </th>
                        <th data-field="position" data-width="150">
                            Position
                        </th>
                        <th data-field="email" data-width="200">
                            Email
                        </th>
                        <th data-field="mobile" data-width="150">
                            Mobile
                        </th>
                        <th data-formatter="userRoleFormatter" data-field="role" data-width="10">
                            Role
                        </th>
                        <!-- <th data-width="5" data-formatter="ticketStatusFormatter" data-field="status">
                            Status
                        </th> -->
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>

<!-- Common scripts -->
<!-- dropzonejs -->
<!-- <script src="plugins/dropzone/min/dropzone.min.js"></script> -->
<!-- BTAble -->
<script src="dist/js/tableExport/tableExport.min.js"></script>
<script src="dist/js/tableExport/libs/js-xlsx/xlsx.core.min.js"></script>
<script src="dist/js/tableExport/libs/jsPDF/jspdf.umd.min.js"></script>
<script src="dist/js/tableExport/libs/es6-promise/es6-promise.auto.min.js"></script>
<script src="dist/js/tableExport/libs/html2canvas/html2canvas.min.js"></script>
<script src="plugins/bootstrap-table/js/bootstrap-table.min.js"></script>
<script src="plugins/bootstrap-table/js/bootstrap-table-en-US.js"></script>
<script src="plugins/bootstrap-table/js/bootstrap-table-export.min.js"></script>
<!-- Select2 -->
<script src="plugins/select2/js/select2.full.min.js"></script>
<!-- SweetAlert2 -->
<script src="plugins/sweetalert2/sweetalert2.min.js"></script>
<!-- Toastr -->
<script src="plugins/toastr/toastr.min.js"></script>
<!-- AutoCommplete -->
<script src="dist/js/bootstrap-autocomplete/bootstrap-autocomplete.min.js"></script>
<!-- daterangepicker -->
<script src="plugins/moment/moment.min.js"></script>
<script src="plugins/daterangepicker/daterangepicker.js"></script>
<!-- Ekko Lightbox -->
<script src="plugins/ekko-lightbox/ekko-lightbox.min.js"></script>

<?php
include('resources/views/common/script/function.php');
?>
<!-- custom scripts for this page only -->

<script>
    // GLOBALS
</script>

<script>
    function refreshUsersTable() {
        initUsersTable();
        var $table = $('#table_users')
        $(function() {
            $table.bootstrapTable('refresh', {
                url: 'app/models/user.php'
            });
        })
    }

    function refreshUsersTableSilent() {
        var $table = $('#table_users')
        $(function() {
            try {
                $table.bootstrapTable('refresh', {
                    url: 'app/models/user.php'
                });
            } catch (e) {
                console.log('reply from viewer. error: ' + e)
            }
        })
    }

    function initUsersTable() {
        var $table = $('#table_users');
        $table.bootstrapTable('destroy').bootstrapTable({
            sidePagination: 'server',
            formatSearch: function() {
                return 'Search...'
            },
            onLoadSuccess: function() {
                $("select[data-role]").each(function() {
                    var $select2 = $(this).select2({
                        placeholder: "Select role",
                        // minimumResultsForSearch: -1,
                        allowClear: true,
                        escapeMarkup: function(markup) {
                            return markup;
                        },
                        ajax: {
                            url: 'app/models/user.php',
                            dataType: 'json',
                            delay: 250,
                            data: function(data) {
                                return {
                                    model: 'read_roles',
                                    search: data
                                        .term // search term
                                };
                            },
                            processResults: function(response) {
                                return {
                                    results: response
                                };
                            },
                            cache: true
                        }
                    })
                    var role_name = $(this).attr('data-role-name');
                    if (!isEmpty(role_name)) {
                        var newOption = new Option(role_name, role_name, true, true);
                        $(this).append(newOption).trigger('change');
                    }


                })
                selectListener();
            },
            exportOptions: {
                fileName: function() {
                    return 'titile'
                }
            }
        });
    }


    function selectListener() {
        $("select[data-role]").each(function() {
            clickedId = this.id;
            $('#' + clickedId).on('select2:select select2:unselecting', function(e) {
                var role_id = $(this).val();
                var user_id = $(this).attr('data-user');
                $.ajax({
                    url: "app/models/user.php",
                    method: "POST",
                    data: {
                        model: 'update_user_role',
                        role_id: role_id,
                        user_id: user_id
                    },
                    beforeSend: function() {
                        toastr.remove();
                        toastr.info('Updating role...')
                    },
                    success: function(data) {
                        // refreshTableSilent(); //tobe change not resetting table
                        toastr.remove();
                        toastr.success('Role updated...')
                    }
                });

            });

        });
    }

    function ticketsQueryParams(params) {

        return {
            search: $('#ticket-search').val(),
            offset: params.offset,
            limit: params.limit,
            sort: params.sort,
            order: params.order,
            filter_role: $('#role-filter').val(),
            model: 'read_users_list',
        };
    }

    function initTicketSearchEvt() {
        $('#ticket-search').focusin(function() {
            $('#ticket-search-div').removeClass('default-search-size');
            $('#ticket-search-div').addClass('expand-search-size');
        });

        $('#ticket-search').focusout(function() {
            if (isEmpty($(this).val())) {
                $('#ticket-search-div').removeClass('expand-search-size');
                $('#ticket-search-div').addClass('default-search-size');
            }
        });

        $('#ticket-search').on('keyup', delay(function(e) {
            refreshUsersTableSilent();
        }, 500));
    }

    function userRoleFormatter(value, row, index) {
        return `<select name="user-role" id="user_role_` + row.id + `"
                    class="form-control form-control-sm select2" data-user="` + row.id + `" data-role="` + row.role_id + `" data-role-name="` + row.role + `"
                    data-bootstrap-select
                    style="width: 100%;">
                    <option></option>
                </select>`;
    }

    $(document).ready(function() {
        filterEvt();
        refreshUsersTable();
        initTicketSearchEvt();
        $("#role-filter").select2({
            placeholder: "Select role",
            minimumResultsForSearch: -1,
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/user.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_roles',
                        no_roles: 1,
                        search: data
                            .term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });

        $('#role-filter').on('select2:select select2:unselecting', function(e) {
            refreshUsersTableSilent();
        });

        // $('#role-filter').on('select2:select select2:unselecting', function(e) {
        //     refreshUsersTableSilent();
        // });

    });
</script>