 <?php  
if(!isset($session_access['1']) || !in_array('1_1', $session_access['1'])){
    include $error_404;
    exit;
}
?>
 
 <div class="tab-container bg-light">

     <ul class="nav nav-tabs hide-sm">
        <?php  
            if(in_array('1_1', $session_access['1'])){
                ?> 
                    <li class="active">
                        <a class="" href="#settings-system">System</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_5', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-users">Users</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_2', $session_access['1'])){
                ?> 
                   <li class="">
                        <a class="" href="#settings-role">Roles</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_3', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-sms">SMS</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_4', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-notification">Notification</a>
                    </li>
                <?php
            }
        ?>
     </ul>


     <div class="tab-content bg-white m-0 p-3">
         <div class="tab-pane active cont min-height-400">
             <div class="form-group mb-2">
                 <span for="name" class="col-form-label font-weight-normal">Name:</span>
                 <input type="text" json-system-modal="true" class="form-control form-control-sm " id="name">
             </div>
             <div class="form-group mb-2">
                 <span for="url" class="col-form-label font-weight-normal">Website URL:</span>
                 <input type="text" json-system-modal="true" class="form-control form-control-sm " id="url">
             </div>
             <div class="col p-0 mt-3">
             <button type="button" class="btn btn-sm btn-primary float-right" id="btn_cnf_system_save">Save Configuration</button>
         </div></div>
     </div>

 </div>
 

 <!-- Toastr -->
 <script src="plugins/toastr/toastr.min.js"></script>


 <?php 
    include('resources/views/common/script/function.php'); 
?>


 <script>

function readSystemConfig(){
     return $.ajax({
        url: "app/models/user.php",
        data: {
            model: 'read_system_config',
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            // console.log(result);
            $.each(result, function(i, n) {
                //  console.log(n.name + ' '+n.value)    
                    //  console.log(n.name + ' '+n.value)  
                        $("#" + n.name).text(n.value);
                        $("#" + n.name).val(n.value);
                        $("#" + n.name).trigger('change') 
            });
        },
        error: function() {}
    });
}

$(function() {  

    readSystemConfig(); 

 $('#btn_cnf_system_save').on('click', function() {

                        var $element = $("[json-system-modal]");
                        var json_data = generate_json('json-system-modal',
                            $element);
 
                      
                        return $.ajax({
                            url: "app/models/user.php",
                            data: {
                                model: 'update_system_config',
                                json_data: json_data
                            },
                            type: "POST",
                            dataType: 'json',
                            beforeSend: function() {
                                $('#btn_cnf_system_save').prop(
                                    'disabled', true);
                                toastr.remove();
                                toastr.info("Saving...");
                            },
                            success: function(result) {
                                if (parseInt(result.status) === 1) {
                                    toastr.remove();
                                    toastr.success(result.message);  
                                     $('#btn_cnf_system_save').prop(
                                        'disabled', false);
                                } else {
                                    $('#btn_cnf_system_save').prop(
                                        'disabled', false);
                                    toastr.remove();
                                    toastr.error(result.message);
                                }
                            },
                            error: function() {
                                $('#btn_cnf_system_save').prop(
                                    'disabled', false);
                                toastr.remove();
                                toastr.error(
                                    "Error has occurred. Try again."
                                )
                            }
                        });
                    });
                      
  

});
 </script>