<?php  
    if(!isset($session_access['1']) || !in_array('1_3', $session_access['1'])){
        include $error_404;
        exit;
    }
?>

<div class="tab-container bg-light">

     <ul class="nav nav-tabs hide-sm">
        <?php  
            if(in_array('1_1', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-system">System</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_5', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-users">Users</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_2', $session_access['1'])){
                ?> 
                   <li class="">
                        <a class="" href="#settings-role">Roles</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_3', $session_access['1'])){
                ?> 
                    <li class="active">
                        <a class="" href="#settings-sms">SMS</a>
                    </li>
                <?php
            }
        ?>
        <?php  
            if(in_array('1_4', $session_access['1'])){
                ?> 
                    <li class="">
                        <a class="" href="#settings-notification">Notification</a>
                    </li>
                <?php
            }
        ?>
     </ul>

     <div class="tab-content bg-white m-0 p-3">
         <div class="tab-pane active cont min-height-400">

             <div class="form-group mb-2">
                 <span for="api" class="col-form-label font-weight-normal">Selected API:</span>
                 <select name="api" id="api" json-cnf-sms="true" class="form-control form-control-sm" style="width:300px;">
                 </select>
             </div>


             <span for="txt_role_name" class="col-form-label font-weight-normal" hidden>Templates:</span>

             <div class="card collapsed-card mb-2" hidden>
                 <div class="card-header bg-light pl-2 pt-1 pb-1">
                     <h3 class="card-title text-md pt-1">Expert SMS Notification</h3>
                     <div class="card-tools">
                         <button type="button" class="btn btn-tool role-toggle" data-card-widget="collapse">
                             <i class="fas fa-plus"></i>
                         </button>
                     </div>
                 </div>
                 <!-- /.card-header pl-2 pt-1 pb-1 -->
                 <div class="card-body p-0">
                     <div class="col-12 px-3 pt-2" id="sms-parameter-section">
                         <div class="row">

                             <div class="col-sm-12">

                                 <div class="col-12">
                                     <div class="form-group row mb-1">
                                         <label for="txt_lead_call_description" class="col-sm-12 pb-0 pl-0 pt-0 col-form-label font-weight-normal">
                                             Available Parameters:
                                             <i class=" cursor-pointer  tooltip-me pt-1 pl-1 fas fa-question-circle text-primary " title="" data-original-title="Click the desire parameter to insert in template editor."></i>
                                            </label>

                                         <div class="form-group m-0" id="">
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;user&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the owner of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;title&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the title of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;description&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the description of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;category&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the category of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;priority&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the priority level of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;brand&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the selected brand of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;model&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the selected model of ticket.</label>
                                             </div>
                                             <div class="col-12 p-0">
                                                 <label style="width:95px;" lead-sms-parameter="" class="text-danger font-weight-bold cursor-pointer m-0">&lt;variant&gt;</label>
                                                 <label class="font-italic m-0 font-weight-normal">-&nbsp;&nbsp;Display the selected model variant of ticket.</label>
                                             </div>
                                         </div>

                                     </div>
                                 </div>

                             </div>

                             <div class="col-sm-6">


                             </div>
                         </div>
                     </div>

                     <div class="form-group px-3">
                         <textarea style="height: 150px;" type="text" id="t_1" json-cnf-sms="true" placeholder="Enter your template here..." class="form-control form-control-md"></textarea>
                     </div>
                 </div>
                 <!-- /.card-body -->
             </div>




             <div class="col p-0 mt-3 text-right">
                 <button type="button" class="btn btn-sm btn-primary " id="btn_cnf_sms_save">Save SMS Configuration</button>
             </div>
         </div>
     </div>

 </div>


 <!-- Toastr -->
 <script src="plugins/toastr/toastr.min.js"></script>


 <?php 
    include('resources/views/common/script/function.php'); 
?>


 <script>
     
function readSMSTemplates() {
    return $.ajax({
        url: "app/models/user.php",
        data: {
            model: 'read_sms_templates',
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            // console.log(result);
            $.each(result, function(i, n) {
                $("#t_" + n.id).text(n.description);
                $("#t_" + n.id).val(n.description);
                $("#t_" + n.id).trigger('change')
            });
        },
        error: function() {}
    });
}
function readSMSApis(){
     return $.ajax({
        url: "app/models/user.php",
        data: {
            model: 'read_sms_apis',
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#api').html('');
        },
        success: function(result) {
            $('#api').append(`<option value="">Disabled</option>`);
            $.each(result, function(i, n) { 
                var selected = parseInt(n.activated) ? 'selected' : '' ;
                $('#api').append(`<option value="` + n.id + `"  `+selected+`>` + n.text + `</option>`);
            });
        },
        error: function() {}
    });
}
$(function() {

    readSMSApis();
    readSMSTemplates();

     $("[lead-sms-parameter]").each(function() {
                            $(this).on('click', function() { 
                                $('#t_1').insertAtCaret($(this).text());
                                $('#t_1').trigger('focus');
                            });
                        });


    $('#btn_cnf_sms_save').on('click', function() {

        var $element = $("[json-cnf-sms]");
        var json_data = generate_json('json-cnf-sms',
            $element);

// alert(json_data);return false;
        return $.ajax({
            url: "app/models/user.php",
            data: {
                model: 'update_sms_config',
                json_data: json_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                $('#btn_cnf_sms_save').prop(
                    'disabled', true);
                toastr.remove();
                toastr.info("Saving...");
            },
            success: function(result) {
                if (parseInt(result.status) === 1) {
                    toastr.remove();
                    toastr.success(result.message);
                    $('#btn_cnf_sms_save').prop(
                        'disabled', false);
                } else {
                    $('#btn_cnf_sms_save').prop(
                        'disabled', false);
                    toastr.remove();
                    toastr.error(result.message);
                }
            },
            error: function() {
                $('#btn_cnf_sms_save').prop(
                    'disabled', false);
                toastr.remove();
                toastr.error(
                    "Error has occurred. Try again."
                )
            }
        });
    });



});
 </script>