<?php  
    if(!isset($session_access['4']) || !in_array('4_1', $session_access['4'])){
        include $error_404;
        exit;
    }
?>
<div class="tab-container bg-light">

     <ul class="nav nav-tabs hide-sm">
         <li class="active">
             <a class="" href="#knowledgebase-search">Search</a>
         </li>
         <li class="">
             <a class="" href="#knowledgebase-list">Articles</a>
         </li>

        <?php  
            if(in_array('4_3', $session_access['4'])){
                ?> 
                    <li class="">
                        <a class="" href="#knowledgebase-ait">AIT Articles</a>
                    </li>
                <?php
            }
        ?>
        
         <li class="">
             <a class="" href="#knowledgebase-own">My Articles</a>
         </li>
     </ul>


     <div class="tab-content bg-white m-0 p-3">
         <div class="tab-pane active cont min-height-400"> <br>

             <h3 class="main-search-header">Knowledge Base Search</h3>
             <br>

             <div class="control-group row">

                 <div class="form-group col-md-5">
                     <input type="text" placeholder="Keyword ..." name="search_by" id="search_by" autocomplete="off" class="form-control">
                 </div>

                 <div class="form-group px-2 col-md-3" style="padding-left:0px;padding-right:0px">
                     <select name="category_search" id="category_search" class="form-control">
                         <option value="">Category</option>
                     </select>
                 </div>

                 <div class="form-group col-md-2">
                     <button type="submit" id="btn_search" class="btn btn-primary btn-block" style="min-height:35px;">Search</button>
                 </div>


             </div>

             <div class="clearfix"></div>

             <h3 class="text-lg m-0 p-0" id="search-result-lbl">Results:</h3>
             <div class="coveo-result-list-container coveo-list-layout-container">

             </div>
             <div class="row d-flex justify-content-center  bg-light" id="view_more_kb_search">
                 <div class="p-1 col-12 text-center">
                     <span class="cursor-pointer text-primary" id="kb_search_view_more">
                         <i class="fas fa-plus mr-1"></i>View More</span>
                 </div>
             </div>
             <br>
             <br>
             <h3>Browse articles by category</h3>

             <hr class="no-top-margin">

             <div class="row  category-counts">

             </div>

             <br>
             <br>
             <h3>Latest Articles</h3>

             <hr>
             <div id="latest_kb_articles">


             </div> <br>
             <!-- <a class="btn btn-default" href="index.php?category=knowledgebase&amp;action=list">See All</a> -->
             <a class="btn btn-default" href="#knowledgebase-list">See All</a>
             <br>
             <br>
             <div class="clearfix"></div>
         </div>
     </div>

 </div>
<?php 
    include('resources/views/modals/kb_modal.php'); 
    include('resources/views/modals/kb_view_ticket_modal.php'); 
    include('resources/views/modals/kb_view_modal.php'); 
?>

 <!-- Toastr -->
 <script src="plugins/toastr/toastr.min.js"></script>
<!-- AutoCommplete -->
<script src="dist/js/bootstrap-autocomplete/bootstrap-autocomplete.min.js"></script>


 <?php 
    include('resources/views/common/script/function.php'); 
?>


 <script>
     var selected_kb_data = 0;

var search_display_limit_const = 5;
var search_display_limit = search_display_limit_const;
var search_display_count = 0;


// Ticket Replies
var ticket_replies_display_limit_const = 999;
var ticket_replies_display_limit = ticket_replies_display_limit_const;
var ticket_replies_display_count = 0;


function loadFilterCategory() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_sub_categories',
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            $.each(result, function(i, n) {
                $('#category_search').append(`<option value="` + n.id + `">` + n.text + `</option>`);
            });
        },
        error: function() {}
    });
}

function loadCategoryCounts() {
    return $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_sub_categories_content_count',
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            $.each(result, function(i, n) {
                $('.category-counts').append(`
                            <div class="col-md-4 min-height-40 no-left-padding">
                                <span class="category_link"><a href="index.php?category=knowledgebase&amp;action=list&amp;category_id=` + n.name + `" title="` + n.name + `">` + n.name + ` (` + n.count + `)</a></span><br>
                            </div>`);
            });
        },
        error: function() {}
    });
}

function resetSearchResult() {
    search_display_limit = search_display_limit_const;
    search_display_count = 0;
    $('.coveo-result-list-container').html('')
    $('#search-result-lbl').hide();
    $('#view_more_kb_search').addClass('hideEl');
}

function initSearchArticleBtn() {
    $('#btn_search').on('click', function(e) {
        resetSearchResult();
        startSearchArticle();
    });

    $('#search_by').on('keyup', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            resetSearchResult();
            startSearchArticle();
        }
    });
}

function startSearchArticle() {

    if (isEmpty($('#category_search').val()) && isEmpty($('#search_by').val())) {
        $('#search_by').trigger('focus');
        return false;
    }

    var active_items_arr = [];
    active_items_arr.push($('#category_search').val())
    var selected_filters_category = JSON.stringify(active_items_arr);

    $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_knowledgebase_list',
            search: $('#search_by').val(),
            filter_category: selected_filters_category,
            offset: search_display_limit - search_display_limit_const,
            limit: search_display_limit_const,
            short_description: 1
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            $.each(result['rows'], function(i, n) {
                $('#search-result-lbl').show();
                var html = n.descriptionf;
                html = html.replace(/<style([\s\S]*?)<\/style>/gi, '');
                html = html.replace(/<script([\s\S]*?)<\/script>/gi, '');
                html = html.replace(/<\/div>/ig, '\n');
                html = html.replace(/<\/li>/ig, '\n');
                html = html.replace(/<li>/ig, '  *  ');
                html = html.replace(/<\/ul>/ig, '\n');
                html = html.replace(/<\/p>/ig, '\n');
                html = html.replace(/<br\s*[\/]?>/gi, "\n");
                html = html.replace(/<[^>]+>/ig, '');
 
                    var uri = "#knowledgebase-view-"+n.id; 
                    if(parseInt(n.source) === 2){
                        uri = "#tickets-view-"+n.id;
                    }
                    $('.coveo-result-list-container').append(`
                    <div class="coveo-list-layout CoveoResult p-2">
                        <div>
                            <div class="coveo-title">
                            <a class="CoveoResultLink cursor-pointer" tabindex="0" role="heading" aria-level="2"  href="`+uri+`" target="_blank" >` + n.title + `</a>
                            </div>
                            <div class="CoveoExcerpt">` + html + `</div>
                        </div>
                    </div>
                        `);

                // $('.coveo-result-list-container').append(`
                //     <div class="coveo-list-layout CoveoResult p-2">
                //         <div>
                //             <div class="coveo-title"><a class="CoveoResultLink cursor-pointer" tabindex="0" role="heading" aria-level="2" onclick="viewKBInfo('`+n.source+`','`+n.id+`')" >` + n.title + `</a>
                //             </div>
                //             <div class="CoveoExcerpt">` + html + `</div>
                //         </div>
                //     </div>
                //         `);
                search_display_count++;

            });

            if (result['rows'].length == 0) {
                $('#view_more_kb_search').addClass('hideEl');
            } else {
                $('#view_more_kb_search').removeClass('hideEl');
            }
            if (search_display_count == 0) {
                // $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
                toastr.remove();
                toastr.info("No result found...");
                toastr.remove
            } else if (search_display_count != 0 && result['rows'].length == 0) {
                toastr.remove();
                toastr.info("No more result.")
            }

            if (parseInt(result.total) > search_display_limit_const) {
                $('#view_more_kb_search').removeClass('hideEl');
            } else {
                $('#view_more_kb_search').addClass('hideEl');
            }
        },
        error: function() {}
    });
}


function kbInformationEvt() {

    $('#kb_view_modal').on('shown.bs.modal', function(e) {

        $('#kb-view-info-modal-tab li a').removeClass('active')
        $('#kb-view-info-modal-tab-content .tab-pane').removeClass('active').removeClass('show')

        $('#kb-view-info-modal-tab-information').addClass('active')
        $('#kb-view-info-modal-tab-information-sec').addClass('active').addClass('show')

        $("[kb-view-info-data]").each(function() {
            $(this).html("<span class='text-md text-muted font-italic'>Loading...</span>")
        });

        readKBInformation();
        readKBAttachments();
    })
}


function initLatestArticle() {
    $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_knowledgebase_list',
            offset: 0, // search_display_limit - search_display_limit_const,
            limit: 5 //search_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            $.each(result['rows'], function(i, n) {
 
                    var uri = "#knowledgebase-view-"+n.id; 
                    if(parseInt(n.source) === 2){
                        uri = "#tickets-view-"+n.id;
                    }
                $('#latest_kb_articles').append(`
                     <a href="`+uri+`" target="_blank" class="cursor-pointer">` + n.title + `</a>
             <span class="font-xs left-margin-5">Posted on: ` + n.datew + `</span><br>

                        `);
            });
        },
        error: function() {}
    });
}



$(function() {
    resetSearchResult();
    loadFilterCategory();
    loadCategoryCounts();
    initSearchArticleBtn();
    initLatestArticle();
    kbInformationEvt();
    kbTicketInformationEvt();
    kbAutoComplete();

    $('#kb_search_view_more').on('click', function() {
        search_display_limit =
            search_display_limit +
            search_display_limit_const;
        startSearchArticle();
    });

});
 </script>