<script>
// alert(owned_ticket_only)
var selected_ticket_data = 0;
var is_new_ticket = 0;

var ticket_json_data = "";
var uploaded_ticket_attachments_arr = [];
var uploaded_ticket_attachments_has_error = false;
var uploaded_ticket_attachments_error_msg;
var remove_ticket_attachment_mock_files = [];

var reply_ticket_json_data = "";
var uploaded_reply_ticket_attachments_arr = [];
var uploaded_reply_ticket_attachments_has_error = false;
var uploaded_reply_ticket_attachments_error_msg;

var ticket_selected_filters = "[]";
var ticket_selected_filters_priority = "[]";
var ticket_selected_filters_category = "[]";
var ticket_selected_filters_final_status = "[]";

// Ticket Replies
var ticket_replies_display_limit_const = 5;
var ticket_replies_display_limit = ticket_replies_display_limit_const;
var ticket_replies_display_count = 0;

var selected_kb_data = 0;
var kb_display_limit_const = 5;
var kb_display_limit = kb_display_limit_const;
var kb_display_count = 0;

// Ticket activity
var ticket_activities_display_limit_const = 5;
var ticket_activities_display_limit = ticket_activities_display_limit_const;
var ticket_activities_display_count = 0;

Dropzone.autoDiscover = false;

function startReplyTicketUpload() {
    if (ticketReplyDropzone.getAcceptedFiles().length < 1) {
        // createReplyTicket();
        createReplyTicketV2();
        return false;
    }
    for (var i = 0; i < ticketReplyDropzone.getAcceptedFiles().length; i++) {
        ticketReplyDropzone.processFile(ticketReplyDropzone.getAcceptedFiles()[i]);
    }
}


function ticketActionFormatter(value, row, index) {
    return "<span id='update_ticket_" + row.id + "' update-ticket-action='" + row.id + "' class='border-primary text-primary border-bottom'>Update</span>"
}

function removeTicketFormatter(value, row, index) {
    // return '<span class="font-weight-bold"><i class="fa fa-times text-danger text-lg cursor-pointer" aria-hidden="true"></i></span>';
    return '<span class="font-weight-bold"><i class="fas fa-trash text-danger text-md cursor-pointer"></i></span>';
}

function ticketTitleFormatter(value, row, index) {
    var color = "badge-primary";
    if(row.status == 'In Progress'){
        color = "badge-warning";
    }else if(row.status == 'On Hold'){
        color = "badge-danger";
    }else if(row.status == 'Close'){
        color = "badge-success";
    }else if(row.status == 'Escalated (In Progress)' || row.status == 'Escalated (Close)'){
        color = "badge-secondary";
    }else if(row.status == 'Close (Solve Escalated)'){
        color = "badge-info";
    }

    return "<span style='font-size:15px;'  class='font-weight-bold'>"+value+"</span><br><span style='font-size:12px; border-radius: 0.0rem;' class='badge "+color+"'>"+row.status+"</span>";
}

function ticketStatusFormatter(value, row, index) {
    if (row.final_status_id == '1') {
        return "<span class='text-success font-weight-bold'>" + value + "<span>";
    }
    if (row.final_status_id == '2') {
        return "<span class='text-danger font-weight-bold'>" + value + "<span>";
    }
    return "<span class='text-primary font-weight-bold'>" + value + "<span>";;
    // return "<span id='update_ticket_" + row.id + "' update-ticket-action='" + row.id + "' class='border-primary text-primary border-bottom'>Update</span>"
}

function createReplyTicketV2() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'create_ticket_reply_v2',
            json_data: reply_ticket_json_data,
            attachments: JSON.stringify(uploaded_reply_ticket_attachments_arr),
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#reply_ticket_send_btn').prop(
                'disabled', true);
            toastr.remove();
            toastr.info("Sending response...");
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                // created_ticket_id = result.id;

                    //reset
                        readTicketRepliesV2();
                        readTicketInformationData();
                        ticketReplyDropzone.removeAllFiles(true);
                        $('#ticket_reply').val('');
                        uploaded_reply_ticket_attachments_has_error = false;
                        uploaded_reply_ticket_attachments_arr = [];

                        resetTicketActivities();

                       

                 toastr.remove();
                toastr.success(result.message);

            } else {
               toastr.remove();
                toastr.error(result.message);
               
            }
              $('#reply_ticket_send_btn').prop(
                    'disabled', false);
        },
        error: function() {
            $('#reply_ticket_send_btn').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}
function createReplyTicket() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'create_ticket_reply',
            json_data: reply_ticket_json_data,
            attachments: JSON.stringify(uploaded_reply_ticket_attachments_arr),
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#reply_ticket_send_btn').prop(
                'disabled', true);
            toastr.remove();
            toastr.info("Sending response...");
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                // created_ticket_id = result.id;
                createReplyTicketDone(result.message)

            } else {
                $('#reply_ticket_send_btn').prop(
                    'disabled', false);
                toastr.remove();
                toastr.error(result.message);
            }
        },
        error: function() {
            $('#reply_ticket_send_btn').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}

function showReopenTicket() {
    $('.ticket-reopen-status').show();
    // hide close, resolve, unresolve option
    $('.ticket-final-status').hide();
    // $('#reply_ticket_send_btn').removeClass('mt-3')
}

function showCloseTicket() {
    $('.ticket-reopen-status').hide();
    $('.ticket-escalated-status').hide();
    // show close, resolve, unresolve option
    $('.ticket-final-status').show();
    // $('#reply_ticket_send_btn').addClass('mt-3')
}


function showEscalatedTicket(){
    $('.ticket-escalated-status').show();
}

 

function resetTicketInfoChk() {

    $('#ticket_reply').val('');
    $('#txt_final_status').val('');
    $('#chk_resolve_ticket').prop('checked', false);
    $('#chk_unresolve_ticket').prop('checked', false);

    $('#chk_reopen_ticket').val('');
    $('#chk_reopen_ticket').prop('checked', false);

    $('#chk_escalated_solve_ticket').val('');
    $('#chk_escalated_solve_ticket').prop('checked', false);
}

function createReplyTicketDone(message) {
    toastr.remove();
    toastr.success(message);

    // var $el = $('#ticket_info_modal');
    // resetElementForm($el);

    $('#ticket_reply').val('');
    $('#chk_close_ticket').val('2');
    $('#chk_close_ticket').prop('checked', false);

    if (!isEmpty($('#chk_reopen_ticket').val()) && isEmpty($('#txt_final_status').val())) {
        showCloseTicket();
    } else if (isEmpty($('#chk_reopen_ticket').val()) && !isEmpty($('#txt_final_status').val())) {
        showReopenTicket();
    }  else {
        // No changes in status
        // $('.ticket-reopen-status').hide();
        // $('.ticket-final-status').hide();
    }

    if($('#chk_unresolve_ticket').is(":checked")){ 
        showEscalatedTicket();
    }
    
    if($('#chk_escalated_solve_ticket').is(":checked")){ 
        $('.ticket-escalated-status').hide();
    }
    resetTicketInfoChk();

    // $('#ticket_info_modal').modal(
    //     'hide');
    $('#reply_ticket_send_btn').prop(
        'disabled', false);


    defaultTicketReplies();
    refreshTicketTableSilent();

}

// DROPZONE 2 END

function refreshTicketTable() {
    initTicketList();
    var $table = $('#table_tickets')
    $(function() {
        $table.bootstrapTable('refresh', {
            url: 'app/models/ticket.php'
        });
    })
}

function refreshTicketTableSilent() {

    var $table = $('#table_tickets')
    $(function() {
        try {
            $table.bootstrapTable('refresh', {
                url: 'app/models/ticket.php'
            });
        } catch (e) {
            console.log('reply from viewer. error: ' + e)
        }
    })


}

function initTicketList() {
    var $table = $('#table_tickets');
    $table.bootstrapTable('destroy').bootstrapTable({
        sidePagination: 'server',
        formatSearch: function() {
            return 'Search...'
        },
        onLoadSuccess: function() {
            initTicketActionColVisibility();
            initTicketActionEvent();

        },
        exportOptions: {
            fileName: function() {
                return 'titile'
            }
        }
    });
}

function initTicketActionEvent() {
    $("[update-ticket-action]").each(function() {
        $(this).on('click', function() {
            // var ticket_id = $(this).attr("update-ticket-action");
            removeSelectChangeEvt();
            is_new_ticket = 0;
            resetTicketModal();
            // myDropzone.removeAllFiles(true);
            // fetch selected ticket
            $('#ticket_modal').modal('show');
            setTimeout(function() {
                initTicketData();
            }, 100)

        });
    });
}

function initTicketData() {
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_data',
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {},
        success: function(result) {
            addSelectChangeEvt();
            remove_ticket_attachment_mock_files = [];
            $.each(result.rows, function(i, n) {
                $("#" + i).text(n);
                $("#" + i).val(n);
                $("#" + i).trigger('change')
                var newState = new Option(n, n, true, true);
                // Append it to the select
                $("#" + i).append(newState).trigger('change');


            });

            $.each(result.attachments, function(key, value) {
                var mockFile = {
                    id: value.id,
                    name: value.original_name,
                    size: value.unreadable_size
                };
                myDropzone.emit("addedfile", mockFile);
                myDropzone.emit("complete", mockFile);
                myDropzone.files.push(mockFile); // here you add them into the files array  
            });

            // delete ticket_attachment_mock_files[57]; 
        },
        error: function() {}
    });
}

function initTicketActionColVisibility() {
    if (owned_ticket_only) {
        // $('.action-formatter-th').show()
        $('.action-formatter-th').hide()
    } else {
        $('.action-formatter-th').hide()
    }
  if (remove_access) { 
        $('.remove-formatter-th').show()
    } else {
        $('.remove-formatter-th').hide()
    }

}

function ticketsQueryParams(params) {

    var start = $('#filter-date').data('daterangepicker').startDate;
    var end = $('#filter-date').data('daterangepicker').endDate;

    var start_date = start.format('YYYY-MM-DD');
    var end_date = end.format('YYYY-MM-DD');

    return {
        search: $('#ticket-search').val(),
        offset: params.offset,
        limit: params.limit,
        sort: params.sort,
        order: params.order,
        filter_status: ticket_selected_filters_final_status,
        filter_category: ticket_selected_filters_category,
        filter_priority: ticket_selected_filters_priority, 
        filter_brand: $('#brand-filter').val(),
        filter_model: $('#model-filter').val(),
        start_date: start_date,
        end_date: end_date,
        owned_ticket_only: owned_ticket_only,
        model: 'read_ticket_list',
    };
}



function resetTicketModal() {
    var $el = $('#ticket_modal');
    resetElementForm($el);

    myDropzone.removeAllFiles(true);
    // $('.select2bs4').val('').trigger('change');
}


function createTicketDone(message) {
    toastr.remove();
    toastr.success(message);
    resetTicketModal();
    $('#ticket_modal').modal(
        'hide');
    $('#kb_suggestion_modal').modal(
        'hide');
    $('#btn_ticket_save').prop(
        'disabled', false);
    $('#btn_ticket_save_2').prop(
        'disabled', false);
    refreshTicketTableSilent();
}





function createTicket() {
    // console.log(remove_ticket_attachment_mock_files);
    return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'create_ticket',
            json_data: ticket_json_data,
            attachments: JSON.stringify(uploaded_ticket_attachments_arr),
            is_new_ticket: is_new_ticket,
            ticket_id: selected_ticket_data,
            remove_attachments: JSON.stringify(remove_ticket_attachment_mock_files)
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#btn_ticket_save').prop(
                'disabled', true);

            $('#btn_ticket_save_2').prop(
                'disabled', true);
            toastr.remove();
            toastr.info("Creating ticket...");
        },
        success: function(result) {
            if (parseInt(result.status) === 1) {
                // created_ticket_id = result.id;
                createTicketDone(result.message)
            } else {
                $('#btn_ticket_save').prop(
                    'disabled', false);

                $('#btn_ticket_save_2').prop(
                    'disabled', false);
                toastr.remove();
                toastr.error(result.message);
            }
        },
        error: function() {
            $('#btn_ticket_save').prop(
                'disabled', false);

            $('#btn_ticket_save_2').prop(
                'disabled', false);
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });
}


function resetDateRangePicker() {
    // daterangepicker_filter = false;
    var start = isEmpty(param_start) ? moment().startOf('year') : moment(param_start); 
    var end = isEmpty(param_end) ? moment().endOf('year') : moment(param_end); 
    // moment().startOf('month'), moment().endOf('month')
    $("#filter-date").data('daterangepicker').setStartDate(start);
    $("#filter-date").data('daterangepicker').setEndDate(end);
    // $('#filter-date').data('daterangepicker').chosenLabel = 'Disable';
    $('#filter-date').data('daterangepicker').hideCalendars();
    // $('.daterangepicker').css('width', 'auto');
    // $('#filter-date span').html('Date Filter'); 
    $('#filter-date span').html(start.format('M/D/YYYY') + '&nbsp;to<br>' + end.format(
        'M/D/YYYY'));
}

function readTicketInformation() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_information',
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            resetTicketInfoChk();
            $('.type_vehicle_reply_modal').hide();
            $('#reply_ticket_send_btn').prop(
                'disabled', true);
        },
        success: function(result) {

  if (result.ticket_type == '1') {
               $('#chk_classified').prop('checked', true);
            }else{
                $('#chk_classified').prop('checked', false);
            } 
                
            if (parseInt(result.show_vehicle) === 1) { 
                $('.type_vehicle_reply_modal').show();
            }

            // alert(result.category_id)
            if (parseInt(result.ticket_status_id) === 3) {
                $("#chk_close_ticket").val('3');
                $('#chk_close_ticket').prop('checked', true);
                // show reopen ticket
                showReopenTicket();
                if(result.ticket_final_status_id == '2' && isEmpty(result.escalated_ticket_id)){
                    showEscalatedTicket();
                }
            } else {
                $("#chk_close_ticket").val('2');
                $('#chk_close_ticket').prop('checked', false);
                // hide reopen ticket
                showCloseTicket();
            }

            $.each(result, function(i, n) {

                if (i.startsWith("lbl_")) {
                    if (i == "lbl_ticket_description") {
                        $("#" + i).html(n);
                    } else {
                        $("#" + i).text(n);
                        $("#" + i).val(n);
                        $("#" + i).trigger('change')
                    }

                    if (isEmpty(n)) {
                        $("#" + i + "_div").hide();
                    } else {
                        $("#" + i + "_div").show();
                    }
                }
            });


            $('#reply_ticket_send_btn').prop(
                'disabled', false);
        },
        error: function() {
            $('#reply_ticket_send_btn').prop(
                'disabled', false);
        }
    });
}

function readTicketAttachments() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_attachments',
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#ticket_attachment').html('')
        },
        success: function(result) {

            $.each(result, function(i, n) {
                
                var dl_hover = ` <div class="hover "> 
                                        <button type="button" onClick="downloadTicketAttachment('` + n.change_name + `','1')" title="Download" class="tooltip-me btn btn-icon btn-primary">
                                            <i class="fa fa-download"></i>
                                        </button>
                                    </div>`;

                var fileExt = n.change_name.split('.').pop(); 
                var filename = n.change_name.replace(/\.[^/.]+$/, "")  
                var href_uri = `href="javascript:void(0);"`;
                            switch(fileExt){
                                case 'png':
                                case 'jpg':
                                case 'jpeg':
                                    // href_uri = `data-toggle="lightbox" href="dist/attachments/`+n.change_name+`"`;
                                    href_uri = ` data-type="image" data-toggle="lightbox" href="viewer/image.php?token=` + filename + `@` + `1"`;
                                    dl_hover = "";
                                break;
                                case 'pdf':  
                                    href_uri = `target="_blank" href="pdf/pdf.php?token=` + filename + `@` + `1"`;
                                    dl_hover = "";
                                break;
                                default:
                                
                            }

                $('#ticket_attachment').append(`
                         <div class="col-lg-3 col-md-4 col-sm-12 pb-3">
                            <div class="card h-100">
                                <div class="file"  >
                                    <a `+href_uri+`> 
                                    `+dl_hover+`
                                        <div class="icon p-0">
                                           ` + n.icon + `
                                        </div>
                                        <div class="file-name">
                                            <p class="mb-0 text-muted">` + n.original_name + `</p>
                                            <small>Size: ` + n.size + ` <span class="date text-muted">` + n.date + `</span></small>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        `);
            });

            if (result.length == 0) {
                $('#ticket_attachment').html('<div class="col-12 text-center"><span class="text-center">No attachment</span></div>')
            } else {
                defaultFunctions();
            }


        },
        error: function() {}
    });
}

// function downloadTicketAttachment(file, src) {
//     var fileExt = file.split('.').pop();
//     alert(fileExt);return false;
//     var url = "download.php?src=" + src + "&file=" + file;
//     window.open(url, '_blank').focus();
// }

// function viewTicketAttachment(file, name) {
//     var re = /(?:\.([^.]+))?$/;
//     var ext = re.exec(file)[1];
//     switch (ext) {
//         case "jpg":
//         case "jpeg":
//         case "png":

//             break;
//         default:
//             // toastr.remove();
//             // toastr.info("This file can't open online, download the file instead.");
//     }
// }

function readTicketReplies() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_replies',
            ticket_id: selected_ticket_data,
            order: 'desc',
            offset: ticket_replies_display_limit - ticket_replies_display_limit_const,
            limit: ticket_replies_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            // $('#ticket_replies').html('')
        },
        success: function(result) {
            $.each(result['rows'], function(i, n) {
                var content_description = isEmpty(n.description) ? '' : n.description;
                var this_reply_attachment_count = 0;
                var reply_attachments = ``;
                $.each(result['attachments'], function(j, m) {
                    if (n.id == m.reply_id) {
                            var fileExt = m.attachment_name.split('.').pop();  
                            var filename = m.attachment_name.replace(/\.[^/.]+$/, "")  
                            switch(fileExt){
                                case 'png':
                                case 'jpg':
                                case 'jpeg':
                                    //  reply_attachments = reply_attachments + `<a data-toggle="lightbox" href="dist/attachments/`+m.attachment_name+`" > 
                                    //                         <u><span>` + m.original_name + `</span></u>
                                    //                     </a><br>`;
                                     reply_attachments = reply_attachments + `<a  data-type="image" data-toggle="lightbox" href="viewer/image.php?token=`+ filename + `@1" > 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;

                                break;
                                case 'pdf': 
                                    reply_attachments = reply_attachments + `<a target="_blank"  href="pdf/pdf.php?token=` + filename + `@1" > 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;
                                    break;
                                default:
                                                reply_attachments = reply_attachments + `<a href="javascript:void(0);" onClick="downloadTicketAttachment('` + m.attachment_name + `','2')"> 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;
                            }
 
                        this_reply_attachment_count++;
                    }
                });

                
                var hide_attachment_area = (this_reply_attachment_count > 0) ? '' : 'hidden';

                var final_status_msg = (isEmpty(n.final_status_id) ?  (isEmpty(n.reopen_ticket_id) ? '' : 'Reopen the ticket.') : (isEmpty(n.escalated_ticket_id) ? 'Closed the ticket.' : 'Closed, solve in plant.')) ;

                var remove_reply = isEmpty(final_status_msg) ?  `<br><small class="text-danger float-lg-right" remove-ticket-reply="` + n.id + `" ><u>` + n.remove + `</u></small>` : '' ;

                $('#ticket_replies').append(`
                                            <li>
                                                <a href="javascript:void(0);"> 
                                                    <img class="contacts-list-img" src="dist/img/profile.png" alt="User Avatar">


                                                    <div class="contacts-list-info">
                                                    <div class="pl-1 row">

                                                        <div class="col-lg-6 col-sm-12">
                                                            <span class="contacts-list-name text-dark">
                                                                ` + n.user + `<small class="text-primary">` + n.creator + `</small>   
                                                                <small class="text-primary text-muted font-italic">`+final_status_msg+`</small>
                                                            </span>
                                                            
                                                        </div>
                                                        <div class="col-lg-6 col-sm-12">
                                                           <small class="contacts-list-date pt-1 float-lg-right text-dark">` + n.date_added + `</small>
                                                            `+remove_reply+`
                                                        </div>
                                                    </div>
                                                    <div class="col pl-1">
                                                        <span class="contacts-list-msg text-dark">` + content_description + `</span>
                                                    </div>

                                                    <div class="pl-1 pt-2 reply-attachment" ` + hide_attachment_area + `>
                                                        <span class="text-dark font-weight-normal">Attachment(s):</span><br> 
                                                        ` + reply_attachments + `
                                                    </div>
                                                    

                                                    </div>
                                                    <!-- /.contacts-list-info -->

                                                </a>
                                              
                                            </li>
                                            <!-- End Contact Item -->
                        `);
                ticket_replies_display_count++;
            });


            // add ticket reply remove listner
            $("[remove-ticket-reply]").each(function() {
                $(this).off('click').on('click', function() {
                    var ticket_reply_id = $(this).attr('remove-ticket-reply');

                    // SWAL
                    Swal.fire({
                        icon: 'warning',
                        html: 'Are you sure you want to remove this reply?',
                        showDenyButton: false,
                        showCancelButton: true,
                        confirmButtonText: `Yes`,
                        cancelButtonText: `No`,
                        denyButtonText: `Don't Confirm`,
                        showClass: {
                            backdrop: 'swal2-noanimation', // disable backdrop animation
                            popup: '', // disable popup animation
                            icon: '' // disable icon animation
                        },
                        hideClass: {
                            popup: '', // disable popup fade-out animation
                        },
                        customClass: 'swal-height'
                    }).then((result) => {
                        if (result.isConfirmed) {

                            $.ajax({
                                url: "app/models/ticket.php",
                                data: {
                                    model: 'delete_ticket_reply',
                                    ticket_reply_id: ticket_reply_id
                                },
                                type: "POST",
                                dataType: 'json',
                                beforeSend: function() {
                                    toastr.remove();
                                    toastr.info('Removing reply...')
                                },
                                success: function(result) {
                                    toastr.remove();
                                    toastr.success(result.message);
                                    $('#ticket_replies').html('')
                                    readTicketReplies();
                                },
                                error: function() {}
                            });


                        } else if (result.isDenied) {} else {}
                    })
                    // SWAL

                });
            });


            if (result['rows'].length == 0) {
                $('#view_more_replies').addClass('hideEl');
            } else {
                $('#view_more_replies').removeClass('hideEl');
            }
            if (ticket_replies_display_count == 0) {
                $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
            } else if (ticket_replies_display_count != 0 && result['rows'].length == 0) {
                toastr.remove();
                toastr.info("No more replies.")
            }




        },
        error: function() {}
    });
}

function readTicketRepliesV2() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_replies_v2',
            ticket_id: selected_ticket_data,
            order: 'desc',
            offset: ticket_replies_display_limit - ticket_replies_display_limit_const,
            limit: ticket_replies_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#ticket_replies').html('')
        },
        success: function(result) { 
               if (result['rows'].length <= 0) {
                   $('#ticket_replies').html(`<div class="col-12 text-center"><span class="text-center">No feedback</span></div>`)
                   return false;
               }

            $.each(result['rows'], function(i, n) {
                var content_description = isEmpty(n.description) ? '' : n.description;
                var this_reply_attachment_count = 0;
                var reply_attachments = ``;
                $.each(result['attachments'], function(j, m) {
                    if (n.id == m.reply_id) {
                            var fileExt = m.attachment_name.split('.').pop();  
                            var filename = m.attachment_name.replace(/\.[^/.]+$/, "")  
                            switch(fileExt){
                                case 'png':
                                case 'jpg':
                                case 'jpeg':
                                    reply_attachments = reply_attachments + `<a data-type="image" data-toggle="lightbox" href="viewer/image.php?token=`+ filename + `@1">
                                                                                <u>
                                                                                    <p class="text-sm p-0 m-0">`+ m.original_name + `</p>
                                                                                </u>
                                                                            </a>`;

                                break;
                                case 'pdf':  
                                    reply_attachments = reply_attachments + `<a  target="_blank" href="pdf/pdf.php?token=` + filename + `@1">
                                                                                <u>
                                                                                    <p class="text-sm p-0 m-0">` + m.original_name + `</p>
                                                                                </u>
                                                                            </a>`;
                                    break;
                                default:
                                                reply_attachments = reply_attachments + `<a href="javascript:void(0);" onClick="downloadTicketAttachment('` + m.attachment_name + `','2')">
                                                                                            <u>
                                                                                                <p class="text-sm p-0 m-0">` + m.original_name + `</p>
                                                                                            </u>
                                                                                        </a>`;
                            }
 
                        this_reply_attachment_count++;
                    }
                });

                
                var hide_attachment_area = (this_reply_attachment_count > 0) ? '' : 'hidden';

                var final_status_msg = (isEmpty(n.final_status_id) ?  (isEmpty(n.reopen_ticket_id) ? '' : 'Reopen the ticket.') : (isEmpty(n.escalated_ticket_id) ? 'Closed the ticket.' : 'Closed, solve in plant.')) ;

                var remove_reply = isEmpty(final_status_msg) ?  `<br><small class="text-danger float-lg-right" remove-ticket-reply="` + n.id + `" ><u>` + n.remove + `</u></small>` : '' ;

                var default_chat_one = ''
                var default_chat_two = 'mr-5 ml-0 custom-left-border' 
                if(n.reply_owner){
                    default_chat_one = 'right'
                    default_chat_two = 'mr-0 ml-5 custom-right-border' 
                }


                $('#ticket_replies').append(`<div class="direct-chat-msg `+default_chat_one+`">
                        <div class="direct-chat-textt `+default_chat_two+`">
                            <div class="direct-chat-infos clearfix">
                                <span class="direct-chat-name float-left"> ` + n.user + `</span>
                            </div>
                            ` + content_description + `
                            <div class="pl-1 pt-2 reply-attachment" ` + hide_attachment_area + `>
                                <p class="text-dark text-sm font-weight-normal m-0 p-0">Attachment(s):</p>
                                ` + reply_attachments + `
                            </div>
                            <div class="direct-chat-infos clearfix mt-3">
                                <span class="float-left">Posted on&nbsp;</span>
                                <span class="direct-chat-name float-left">` + n.date_added + `</span>
                            </div>
                        </div>
                    </div>`)
                // $('#ticket_replies').append(`
                //                             <li>
                //                                 <a href="javascript:void(0);"> 
                //                                     <img class="contacts-list-img" src="dist/img/profile.png" alt="User Avatar">


                //                                     <div class="contacts-list-info">
                //                                     <div class="pl-1 row">

                //                                         <div class="col-lg-6 col-sm-12">
                //                                             <span class="contacts-list-name text-dark">
                //                                                 ` + n.user + `<small class="text-primary">` + n.creator + `</small>   
                //                                                 <small class="text-primary text-muted font-italic">`+final_status_msg+`</small>
                //                                             </span>
                                                            
                //                                         </div>
                //                                         <div class="col-lg-6 col-sm-12">
                //                                            <small class="contacts-list-date pt-1 float-lg-right text-dark">` + n.date_added + `</small>
                //                                             `+remove_reply+`
                //                                         </div>
                //                                     </div>
                //                                     <div class="col pl-1">
                //                                         <span class="contacts-list-msg text-dark">` + content_description + `</span>
                //                                     </div>

                //                                     <div class="pl-1 pt-2 reply-attachment" ` + hide_attachment_area + `>
                //                                         <span class="text-dark font-weight-normal">Attachment(s):</span><br> 
                //                                         ` + reply_attachments + `
                //                                     </div>
                                                    

                //                                     </div>
                //                                     <!-- /.contacts-list-info -->

                //                                 </a>
                                              
                //                             </li>
                //                             <!-- End Contact Item -->
                //         `);
                ticket_replies_display_count++;
            });


            // add ticket reply remove listner
            // $("[remove-ticket-reply]").each(function() {
            //     $(this).off('click').on('click', function() {
            //         var ticket_reply_id = $(this).attr('remove-ticket-reply');

            //         // SWAL
            //         Swal.fire({
            //             icon: 'warning',
            //             html: 'Are you sure you want to remove this reply?',
            //             showDenyButton: false,
            //             showCancelButton: true,
            //             confirmButtonText: `Yes`,
            //             cancelButtonText: `No`,
            //             denyButtonText: `Don't Confirm`,
            //             showClass: {
            //                 backdrop: 'swal2-noanimation', // disable backdrop animation
            //                 popup: '', // disable popup animation
            //                 icon: '' // disable icon animation
            //             },
            //             hideClass: {
            //                 popup: '', // disable popup fade-out animation
            //             },
            //             customClass: 'swal-height'
            //         }).then((result) => {
            //             if (result.isConfirmed) {

            //                 $.ajax({
            //                     url: "app/models/ticket.php",
            //                     data: {
            //                         model: 'delete_ticket_reply',
            //                         ticket_reply_id: ticket_reply_id
            //                     },
            //                     type: "POST",
            //                     dataType: 'json',
            //                     beforeSend: function() {
            //                         toastr.remove();
            //                         toastr.info('Removing reply...')
            //                     },
            //                     success: function(result) {
            //                         toastr.remove();
            //                         toastr.success(result.message);
            //                         $('#ticket_replies').html('')
            //                         readTicketReplies();
            //                     },
            //                     error: function() {}
            //                 });


            //             } else if (result.isDenied) {} else {}
            //         })
            //         // SWAL

            //     });
            // });

            // if (result['rows'].length == 0) {
            //     $('#view_more_replies').addClass('hideEl');
            // } else {
            //     $('#view_more_replies').removeClass('hideEl');
            // }
            // if (ticket_replies_display_count == 0) {
            //     $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
            // } else if (ticket_replies_display_count != 0 && result['rows'].length == 0) {
            //     toastr.remove();
            //     toastr.info("No more replies.")
            // }




        },
        error: function() {}
    });
}

function readTicketActivities() {
    $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'read_ticket_activities',
            // model: 'read_ticket_replies_v2',
            ticket_id: selected_ticket_data,
            order: 'ASC',
            offset: ticket_activities_display_limit - ticket_activities_display_limit_const,
            limit: ticket_activities_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            // $('#ticket_activities').html('')
        },
        success: function(result) {
            $.each(result['rows'], function(i, n) {
              
                $('#ticket_activities').append(`
                                          <div class="direct-chat-textt mr-0 ml-0 custom-left-border py-1">
                                                <div class="direct-chat-infos clearfix my-0">
                                                    <span class="direct-chat-name float-left">`+n.user+`</span>
                                                    <br>
                                                    <span class="m-0 p-0 text-md">`+n.description+`</span>
                                                    <br>
                                                    <span class="direct-chat-name float-left">`+n.date_added+`</span>
                                                </div>
                                            </div>
                        `);
                ticket_activities_display_count++;
            });

            if (result['rows'].length == 0) {
                $('#view_more_activities').addClass('hideEl');
            } else {
                $('#view_more_activities').removeClass('hideEl');
            }
            if (ticket_activities_display_count == 0) {
                $('#ticket_activities').html('<div class="col-12 text-center"><span class="text-center">No activities</span></div>')
            } else if (ticket_activities_display_count != 0 && result['rows'].length == 0) {
                toastr.remove();
                toastr.info("No more activities.")
            } 
        },
        error: function() {}
    });
}

function defaultTicketReplies() {
    ticket_replies_display_limit = ticket_replies_display_limit_const;
    ticket_replies_display_count = 0;
    $('#ticket_replies').html('')
    readTicketReplies();
}

function removeSelectChangeEvt() {
    // $('#category').off('change');
    // $('#brand').off('change');
    // $('#brand-filter').off('change');
}


function initFilterCategory() {
    $.when(loadTicketFilterCategory()).done(function(ajax1Results) {
        $(".ticket-filter-category li").each(function() {
            $(this).on('click', function() {
                $(this).toggleClass("active");

                var active_items = $('.ticket-filter-category').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });

                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });

                ticket_selected_filters_category = JSON.stringify(active_items_arr);
                // alert(ticket_selected_filters_category)
                refreshTicketTableSilent();
            });
        });


          $(".ticket-filter-category li").each(function() {
            var cur_text = $(this).text();
            if (param_category.includes(cur_text)) {
                $(this).toggleClass("active");
                var active_items = $('.ticket-filter-category').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });
                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });
                ticket_selected_filters_category = JSON.stringify(active_items_arr);
            }
        });
        if (param_category.length > 0) {
            refreshTicketTableSilent();
        }

    });
}

function initFilterFinalStatus() {
    $.when(loadTicketFilterFinalStatus()).done(function(ajax1Results) {
        $(".ticket-filter-final-status li").each(function() {
            $(this).on('click', function() {
                $(this).toggleClass("active");

                var active_items = $('.ticket-filter-final-status').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });

                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });

                ticket_selected_filters_final_status = JSON.stringify(active_items_arr);
                // alert(ticket_selected_filters_final_status)
                refreshTicketTableSilent();
            });
        });

         $(".ticket-filter-final-status li").each(function() {
            var cur_text = $(this).text();
            if (param_status.includes(cur_text)) {
                $(this).toggleClass("active");
                var active_items = $('.ticket-filter-final-status').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });
                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });
                ticket_selected_filters_final_status = JSON.stringify(active_items_arr);
            }
        });
        if (param_status.length > 0) {
            refreshTicketTableSilent();
        }

    });
}

function initFilterStatus() {
    $.when(loadTicketFilterStatus()).done(function(ajax1Results) {
        $(".ticket-filter-status li").each(function() {
            $(this).on('click', function() {

                $(this).toggleClass("active");

                var active_items = $('.ticket-filter-status').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });

                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });

                ticket_selected_filters = JSON.stringify(active_items_arr);
                // alert(ticket_selected_filters_category)
                refreshTicketTableSilent();
            });
        });

        $(".ticket-filter-status li").each(function() {
            var cur_text = $(this).text();
            if (param_progress.includes(cur_text)) {
                $(this).toggleClass("active");
                var active_items = $('.ticket-filter-status').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });
                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });
                ticket_selected_filters = JSON.stringify(active_items_arr);
            }
        });
        if (param_progress.length > 0) {
            refreshTicketTableSilent();
        }
    });
}

function initFilterPriority() {
    $.when(loadTicketFilterPriority()).done(function(ajax1Results) {
        $(".ticket-filter-priority li").each(function() {
            $(this).on('click', function() {

                $(this).toggleClass("active");

                var active_items = $('.ticket-filter-priority').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });

                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });

                ticket_selected_filters_priority = JSON.stringify(active_items_arr);
                // alert(ticket_selected_filters_category)
                refreshTicketTableSilent();
            });
        });

         $(".ticket-filter-priority li").each(function() {
            var cur_text = $(this).text();
            if (param_priority.includes(cur_text)) {
                $(this).toggleClass("active");
                var active_items = $('.ticket-filter-priority').find('li.active').map(
                    function() {
                        var item = {};
                        // item.id = this.value;
                        item.status = $(this).text();
                        return item;
                    });
                var active_items_arr = [];
                $.each(active_items, function(i, n) {
                    active_items_arr.push(n.status)
                });
                ticket_selected_filters_priority = JSON.stringify(active_items_arr);
            }
        });
        if (param_priority.length > 0) {
            refreshTicketTableSilent();
        }

    });
}



function ticketTableCellClickEvt() {
    $('#table_tickets').on('click-cell.bs.table', function(field, value, row, $el) {
        
        if (value == 'action_remove') {
            removeTicket($el.id)
            return;
        }
  
        window.location.hash = 'tickets-view-'+$el.id;
        return;
    });
}

function removeTicket(id){
     Swal.fire({
                        icon: 'warning',
                        html: 'Are you sure you want to remove this case?',
                        showDenyButton: false,
                        showCancelButton: true,
                        confirmButtonText: `Yes`,
                        cancelButtonText: `No`,
                        denyButtonText: `Don't Confirm`,
                        showClass: {
                            backdrop: 'swal2-noanimation', // disable backdrop animation
                            popup: '', // disable popup animation
                            icon: '' // disable icon animation
                        },
                        hideClass: {
                            popup: '', // disable popup fade-out animation
                        },
                        customClass: 'swal-height'
                    }).then((result) => {
                        if (result.isConfirmed) {

                            $.ajax({
                                url: "app/models/ticket.php",
                                data: {
                                    model: 'delete_ticket',
                                    id: id
                                },
                                type: "POST",
                                dataType: 'json',
                                beforeSend: function() {
                                    toastr.remove();
                                    toastr.info('Removing...')
                                },
                                success: function(result) {
                                    toastr.remove();
                                    toastr.success(result.message);
                                    refreshTicketTableSilent();
                                },
                                error: function() {}
                            });


                        } else if (result.isDenied) {} else {}
                    })
}

function btnNewTicketEvt() {
    $('#new_ticket').on("click", function(e) {
        is_new_ticket = 1;
        resetTicketModal();
        $('#ticket_modal').modal('show');
    });
}

function initDateRangePicker() {
    // var start = moment().startOf('year');//, moment().endOf('year')//moment().startOf('month');
    // var end = moment().endOf('year');
      var start = isEmpty(param_start) ? moment().startOf('year') : moment(param_start); 
    var end = isEmpty(param_end) ? moment().endOf('year') : moment(param_end); 

    $('#filter-date').daterangepicker({
        // autoUpdateInput: false,
        showDropdowns: true,
        maxDate: new Date(),
        // parentEl: '#ticket-more-filter',
        locale: {
            cancelLabel: 'Cancel'
        },
        startDate: start,
        opens: "left",
        endDate: end,
        ranges: {
            // 'Disable': [moment(), moment()],
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1,
                'year').endOf('year')]
        }
    });

    $('#filter-date').on('apply.daterangepicker', function(ev, picker) {
        $('#filter-date span').html(picker.startDate.format('M/D/YYYY') + '&nbsp;to<br>' + picker.endDate.format(
            'M/D/YYYY'));
        refreshTicketTableSilent();
        // }

    });
}


function initTicketSearchEvt() {
    $('#ticket-search').focusin(function() {
        $('#ticket-search-div').removeClass('default-search-size');
        $('#ticket-search-div').addClass('expand-search-size');
    });

    $('#ticket-search').focusout(function() {
        if (isEmpty($(this).val())) {
            $('#ticket-search-div').removeClass('expand-search-size');
            $('#ticket-search-div').addClass('default-search-size');
        }
    });

    $('#ticket-search').on('keyup', delay(function(e) {
        refreshTicketTableSilent();
    }, 500));
}





function saveTicketEvt() {


    $('#btn_ticket_save').on('click', function() {


        if (check_if_empty_field($('#category'),
                'Category is required.')) {
            return;
        }

        if (check_if_empty_field($('#title'),
                'Subject is required.')) {
            return;
        }

        if ($('#title').val().length <= 4) {
            toastr.remove();
            toastr.error("Subject is too short...");
            $('#title').trigger('focus');
            return;
        }

        if (check_if_empty_field($('#description'),
                'Description is required.')) {
            return;
        }

        if ($('#description').val().length <= 5) {
            toastr.remove();
            toastr.error("Description is too short...");
            $('#description').trigger('focus');
            return;
        }

        if (check_if_empty_field($('#priority_level'),
                'Priority level is required.')) {
            return;
        }

        // if (check_if_empty_field($('#brand'),
        //         'Brand is required.')) {
        //     return;
        // }

        // if (check_if_empty_field($('#model'),
        //         'Model is required.')) {
        //     return;
        // }

        // if (check_if_empty_field($('#plate_cs'),
        //         'Plate is required.')) {
        //     return;
        // }

        if (!isEmpty($('#year_model').val())) {
            if ($('#year_model').val().length != 4) {
                toastr.remove();
                toastr.error("Invalid year model...");
                $('#year_model').trigger('focus');
                return;
            }
        }

        var $element = $("[json-ticket-modal]");
        ticket_json_data = generate_json(
            'json-ticket-modal',
            $element);
        // alert(ticket_json_data);
        // return;



        if (is_new_ticket) {
            // suggest a possible or related solution 101 using modal
            // if user view pop up related content cancel the creation and view the clicked content

            //Logic
            // load possible 5 solution with 50 characters
            // if no posbile solution create ticket end
            // if meron
            // hide current modal
            // show solution modal
            // load solution contents
            resetRelatedArticleResult();
            read_related_kb_tickets();
            // $.when(read_related_kb_tickets()).done(function(result) {

            // });

        } else {
            startUpload();
        }


    });
    
    $('#btn_ticket_save_2').on('click', function() {
        startUpload();
    });

}

function ticketSubjectEvt() {
    var xhr = null;
    $('#title').autoComplete({
        resolver: 'custom',
        noResultsText: '',
        events: {
            search: function(qry, callback) {
                // let's do a custom ajax call
                if (xhr != null) {
                    //kill the request
                    xhr.abort()
                }
                xhr = $.ajax(
                    'app/models/knowledgebase.php', {
                        data: {
                            'search': qry,
                            offset: 0,
                            limit:10,
                            'model': 'read_knowledgebase_list_autocomplete'
                        }
                    }
                ).done(function(res) {
                    // console.log(res)
                    results = JSON.parse(res)
                    // console.log(results.rows);
                    callback(results.rows)
                });
            }
        }
    });

    $('#title').on('autocomplete.select', function(evt,
        item) {
        // $("#title_id").val(item.id);
    });
  
}

function ticketSearchEvt() {
    var xhr = null;
    $('#ticket-search').autoComplete({
        resolver: 'custom',
        noResultsText: '',
        events: {
            search: function(qry, callback) {
                // let's do a custom ajax call
                if (xhr != null) {
                    //kill the request
                    xhr.abort()
                }
                xhr = $.ajax(
                    'app/models/ticket.php', {
                        data: {
                            'search': qry,
                            offset: 0,
                            limit:10,
                            'model': 'read_ticket_list_autocomplete'
                        }
                    }
                ).done(function(res) {
                    // console.log(res)
                    results = JSON.parse(res)
                    // console.log(results.rows);
                    callback(results.rows)
                });
            }
        }
    });

    $('#ticket-search').on('autocomplete.select', function(evt,
        item) {
        refreshTicketTableSilent();
    });
  
}

function read_related_kb_tickets() {
    return $.ajax({
        url: "app/models/knowledgebase.php",
        data: {
            model: 'read_related_articles',
            json_data: ticket_json_data,
            offset: kb_display_limit - kb_display_limit_const,
            limit: kb_display_limit_const
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            $('#btn_ticket_save').prop(
                'disabled', true);
        },
        success: function(result) {
            if (parseInt(result.total) > 0) {
                $("#ticket_modal").modal('hide');
                $("#kb_suggestion_modal").modal('show');

                $.each(result['rows'], function(i, n) {
                    $('#search-result-lbl').show();
                    var html = n.descriptionf;
                    html = html.replace(/<style([\s\S]*?)<\/style>/gi, '');
                    html = html.replace(/<script([\s\S]*?)<\/script>/gi, '');
                    html = html.replace(/<\/div>/ig, '\n');
                    html = html.replace(/<\/li>/ig, '\n');
                    html = html.replace(/<li>/ig, '  *  ');
                    html = html.replace(/<\/ul>/ig, '\n');
                    html = html.replace(/<\/p>/ig, '\n');
                    html = html.replace(/<br\s*[\/]?>/gi, "\n");
                    html = html.replace(/<[^>]+>/ig, '');

                    var uri = "#knowledgebase-view-"+n.id; 
                    //  window.location.hash = 'knowledgebase-view-'+$el.id;
                    if(parseInt(n.source) === 2){
                        uri = "#tickets-view-"+n.id;
                    }
                    $('.coveo-result-list-container').append(`
                    <div class="coveo-list-layout CoveoResult p-2">
                        <div>
                            <div class="coveo-title">
                            <a class="CoveoResultLink cursor-pointer" tabindex="0" role="heading" aria-level="2"  href="`+uri+`" target="_blank" >` + n.title + `</a>
                            </div>
                            <div class="CoveoExcerpt">` + html + `</div>
                        </div>
                    </div>
                        `);
                    kb_display_count++;

                });


                if (result['rows'].length == 0) {
                    $('#view_more_kb_search').addClass('hideEl');
                } else {
                    $('#view_more_kb_search').removeClass('hideEl');
                }
                if (kb_display_count == 0) {
                    // $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
                    toastr.remove();
                    toastr.info("No result found...");
                    toastr.remove
                } else if (kb_display_count != 0 && result['rows'].length == 0) {
                    toastr.remove();
                    toastr.info("No more result.")
                }

                if (parseInt(result.total) > kb_display_limit_const) {
                    $('#view_more_kb_search').removeClass('hideEl');
                } else {
                    $('#view_more_kb_search').addClass('hideEl');
                }

            } else {
                startUpload();
            }

            $('#btn_ticket_save').prop(
                'disabled', false);
        },
        error: function() {
            $('#btn_ticket_save').prop(
                'disabled', false);
        }
    });

}

function ticketInformationEvt() {
    $('#reply_ticket_send_btn').on('click', function(evt) {
        var $element = $("[json-reply-ticket-modal]");
        reply_ticket_json_data = generate_json(
            'json-reply-ticket-modal',
            $element);
        // alert(reply_ticket_json_data);
        // return;  
        if (isEmpty($('#ticket_reply').val()) && 
            ticketReplyDropzone.getAcceptedFiles().length < 1 && 
            !$('#chk_resolve_ticket').is(":checked") && 
            !$('#chk_unresolve_ticket').is(":checked") && 
            !$('#chk_reopen_ticket').is(":checked") && 
            !$('#chk_escalated_solve_ticket').is(":checked")
            ) {
            toastr.remove();
            toastr.error("Enter your response or attach a file.");
        } else {
            startReplyTicketUpload();
        }
    });

    $("[reply-ticket-chk]").each(function() {
        $(this).on('change', function() {
            if (this.checked) {
                $(this).val("3");
            } else {
                $(this).val("2");
            }
        });
    });

    $('#chk_resolve_ticket').on('change', function() {
        $('#chk_unresolve_ticket').prop('checked', false);
        $('#txt_final_status').val("");

        if (this.checked) {
            $('#txt_final_status').val("1");
        } else {
            $('#txt_final_status').val("");
        }
    });

    $('#chk_unresolve_ticket').on('change', function() {
        $('#chk_resolve_ticket').prop('checked', false);
        $('#txt_final_status').val("");
        if (this.checked) {
            $('#txt_final_status').val("2");
        } else {
            $('#txt_final_status').val("");
        }
    });
    $('#chk_reopen_ticket').on('change', function() {
        $('#chk_escalated_solve_ticket').prop('checked', false);
        if (this.checked) {
            $(this).val("1");
        } else {
            $(this).val("");
        }
    });

     $('#chk_escalated_solve_ticket').on('change', function() {
         $('#chk_reopen_ticket').prop('checked', false);
        if (this.checked) {
            $(this).val("1");
        } else {
            $(this).val("");
        }
    });

    $('#ticket_info_modal').on('shown.bs.modal', function(e) {

        $('#ticket-info-modal-tab li a').removeClass('active')
        $('#ticket-info-modal-tab-content .tab-pane').removeClass('active').removeClass('show')

        $('#ticket-info-modal-tab-information').addClass('active')
        $('#ticket-info-modal-tab-information-sec').addClass('active').addClass('show')

        $("[ticket-info-data]").each(function() {
            $(this).html("<span class='text-md text-muted font-italic'>Loading...</span>")
        });

        readTicketInformation();
        readTicketAttachments();

        defaultTicketReplies();
    })

    $('#ticket_replies_view_more').on('click', function() {
        ticket_replies_display_limit =
            ticket_replies_display_limit +
            ticket_replies_display_limit_const;
        readTicketReplies();
    });

}

function initSelect2UnselectElement() {
    $('#brand-filter,#model-filter').on('select2:select select2:unselecting', function(e) {
        refreshTicketTableSilent();
    });
}

function resetRelatedArticleResult() {
    kb_display_limit = kb_display_limit_const;
    kb_display_count = 0;
    $('.coveo-result-list-container').html('')
    $('#view_more_kb_search').addClass('hideEl');
}

function classifiedTicketsEvt(){ 
       $('#chk_classified').on('change', function() {
        var updated_type = 0;
        if (this.checked) { 
            updated_type = 1;
        }
         return $.ajax({
        url: "app/models/ticket.php",
        data: {
            model: 'update_ticket_type',
            type: updated_type,
            ticket_id: selected_ticket_data
        },
        type: "POST",
        dataType: 'json',
        beforeSend: function() {
            toastr.remove();
            toastr.info("Updating...");
        },
        success: function(result) {
                toastr.remove();
                toastr.info("Done...");
        },
        error: function() {
            toastr.remove();
            toastr.error(
                "Error has occurred. Try again."
            )
        }
    });

    });
}
</script>