<script>
    $(document).ready(function() {
        $('.no-sp-ch').on('input', function() { //no special character
            var c = this.selectionStart,
                r = /[^a-z0-9]/gi,
                v = $(this).val();
            if (r.test(v)) {
                $(this).val(v.replace(r, ''));
                c--;
            }
            this.setSelectionRange(c, c);
        });

        $('.uppercase').on('input', function() {
            this.value = this.value.toUpperCase();
        });



        init_toastr();
        defaultFunctions();
        $('.am-toggle-left-sidebar').trigger("click");
    });

    function testf() {
        alert('test aler')
    }

    function init_toastr() {
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "3000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };
    }



    function isEmpty(string) {
        // alert(string)
        var flag = false;
        try {
            if (string == null) {
                flag = true;
            } else if (typeof string === 'undefined') {
                flag = true;
            } else if (string.trim() == '') {
                flag = true;
            }
        } catch (err) {
            console.log(err);
            flag = true;
        }
        return flag;
    }

    function generate_json(attribute, $element) {
        var
            /* Create an object. */
            obj = {},
            /* Create a variable that references the current object (default → obj). */
            ref = obj;
        /* Iterate over every input. */
        $element.each(function() {
            /* Cache the id of the input. */
            var id = this.id;
            /* Check whether the nodetype attribute is set to 'parent'. */
            if (this.getAttribute(attribute) == "parent") {
                /* Set a new object to the property and set ref to refer to it. */
                ref = obj[id] = {};
            } else {
                /* Set the value of the input to the referred object. */
                if (this.getAttribute(attribute) == "true") {
                    if (isEmpty($(this).val())) {
                        ref[id] = '';
                    } else {
                        ref[id] = $(this).val().trim();
                    }

                }
            }
        });
        /* Stringify the object and return it. */
        return JSON.stringify(obj);
    }


    function check_if_empty_field($element, msg) {
        if (isEmpty($element.val())) {
            $element.focus();
            toastr.remove();
            toastr.error(msg);
            return true;
        } else {
            return false;
        }
    }

    function resetElementForm($el) {
        $el
            .find("input,textarea,select")
            .val('')
            .trigger('change')
            .end()
            .find("input[type=checkbox], input[type=radio]")
            .prop("checked", "")
            .end();
    }

    function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }



    function defaultFunctions() {
        initToolTip()
    }

    function initToolTip() {
        $('.tooltip-me').bstooltip();
        $('.tooltip-me').on('click', function() {
            // $(this).bstooltip('hide')
        })
    }

    function addCommas(nStr) {
        nStr += '';
        x = nStr.split('.');
        x1 = x[0];
        x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    }
    //    function getRandomColor() {
    //                 var letters = 'BE26'.split('');
    //                 var color = '#';
    //                 for (var i = 0; i < 6; i++ ) {
    //                     color += letters[Math.floor(Math.random() * letters.length)];
    //                 }
    //                 return color;
    //             }
    function getRandomColor() {
        var letters = '0123456789ABCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }


    function filterEvt() {
        $(document).on('click', '.ticket-filter-final-status,.ticket-more-filter,.ticket-filter-category,.ticket-filter-status,.ticket-filter-priority', function(e) {
            e.stopPropagation();
        });
    }

    function initSelect2Element() {
        $("#brand,#brand-filter").select2({
            // tags:true,
            minimumResultsForSearch: -1,
            placeholder: "Select brand",
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/brand.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_brands',
                        search: data.term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });

        $("#section-filter").select2({
            // tags:true,
            minimumResultsForSearch: -1,
            placeholder: "Select section",
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/ticket.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_sections',
                        search: data.term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });

        $("#category").select2({
            // tags:true,
            placeholder: "Select category",
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/ticket.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_sub_categories',
                        search: data.term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });

        $("#section").select2({
            // tags:true,
            placeholder: "Select section",
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/ticket.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_sections',
                        search: data.term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });


        $("#priority_level").select2({
            // tags:true,
            minimumResultsForSearch: -1,
            placeholder: "Select priority",
            allowClear: true,
            escapeMarkup: function(markup) {
                return markup;
            },
            ajax: {
                url: 'app/models/ticket.php',
                dataType: 'json',
                delay: 250,
                data: function(data) {
                    return {
                        model: 'read_priority_level',
                        search: data.term // search term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true
            }
        });


        $('#model').select2({
            placeholder: "Select brand first",
            minimumResultsForSearch: -1
        });

        $('#model-filter').select2({
            placeholder: "Select model",
            minimumResultsForSearch: -1,

            escapeMarkup: function(markup) {
                return markup;
            },
            language: {
                noResults: function(params) {
                    return "Select brand first";
                }
            }
        });


    }



    function loadTicketFilterCategory() {
        return $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_sub_categories',
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                // console.log(result)
                $.each(result, function(i, n) {
                    // console.log(n.text)
                    // $.each(n,function(j,m){
                    $('.ticket-filter-category').append(`<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` + n.text + `</span></li>`);
                    // })
                });
            },
            error: function() {}
        });
    }

    function loadTicketFilterFinalStatus() {
        return $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_ticket_status',
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                // console.log(result)
                $.each(result, function(i, n) {
                    // console.log(n.text)
                    // $.each(n,function(j,m){
                    $('.ticket-filter-final-status').append(`<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` + n.text + `</span></li>`);
                    // })
                });
                //   $('.ticket-filter-final-status').append(`<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">Escalated (Solve)</span></li>`);
            },
            error: function() {}
        });
    }

    function loadTicketFilterStatus() {
        return $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_ticket_status',
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                // console.log(result)
                $.each(result, function(i, n) {
                    // console.log(n.text)
                    // $.each(n,function(j,m){
                    $('.ticket-filter-status').append(`<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` + n.text + `</span></li>`);
                    // })
                });
            },
            error: function() {}
        });
    }

    function loadTicketFilterPriority() {
        return $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_priority_level',
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                // console.log(result)
                $.each(result, function(i, n) {
                    // console.log(n.text)
                    // $.each(n,function(j,m){
                    $('.ticket-filter-priority').append(`<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` + n.text + `</span></li>`);
                    // })
                });
            },
            error: function() {}
        });
    }

    function hideTicketTypes() {
        $('.type_vehicle').hide();
    }

    function addSelectChangeEvt() {
        $('#category').on('change', function(e) {
            var sub_category = $('#category').val();
            $.ajax({
                url: "app/models/ticket.php",
                data: {
                    model: 'read_category_id_by_sub_category_name',
                    sub_category: sub_category
                },
                type: "POST",
                dataType: 'json',
                beforeSend: function() {
                    $('#btn_ticket_save').prop(
                        'disabled', true);
                    hideTicketTypes();
                },
                success: function(result) {
                    $('#btn_ticket_save').prop(
                        'disabled', false);
                    if (parseInt(result.show_vehicle) === 1) {
                        $('.type_vehicle').show();
                    }
                },
                error: function() {
                    $('#btn_ticket_save').prop(
                        'disabled', false);
                }
            });
        });

        $('#brand').on('change', function(e) {
            var brand_name = $('#brand').val();
            $("#model").val('');
            $("#model").select2('destroy').select2({
                // tags:true,
                placeholder: "Select model",
                allowClear: true,
                escapeMarkup: function(markup) {
                    return markup;
                },
                ajax: {
                    url: 'app/models/model.php',
                    dataType: 'json',
                    delay: 250,
                    data: function(data) {
                        return {
                            model: 'read_models',
                            brand_name: brand_name,
                            search: data
                                .term // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });
        });

        $('#brand-filter').on('change', function(e) {
            var brand_name = $('#brand-filter').val();
            $("#model-filter").val('');
            $("#model-filter").select2('destroy').select2({
                // tags:true,
                placeholder: "Select model",
                minimumResultsForSearch: -1,
                allowClear: true,
                escapeMarkup: function(markup) {
                    return markup;
                },
                ajax: {
                    url: 'app/models/model.php',
                    dataType: 'json',
                    delay: 250,
                    data: function(data) {
                        return {
                            model: 'read_models',
                            brand_name: brand_name,
                            search: data
                                .term // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }
            });
        });

    }

    function modelVariantEvt() {
        var xhr = null;
        $('#model_variant').autoComplete({
            resolver: 'custom',
            noResultsText: '',
            events: {
                search: function(qry, callback) {
                    // let's do a custom ajax call
                    if (xhr != null) {
                        //kill the request
                        xhr.abort()
                    }
                    xhr = $.ajax(
                        'app/models/model.php', {
                            data: {
                                'search': qry,
                                'vehicle_model': $("#model").val(),
                                'model': 'read_model_variants'
                            }
                        }
                    ).done(function(res) {
                        results = JSON.parse(res)
                        callback(results.data)
                    });
                }
            }
        });

        $('#model_variant').on('autocomplete.select', function(evt,
            item) {
            $("#model_variant_id").val(item.id);

            var newBrandState = new Option(item.brand, item.brand, true, true);
            // Append it to the select
            $("#brand").append(newBrandState).trigger('change');

            var newModelState = new Option(item.model, item.model, true, true);
            // Append it to the select
            $("#model").append(newModelState).trigger('change');


        });
        $("#model_variant").on("keyup change", function(e) {
            $("#model_variant_id").val('');
        })
    }



    function readKBInformation() {
        $.ajax({
            url: "app/models/knowledgebase.php",
            data: {
                model: 'read_knowledgebase_information',
                knowledgebase_id: selected_kb_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                var has_vehicle_info = false;

                if (parseInt(result.show_vehicle) === 1) {
                    $('.type_vehicle_reply_modal').show();
                } else {
                    $('.type_vehicle_reply_modal').hide();
                }


                $.each(result, function(i, n) {
                    if (i.startsWith('lbl_v_')) {
                        if (!isEmpty(n)) {
                            has_vehicle_info = true;
                        }
                    }

                    if (i == "lbl_kb_description") {
                        $("#" + i).html(n);
                    } else {
                        $("#" + i).text(n);
                        $("#" + i + "_2").text(n);
                    }

                    if (isEmpty(n)) {
                        $("#" + i + "_div").hide();
                    } else {
                        $("#" + i + "_div").show();
                    }

                });

                if (has_vehicle_info) {
                    $('.has_vehicle_info').show();
                } else {
                    $('.has_vehicle_info').hide();
                }
            },
            error: function() {}
        });
    }

    function updateNotificationMarkAsRead(target_id, to_user_id) {
        $.ajax({
            url: "app/models/user.php",
            data: {
                model: 'update_notification_status',
                target_id: target_id,
                to_user_id: to_user_id
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                read_user_notification_count();
            },
            error: function() {}
        });
    }

    function close_notification(target_id) {
        $.ajax({
            url: "app/models/user.php",
            data: {
                model: 'update_notification_status_close',
                target_id: target_id
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {
                read_user_notification_count();
            },
            error: function() {}
        });
    }

    function readKBAttachments() {
        $.ajax({
            url: "app/models/knowledgebase.php",
            data: {
                model: 'read_knowledgebase_attachments',
                knowledgebase_id: selected_kb_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                $('#kb_attachment').html('')
            },
            success: function(result) {

                $.each(result, function(i, n) {

                    var dl_hover = ` <div class="hover "> 
                                        <button type="button" onClick="downloadTicketAttachment('` + n.change_name + `','3')" title="Download" class="tooltip-me btn btn-icon btn-primary">
                                            <i class="fa fa-download"></i>
                                        </button>
                                    </div>`;

                    var fileExt = n.change_name.split('.').pop();
                    var filename = n.change_name.replace(/\.[^/.]+$/, "")
                    var href_uri = `href="javascript:void(0);"`;
                    switch (fileExt) {
                        case 'png':
                        case 'jpg':
                        case 'jpeg':
                            href_uri = ` data-type="image" data-toggle="lightbox"  href="viewer/image.php?token=` + filename + `@` + `3"`;
                            dl_hover = "";
                            break;
                        case 'pdf':
                            href_uri = `target="_blank" href="pdf/pdf.php?token=` + filename + `@` + `3"`;
                            dl_hover = "";
                            break;
                        default:

                    }

                    $('#kb_attachment').append(`
                         <div class="col-lg-3 col-md-4 col-sm-12 pb-3">
                            <div class="card h-100">
                                <div class="file" >
                                <a ` + href_uri + `> 
                                    ` + dl_hover + `
                                        <div class="icon p-0">
                                           ` + n.icon + `
                                        </div>
                                        <div class="file-name">
                                            <p class="m-b-5 text-muted">` + n.original_name + `</p>
                                            <small>Size: ` + n.size + ` <span class="date text-muted">` + n.date + `</span></small>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        `);
                });

                if (result.length == 0) {
                    $('#kb_attachment').html('<div class="col-12 text-center"><span class="text-center">No attachment</span></div>')
                } else {
                    defaultFunctions();
                }


            },
            error: function() {}
        });
    }


    function viewKBInfo(source, id) {
        selected_kb_data = id;
        var source = source;
        switch (source) {
            case '1':
                $('#kb_view_modal').modal('show');
                break;
            case '2':
                $('#kb_view_ticket_modal').modal('show');
                break;
        }

    }

    function kbTicketInformationEvt() {

        $('#kb_view_ticket_modal').on('shown.bs.modal', function(e) {

            $('#kb-view-ticket-info-modal-tab li a').removeClass('active')
            $('#kb-view-ticket-info-modal-tab-content .tab-pane').removeClass('active').removeClass('show')

            $('#kb-view-ticket-info-modal-tab-information').addClass('active')
            $('#kb-view-ticket-info-modal-tab-information-sec').addClass('active').addClass('show')

            $("[kb-view-ticket-info-data]").each(function() {
                $(this).html("<span class='text-md text-muted font-italic'>Loading...</span>")
            });

            readKBTicketInformation();
            readTicketAttachments();

            defaultTicketReplies();
        })

        $('#ticket_replies_view_more').on('click', function() {
            ticket_replies_display_limit =
                ticket_replies_display_limit +
                ticket_replies_display_limit_const;
            readTicketReplies();
        });

    }


    function auto_grow(element) {
        element.style.height = "5px";
        element.style.height = (element.scrollHeight) + "px";
    }

    function readKBTicketInformation() {
        $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_ticket_information',
                ticket_id: selected_kb_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {},
            success: function(result) {

                if (parseInt(result.show_vehicle) === 1) {
                    $('.type_vehicle_reply_modal').show();
                }
                $.each(result, function(i, n) {
                    if (i.startsWith("lbl_")) {
                        if (i == "lbl_ticket_description") {
                            $("#" + i).html(n);
                        } else {
                            $("#" + i).text(n);
                            $("#" + i).val(n);
                            $("#" + i).trigger('change')
                        }

                        if (isEmpty(n)) {
                            $("#" + i + "_div").hide();
                        } else {
                            $("#" + i + "_div").show();
                        }
                    }
                });
            },
            error: function() {}
        });
    }


    function readTicketAttachments() {
        $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_ticket_attachments',
                ticket_id: selected_kb_data
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                $('#kb_ticket_attachment').html('')
            },
            success: function(result) {



                $.each(result, function(i, n) {
                    var dl_hover = ` <div class="hover "> 
                                        <button type="button" onClick="downloadTicketAttachment('` + n.change_name + `','1')" title="Download" class="tooltip-me btn btn-icon btn-primary">
                                            <i class="fa fa-download"></i>
                                        </button>
                                    </div>`;

                    var fileExt = n.change_name.split('.').pop();
                    var filename = n.change_name.replace(/\.[^/.]+$/, "")
                    var href_uri = `href="javascript:void(0);"`;
                    switch (fileExt) {
                        case 'png':
                        case 'jpg':
                        case 'jpeg':
                            href_uri = ` data-type="image" data-toggle="lightbox"  href="viewer/image.php?token=` + filename + `@` + `1"`;
                            dl_hover = "";
                            break;
                        case 'pdf':
                            href_uri = `target="_blank" href="pdf/pdf.php?token=` + filename + `@` + `1"`;
                            dl_hover = "";
                            break;
                        default:

                    }

                    $('#kb_ticket_attachment').append(`
                         <div class="col-lg-3 col-md-4 col-sm-12 pb-3">
                            <div class="card h-100">
                                <div class="file"  >
                                <a ` + href_uri + `> 
                                     ` + dl_hover + `
                                        <div class="icon p-0">
                                           ` + n.icon + `
                                        </div>
                                        <div class="file-name">
                                            <p class="m-b-5 text-muted">` + n.original_name + `</p>
                                            <small>Size: ` + n.size + ` <span class="date text-muted">` + n.date + `</span></small>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        `);
                });

                if (result.length == 0) {
                    $('#kb_ticket_attachment').html('<div class="col-12 text-center"><span class="text-center">No attachment</span></div>')
                } else {
                    defaultFunctions();
                }


            },
            error: function() {}
        });
    }


    function defaultTicketReplies() {
        ticket_replies_display_limit = ticket_replies_display_limit_const;
        ticket_replies_display_count = 0;
        $('#ticket_replies').html('')
        readTicketReplies();
    }

    function readTicketReplies() {
        $.ajax({
            url: "app/models/ticket.php",
            data: {
                model: 'read_ticket_replies',
                ticket_id: selected_kb_data,
                order: 'asc',
                offset: ticket_replies_display_limit - ticket_replies_display_limit_const,
                limit: ticket_replies_display_limit_const
            },
            type: "POST",
            dataType: 'json',
            beforeSend: function() {
                // $('#ticket_replies').html('')
            },
            success: function(result) {
                $.each(result['rows'], function(i, n) {
                    var content_description = isEmpty(n.description) ? '' : n.description;
                    var this_reply_attachment_count = 0;
                    var reply_attachments = ``;
                    $.each(result['attachments'], function(j, m) {
                        if (n.id == m.reply_id) {
                            var fileExt = m.attachment_name.split('.').pop();
                            var filename = m.attachment_name.replace(/\.[^/.]+$/, "")
                            switch (fileExt) {
                                case 'png':
                                case 'jpg':
                                case 'jpeg':
                                    reply_attachments = reply_attachments + `<a data-type="image" data-toggle="lightbox"  href="viewer/image.php?token=` + filename + `@1" > 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;
                                    break;
                                case 'pdf':
                                    reply_attachments = reply_attachments + `<a target="_blank"  href="pdf/pdf.php?token=` + filename + `@1" > 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;
                                    break;
                                default:
                                    reply_attachments = reply_attachments + `<a href="javascript:void(0);" onClick="downloadTicketAttachment('` + m.attachment_name + `','2')"> 
                                                            <u><span>` + m.original_name + `</span></u>
                                                        </a><br>`;
                            }

                            this_reply_attachment_count++;
                        }
                    });
                    var hide_attachment_area = (this_reply_attachment_count > 0) ? '' : 'hidden';
                    // var final_status_msg = (isEmpty(n.final_status_id) ?  (isEmpty(n.reopen_ticket_id) ? '' : 'Reopen the ticket.') : 'Closed the ticket.') ;
                    var final_status_msg = (isEmpty(n.final_status_id) ? (isEmpty(n.reopen_ticket_id) ? '' : 'Reopen the ticket.') : (isEmpty(n.escalated_ticket_id) ? 'Closed the ticket.' : 'Closed, solve in plant.'));


                    $('#ticket_replies').append(`
                                            <li>
                                                <a href="javascript:void(0);"> 
                                                    <img class="contacts-list-img" src="dist/img/profile.png" alt="User Avatar">


                                                    <div class="contacts-list-info">
                                                    <div class="pl-1 row">

                                                        <div class="col-lg-6 col-sm-12">
                                                        <span class="contacts-list-name text-dark">
                                                                ` + n.user + `<small class="text-primary">` + n.creator + `</small>   
                                                                <small class="text-primary text-muted font-italic">` + final_status_msg + `</small>
                                                            </span>
                                                        </div>
                                                        <div class="col-lg-6 col-sm-12">
                                                           <small class="contacts-list-date pt-1 float-lg-right text-dark">` + n.date_added + `</small>
                                                           <!-- <br>
                                                                <small class="text-danger float-lg-right" remove-ticket-reply="` + n.id + `" ><u>` + n.remove + `</u></small>
                                                                -->
        
                                                        </div>
                                                    </div>
                                                    <div class="col pl-1">
                                                        <span class="contacts-list-msg text-dark">` + content_description + `</span>
                                                    </div>

                                                    <div class="pl-1 pt-2 reply-attachment" ` + hide_attachment_area + `>
                                                        <span class="text-dark font-weight-normal">Attachment(s):</span><br> 
                                                        ` + reply_attachments + `
                                                    </div>
                                                    

                                                    </div>
                                                    <!-- /.contacts-list-info -->

                                                </a>
                                              
                                            </li>
                                            <!-- End Contact Item -->
                        `);
                    ticket_replies_display_count++;
                });


                // add ticket reply remove listner
                $("[remove-ticket-reply]").each(function() {
                    $(this).off('click').on('click', function() {
                        var ticket_reply_id = $(this).attr('remove-ticket-reply');

                        // SWAL
                        Swal.fire({
                            icon: 'warning',
                            html: 'Are you sure you want to remove this reply?',
                            showDenyButton: false,
                            showCancelButton: true,
                            confirmButtonText: `Yes`,
                            cancelButtonText: `No`,
                            denyButtonText: `Don't Confirm`,
                            showClass: {
                                backdrop: 'swal2-noanimation', // disable backdrop animation
                                popup: '', // disable popup animation
                                icon: '' // disable icon animation
                            },
                            hideClass: {
                                popup: '', // disable popup fade-out animation
                            },
                            customClass: 'swal-height'
                        }).then((result) => {
                            if (result.isConfirmed) {

                                $.ajax({
                                    url: "app/models/knowledgebase.php",
                                    data: {
                                        model: 'delete_ticket_reply',
                                        ticket_reply_id: ticket_reply_id
                                    },
                                    type: "POST",
                                    dataType: 'json',
                                    beforeSend: function() {
                                        toastr.remove();
                                        toastr.info('Removing reply...')
                                    },
                                    success: function(result) {
                                        toastr.remove();
                                        toastr.success(result.message);
                                        $('#ticket_replies').html('')
                                        readTicketReplies();
                                    },
                                    error: function() {}
                                });


                            } else if (result.isDenied) {} else {}
                        })
                        // SWAL

                    });
                });


                if (result['rows'].length == 0) {
                    $('#view_more_replies').addClass('hideEl');
                } else {
                    $('#view_more_replies').removeClass('hideEl');
                }
                if (ticket_replies_display_count == 0) {
                    $('#ticket_replies').html('<div class="col-12 text-center"><span class="text-center">No replies</span></div>')
                } else if (ticket_replies_display_count != 0 && result['rows'].length == 0) {
                    toastr.remove();
                    toastr.info("No more replies.")
                }




            },
            error: function() {}
        });
    }


    function downloadTicketAttachment(file, src) {
        var fileExt = file.split('.').pop();
        var filename = file.replace(/\.[^/.]+$/, "")
        switch (fileExt) {
            case 'pdf':
                var url = "pdf/pdf.php?token=" + filename + "@" + src;
                window.open(url, '_blank').focus();
                return;
            case 'png':
            case 'jpg':
            case 'jpeg':
                var url = "viewer/image.php?token=" + filename + "@" + src;
                window.open(url, '_blank').focus();
                return;
            default:
                var url = "download.php?src=" + src + "&file=" + file;
                window.open(url, '_blank').focus();
        }
    }


    function viewTicketAttachment(file, name) {
        var re = /(?:\.([^.]+))?$/;
        var ext = re.exec(file)[1];
        switch (ext) {
            case "jpg":
            case "jpeg":
            case "png":

                break;
            default:
                // toastr.remove();
                // toastr.info("This file can't open online, download the file instead.");
        }
    }

    function kbAutoComplete() {
        var xhr = null;
        $('#search_by,#ticket-search').autoComplete({
            resolver: 'custom',
            noResultsText: '',
            events: {
                search: function(qry, callback) {
                    // let's do a custom ajax call
                    if (xhr != null) {
                        //kill the request
                        xhr.abort()
                    }
                    xhr = $.ajax(
                        'app/models/knowledgebase.php', {
                            data: {
                                'search': qry,
                                offset: 0,
                                limit: 10,
                                'model': 'read_knowledgebase_list_autocomplete'
                            }
                        }
                    ).done(function(res) {
                        // console.log(res)
                        results = JSON.parse(res)
                        // console.log(results.rows);
                        callback(results.rows)
                    });
                }
            }
        });

        $('#search_by,#ticket-search').on('autocomplete.select', function(evt,
            item) {
            // $("#title_id").val(item.id);
            try {
                refreshKBTableSilent();
            } catch (e) {
                console.log(e.message);
            }

        });

    }
</script>