<?php 
ini_set('max_execution_time', '0'); 
set_time_limit(0);
//same code above
ini_set('memory_limit','-1').
date_default_timezone_set('Asia/Manila');

// header('Content-type: application/pdf');

include_once dirname(__FILE__) . '/../../cfg/db.php';
include_once dirname(__FILE__) . '/../../app/classes/ticket_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/utility.php';  

$ticket_class = new Ticket();
$utility_class = new Utility();

// include('cfg/db.php');  

// if(!isset($_SESSION['user']['id'])){
// 	header('location:requested_reports.php');
// 	return;
// }
   
//START GETTING REPORT INFORMATION
/**
 * save report data to local para sa future hindi na dadaan sa mysql it consist control number name
 */

if(!isset($_REQUEST['id']) || !$utility_class->isNotEmpty($_REQUEST['id'])){
     $return_array['status'] = 0;
    $return_array['message'] = "Missing case id"; 
    echo json_encode($return_array);
    exit; 
}

$ticket_id = $db->escape($_REQUEST['id']);
$ticket_information_obj = $ticket_class->read_ticket_information($ticket_id,$utility_class,$db);
$ticket_attachments_obj = $ticket_class->read_ticket_attachments($ticket_id,$utility_class,$db);
$offset = 0;
$limit = 999;
$order = "DESC";
$ticket_replies_obj = $ticket_class->read_ticket_replies($ticket_id,$offset,$limit,$order,$utility_class,$db);  


$ticket_information_arr = array();
$ticket_attachments_arr = array();
$ticket_replies_arr = array();
$ticket_replies_attachment_arr = array();

    //read ticket information
    foreach($ticket_information_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       $ticket_information_arr = $row;
    }

    if(count($ticket_information_arr) <= 0){
        $return_array['status'] = 0;
        $return_array['message'] = "No data found"; 
        echo json_encode($return_array);
        exit; 
    }

    //read ticket all attachments
    foreach($ticket_attachments_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       $ticket_attachments_arr = array_merge($ticket_attachments_arr,array($row));
    }

    //read replies and replies attachment
    foreach($ticket_replies_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       $ticket_replies_arr = array_merge($ticket_replies_arr,array($row));
       $ticket_replies_attachment_obj = $ticket_class->read_ticket_reply_attachments($row['id'],$utility_class,$db);
        foreach($ticket_replies_attachment_obj as $row1){
            $ticket_replies_attachment_arr = array_merge($ticket_replies_attachment_arr,array(
            //     array(
            //         'id'=>$row1['id'],
            //         'ticket_reply_id'=>$row1['ticket_reply_id'],
            //         'attachment_name'=>$row1['attachment_name'],
            //         'original_name'=>$row1['original_name'],
            // )
            $row1
        ));
        }
    }

    // print_r($ticket_information_arr);exit;
    // print_r($ticket_attachments_arr);exit;
    // print_r($ticket_replies_arr);exit;
    // print_r($ticket_replies_attachment_arr);exit;

$control_number = $ticket_information_arr['reference_no'];
$pdf_file_name = "case_".$ticket_information_arr['reference_no']."_report_".strtolower(date('F_d_Y_h_i_s')).".pdf"; 

include('../../plugins/fpdf/mc_table.php');  

$pdf=new PDF_MC_Table('P','mm','Letter'); 
$title = 'Case '.$control_number.' Report';
$pdf->SetTitle($title);
$pdf->AddPage();
 

$pdf->SetFont('Arial','',14); 
$pdf->SetFillColor(255,255,255); 
$pdf->Cell(0,6,'CASE REPORT',0,1,'C',true);

$pdf->SetFont('Arial','',14); 
$pdf->SetFillColor(255,255,255); 
$pdf->Cell(0,6,$ticket_information_arr['title'],0,1,'L',true);

$pdf->SetFont('Arial','',10);
$pdf_report_data[] = array('Case ID',  ': ',$ticket_information_arr['reference_no'], 'Date Created',  ': ',$ticket_information_arr['date_addedf']);
$pdf_report_data[] = array('Priority', ': ',$ticket_information_arr['priority_level'], 'Created By',  ': ',$ticket_information_arr['firstname'].' '.$ticket_information_arr['lastname']);
$pdf_report_data[] = array('Area', ': ',$ticket_information_arr['sub_category'], 'Progress',   ': ',$ticket_information_arr['ticket_status'] );
$report_header_widths = array(30,4 ,55, 30,4,60);
// $pdf->ReportHead($pdf_report_data,$report_header_widths);
$pdf->SetWidths($report_header_widths);
foreach($pdf_report_data as $row){
	$pdf->Row($row,false);  
}
$pdf->Ln(2);
$pdf->SetFont('Arial','',11);  

$pdf->SetFillColor(0,0,0); 
$pdf->SetTextColor(255);
$pdf->Cell(0,6,'VEHICLE DETAILS',0,1,'L',true);
$pdf->SetTextColor(0);
$pdf->SetFont('Arial','',10);
$vehicle_information[] = array('Plate/CS',  ': ',$ticket_information_arr['plate_cs']);
$vehicle_information[] = array('VIN', ': ',$ticket_information_arr['vin']);
$vehicle_information[] = array('Mileage', ': ',$ticket_information_arr['mileage']);
$vehicle_information[] = array('Brand', ': ',$ticket_information_arr['brand']);
$vehicle_information[] = array('Model', ': ',$ticket_information_arr['model']);
$vehicle_information[] = array('Model Variant', ': ',$ticket_information_arr['model_variant']);
$vehicle_information[] = array('Year Model', ': ',$ticket_information_arr['year_model']);
$vehicle_information[] = array('Workshop visits', ': ',$ticket_information_arr['workshop_visit_count']);
$vehicle_information[] = array('Breakdown', ': ',(intval($ticket_information_arr['breakdown']) ? 'Yes' : 'No'));
$vehicle_information[] = array('Vehicle on site', ': ',(intval($ticket_information_arr['on_site']) ? 'Yes' : 'No')); 
$report_header_widths = array(30,4 ,146);
$pdf->SetWidths($report_header_widths);
foreach($vehicle_information as $row){
	$pdf->Row($row,false);  
} 

$pdf->Ln(2);
$pdf->SetFont('Arial','',11); 

$pdf->SetFillColor(0,0,0); 
$pdf->SetTextColor(255);
$pdf->Cell(0,6,'COMPLAINT',0,1,'L',true);
$pdf->SetTextColor(0);

$pdf->SetFont('Arial','',10); 
$pdf->SetWidths(array(180));
$pdf->Row(array($ticket_information_arr['complaint']),false);

$pdf->Ln(2);
$pdf->SetFont('Arial','',11); 

$pdf->SetFillColor(0,0,0); 
$pdf->SetTextColor(255);
$pdf->Cell(0,6,'WORK PERFORMED',0,1,'L',true);
$pdf->SetTextColor(0);

$pdf->SetFont('Arial','',10); 
$pdf->SetWidths(array(180));
$pdf->Row(array($ticket_information_arr['work_performed']),false);  

$pdf->Ln(2);
$pdf->SetFont('Arial','',11); 

$pdf->SetFillColor(0,0,0); 
$pdf->SetTextColor(255);
$pdf->Cell(0,6,'IMPORTANT ADDITIONAL DATA',0,1,'L',true);
$pdf->SetTextColor(0);

$pdf->SetFont('Arial','',10); 

$additional_data[] = array('Fault Codes', ': ',$ticket_information_arr['fault_codes']); 
$report_header_widths = array(30,4 ,146);
$pdf->SetWidths($report_header_widths);
foreach($additional_data as $row){
	$pdf->Row($row,false);  
} 

$pdf->Ln(2);
$pdf->SetFont('Arial','',11); 
$pdf->SetFillColor(0,0,0); 
$pdf->SetTextColor(255);
$pdf->Cell(0,6,'ATTACHMENTS',0,1,'L',true);
$pdf->SetTextColor(0);

$pdf->SetFont('Arial','',10); 

$attachment_data = array(); 
foreach($ticket_attachments_arr as $row){
	$attachment_data[] = array($row['original_name']);
}

$report_header_widths = array(180);
$pdf->SetWidths($report_header_widths);
foreach($attachment_data as $row){ 
	$pdf->Row($row,false);  
}

$pdf->AddPage();
$pdf->SetFont('Arial','',14); 
$pdf->SetFillColor(255,255,255); 
$pdf->Cell(0,6,'CASE #'.$ticket_information_arr['reference_no'].' FEEDBACK',0,1,'C',true);

if(count($ticket_replies_arr) <= 0){
     $pdf->Ln(5);
    $pdf->SetFont('Arial','',12); 
         $pdf->SetFillColor(0,0,0); 
        $pdf->SetTextColor(255);
    $pdf->Cell(0,6,'No Data',0,1,'C',true);
}else{
    foreach($ticket_replies_arr as $row){
        $pdf->Ln(2);
        $pdf->SetFont('Arial','',11); 
        $pdf->SetFillColor(0,0,0); 
        $pdf->SetTextColor(255);
        $pdf->Cell(0,6,$row['firstname'].' '.$row['lastname'],0,1,'L',true);
        $pdf->SetTextColor(0);

        if($utility_class->isNotEmpty($row['description'])){
              $pdf->SetFont('Arial','',10); 
            $pdf->SetWidths(array(180));
            $pdf->Row(array($row['description']),false);  
        }
 
        $pdf->SetFillColor(255,255,255); 

        $reply_attachment_data = array(); 
        foreach($ticket_replies_attachment_arr as $ticket_replies_attachment_row){
            if(intval($row['id']) === intval($ticket_replies_attachment_row['ticket_reply_id'])){
                $unicode_char = '• '.$ticket_replies_attachment_row['original_name'];
                $reply_attachment_data[] = array(iconv('UTF-8', 'windows-1252', $unicode_char));
                // $reply_attachment_data[] = array('• '.$ticket_replies_attachment_row['original_name']);
            }  
        }

        
        if(count($reply_attachment_data) > 0){
            $pdf->Cell(0,6,'Attachments:',0,1,'L',true);
            $report_header_widths = array(180);
            $pdf->SetWidths($report_header_widths);
            foreach($reply_attachment_data as $reply_attachment_data_row){ 
                $pdf->Row($reply_attachment_data_row,false);  
            }
        }
        

        $pdf->Ln(2);
        $pdf->SetFont('Arial','',10);   
        $pdf->SetFillColor(255,255,255); 
        $pdf->Cell(0,6,'Posted on Jan. 10, 2022 02:38PM',0,1,'L',true); 
    }
}




// $pdf->WriteHTML('<b>asdas</b>');

// $pdf_report_data = $pdf->LoadData('report/data/'.strtr( $db -> cipher($report_session_data['control_number'],true),  "+/", "-_" ).'.'.'php');

// $pdf->FancyTable($pdf_report_data,$report_session_data['col_width']);
// $pdf->Output('D', 'AutoHub-'.$report_session_data['report_type'].'-'.$report_session_data['control_number'].'.'.'pdf');
// $pdf->Output('AutoHub-'.$report_session_data['report_type'].'-'.$report_session_data['control_number'].'.'.'pdf','I');

$filename=$pdf_file_name;
$pdf->Output($filename,'I');
// $pdf->Output($filename,'D');

//  if(true){
//     $return_array['status'] = 1;
//     $return_array['message'] = "Report Generated";  
//     $return_array['file'] = str_replace(".pdf","",  $pdf_file_name);
// }else{
//     $return_array['status'] = 0;
//     $return_array['message'] = "Report Generation Failed"; 
// } 
// echo json_encode($return_array);


?>
