<?php
	require('fpdf.php');

	class PDF_MC_Table extends FPDF
	{
		
	var $widths;
	var $aligns;

	function SetWidths($w)
	{
		//Set the array of column widths
		$this->widths=$w;
	}

	function SetAligns($a)
	{
		//Set the array of column alignments
		$this->aligns=$a;
	}

	function Row($data,$lines)
	{
		//Calculate the height of the row
		$nb=0;
		for($i=0;$i<count($data);$i++)
			$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
		$h=5*$nb;
		//Issue a page break first if needed
		$this->CheckPageBreak($h);
		//Draw the cells of the row
		for($i=0;$i<count($data);$i++)
		{
			$w=$this->widths[$i];
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
			//Save the current position
			$x=$this->GetX();
			$y=$this->GetY();
			if($lines){
				//Draw the border
				$this->Rect($x,$y,$w,$h);
			}
			//Print the text
			
			$this->MultiCell($w,5,$data[$i],0,$a);
			//Put the position to the right of the cell
			$this->SetXY($x+$w,$y);
		}
		//Go to the next line
		
		$this->Ln($h);
	}

	function CheckPageBreak($h)
	{
		//If the height h would cause an overflow, add a new page immediately
		if($this->GetY()+$h>$this->PageBreakTrigger)
			$this->AddPage($this->CurOrientation);
	}

	function NbLines($w,$txt)
	{
		//Computes the number of lines a MultiCell of width w will take
		$cw=&$this->CurrentFont['cw'];
		if($w==0)
			$w=$this->w-$this->rMargin-$this->x;
		$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
		$s=str_replace("\r",'',$txt);
		$nb=strlen($s);
		if($nb>0 and $s[$nb-1]=="\n")
			$nb--;
		$sep=-1;
		$i=0;
		$j=0;
		$l=0;
		$nl=1;
		while($i<$nb)
		{
			$c=$s[$i];
			if($c=="\n")
			{
				$i++;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
				continue;
			}
			if($c==' ')
				$sep=$i;
			$l+=$cw[$c];
			if($l>$wmax)
			{
				if($sep==-1)
				{
					if($i==$j)
						$i++;
				}
				else
					$i=$sep+1;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
			}
			else
				$i++;
		}
		return $nl;
	}

	function Header(){
		global $title;
		// Logo
		$this->Image('../../dist/img/AGC_TRANSPARENT.png',7,0,50);
		// Arial bold 15
		$this->SetFont('Arial','',14);
		// Move to the right
		$this->Cell(40);
		// Title
		$this->Cell(162,-5, date('F d, Y'),0,0,'R');
		// Line break
		$this->Ln(5); 
		$this->SetFont('Arial','',8.5);
		$this->Cell(40); 
		$this->Cell(162,-5, 'Blk. 15, Ford Global Building., 32nd St., cor. Rizal Drive, Crescent Park West, BGC, Taguig City',0,0,'R'); 
		$this->Ln(5); 
		$this->SetFont('Arial','',8.5);
		$this->Cell(40); 
		$this->Cell(162,-5, 'Tel. No.: 8860-8888',0,0,'R'); 
		$this->Ln(5);
	}

	// Page footer
	function Footer()
	{
		global $control_number;
		// Position at 1.5 cm from bottom
		$this->SetY(-10);
		// Arial italic 8
		$this->SetFont('Arial','I',8);
		// Page number
		$this->Cell(200,0,'Page '.$this->PageNo().'',0,0,'R');
		$this->SetY(-10);
		// Arial italic 8
		$this->SetFont('Arial','I',8);
		// Page number
		$this->Cell(10,0,'Case ID: '.$control_number.'',0,0,'L');
	}

	function LoadData($file)
	{
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line)
			$data[] = explode(';',trim($line));
		return $data;
	}

	function FancyTable($data,$widths)
	{
		// Colors, line width and bold font
		$this->SetFillColor(0,0,0);
		$this->SetTextColor(255);
		$this->SetDrawColor(0,0,0);
		$this->SetLineWidth(.3);
		// $this->SetFont('','B',10);
		// Header
		$this->SetWidths($widths);
		$header = array();
		foreach($data as $row) {  
			$header = $row;
			break;
		} 
		for($i=0;$i<count($header);$i++)
			$this->Cell($widths[$i],7,$header[$i],1,0,'L',true);
		$this->Ln();
		// Color and font restoration
		// $this->SetFillColor(224,235,255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data 
		foreach($data as $row)
		{  
			if(count($header) > 0){
				$header = array();
			}else{
				$this->Row($row,true); 
			} 
		} 

	} 

	function ReportHead($data,$widths)
	{ 
		foreach($data as $row)
		{
			$this->SetFont('','');
			$this->Cell($widths[0],5,$row[0],'',0,'L');
			$this->SetFont('','B');
			$this->Cell($widths[1],5,': '.$row[1],'',0,'L');
			$this->SetFont('','');
			$this->Cell($widths[2],5,$row[2],'',0,'');
			$this->SetFont('','B');
			$this->Cell($widths[3],5,': '.$row[3],'',0,'L');
			$this->Ln(); 
		} 
	}

	
	}
?>
