<?php
if (empty($_SERVER["HTTPS"]) || $_SERVER["HTTPS"] !== "on") {
    header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
    exit();
}
ob_start();
session_start();

include_once dirname(__FILE__) . '/../cfg/cfg.php';
include_once dirname(__FILE__) . '/../app/classes/utility.php';
include_once dirname(__FILE__) . '/../app/classes/logger.php';
include_once dirname(__FILE__) . '/../app/classes/user_class.php';
$db = new db();
$utility_class = new Utility();
// $logger_class = new Logger(); 
$GLOBALS['logger_class'] = new Logger();
$user_class = new User();
$global_system_settings = $db->system_settings();
if (intval($global_system_settings['is_maintenance']) === 1) {
    if (file_exists('maintenance.php')) {
        header('location:maintenance.php');
    } else {
        echo "Maintenance";
    }
    exit;
}

// print_r($_SESSION['cc_user']);exit;
//check account status 
$global_user_status = 0;
$global_user_message = "Invalid Request.";

if (
    isset($_SESSION['cc_user']) ||
    (isset($_COOKIE['login_token']) && $utility_class->isNotEmpty($_COOKIE['login_token']))
) {
    // check session and cookie
    if (isset($_SESSION['cc_user'])) {
        $login_token_user_id = $_SESSION['cc_user']['id'];
    } else {
        $login_token = $_COOKIE['login_token'];
        $login_token_user_obj = $user_class->read_user_login_token($login_token, 3, 1, $db);
        $login_token_user_arr = array();
        foreach ($login_token_user_obj as $login_token_user_row) {
            $login_token_user_arr = $login_token_user_row;
        }

        if (count($login_token_user_arr) <= 0) {
            unset($_COOKIE['login_token']);
            setcookie('login_token', null, -1, '/');
            header('Location: ' . $global_system_settings['url']);
            exit;
        }

        $login_token_user_id = $login_token_user_arr['user_id'];
    }

    // put function that need to call every call 
    $where_statement = " AND (u.`id` = '" . $login_token_user_id . "') ";

    //check user status
    $global_result_arr = $user_class->system_user_security($where_statement, array(), 'main', $utility_class, $db);

    // print_r($global_result_arr );exit;
    $global_user_message = $global_result_arr['message'];
    $global_user_status = $global_result_arr['status'];

    if (!intval($global_user_status) && !file_exists('maintenance.php')) {
        echo $global_user_message;
        exit;
    }

    $session_user = $_SESSION['cc_user'];
    $session_user_id =  $_SESSION['cc_user']['id'];
    $session_access = $_SESSION['cc_user']['json_access'];
} else {
    $session_user = NULL;
    $session_user_id =  NULL;
}

ob_flush();
ob_end_flush();
