<?php

date_default_timezone_set('Asia/Manila');

include "func.php"; 


class db extends functions{

    // The database connection

    protected static $connection;

	

    /**

     * Connect to the database

     * 

     * @return bool false on failure / mysqli MySQLi object instance on success

     */

    public function connect() {    

        // Try and connect to the database

        if(!isset(self::$connection)) {

            // Load configuration as an array. Use the actual location of your configuration file

            $config = parse_ini_file('cfg.ini'); 

            self::$connection = new mysqli($config['host'],$config['username'],$config['password'],$config['database']);
            self::$connection -> set_charset("utf8");

        }



        // If connection was not successful, handle the error

        if(self::$connection === false) {

            // Handle error - notify administrator, log to a file, show an error screen, etc.

            return false;

        }

        return self::$connection;

    }



	/**

     * Fetch the last error from the database

     * 

     * @return string Database error message

     */

    public function error() {

        $connection = $this -> connect();

        return $connection -> error;

    }

	

	

}

?>