<?php   
if(isset($_REQUEST['api'])){ 
    include_once dirname(__FILE__) . '/../../cfg/db_api.php'; 
}else{ 
    include_once dirname(__FILE__) . '/../../cfg/db.php';
    // if(!intval($global_user_status)){ 
    //     echo $global_user_message;
    //     exit; 
    // }
} 
 
include_once dirname(__FILE__) . '/../../app/classes/brand_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/model_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/utility.php';  

$utility_class = new Utility();
$brand_class = new Brand();
$model_class = new Model();

$server_method = $_SERVER["REQUEST_METHOD"];

if(isset($_REQUEST['model'])){
    $function_name = $db->escape($_REQUEST['model']); 
    $parameters = array(
        'db'=>$db,
        'utility_class'=>$utility_class,
        'brand_class'=>$brand_class,
        'model_class'=>$model_class,
        'server_method'=>$server_method,
        // 'user'=>$session_user,
        // 'global_system_settings'=>$global_system_settings,
        'request'=>$_REQUEST,
    );
    call_user_func($function_name,$parameters);
}else{ 
    echo "Invalid Request.";
    exit;
} 


function read_model_variants($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $model_class = $param['model_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ;
    $vehicle_model = isset($request['vehicle_model']) ? $db -> escape($request['vehicle_model']) : '' ;
    $vehicle_model_id = $utility_class->isNotEmpty($vehicle_model) ? $model_class->read_model_id_by_name($vehicle_model,$utility_class,$db) : '' ;
    $model_variants = $model_class->read_model_variants($vehicle_model_id,$search,$utility_class,$db);
 
   $json_arr['data'] = array();
    foreach($model_variants as $row){
         $json_arr['data'] = array_merge($json_arr['data'], 
            array(array(
                'id'=>$row['id'], 
                'text'=>$row['description'], 
                'model_id'=>$row['model_id'], 
                'model'=>$row['model'], 
                'brand_id'=>$row['brand_id'], 
                'brand'=>$row['brand'], 
            ))
        );
    }

    echo json_encode($json_arr);

}


function read_models($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ;
    $brand_id = 0;
    $brand_info = $brand_class->read_brand_by_name($request['brand_name'],$param['utility_class'],$db);
    foreach($brand_info as $row){ 
        $brand_id = $row['id'];
    } 
    $model_list_obj = $model_class->read_models($brand_id,$search,$utility_class,$db);

    $json = [];
    foreach($model_list_obj as $row){ 
          $json[] = ['id'=>$row['name'], 'text'=>$row['name']];
    }

    echo json_encode($json);
}
 

?>