<?php   
if(isset($_REQUEST['api'])){ 
    include_once dirname(__FILE__) . '/../../cfg/db_api.php'; 
}else{ 
    include_once dirname(__FILE__) . '/../../cfg/db.php';
    // if(!intval($global_user_status)){ 
    //     echo $global_user_message;
    //     exit; 
    // }
} 
 
include_once dirname(__FILE__) . '/../../app/classes/knowledgebase_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/ticket_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/brand_class.php';  
include_once dirname(__FILE__) . '/../../app/classes/model_class.php';
include_once dirname(__FILE__) . '/../../app/classes/upload_class.php';
include_once dirname(__FILE__) . '/../../app/classes/user_class.php';
include_once dirname(__FILE__) . '/../../app/classes/utility.php';  

$utility_class = new Utility();
$knowledgebase_class = new Knowledgebase();
$ticket_class = new Ticket();
$brand_class = new Brand();
$model_class = new Model();
$user_class = new User();
$upload_class = new Upload();

$server_method = $_SERVER["REQUEST_METHOD"];

if(isset($_REQUEST['model'])){
    $function_name = $db->escape($_REQUEST['model']); 
    $parameters = array(
        'db'=>$db,
        'utility_class'=>$utility_class,
        'brand_class'=>$brand_class,
        'model_class'=>$model_class,
        'user_class'=>$user_class,
        'knowledgebase_class'=>$knowledgebase_class,
        'ticket_class'=>$ticket_class,
        'upload_class'=>$upload_class,
        'server_method'=>$server_method,
        'user_session'=>$session_user,
        'session_access'=>$session_access,
        'global_system_settings'=>$global_system_settings,
        'request'=>$_REQUEST,
    );
    call_user_func($function_name,$parameters);
}else{ 
    echo "Invalid Request.";
    exit;
}  

function read_knowledgebase_information($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];

    $knowledgebase_id = $request['knowledgebase_id'];
    $knowledgebase_info_obj = $knowledgebase_class->read_knowledgebase_information($knowledgebase_id,$utility_class,$db);

    $json = array();
    foreach($knowledgebase_info_obj as $row){ 
        $row = $utility_class->arrayNullToBlank($row);

         $display_name =  $row['firstname']. ' '.substr($row['lastname'],0,1);
          $json = array( 
                'lbl_kb_subject'=>$row['title'],
                'lbl_kb_description'=>$row['description'], 
                'lbl_kb_category'=>$row['sub_category'],
                'lbl_kb_posted_by'=>$display_name,
                'lbl_v_kb_brand'=>$row['brand'],
                'lbl_v_kb_model'=>$row['model'],
                'lbl_v_kb_mv'=>$row['model_variant'],
                'lbl_kb_posted_date'=>$row['date_addedf'],
                'lbl_ticket_fault_codes'=>$row['fault_codes'],
                'category_id'=>$row['category_id'],
                'show_vehicle'=>$row['show_vehicle'],
                'kb_vehicle_id'=>$row['knowledgebase_vehicle_id'],
            );
    }
    echo json_encode($json);
}

function read_knowledgebase_data($param){
        $db = $param['db'];
        $utility_class = $param['utility_class'];
        $knowledgebase_class = $param['knowledgebase_class']; 
        $request = $param['request'];
        $knowledgebase_id = $request['knowledgebase_id'];
        $json['rows'] = array();
        $json['attachments'] = array(); 

    $knowledgebase_id = $request['knowledgebase_id'];
    $knowledgebase_info_obj = $knowledgebase_class->read_knowledgebase_information($knowledgebase_id,$utility_class,$db);
 

    foreach($knowledgebase_info_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       
          $json['rows'] = array( 
                'category'=>$row['sub_category'],
                'section'=>$row['section'],
                'title'=>$row['title'],
                'description'=>$row['description'],
                'fault_codes'=>$row['fault_codes'],
                // 'sub_category_id'=>$row['sub_category_id'],
                // 'sub_category'=>$row['sub_category'],
                // 'subject'=>$row['title'],
                // 'description'=>$row['description'],
                // 'priority_id'=>$row['priority_level_id'],
                // 'priority_level'=>$row['priority_level'],
                // // 'brand_id'=>$row['brand_id'],
                'brand'=>$row['brand'],
                // 'model_id'=>$row['model_id'],
                'model'=>$row['model'],
                'model_variant_id'=>$row['model_variant_id'],
                'model_variant'=>$row['model_variant'],
                // 'year_model'=>$row['year_model'],
                // 'plate_cs'=>$row['plate_cs'],
                // 'vin'=>$row['vin'],
                // 'category_id'=>$row['category_id'],
                // 'knowledgebase_status_id'=>$row['knowledgebase_status_id'],
                // 'knowledgebase_status'=>$row['knowledgebase_status'],
            );
    }
 

    $knowledgebase_attach_obj = $knowledgebase_class->read_knowledgebase_attachments($knowledgebase_id,$utility_class,$db);
    foreach($knowledgebase_attach_obj as $row){  
        $file = dirname(__FILE__) . '/../../dist/knowledgebase/'.$row['attachment_name'];
        $unreadable_size = (is_file($file) ? filesize($file) : 0 );
        $readable_file_size = $utility_class->humanFileSize($unreadable_size);
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
          $json['attachments'] = array_merge($json['attachments'],array(array( 
                'id'=>$row['id'],
                'change_name'=>$row['attachment_name'],
                'original_name'=>$row['original_name'],
                'date'=>$row['date_addedf'],
                'size'=>$readable_file_size,
                'unreadable_size'=>$unreadable_size,
                'icon'=>$fa_icon,
            )));
    }
    echo json_encode($json);
     
        
}

function create_knowledgebase($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];

    $is_new_kb = $request['is_new_kb'];

     $knowledgebase_attachments = json_decode($request['attachments'],true);
      

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }

    $knowledgebase_id = $request['knowledgebase_id'];

     // get category id
    $sub_category_id = $ticket_class->read_sub_category_id_by_name($array_data['category'],$utility_class,$db); 
     // get section id
    $section_id = $ticket_class->read_section_id_by_name($array_data['section'],$utility_class,$db); 
    // get main category id
    $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id,$utility_class,$db); 
    $category_arr = array();
    foreach($category_obj as $category_row){
        $category_arr = $category_row;
    }
 
    $cat_show_vehicle = $category_arr['show_vehicle'];
    $category_id = $category_arr['category_id'];

    if(intval($cat_show_vehicle) === 1){ //means vehicle 
        // get brand id

        if($utility_class->isNotEmpty($array_data['brand'])){
            $brand_id = $brand_class->read_brand_id_by_name($array_data['brand'],$utility_class,$db); 
        }else{
            $brand_id = "";
        } 

        if($utility_class->isNotEmpty($array_data['model']) && $utility_class->isNotEmpty($brand_id)){
            $model_id = $model_class->read_model_id_by_name_n_brand_id($brand_id,$array_data['model'],$utility_class,$db); 
        }else{
            $model_id = "";
        }
     
        // get model variant id
        $model_variant_id = $array_data['model_variant_id'];

        if(!$utility_class->isNotEmpty($model_variant_id) && $utility_class->isNotEmpty($array_data['model_variant']) && $utility_class->isNotEmpty($model_id)){
            $model_variant_id = $model_class->insert_model_variant($model_id,$array_data['model_variant'],$utility_class,$db); 
        }
 
        // echo $is_new_kb;exit;
        if($is_new_kb){
            $knowledgebase_id = $knowledgebase_class->create_knowledgebase($user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
            $knowledgebase_class->create_vehicle_type_knowledgebase($knowledgebase_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
        }else{
            $knowledgebase_class->update_knowledgebase($knowledgebase_id,$user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
            $knowledgebase_type_vehicle_obj =  $knowledgebase_class->read_vehicle_type_knowledgebase($knowledgebase_id,$utility_class,$db);
            $knowledgebase_type_vehicle_arr = array();
            foreach($knowledgebase_type_vehicle_obj as $row_vehicle_type){
                $knowledgebase_type_vehicle_arr = $row_vehicle_type;
            }
            
            if(count($knowledgebase_type_vehicle_arr) > 0){
                $knowledgebase_class->update_vehicle_type_knowledgebase($knowledgebase_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
            }else{
                $knowledgebase_class->create_vehicle_type_knowledgebase($knowledgebase_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
            }
        }

    }else{
         if($is_new_kb){
            // Insert no type (general) ticket and no 
             $knowledgebase_id = $knowledgebase_class->create_knowledgebase($user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
         }else{ 
             $knowledgebase_class->update_knowledgebase($knowledgebase_id,$user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
            $knowledgebase_class->update_vehicle_type_knowledgebase_status($knowledgebase_id,0,$utility_class,$db);
         }
    }

    foreach($knowledgebase_attachments as $knowledgebase_attachment){
        $knowledgebase_class->create_knowledgebase_attachment($knowledgebase_id,$knowledgebase_attachment['change_name'],$knowledgebase_attachment['original_name'],$utility_class,$db);
    }
 

    if(!$is_new_kb){  
        // update remove attachments
        $attachment_ids_arr = json_decode($request['remove_attachments'],true);
        if(count($attachment_ids_arr) > 0){
            $attachment_ids = implode(',', $attachment_ids_arr);
            $knowledgebase_class->update_knowledgebase_attachment_status($attachment_ids,0,$utility_class,$db);
        }
     }

    if($is_new_kb){   
        $return_arr['message'] = "Article has been added.";
    }else{
        $return_arr['message'] = "Article has been updated.";
    }
    
    $return_arr['id'] = $knowledgebase_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);

    
}

function read_knowledgebase_attachments($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];

    $knowledgebase_id = $request['knowledgebase_id'];
    $knowledgebase_info_obj = $knowledgebase_class->read_knowledgebase_attachments($knowledgebase_id,$utility_class,$db);

    $json = array();

    foreach($knowledgebase_info_obj as $row){  
        $file = dirname(__FILE__) . '/../../dist/knowledgebase/'.$row['attachment_name'];
        $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0 ));
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
          $json[] = array( 
                'id'=>$row['id'],
                'change_name'=>$row['attachment_name'],
                'original_name'=>$row['original_name'],
                'date'=>$row['date_addedf'],
                'size'=>$readable_file_size,
                'icon'=>$fa_icon,
            );
    }
    echo json_encode($json);
}


function read_knowledgebase_list($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_session = $param['user_session'];
    $session_access =  $param['session_access'];
     $brand_access_arr =  $user_session['json_brand']; 
    $request = $param['request'];
    $array_data = array();

    $search = isset($request['search']) ? $db->escape($request['search']) : '' ;
    $offset = $request['offset'];
    $limit = $request['limit']; 
    $owned_kb_only = isset($request['owned_kb_only']) ? $request['owned_kb_only'] : '' ;
    
    $short_description = isset($request['short_description']) ? $request['short_description'] : '' ;
    
    $filter_start_date =  isset($request['start_date']) ? $request['start_date'] : '' ; //$request['start_date'];
    $filter_end_date = isset($request['end_date']) ? $request['end_date'] : '' ; //$request['end_date'];

    $filter_src_type = isset($request['filter_type']) ? $request['filter_type'] : '' ; 
    $filter_brand_id = isset($request['filter_brand']) && ($utility_class->isNotEmpty($request['filter_brand']))? $brand_class->read_brand_id_by_name($request['filter_brand'],$utility_class,$db) : ''; 
    $filter_model_id = (isset($request['filter_model']) && $utility_class->isNotEmpty($request['filter_model']))? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id,$request['filter_model'],$utility_class,$db) : ''; 


    //   if(!(isset($session_access['4']) && in_array('4_3', $session_access['4']))){
    //     $ait_access= "";
    // }else{
    //    $ait_access= " AND ks.id IS NULL";
    // }


    //enable if empty section or no access in ait
    if(
        (isset($request['filter_section']) && ($request['filter_section'] == 'EMPTY_SECTION')) || 
        !(isset($session_access['4']) && in_array('4_3', $session_access['4']))
        ){
        $array_data['all_null_section'] = 1;

    }
    $filter_section_id = isset($request['filter_section']) && ($utility_class->isNotEmpty($request['filter_section']))? $ticket_class->read_section_id_by_name($request['filter_section'],$utility_class,$db) : ''; 
 
    $req_filter_category = isset($request['filter_category']) ? $request['filter_category'] : '[]' ;
    $filter_category = json_decode($req_filter_category,true);
    $filter_category_ids = array();
    if(count($filter_category) > 0){
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names,$utility_class,$db);
        foreach($category_id_list_obj as $category_id_list){
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",",$filter_category_ids) : '' ;

    // $req_filter_final_status = isset($request['filter_final_status']) ? $request['filter_final_status'] : '[]' ;
    //  // Filter by final Status
    // $filter_final_status = json_decode($req_filter_final_status,true);
    // $filter_final_status_ids = array();
    // if(count($filter_final_status) > 0){
    //     $filter_final_status_names = "'" . implode("','", $filter_final_status) . "'";
    //     $status_id_list_obj = $ticket_class->read_ticket_final_status_ids_by_names($filter_final_status_names,$utility_class,$db);
    //     foreach($status_id_list_obj as $status_id_list){
    //         $filter_final_status_ids[] = $status_id_list['id'];
    //     }
    // }
    // $filter_final_status_ids_str = count($filter_final_status_ids) > 0 ? implode(",",$filter_final_status_ids) : '' ;
    //  $filter_escalated_status = array();
    // if(in_array('Escalated (Solve)',$filter_final_status)){
    //     $filter_escalated_status[] = 1;
    // }
    // $filter_escalated_str =  count($filter_escalated_status) > 0 ? implode(",",$filter_escalated_status) : '' ;


    $universal_knowledgebase_query = $knowledgebase_class->universal_knowledgebase_query();
    $universal_ticket_query = $ticket_class->universal_ticket_query();

    $display_union_count = 50;

    
    $kb_list_array = $knowledgebase_class->read_knowledgebase_list($user_session['id'],
                                                                    $array_data,
                                                                    $filter_src_type,
                                                                    $owned_kb_only,
                                                                    $short_description,
                                                                    $filter_category_ids_str,
                                                                    $filter_brand_id,
                                                                    $filter_model_id,
                                                                    $filter_section_id,
                                                                    $brand_access_arr,
                                                                    $search,
                                                                    $filter_start_date,
                                                                    $filter_end_date,
                                                                    $offset,
                                                                    $limit,
                                                                    $universal_knowledgebase_query,
                                                                    $universal_ticket_query,
                                                                    $display_union_count,
                                                                    $utility_class,
                                                                    $db);


    $json_arr['total'] = (intval($kb_list_array[0]) < ($display_union_count*2)) ? $kb_list_array[0] : ($display_union_count*2) ; //$kb_list_array[0];

    $kb_list_obj = $kb_list_array[1]; 

    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($kb_list_obj as $row){
        //  $row = $utility_class->arrayNullToBlank($row);
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
        $display_name =  $row['firstname']. ' '.substr($row['lastname'],0,1); 
        
        $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'source'=>$row['source'],
                'date'=>$row['date_addedf'],
                'datew'=>date("M. j, Y", strtotime($row['date_addedf'])),
                'category'=>$row['sub_category'],
                'vehicle'=>$row['brand'].' - '.$row['model'], 
                'title'=>$row['title'],  
                'descriptionf'=>$row['descriptionf'],   
                'created_by'=>$display_name, 
                // 'status'=>$row['final_status'],
                // 'final_status_id'=>$row['final_status_id'],
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_knowledgebase_video_autocomplete($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];
    $request = $param['request']; 
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand']; 
     
    // print_r($request);exit;
 
    $search = isset($request['search']) ? $db->escape($request['search']) : '' ;
    $offset = $request['offset'];
    $limit = $request['limit'];

    $list_obj = $knowledgebase_class->read_knowledgebase_video_autocomplete(
                                                        $search,
                                                        $offset,
                                                        $limit,
                                                        $utility_class,$db);
    $json_arr['rows'] = array();
    foreach($list_obj as $row){ 
         $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'id'=>$row['id'],
                'text'=>$row['title'],
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_knowledgebase_list_autocomplete($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_session = $param['user_session'];
     $brand_access_arr =  $user_session['json_brand']; 
    $request = $param['request'];

    $search = isset($request['search']) ? $db->escape($request['search']) : '' ;
    $offset = $request['offset'];
    $limit = $request['limit']; 
    
    $universal_knowledgebase_query = $knowledgebase_class->universal_knowledgebase_query();
    $universal_ticket_query = $ticket_class->universal_ticket_query();

    $display_union_count = 50;
    $kb_list_obj = $knowledgebase_class->read_knowledgebase_list_autocomplete(
                                                                    $search, 
                                                                    $offset,
                                                                    $limit,
                                                                    $universal_knowledgebase_query,
                                                                    $universal_ticket_query,
                                                                    $display_union_count,
                                                                    $utility_class,
                                                                    $db);


  

    $json_arr['rows'] = array();

    foreach($kb_list_obj as $row){
        //  $row = $utility_class->arrayNullToBlank($row);
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
     
        $json_arr['rows'] = array_merge($json_arr['rows'],
   
            array(array( 
                'id'=>$row['id'], 
                'text'=>$row['title'],  
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_related_articles($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_session = $param['user_session'];
    $request = $param['request'];
    $brand_access_arr =  $user_session['json_brand']; 

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }
   
    $title = $array_data['title']; 
    $fault_codes = $array_data['fault_codes'];

    $offset = $request['offset'];
    $limit = $request['limit']; 

    $sub_category_id = $ticket_class->read_sub_category_id_by_name($array_data['category'],$utility_class,$db); 
    // get main category id
    $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id,$utility_class,$db); 
    $category_arr = array();
    foreach($category_obj as $category_row){
        $category_arr = $category_row;
    }
 
    $cat_show_vehicle = $category_arr['show_vehicle'];
    $category_id = $category_arr['category_id'];

    if($utility_class->isNotEmpty($array_data['brand'])){
        $brand_id = $brand_class->read_brand_id_by_name($array_data['brand'],$utility_class,$db); 
    }else{
        $brand_id = "";
    }

    if($utility_class->isNotEmpty($array_data['model'])){
        $model_id = $model_class->read_model_id_by_name_n_brand_id($brand_id,$array_data['model'],$utility_class,$db); 
    }else{
       $model_id = "";
    }

    if($utility_class->isNotEmpty($array_data['model_variant_id'])){
       $model_variant_id = $array_data['model_variant_id'];
    }else{
      $model_variant_id ="";
    }

    $universal_knowledgebase_query = $knowledgebase_class->universal_knowledgebase_query();
    $universal_ticket_query = $ticket_class->universal_ticket_query();

    $display_union_count = 50;
    $kb_list_array = $knowledgebase_class->read_related_articles(
                                                                    $title,
                                                                    $fault_codes,
                                                                    $sub_category_id,
                                                                    $brand_id,
                                                                    $model_id,
                                                                    $model_variant_id,
                                                                    $brand_access_arr,
                                                                    $offset,
                                                                    $limit,
                                                                    $universal_knowledgebase_query,
                                                                    $universal_ticket_query,
                                                                    $display_union_count,
                                                                    $utility_class,
                                                                    $db);


    $json_arr['total'] = (intval($kb_list_array[0]) < ($display_union_count*2)) ? $kb_list_array[0] : ($display_union_count*2) ; //$kb_list_array[0];

    $kb_list_obj = $kb_list_array[1]; 

    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($kb_list_obj as $row){
        //  $row = $utility_class->arrayNullToBlank($row);
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
        // $final_status = $utility_class->isNotEmpty($row['final_status']) ? $row['status']. ' ('.$row['final_status'].')' : $row['status'] ;
     
        $json_arr['rows'] = array_merge($json_arr['rows'],
   
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'source'=>$row['source'],
                'date'=>$row['date_addedf'],
                'datew'=>date("F j, Y", strtotime($row['date_addedf'])),
                'category'=>$row['sub_category'],
                'vehicle'=>$row['brand'].' - '.$row['model'], 
                'title'=>$row['title'], 
                'descriptionf'=>$row['descriptionf'],  
                // 'status'=>$row['final_status'],
                // 'final_status_id'=>$row['final_status_id'],
            ))
        );
    }

    echo json_encode($json_arr);
     
}

 



function create_video($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $is_new_video = $request['is_new_video'];
    $user_class = $param['user_class'];
    $send_notif = $request['send_notif'];
    $global_system_settings = $param['global_system_settings'];
    $position_data = $request['position_data'];
    $position_data_arr = json_decode($position_data,true); 

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }


    $knowledgebase_attachments = json_decode($request['rsc_attachments'],true);

    $ticket_attachments = json_decode($request['attachments'],true);
    $ticket_attachments_arr = array();
    foreach($ticket_attachments as $ticket_attachment){ 
        $ticket_attachments_arr = $ticket_attachment;
        break;
    } 
    // print_r($ticket_attachments_arr);exit;
 

    // get category id
    $sub_category_id = $ticket_class->read_sub_category_id_by_name($array_data['category'],$utility_class,$db); 
     // get section id
    $section_id = $ticket_class->read_section_id_by_name($array_data['section'],$utility_class,$db); 
    // get main category id
     $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id,$utility_class,$db); 
    $category_arr = array();
    foreach($category_obj as $category_row){
        $category_arr = $category_row;
    }
 
    $cat_show_vehicle = $category_arr['show_vehicle'];
    $category_id = $category_arr['category_id'];
    // get priority id
    // $priority_id = $ticket_class->read_priority_level_id_by_name($array_data['priority_level'],$utility_class,$db); 
    // insert main ticket

    $video_id = 0;

    // $array_data['description'] = str_replace("\\n","<br>",$array_data['description']);
    // echo  $array_data['description'];exit;

    //if the sub category is under vehicle catgory execute this 
    // current Vehicle Category is 2, change it depends to your database category table
    if(intval($cat_show_vehicle) === 1){
        // get brand id

        if($utility_class->isNotEmpty($array_data['brand'])){
            $brand_id = $brand_class->read_brand_id_by_name($array_data['brand'],$utility_class,$db); 
        }else{
            $brand_id = "";
        } 

        if($utility_class->isNotEmpty($array_data['model']) && $utility_class->isNotEmpty($brand_id)){
            $model_id = $model_class->read_model_id_by_name_n_brand_id($brand_id,$array_data['model'],$utility_class,$db); 
        }else{
            $model_id = "";
        }
     
        // get model variant id
        $model_variant_id = $array_data['model_variant_id'];

        if(!$utility_class->isNotEmpty($model_variant_id) && $utility_class->isNotEmpty($array_data['model_variant']) && $utility_class->isNotEmpty($model_id)){
            $model_variant_id = $model_class->insert_model_variant($model_id,$array_data['model_variant'],$utility_class,$db); 
        }
 
        // echo $is_new_video;exit;
        if($is_new_video){
            $video_id = $knowledgebase_class->create_video($user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$ticket_attachments_arr['original_name'],$ticket_attachments_arr['change_name'],$utility_class,$db);
            $knowledgebase_class->create_vehicle_type_video($video_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
        }else{
            $video_id = $request['video_id']; 
            $knowledgebase_class->update_video($video_id,$user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
            $video_type_vehicle_obj =  $knowledgebase_class->read_vehicle_type_video($video_id,$utility_class,$db);
            $video_type_vehicle_arr = array();
            foreach($video_type_vehicle_obj as $row_vehicle_type){
                $video_type_vehicle_arr = $row_vehicle_type;
            }
            
            // echo $video_type_vehicle_arr;exit;
            if(count($video_type_vehicle_arr) > 0){
                $knowledgebase_class->update_vehicle_type_video($video_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
            }else{
                $knowledgebase_class->create_vehicle_type_video($video_id,$brand_id,$model_id,$model_variant_id,$utility_class,$db);
            }
            
        }

    }else{
         if($is_new_video){
            // Insert no type (general) ticket and no 
            $video_id = $knowledgebase_class->create_video($user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$ticket_attachments_arr['original_name'],$ticket_attachments_arr['change_name'],$utility_class,$db);
         }else{
            $video_id = $request['video_id'];
            $knowledgebase_class->update_video($video_id,$user_session['id'],$sub_category_id,$section_id,$array_data['title'],$array_data['description'],$array_data['fault_codes'],$utility_class,$db);
            $knowledgebase_class->update_vehicle_type_video_status($video_id,0,$utility_class,$db);
         }
    }


    // print_r($knowledgebase_attachments);exit;
    foreach($knowledgebase_attachments as $knowledgebase_attachment){
        $knowledgebase_class->create_video_attachment($video_id,$knowledgebase_attachment['change_name'],$knowledgebase_attachment['original_name'],$utility_class,$db);
    }

    if(!$is_new_video){
        // update remove attachments
        $attachment_ids_arr = json_decode($request['rsc_remove_attachments'],true);
        if(count($attachment_ids_arr) > 0){
            $attachment_ids = implode(',', $attachment_ids_arr);
            $knowledgebase_class->update_video_attachment_status($attachment_ids,0,$utility_class,$db);
        }
     }

    $knowledgebase_class->create_video_access($video_id,$position_data,$utility_class,$db);
 
    if($is_new_video && count($position_data_arr) > 0 && $send_notif ){

        $array_data['target_json'] = $position_data;
        $array_data['target_id'] = $video_id;
        $array_data['api_type'] = 1;
        $array_data['data_type'] = 1;
        
        //table of this will remove
        // $user_class->create_api_notifications($array_data,$utility_class,$db); 


        //  $query = "SELECT * FROM `cnf_api_notifications` WHERE 1 AND api_type = 1 AND data_type = 1 AND status = 1"; 
        // $api_notif_obj = $db->sql_query($query);
        // foreach($api_notif_obj as $api_notif_row){ 
            // $db->sql_query("UPDATE `cnf_api_notifications` SET `status`=0 WHERE 1 AND id = ".$api_notif_row['id']."");
            $utility_class -> curl_me_async(
            $global_system_settings['url']."api/v1/viber/send_video_notification.php",
            array("json"=>'{"target_id":"'.$array_data['target_id'].'","type":1,"target_json":'.$array_data['target_json'].'}'),
            'POST'); 
            // echo '{"target_id":"'.$api_notif_row['target_id'].'","type":1,"target_json":'.$api_notif_row['target_json'].'} ....';

        // }  
            
     
 
                            
    }

    
    if($is_new_video){   
        $return_arr['message'] = "Video has been added.";
    }else{
        $return_arr['message'] = "Video has been updated.";
    }
    
    $return_arr['id'] = $video_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);
}
 

function read_video_viewers($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $video_id = $request['video_id'];
    $offset = $request['offset'];
    $limit = $request['limit'];
    $search = isset($request['search']) ? $db->escape($request['search']) : '' ;

    $order = $request['order'];
    $data_obj = $knowledgebase_class->read_video_viewers($video_id,$search,$offset,$limit,$order,$utility_class,$db);  
    
    $json['rows'] = array(); 
    foreach($data_obj as $row){ 
          $json['rows'] = array_merge($json['rows'],array(array(
                'id'=>$row['id'], 
                'user'=>$row['firstname'].' '.$row['lastname'], 
                'id_number'=> $row['id_number'], 
                'date_added'=>$row['date_addedf'], 
            ))); 
    }
 
    echo json_encode($json);
}

function read_videos($param){
    
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $request = $param['request'];
    
    $session_access =  $param['session_access'];
    $user_session = $param['user_session']; 
     $brand_access_arr =  $user_session['json_brand']; 
    $owned_video_only = isset($request['owned_video_only']) ? $request['owned_video_only'] : '' ;
     $array_data = array();
    
    $search = isset($request['search']) ? $db->escape($request['search']) : '' ;
    $offset = $request['offset'];
    $limit = $request['limit']; 

     $filter_category = json_decode(isset($request['filter_category']) ? $request['filter_category'] : "[]",true);
    $filter_category_ids = array();
    if(count($filter_category) > 0){
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names,$utility_class,$db);
        foreach($category_id_list_obj as $category_id_list){
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",",$filter_category_ids) : '' ;

     $filter_brand_id = isset($request['filter_brand']) && $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'],$utility_class,$db) : ''; 
    $filter_model_id = isset($request['filter_model']) && $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id,$request['filter_model'],$utility_class,$db) : ''; 
    $filter_position_id = isset($request['filter_position']) && $utility_class->isNotEmpty($request['filter_position']) ? $user_class->read_position_id_by_name($request['filter_position'],$utility_class,$db) : ''; 

    if(
        (isset($request['filter_section']) && ($request['filter_section'] == 'EMPTY_SECTION')) || 
        !(isset($session_access['5']) && in_array('5_4', $session_access['5']))
        ){
        $array_data['all_null_section'] = 1;

    }

    $filter_section_id = isset($request['filter_section']) && ($utility_class->isNotEmpty($request['filter_section']))? $ticket_class->read_section_id_by_name($request['filter_section'],$utility_class,$db) : ''; 
  
    // print_r($user_session);exit;
    if($utility_class->isNotEmpty($filter_position_id)){
        $position_ids_arr = array($user_session['position_id'],$filter_position_id);
    }else{
        $position_ids_arr = array($user_session['position_id']);
    }

    $video_list_array = $knowledgebase_class->read_video_list($user_session['id'],$array_data,$position_ids_arr,$owned_video_only,$filter_category_ids_str,$filter_brand_id,$filter_model_id,$filter_section_id,$brand_access_arr,$search,$offset,$limit,$utility_class,$db);

    $json_arr['total'] = $video_list_array[0];
    $video_list_obj = $video_list_array[1];
    
    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($video_list_obj as $row){
      $row = $utility_class->arrayNullToBlank($row);
        $file = dirname(__FILE__) . '/../../dist/videos/'.$row['attachment_name'];
        $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0 ));

         $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'date'=>$row['date_addedf'],
                'original_name'=>$row['original_name'],
                'attachment_name'=>$row['attachment_name'],
                'title'=>$row['title'],
                'description'=>$row['description'],
                'descriptionf'=>$row['descriptionf'],
                'size'=>$readable_file_size,
                'brand'=>$row['brand'],
                'model'=>$row['model'],
                'model_variant'=>$row['model_variant'],
                // 'category'=>$row['sub_category'],
                // 'vehicle'=>$row['brand'].' - '.$row['model'],
                // 'plate_cs'=>$row['plate_cs'],
                // 'title'=>$row['title'],
                // 'priority'=>$row['priority_level'],
                // 'status'=>$row['status'],
            ))
        );
    }

    echo json_encode($json_arr);

}

function read_ticket_attachments($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];

    $ticket_id = $request['ticket_id'];
    $ticket_info_obj = $ticket_class->read_ticket_attachments($ticket_id,$utility_class,$db);

    $json = array();

    

    foreach($ticket_info_obj as $row){  
        $file = dirname(__FILE__) . '/../../dist/attachments/'.$row['attachment_name'];
        $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0 ));
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
          $json[] = array( 
                'id'=>$row['id'],
                'change_name'=>$row['attachment_name'],
                'original_name'=>$row['original_name'],
                'date'=>$row['date_addedf'],
                'size'=>$readable_file_size,
                'icon'=>$fa_icon,
            );
    }
    echo json_encode($json);
}

function delete_video($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];
    $user_session = $param['user_session']; 
    $video_id = $request['video_id'];
 
    $knowledgebase_class->update_video_status($video_id,0,$utility_class,$db);

    $json['message'] = "Successfully removed.";
    echo json_encode($json);
}

function create_watched_video($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $request = $param['request'];
    $user_session = $param['user_session']; 
    $video_id = $request['video_id'];
    
    $watched_video_id = $knowledgebase_class->read_watched_video($video_id,$user_session['id'],$utility_class,$db);

    if(!$utility_class->isNotEmpty($watched_video_id)){
        $knowledgebase_class->create_watched_video($video_id,$user_session['id'],$utility_class,$db);
    }

    $json['status'] = 1;
    $json['message'] = "Successful.";
    echo json_encode($json);
}

function read_video_data($param){
        $db = $param['db'];
        $utility_class = $param['utility_class'];
        $knowledgebase_class = $param['knowledgebase_class']; 
        $request = $param['request'];
        $video_id = $request['video_id'];
        $json['rows'] = array(); 
        $json['attachments'] = array();
 
    $video_info_obj = $knowledgebase_class->read_video_information($video_id,$utility_class,$db);
 
    

    foreach($video_info_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       
        // $file = dirname(__FILE__) . '/../../dist/videos/'.$row['attachment_name'];
        // $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0 ));
        $display_name =  $row['firstname']. ' '.substr($row['lastname'],0,1); 
                $display_name = ucwords(strtolower($display_name));

          $json['rows'] = array(
                'id'=>$row['id'],
                'date'=>$row['date_addedf'],
                'user'=>'Created by '.$display_name.' on '.$row['date_addedf'],
                'original_name'=>$row['original_name'],
                'attachment_name'=>$row['attachment_name'],
                'title'=>$row['title'],
                'description'=>$row['description'],
                'category'=>$row['sub_category'], 
                'section'=>$row['section'], 
                'brand'=>$row['brand'], 
                'model'=>$row['model'], 
                'fault_codes'=>$row['fault_codes'], 
                'model_variant'=>$row['model_variant'],
                'model_variant_id'=>$row['model_variant_id'],
                'position_access'=>$row['json_data'],
            );
    }

 $attach_obj = $knowledgebase_class->read_video_attachments($video_id,$utility_class,$db);
    foreach($attach_obj as $row){  
        $file = dirname(__FILE__) . '/../../dist/videos/resources/'.$row['attachment_name'];
        $unreadable_size = (is_file($file) ? filesize($file) : 0 );
        $readable_file_size = $utility_class->humanFileSize($unreadable_size);
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
          $json['attachments'] = array_merge($json['attachments'],array(array( 
                'id'=>$row['id'],
                'change_name'=>$row['attachment_name'],
                'original_name'=>$row['original_name'],
                'date'=>$row['date_addedf'],
                'size'=>$readable_file_size,
                'unreadable_size'=>$unreadable_size,
                'icon'=>$fa_icon,
            )));
    }

 
    
    echo json_encode($json);
     
        
}

function read_video_information($param){
        $db = $param['db'];
        $utility_class = $param['utility_class'];
        $knowledgebase_class = $param['knowledgebase_class']; 
        $request = $param['request'];
        $video_id = $request['video_id'];
        $json['rows'] = array(); 
        $json['attachments'] = array();
 
    $video_info_obj = $knowledgebase_class->read_video_information($video_id,$utility_class,$db);
 
    

    foreach($video_info_obj as $row){
       $row = $utility_class->arrayNullToBlank($row);
       
        // $file = dirname(__FILE__) . '/../../dist/videos/'.$row['attachment_name'];
        // $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0 ));
        $display_name =  $row['firstname']. ' '.substr($row['lastname'],0,1); 
                $display_name = ucwords(strtolower($display_name));

          $json['rows'] = array(
                'id'=>$row['id'],
                'date'=>$row['date_addedf'],
                'user'=>'Created by '.$display_name.' on '.$row['date_addedf'],
                'original_name'=>$row['original_name'],
                'attachment_name'=>$row['attachment_name'],
                'title'=>$row['title'],
                'lbl_description'=>str_replace("\n","<br>",$row['description']), //$row['description'],
                'lbl_category'=>$row['sub_category'], 
                'v_view_brand'=>$row['brand'], 
                'v_view_model'=>$row['model'], 
                'v_view_model_variant'=>$row['model_variant'],
                'model_variant_id'=>$row['model_variant_id'],
                'lbl_ticket_fault_codes'=>$row['fault_codes'],
            );
    }

 $attach_obj = $knowledgebase_class->read_video_attachments($video_id,$utility_class,$db);
    foreach($attach_obj as $row){  
        $file = dirname(__FILE__) . '/../../dist/videos/resources/'.$row['attachment_name'];
        $unreadable_size = (is_file($file) ? filesize($file) : 0 );
        $readable_file_size = $utility_class->humanFileSize($unreadable_size);
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
          $json['attachments'] = array_merge($json['attachments'],array(array( 
                'id'=>$row['id'],
                'change_name'=>$row['attachment_name'],
                'original_name'=>$row['original_name'],
                'date'=>$row['date_addedf'],
                'size'=>$readable_file_size,
                'unreadable_size'=>$unreadable_size,
                'icon'=>$fa_icon,
            )));
    }

 
    
    echo json_encode($json);
     
        
}


function read_sub_categories_content_count($param){
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $knowledgebase_class = $param['knowledgebase_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];
    $session_access =  $param['session_access'];

    $universal_knowledgebase_query = $knowledgebase_class->universal_knowledgebase_query();
    $universal_ticket_query = $ticket_class->universal_ticket_query();

 
    
    $display_union_count = 0;
    $knowledgebase_cat_obj = $knowledgebase_class->read_sub_category_count_v2(
                                                                    $session_access,
                                                                    $brand_access_arr,
                                                                    $universal_knowledgebase_query,
                                                                    $universal_ticket_query,
                                                                    $display_union_count,
                                                                    $utility_class,
                                                                    $db);
  $knowledgebase_cat_arr = array();
  foreach($knowledgebase_cat_obj as $knowledgebase_cat){
         $knowledgebase_cat_arr = array_merge($knowledgebase_cat_arr, array(array(
             'id'=>$knowledgebase_cat['id'],
             'name'=>$knowledgebase_cat['name'],
             'count'=>$knowledgebase_cat['sub_category_count'],
         )));
    }   

    $category_list_obj = $ticket_class->read_sub_categories('',$utility_class,$db);

    $category_list_arr = array();
    foreach($category_list_obj as $row){ 
        $knowledgebase_count = 0;
        foreach($knowledgebase_cat_arr as $knowledgebase_cat_row){
            if($row['id'] == $knowledgebase_cat_row['id']){
                $knowledgebase_count = $knowledgebase_cat_row['count'];
            }   
        }
          $category_list_arr = array_merge($category_list_arr,array(array(
              'id'=>$row['id'], 
              'name'=>$row['name'],
              'count'=>$knowledgebase_count,
          )));
    }
    
echo json_encode($category_list_arr);
    

}

?>