<?php

class Utility
{

    function test()
    {
        return "Test101";
    }
    function generate_uuid($db)
    {
        return $db->select("SELECT UUID_SHORT()");
    }

    function isValidEmail($email)
    {
        return (filter_var($email, FILTER_VALIDATE_EMAIL));
    }

    function isPostMethod($request)
    {
        if ($request != "POST") {
            return false;
        }
        return true;
    }

    function time_elapsed_string($datetime, $full = false)
    {
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array(
            'y' => 'year',
            'm' => 'month',
            'w' => 'week',
            'd' => 'day',
            'h' => 'hour',
            'i' => 'minute',
            's' => 'second',
        );
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        return $string ? implode(', ', $string) . '' : 'just now';
    }

    function toArrayInt($array_data)
    {
        $array_data = array_map(
            function ($value) {
                return (int)$value;
            },
            $array_data
        );
        return $array_data;
    }
    function isJson($string)
    {
        json_decode($string);
        return json_last_error() === JSON_ERROR_NONE;
    }

    function getGenderID($gender)
    {
        $gender = strtolower($gender);
        $gender_id = "0";
        if ($this->isNotEmpty($gender)) {
            if (substr($gender, 0, 1) == "m") {
                $gender_id = "1";
            } else if (substr($gender, 0, 1) == "f") {
                $gender_id = "2";
            }
        }
        return $gender_id;
    }

    function getFileIcon($extension)
    {

        //  $valid_ext_doc = array('pdf','doc','docx','txt','html','htm','ppt','pptx','xls','csv','xlsx'); 
        //             $valid_ext_img = array('png','jpeg','jpg'); 
        //             $valid_ext_vid = array('mp4','mkv','mov','avi','wmv');  

        switch ($extension) {
            case "jpg":
            case "jpeg":
            case "png":
                return "<i class='fa fa-file-image text-primary' aria-hidden='true'></i>";
                break;
            case "mp4":
            case "mkv":
            case "mov":
            case "avi":
            case "wmv":
                return "<i class='fa fa-play text-danger' aria-hidden='true'></i>";
                break;
            case "pdf":
                return "<i class='fa fa-file-pdf text-danger' aria-hidden='true'></i>";
                break;
            case "txt":
                return "<i class='fa fa-file-text' aria-hidden='true'></i>";
                break;
            case "doc":
            case "docx":
                return "<i class='fa fa-file-word text-primary ' aria-hidden='true'></i>";
                break;
            case "ppt":
            case "pptx":
                return "<i class='fa fa-file-powerpoint text-warning' aria-hidden='true'></i>";
                break;
            case "xls":
            case "csv":
            case "xlsx":
                return "<i class='fa fa-file-excel text-success' aria-hidden='true'></i>";
                break;
            default:
                return "<i class='fa fa-file text-info'></i>";
        }
    }
    function humanFileSize($size, $unit = "")
    {
        if ((!$unit && $size >= 1 << 30) || $unit == "GB")
            return number_format($size / (1 << 30), 2) . "GB";
        if ((!$unit && $size >= 1 << 20) || $unit == "MB")
            return number_format($size / (1 << 20), 2) . "MB";
        if ((!$unit && $size >= 1 << 10) || $unit == "KB")
            return number_format($size / (1 << 10), 2) . "KB";
        return number_format($size) . " bytes";
    }

    function isGetMethod($request)
    {
        if ($request != "GET") {
            return false;
        }
        return true;
    }

    function implodeQoutation(array $data)
    {
        if (count($data) <= 0) {
            return '';
        }
        return implode(",", array_map(array($this, 'quoteString'), $data));
    }

    function quoteString($string)
    {
        return sprintf("'%s'", $string);
    }

    function isNotEmpty($data)
    {
        return preg_match('/\S/', $data);
    }

    function convert_sql_date($data, $current_format)
    {
        if ($current_format == 'mm/dd/yyyy') {
            $parts = explode('/', $data);
            $yyyy_mm_dd = $parts[2] . '-' . $parts[0] . '-' . $parts[1];
            return $yyyy_mm_dd;
        } else if ($current_format == 'dd/mm/yyyy') {
            $date = str_replace('/', '-', $data);
            return date('Y-m-d', strtotime($date));
        } else {
            return "";
        }
    }

    function alphaNumericOnly($s)
    {
        return preg_replace("/[^a-zA-Z0-9]+/", "", $s);
    }

    function fix_date($data, $format, $utility)
    {
        if ($utility->isNotEmpty($data)) {
            $fix_date = "";
            if (count(explode("/", $data)) == 3) {
                $fix_date = $data;
            } else {
                if ($utility->isNotEmpty(strtotime($data))) {
                    $fix_date = date("m/d/Y", strtotime($data)); //aha word date
                }
            }

            if ($utility->isNotEmpty($fix_date)) {
                // 01/23/2020 false
                // 23/01/2020 true

                $array_date = explode("/", explode(" ", $fix_date)[0]);
                if ($format) { //if format == true swap index 0 and 1  
                    $return_date = $array_date[2] . '-' . $array_date[1] . '-' . $array_date[0];
                } else {
                    $return_date = $array_date[2] . '-' . $array_date[0] . '-' . $array_date[1];
                }
                $return_date =  date("Y-m-d", strtotime($return_date));
                if ($this->validateDate($return_date)) {
                    return $return_date;
                }
            }
        }
        return "";
    }


    function upperCaseNestedArray($value)
    {
        if (is_array($value)) {
            return array_map(array($this, 'upperCaseNestedArray'), $value);
        }
        return trim(mb_strtoupper($value));
    }

    //  function removeEmptyValueArray($value) {  
    //     if (is_array($value)) {
    //         return array_map(array($this, 'removeEmptyValueArray'), $value);
    //     }
    //     if($this->isNotEmpty()){

    //     }
    //     return trim(strtoupper($value));
    // }


    function lowerCaseNestedArray($value)
    {
        if (is_array($value)) {
            return array_map(array($this, 'lowerCaseNestedArray'), $value);
        }
        return trim(strtolower($value));
    }

    function convert_sql_date_to_date_picker($value)
    {
        if (trim($value) == '') {
            return '';
        }
        return date("m/d/Y", strtotime($value));
    }

    function fix_mobile_format($data)
    {
        if (strlen($data) < 5) {
            return "";
        }
        $final_data = "";
        //if area code equal to 639xx it will change to 09xxxxxxxxx
        if (substr($data, 0, 2) === "09") {
            $final_data = "+639" . substr($data, 2, strlen($data));
        } else if (substr($data, 0, 3) === "639") {
            $final_data = "+639" . substr($data, 3, strlen($data));
        } else if (substr($data, 0, 1) === "9" && strlen($data) == 10) {
            $final_data = "+639" . substr($data, 1, strlen($data));
        } else {
            $final_data = $data;
        }

        //if number start with 09xxx, check the length, if length is not 11 return blank, if not 09xxx return it
        if (substr($final_data, 0, 4) === "+639") {
            if (strlen($final_data) == 13) {
                return $final_data;
            } else {
                return (strlen($final_data) > 13) ? substr($final_data, 0, 13) : $final_data;
            }
        }
        return $final_data;
    }

    function fix_mobile_format_v2($data)
    {
        if (strlen($data) < 5) {
            return "";
        }
        $final_data = "";
        //if area code equal to 639xx it will change to 09xxxxxxxxx
        if (substr($data, 0, 2) === "09") {
            $final_data = "9" . substr($data, 2, strlen($data));
        } else if (substr($data, 0, 3) === "639") {
            $final_data = "9" . substr($data, 3, strlen($data));
        } else if (substr($data, 0, 1) === "9" && strlen($data) == 10) {
            $final_data = "9" . substr($data, 1, strlen($data));
        } else {
            $final_data = $data;
        }

        //if number start with 09xxx, check the length, if length is not 11 return blank, if not 09xxx return it
        if (substr($final_data, 0, 1) === "9") {
            if (strlen($final_data) == 10) {
                return $final_data;
            } else {
                return (strlen($final_data) > 10) ? substr($final_data, 0, 10) : $final_data;
            }
        }
        return '';
    }

    function remove_non_numeric($data)
    {
        return preg_replace("/[^0-9]/", "", $data);
    }

    function cleanStr($string)
    {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }

    function mask($str, $first, $last)
    {
        $str = $this->cleanStr($str);
        $len = strlen($str);
        $toShow = $first + $last;
        return substr($str, 0, $len <= $toShow ? 0 : $first) . str_repeat("*", $len - ($len <= $toShow ? 0 : $toShow)) . substr($str, $len - $last, $len <= $toShow ? 0 : $last);
    }

    function mask_email($email)
    {
        if (!$this->isNotEmpty($email)) {
            return "";
        }
        $mail_parts = explode("@", $email);
        $domain_parts = explode('.', $mail_parts[1]);

        $mail_parts[0] = $this->mask($mail_parts[0], 2, 1); // show first 2 letters and last 1 letter

        $mail_parts[1] = implode('.', $domain_parts);

        return implode("@", $mail_parts);
    }

    function make_thumb($src, $dest, $desired_width)
    {

        /* read the source image */

        $imgInfo = getimagesize($src);
        $mime = $imgInfo['mime'];

        // Create a new image from file 
        switch ($mime) {
            case 'image/jpeg':
                $source_image = imagecreatefromjpeg($src);
                break;
            case 'image/png':
                $source_image = imagecreatefrompng($src);
                break;
            case 'image/gif':
                $source_image = imagecreatefromgif($src);
                break;
            default:
                $source_image = imagecreatefromjpeg($src);
        }

        $width = imagesx($source_image);
        $height = imagesy($source_image);

        /* find the "desired height" of this thumbnail, relative to the desired width  */
        $desired_height = floor($height * ($desired_width / $width));

        /* create a new, "virtual" image */
        $virtual_image = imagecreatetruecolor($desired_width, $desired_height);

        /* copy source image at a resized size */
        imagecopyresampled($virtual_image, $source_image, 0, 0, 0, 0, $desired_width, $desired_height, $width, $height);

        /* create the physical thumbnail image to its destination */
        switch ($mime) {
            case 'image/jpeg':
                imagejpeg($virtual_image, $dest);
                break;
            case 'image/png':
                imagepng($virtual_image, $dest);
                break;
            case 'image/gif':
                imagegif($virtual_image, $dest);
                break;
            default:
                imagejpeg($virtual_image, $dest);
        }
    }

    function curl_me($url, $params, $method, $headers = "[]")
    {
        $method = strtoupper($method);
        $ch = curl_init();

        $headers = json_decode($headers, true);

        switch ($method) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
                break;
            case 'GET':
                break;
            default:
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        if (count($headers) > 0) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }


        $server_output = curl_exec($ch);
        curl_close($ch);
        return $server_output;
    }

    function curl_me_async($url, $params, $method)
    {
        $method = strtoupper($method);
        $ch = curl_init();

        switch ($method) {
            case 'POST':
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
                break;
            case 'GET':
                break;
            default:
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_TIMEOUT_MS, 500);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        $server_output = curl_exec($ch);
        curl_close($ch);
        return $server_output;
    }

    function validateDate($date, $format = 'Y-m-d')
    {
        $d = DateTime::createFromFormat($format, $date);

        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }

    function arrayNullToBlank($array)
    {
        foreach ($array as $key => $value) {
            if (is_null($value)) {
                $array[$key] = "";
            }
        }

        return $array;
    }


    function stringStartsWith($haystack, $needle, $case = true)
    {
        if ($case) {
            return strpos($haystack, $needle, 0) === 0;
        }
        return stripos($haystack, $needle, 0) === 0;
    }

    function stringEndsWith($haystack, $needle, $case = true)
    {
        $expectedPosition = strlen($haystack) - strlen($needle);
        if ($case) {
            return strrpos($haystack, $needle, 0) === $expectedPosition;
        }
        return strripos($haystack, $needle, 0) === $expectedPosition;
    }

    function encrypt($value)
    {
        //secured params 
        //*domain as key
        //*url as token paramter 
        //*unique encrypted id e.g.: userid 2 
        //*unique token given by source

        $plaintext = $value;
        $password = $_SERVER['HTTP_HOST']; //domain
        $method = 'aes-256-cbc';

        $key = password_hash($password, PASSWORD_BCRYPT, ['cost' => 12]);
        // echo "Key:" . $key . "<br>";

        // IV must be exact 16 chars (128 bit)
        $iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);

        // av3DYGLkwBsErphcyYp+imUW4QKs19hUnFyyYcXwURU=
        $encrypted = base64_encode(openssl_encrypt($plaintext, $method, $key, OPENSSL_RAW_DATA, $iv));

        if (!$encrypted) {
            $arr['key'] = null;
            $arr['value'] = null;
            $arr['status'] = 0;
            $arr['message'] = "Error has occured, check your character encoding.";
            return json_encode($arr);
        }
        $arr['key'] = bin2hex($key);
        $arr['value'] = bin2hex($encrypted);
        $arr['message'] = "Successfully encrypted.";
        $arr['status'] = 1;

        return json_encode($arr);
    }

    function decrypt($key, $value)
    {
        //secured params 
        //*domain as key
        //*url as token paramter 
        //*unique encrypted id e.g.: userid 2 
        //*unique token given by source

        $plaintext = $value;
        $password = $_SERVER['HTTP_HOST']; //domain
        $method = 'aes-256-cbc';

        $key = hex2bin($key);
        // echo "Key:" . $key . "<br>";

        // IV must be exact 16 chars (128 bit)
        $iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);

        // av3DYGLkwBsErphcyYp+imUW4QKs19hUnFyyYcXwURU=
        $encrypted = hex2bin($value); //base64_encode(openssl_encrypt($plaintext, $method, $key, OPENSSL_RAW_DATA, $iv));

        // My secret message 1234
        $decrypted = openssl_decrypt(base64_decode($encrypted), $method, $key, OPENSSL_RAW_DATA, $iv);

        // $arr['key'] = bin2hex($key);
        if (!$decrypted) {
            $arr['value'] = null;
            $arr['status'] = 0;
            $arr['message'] = "Error has occured, check your key.";
            return json_encode($arr);
        }

        $arr['value'] = $decrypted;
        $arr['message'] = "Successfully decrypted.";
        $arr['status'] = 1;

        return json_encode($arr);
    }
}
