<?php
/**
 * use CRUD for class naming
 * example: create_ and read_and update_ and delete_
 */

    class Upload{

        function create_attachment($file,$target_dir,$utility_class,$db){ 
 
            if($utility_class->isNotEmpty($file['name'])){
                // $target_dir = dirname(__FILE__) . '../../../dist/attachments';
                // Create Dir 
                if (!file_exists($target_dir)) {
                    mkdir($target_dir, 0777, true);
                }

                // Getting file name
                $filename = $file['name'];
                $filesize = $file['size'];
                $gen_filename = $db->select('SELECT UUID()');

                // file extension
                $file_extension = pathinfo($filename, PATHINFO_EXTENSION);
                $file_extension = strtolower($file_extension);

                //Valid extension
                $valid_ext_doc = array('pdf','doc','docx','txt','html','htm','ppt','pptx','xls','csv','xlsx'); 
                $valid_ext_img = array('png','jpeg','jpg'); 
                $valid_ext_vid = array('mp4','mkv','mov','avi','wmv');  


                if(in_array($file_extension,$valid_ext_doc)){
                    switch($file_extension){
                        case 'pdf':
                            $location = $target_dir."/".$gen_filename;
                        break;
                        default:   
                            $location = $target_dir."/".$gen_filename.".".$file_extension;
                    }
                    
                    $maxsize = 9097152;  
                    $minsize = 300000;
                    if (move_uploaded_file($_FILES["file"]["tmp_name"], $location)) {
                        $return_arr["status"]=1; 
                        $return_arr["change_name"]= $gen_filename.".".$file_extension;
                        $return_arr["orig_name"]= $filename;
                        $return_arr["message"]=" File Uploaded.";
                    } else {
                        $return_arr["status"]=0; 
                        $return_arr["orig_name"]= $filename;
                        $return_arr["message"]=" File Not Uploaded.";
                    }
                }else if(in_array($file_extension,$valid_ext_img)){
                    // $location = $target_dir."/".$gen_filename.".".$file_extension;
                    $location = $target_dir."/".$gen_filename;
                    $maxsize = 9097152;  
                    $minsize = 300000;

                    if($filesize >= $maxsize  || $filesize == 0 ){
                        $return_arr["status"]=0;
                        $return_arr["orig_name"]= $filename;
                        $return_arr["message"]=" File file too large. File must less than ".round(($maxsize/1000000), 0)." megabytes.";
                        echo json_encode($return_arr);
                        return;
                    }

                    if($filesize >= $minsize ){
                            $quality = 60;
                                if($filesize >= $maxsize/2){
                                    $quality = 30;
                                }
                    }else{ 
                        $quality = 60;  
                    }

                    // Compress Image
                    $this->compressImage($file['tmp_name'],$location,$quality); 
                    $return_arr["status"]=1; 
                    $return_arr["change_name"] = $gen_filename.".".$file_extension;
                    $return_arr["orig_name"]= $filename;
                    $return_arr["message"]=" Image Uploaded.";

                }else if(in_array($file_extension,$valid_ext_vid)){
                    $location = $target_dir."/".$gen_filename.".".$file_extension;
                    $maxsize = 9097152;  
                    $minsize = 300000;
                    if (move_uploaded_file($_FILES["file"]["tmp_name"], $location)) {
                        $return_arr["status"]=1; 
                        $return_arr["change_name"] = $gen_filename.".".$file_extension;
                        $return_arr["orig_name"]= $filename;
                        $return_arr["message"]=" File Uploaded.";
                    } else {
                        $return_arr["status"]=0; 
                        $return_arr["orig_name"]= $filename;
                        $return_arr["message"]=" File Not Uploaded.";
                    }
                }else{
                    $return_arr["status"]=0; 
                    $return_arr["orig_name"]= $filename;
                    $return_arr["message"]=" Invalid file type.";
                }
            }else{
                $return_arr["status"]=0; 
                $return_arr["message"]=" Error has occured.";
            }

            // echo json_encode($return_arr); 
            return $return_arr;
        }

        function compressImage($source, $destination, $quality) {
            // Get image info 
            $imgInfo = getimagesize($source); 
            $mime = $imgInfo['mime']; 
            
            // Create a new image from file 
            switch($mime){ 
                case 'image/jpeg': 
                    $image = imagecreatefromjpeg($source); 
                    break; 
                case 'image/png': 
                    $image = imagecreatefrompng($source); 
                    break; 
                case 'image/gif': 
                    $image = imagecreatefromgif($source); 
                    break; 
                default: 
                    $image = imagecreatefromjpeg($source); 
            } 
            
            // Save image 
            imagejpeg($image, $destination, $quality); 
            
            // Return compressed image 
            return $destination; 
        }

        function delete_attachment($files,$target_dir){
            // $target_dir = dirname(__FILE__) . '../../../dist/attachments/';
            foreach($files as $file){ 
                echo $file['change_name']."\n<br>";
                unlink($target_dir.$file['change_name']);
            }
        }
        

    }
?>