<?php   
include_once dirname(__FILE__) . '/../../../cfg/db_api.php';

// echo $db->select("SELECT REPLACE(UUID(), '-', '')");exit; //gen key

include_once dirname(__FILE__) . '/../../../app/classes/user_class.php'; 
include_once dirname(__FILE__) . '/../../../app/classes/ticket_class.php'; 
include_once dirname(__FILE__) . '/../../../app/classes/company_class.php'; 
include_once dirname(__FILE__) . '/../../../app/classes/brand_class.php'; 
include_once dirname(__FILE__) . '/../../../app/classes/utility.php';  

$user_class = new User(); 
$company_class = new Company(); 
$ticket_class = new Ticket(); 
$brand_class = new Brand(); 
$utility_class = new Utility();

$server_method = $_SERVER["REQUEST_METHOD"];
 
if(isset($_REQUEST['key']) ){
    $function_name = $db->escape($_REQUEST['key']); 
    $parameters = array(
        'db'=>$db,
        'user_class'=>$user_class,
        'ticket_class'=>$ticket_class,
        'company_class'=>$company_class,
        'utility_class'=>$utility_class,
        'brand_class'=>$brand_class,
        'server_method'=>$server_method, 
        // 'user'=>$session_user,
        'global_system_settings'=>$global_system_settings,
        'user_session'=>$session_user,
        'request'=>$_REQUEST,
    );
    call_user_func($function_name,$parameters);
}else{ 
    echo "Invalid request.";
    exit;
}

// function signup($param){
//     if($param['server_method'] !== 'POST'){
//         echo "Invalid request.";
//         exit;
//     } 
//     $request = $param['request'];
//     $db = $param['db'];
//     $array_data = json_decode($request['json_data'],true);
//     foreach ($array_data as $key => $value){
//         if($key != 'password'){
//             $array_data[$key] = trim(mb_strtoupper($array_data[$key]));
//             $array_data[$key] = $param['db']->escape($array_data[$key]);
//         }
//     }
 
//     //check dup id no.
//     $id_no_count = $param['user_class']->read_id_number_count($array_data['id_no'],$param['utility_class'],$db);
//     if(intval($id_no_count) > 0){
//         $return_arr['message'] = "ID number already exist.";
//         $return_arr['status'] = 0;
//         echo json_encode($return_arr);
//         exit;
//     }

//     $email_count = $param['user_class']->read_email_count($array_data['email'],$param['utility_class'],$db);
//     if(intval($email_count) > 0){
//         $return_arr['message'] = "Email address already exist.";
//         $return_arr['status'] = 0;
//         echo json_encode($return_arr);
//         exit;
//     }

//     $mobile_count = $param['user_class']->read_mobile_count($array_data['mobile'],$param['utility_class'],$db);
//     if(intval($mobile_count) > 0){
//         $return_arr['message'] = "Mobile number already exist.";
//         $return_arr['status'] = 0;
//         echo json_encode($return_arr);
//         exit;
//     }
 
//     if($param['user_class']->insert_user_details($array_data,$param['utility_class'],$db) === 2){
//         $return_arr['message'] = "Account successfully created.";
//         $return_arr['status'] = 1;
//         echo json_encode($return_arr);
//         exit;
//     }else{
//         $return_arr['message'] = "Account not created. Try again.";
//         $return_arr['status'] = 0;
//         echo json_encode($return_arr);
//         exit; 
//     }
 
// } 

function read_role_list($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $request = $param['request']; 
    $user_session = $param['user_session'];
    $user_class = $param['user_class'];
     
    // print_r($request);exit;

    $search = $db->escape($request['search']);
    $offset = $request['offset'];
    $limit = $request['limit'];

    $role_list_array = $user_class->read_role_list($user_session['id'],
                                                        $search,
                                                        $offset,
                                                        $limit,
                                                        $utility_class,$db);

    $json_arr['total'] = $role_list_array[0];
    $role_list_obj = $role_list_array[1];
    
    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($role_list_obj as $row){
        $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'name'=>$row['name'],
                'user_category'=>$row['user_category'],
                'json_access'=>$row['json_access'],
                'json_dealer'=>$row['json_dealer'],
                'json_brand'=>$row['json_brand'],
                'user_count'=>intval($row['user_count']),
            ))
        );
    }

    echo json_encode($json_arr);
}



function read_role_brand_list($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $request = $param['request']; 
    $user_session = $param['user_session'];
    $user_class = $param['user_class'];
     
    // print_r($request);exit;

    $search = $db->escape($request['search']);
    $offset = $request['offset'];
    $limit = $request['limit'];
    
    $selected_brands_arr = json_decode($request['selected_brands'],true); 

    $role_list_array = $user_class->read_role_brand_list($user_session['id'],
                                                        $search,
                                                        $offset,
                                                        $limit,
                                                        $utility_class,$db);

    $json_arr['total'] = $role_list_array[0];
    $role_list_obj = $role_list_array[1];
    
    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($role_list_obj as $row){
        $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'name'=>$row['name'],
                'status'=>(in_array($row['id'],$selected_brands_arr) ? 1 : 0 ),
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_position_list($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $request = $param['request']; 
    $user_session = $param['user_session'];
    $user_class = $param['user_class'];
     
    // print_r($request);exit;

    $search = $db->escape($request['search']);
    $offset = $request['offset'];
    $limit = $request['limit'];
    
    $selected_positions_arr = json_decode($request['selected_positions'],true); 

    $role_list_array = $user_class->read_position_list($user_session['id'],
                                                        $search,
                                                        $offset,
                                                        $limit,
                                                        $utility_class,$db);

    $json_arr['total'] = $role_list_array[0];
    $role_list_obj = $role_list_array[1];
    
    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($role_list_obj as $row){
        $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'name'=>$row['name'],
                'status'=>(in_array($row['id'],$selected_positions_arr) ? 1 : 0 ),
            ))
        );
    }

    echo json_encode($json_arr);
}

 

    function remove_role($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $role_id = $request['id'];

        if($user_class->remove_role($role_id,$utility_class,$db) === 1){
                $return_arr['message'] = "Successfully removed.";
                $return_arr['status'] = 1;
                echo json_encode($return_arr);
                exit; 
        }else{
                $return_arr['message'] = "Not removed. Try again.";
                $return_arr['status'] = 0;
                echo json_encode($return_arr);
                exit; 
        }
    }

function create_role($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $brand_class = $param['brand_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $is_new_role = $request['is_new_role'];
    $role_data = $request['role_data'];
    $brand_data = $request['brand_data'];
    $brand_data_arr = json_decode($brand_data,true); 
    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }
    $json_dealer = ""; 

 $role_id = $request['role_id'];

 $role_info_obj = $user_class->read_role_information($role_id,$utility_class,$db); 
 $role_info_arr = array();
 foreach ($role_info_obj as $role_info_row){
    $role_info_arr = $role_info_row;
 }
 
 //secure the admin role
 if(!$is_new_role){
    $admin_role_id = 13;
    if(intval($_SESSION['cc_user']['role_id']) != $admin_role_id && $role_id == $admin_role_id){
        $return_arr['message'] = "Only admin can modify this role."; 
        $return_arr['status'] = 0;
        echo json_encode($return_arr);
        exit;
    }
 }


 if((isset($role_info_arr['name']) && $role_info_arr['name'] != $array_data['txt_role_name']) || $is_new_role){
      // check if duplicate role name
    $role_count = $user_class->read_role_count_by_name($array_data['txt_role_name'],$utility_class,$db); 
    if(intval($role_count) > 0){
            $return_arr['message'] = "Role name already exist."; 
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
    }
 }

   // clean unknown or status 0  brand ids 
    // read every brand id if still active
    // $brand_data = 
 $brand_ids_obj = $brand_class->read_brand_ids($db); 
 $brand_ids_arr = array();
 foreach($brand_ids_obj as $brand_ids_row){
    $brand_ids_arr[] = $brand_ids_row['id'];
 }

 $valid_brand_data = array();
 foreach($brand_data_arr as $brand_data_row){
    if(in_array($brand_data_row,$brand_ids_arr)){
        $valid_brand_data[] = $brand_data_row;
    }
 }
if(count($valid_brand_data) <= 0){
    $brand_data_to_insert= "";
}else{
    $brand_data_to_insert = json_encode($valid_brand_data);
}

    $category_id = $user_class->read_category_id_by_name($array_data['dd_user_type'],$utility_class,$db); 
    if(intval($is_new_role)){
        $role_id = $user_class->create_role($user_session['id'],$array_data['txt_role_name'],$utility_class,$db);
        $user_class->create_role_access($role_id,$role_data,$brand_data_to_insert,$json_dealer,$category_id,$utility_class,$db);
    }else{
         $user_class->update_role($user_session['id'], $role_id,$array_data['txt_role_name'],$utility_class,$db);
         $user_class->update_role_access($role_id,$role_data,$brand_data_to_insert,$json_dealer,$category_id,$utility_class,$db);
    }
if(intval($is_new_role)){
    $return_arr['message'] = "Role has been created.";
}else{
     $return_arr['message'] = "Role has been updated.";
}
    $return_arr['id'] = $role_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);
}


function read_user_categories($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ;
    $category_list_obj = $user_class->read_user_categories($search,$utility_class,$db);

    $json = [];
    foreach($category_list_obj as $row){ 
          $json[] = ['id'=>$row['name'], 'text'=>$row['name']];
    }

    echo json_encode($json);
}

function read_sms_apis($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ;
    $category_list_obj = $user_class->read_sms_apis($search,$utility_class,$db);

    $json = [];
    foreach($category_list_obj as $row){ 
          $json[] = ['id'=>$row['id'], 'text'=>$row['name'], 'activated'=>$row['is_activated']];
    }

    echo json_encode($json);
}

function read_system_config($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request']; 
    $obj = $user_class->read_system_config($utility_class,$db);

    $arr = array();
    foreach($obj as $row){ 
          $arr = array_merge($arr,array(array(
            'id'=> $row['id'],
            'name'=> $row['name'],
            'value'=> $row['value'],
          )));
    }

    echo json_encode($arr);
}



function read_sms_templates($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request']; 
    $obj = $user_class->read_sms_templates($utility_class,$db);

    $arr = array();
    foreach($obj as $row){ 
         $row = $utility_class->arrayNullToBlank($row);
          $arr = array_merge($arr,array(array(
            'id'=> $row['id'],
            'name'=> $row['name'],
            'description'=> $row['description'],
            'type'=> $row['type'],
          )));
    }

    echo json_encode($arr);
}


function read_notification_template($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request']; 
    $obj = $user_class->read_notification_template($utility_class,$db);

    $arr = array();
    foreach($obj as $row){
         $row = $utility_class->arrayNullToBlank($row);
          $arr = array_merge($arr,array(array(
            'id'=> $row['id'],
            'name'=> $row['name'],
            'description'=> $row['description'],
            'is_active'=> $row['is_active'],
            'type'=> $row['type'],
          ))
        );
    }

    echo json_encode($arr);
}

function read_notification_reminder($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $obj = $user_class->read_notification_reminder($utility_class,$db);

    $arr = array();
    foreach($obj as $row){
         $row = $utility_class->arrayNullToBlank($row); 
          $arr = array_merge($arr,array(array(
            'id'=> $row['id'],
            'type'=> $row['type'],
            'minutes'=> $row['minutes'],
            'hours'=> $row['hours'],
            'days'=> $row['days'],
          ))
        );
    }

    echo json_encode($arr);
}



function update_system_config($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request']; 

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }

    $obj = $user_class->update_system_config($array_data,$utility_class,$db);

      $return_arr['message'] = "Update successful...";
        $return_arr['status'] = 1;
        echo json_encode($return_arr);

}

function update_sms_config($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
     $user_class = $param['user_class'];
    $request = $param['request']; 

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }

    // print_r($array_data);exit;
    $sms_api_id = $array_data['api'];
    $user_class->update_all_sms_config_api_status(0,$utility_class,$db);
    if($utility_class->isNotEmpty($sms_api_id)){
        $user_class->update_sms_config_api_status($sms_api_id,1,$utility_class,$db);
    }
    
    // $obj = $user_class->update_sms_config($array_data,$utility_class,$db);
    // update templates
    foreach($array_data as $key => $value){
       if($utility_class->stringStartsWith($key,'t_')){ 
           $template_id = substr($key,2,strlen($key) );   
            $user_class->update_sms_config_template($template_id,$value,$utility_class,$db);
       } 
    }
    // if(){

    // }

      $return_arr['message'] = "Update successful...";
        $return_arr['status'] = 1;
        echo json_encode($return_arr);

}

function update_notification_template($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 

    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }

    $array_data_reminder = json_decode($request['json_data_reminder'],true);
    foreach ($array_data_reminder as $key1 => $value1){   
                $array_data_reminder[$key1] = $db->escape($array_data_reminder[$key1]); 
    }
 
 
    	
    
    // $obj = $user_class->update_sms_config($array_data,$utility_class,$db);
    // update templates
    foreach($array_data as $key => $value){
       if($utility_class->stringStartsWith($key,'t_')){ 
           $template_id = substr($key,2,strlen($key) );
            $template_obj = $user_class->read_notification_by_id($template_id,$db);
            $template_arr = array();
            foreach($template_obj as $template_row){
                $template_arr = $template_row;
            }
            
            $name = $array_data['ttitle_'.$template_id];
            $is_active = $array_data['status_'.$template_id]; 
            
            if(count($template_arr) > 0){
                $user_class->update_notification_template($template_id,$name,$value,$is_active,$utility_class,$db);
            }else{
                $user_class->insert_notification_template($template_id,$name,$value,$is_active,$utility_class,$db);
            }
           
       } 
    }
  
   $reminder_data = array();
    foreach($array_data_reminder as $key => $value){ 
        $reminder_type = substr($key,9,strlen($key) ); 
        $reminder_minutes = abs(intval($value['reminder_min_'.$reminder_type]));
        $reminder_hours = abs(intval($value['reminder_hr_'.$reminder_type]));
        $reminder_days = abs(intval($value['reminder_day_'.$reminder_type]));
        $reminder_data[] =  "('$reminder_type', '$reminder_minutes','$reminder_hours','$reminder_days')";
    }

     $user_class->update_reminder_times($reminder_data,$utility_class,$db);

      $return_arr['message'] = "Update successful...";
        $return_arr['status'] = 1;
        echo json_encode($return_arr);

}

function signin($param){
    if($param['server_method'] !== 'POST'){
        echo "Invalid request.";
        exit;
    } 
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $array_data = json_decode($param['request']['json_data'],true);
    $username = $db->escape($array_data['username']);
    
    $where_statement = " AND (uc.email = '".$array_data['username']."' OR ua.username = '".$array_data['username']."') ";

    $result_arr = $param['user_class'] -> system_user_security($where_statement,$array_data,'login',$utility_class,$db);
      echo json_encode($result_arr); 
 
}

function signin_api_asa($param){
    // echo "sds";exit;
    if($param['server_method'] !== 'POST'){
        echo "Invalid request.";
        exit;
    } 

    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $company_class = $param['company_class'];
    $request = $param['request']; 
    $user_id = "";
  
if(isset($request['json_data'])){
    $array_data = json_decode($request['json_data'],true);
    foreach ($array_data as $key => $value){   
                $array_data[$key] = $db->escape($array_data[$key]); 
    }
    $username = $array_data['username'];
    $password = $array_data['password'];
     $user_info_json = $utility_class -> curl_me(   
    "https://autohub.ph/connect/api/v1/users/users.php",
    array('key'=>'5463358374534','username'=>$username,'password'=>$password),
    'POST');
}else if(isset($request['asa_id'])){
      $user_info_json = $utility_class -> curl_me(   
    "https://autohub.ph/connect/api/v1/users/users.php",
    array('key'=>'54633343444223','id'=>$request['asa_id']),
    'POST');
}else{
    $return_arr['message'] = "Error.";
            $return_arr['status'] = 0;
            echo json_encode($return_arr); 
    exit;
}
    

    $user_info_arr = json_decode($user_info_json,true);
    if($user_info_arr['api_status'] == 1){

        // Process Company
        // insert/update company 
        $company_source_id = $user_info_arr['company_id'];
        $company_name = $user_info_arr['company'];
        $company_code = $user_info_arr['company_code'];
        $company_obj = $company_class->read_company_by_source_id($company_source_id,$utility_class,$db);
        $company_arr= array();
        foreach($company_obj as $company_obj_row){
            $company_arr = $company_obj_row;
        }
        if(count($company_arr) > 0){
            // update
            $company_id = $company_arr['id'];
            $company_class->update_company($company_id,$user_id,$company_source_id,$company_name,$company_code,$utility_class,$db);
        }else{
            // insert and get system id
            $company_id =  $company_class->create_company($user_id,$company_source_id,$company_name,$company_code,$utility_class,$db);
        }

          // insert update dealer 
        $dealer_source_id = $user_info_arr['dealer_id'];
        $dealer_name = $user_info_arr['dealer'];
        $dealer_code = $user_info_arr['dealer_code'];
        $dealer_obj = $company_class->read_dealer_by_source_id($dealer_source_id,$utility_class,$db);
        $dealer_arr= array();
        foreach($dealer_obj as $dealer_obj_row){
            $dealer_arr = $dealer_obj_row;
        }
        if(count($dealer_arr) > 0){
            // update
            $dealer_id = $dealer_arr['id'];
            $company_class->update_dealer($company_id,$dealer_id,$user_id,$dealer_source_id,$dealer_name,$dealer_code,$utility_class,$db);
        }else{
            // insert and get system id
            $dealer_id =  $company_class->create_dealer($user_id,$company_id,$dealer_source_id,$dealer_name,$dealer_code,$utility_class,$db);
        }

        // insert update position  
        $position_name = $user_info_arr['u_position'];
        $position_obj = $user_class->read_user_position_by_name($position_name,$utility_class,$db);
        $position_arr= array();
        foreach($position_obj as $position_obj_row){
            $position_arr = $position_obj_row;
        }
        if(count($position_arr) > 0){
            // update
            $position_id = $position_arr['id'];
            $user_class->update_user_position($user_id,$position_id,$position_name,'','',$utility_class,$db); 
        }else{
            // insert and get system id
            $position_id =  $user_class->create_user_position($user_id,$position_name,'','',$utility_class,$db);
        }

        $user_source_id = $user_info_arr['u_id'];
        $user_obj = $user_class->read_user_by_source_id($user_source_id,$utility_class,$db);
        $user_arr= array();
        foreach($user_obj as $user_obj_row){
            $user_arr = $user_obj_row;
        } 

        $id_number = $user_info_arr['employee_id']; 
        $firstname = $user_info_arr['u_fname'];
        $middlename = $user_info_arr['u_mname'];
        $lastname = $user_info_arr['u_lname']; 

        $mobile = $utility_class->fix_mobile_format_v2($user_info_arr['usr_mobile']);
        $email = ($utility_class->isValidEmail($user_info_arr['email']) ? $user_info_arr['email'] : '' ); 

        $username = $user_info_arr['u_name']; 
        $password =  password_hash($user_info_arr['u_password'], PASSWORD_DEFAULT);
 

 
        $user_source = 2;
        if(count($user_arr) > 0){
            // update
            $user_id = $user_arr['id'];
            $user_class->update_user_api($user_id,$user_source_id,$user_source,$id_number,$position_id,$dealer_id,$firstname,$middlename,$lastname,$utility_class,$db);
            $user_class->update_user_contact_api($user_id,$mobile,$email,$utility_class,$db);
            $user_class->update_user_account_api($user_id,$username,$password,$utility_class,$db);
            // $user_class->update_user($user_id,$user_id,$user_source_id,$user_name,$user_code,$utility_class,$db);
            // $user_class->update_user_contact($utility_class,$db);
            // $user_class->update_user_account($utility_class,$db);
        }else{
            // insert and get system id
            $user_id = $user_class->create_user_api($user_source_id,$user_source,$id_number,$position_id,$dealer_id,$firstname,$middlename,$lastname,$utility_class,$db);
            $user_class->create_user_contact_api($user_id,$mobile,$email,$utility_class,$db);
            $user_class->create_user_account_api($user_id,$username,$password,$utility_class,$db);
        }

         $where_statement = " AND (u.`id` = $user_id) ";
        //check user status
        $result_arr = $user_class->system_user_security($where_statement,array(),'main',$utility_class,$db); 
        //   $result_arr = $param['user_class'] -> system_user_security($where_statement,$array_data,'login',$utility_class,$db);

        // remove previous login token  
        $user_class->update_user_login_token_status($user_id,0,3,$utility_class,$db);
        //create login token for cache
        $token = $db->select('SELECT UUID()'); 
        $to_user_id = $user_id;
        $from_user_id = $user_id;
        $source_id = $user_id; 
        $user_class->create_user_login_token($to_user_id,$from_user_id,$source_id,$token,3,$utility_class,$db);
        
        //create cookie
        $cookie_name = "login_token";
        $cookie_value = $token;
        setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day

        // loggerr
        $log_data['user_id'] = $user_id;
        $log_data['description'] = 'User has login';
        //important
        $log_data['type'] = 1; //login
        $log_data['db'] = $db;
        $GLOBALS['logger_class']->log($log_data);

        echo json_encode($result_arr); 

          // insert update user
    }else{
        $return_arr['message'] = "Login failed.";
            $return_arr['status'] = 0;
            echo json_encode($return_arr); 
    }   
  
 
}



function signout($param){
    if($param['server_method'] !== 'POST'){
        echo "Invalid request.";
        exit;
    } 
      if(isset($_SESSION['cc_user'])){
        session_destroy();
      }else{
          echo "No Session Found.";
      }
}

function user_login_info($param){
    if($param['server_method'] !== 'POST'){
        echo "Invalid request.";
        exit;
    } 
    // print_r($_SESSION['cc_user']);
    echo json_encode($_SESSION['cc_user']);
}

function user_notification_info($param){ 
    if($param['server_method'] !== 'POST'){
        echo "Invalid request.";
        exit;
    } 
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class'];
    $user_id = $param['user_id']; 

    $notification_obj = $user_class->get_user_notification_info($user_id,$utility_class,$db);
    $notification_arr['data'] = array();
    $total_count = 0;
    foreach($notification_obj as $row){
        $total_count += intval($row['total']);

        $notification_arr['data'] = array_merge(   $notification_arr['data'],
        array(array(
            'id'=>$row['id'],
            'count'=>$row['total'],
            'type'=>$row['name'],
            'ago'=>$utility_class->time_elapsed_string($row['ago_time']),
        )));
    }
    
    $notification_arr['total'] = $total_count;
    // print_r($notification_arr);

    echo json_encode($notification_arr);
}


function read_user_notification($param){
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class']; 
    $user_session = $param['user_session'];
    $user_id = $user_session['id']; 
    $request = $param['request']; 
    
    $offset = $request['offset'];
    $limit = $request['limit']; 

    $notification_list_arr = $user_class->read_user_notification($user_id,$offset,$limit,$utility_class,$db);
    
    $notification_arr['total'] = $notification_list_arr[0]; 
    $notification_obj = $notification_list_arr[1]; 

    $notification_arr['rows'] = array();
    foreach($notification_obj as $row){ 
        // print_r($row);
        $notification_formatted_description = read_notification_description($row['target_id'],$row['from_user_id'],$row['template_id'],$row['description'],$param);
        // echo $notification_formatted_description;
        $notification_arr['rows'] =  array_merge($notification_arr['rows'],
        array(array(
            'id'=>$row['id'],
            'target_id'=>$row['target_id'],
            'is_read'=>$row['is_read'],
            'from_user_id'=>$row['from_user_id'],
            'to_user_id'=>$row['to_user_id'],
            'notification_id'=>$row['id'],
            'notification_type'=>$row['template_id'],
            'type'=>$row['type'],
            'description'=>$notification_formatted_description,
            'ago'=>$utility_class->time_elapsed_string($row['date_added']),
        )));
    }

      echo json_encode($notification_arr);

}

function read_user_notification_count($param){
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class']; 
    $user_session = $param['user_session'];
    $user_id = $user_session['id']; 
    $request = $param['request']; 
 
    $notification_arr['total'] =  $user_class->read_user_notification_count($user_id,$utility_class,$db);

    echo json_encode($notification_arr);

}

 
function update_notification_status($param){
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class']; 
    $user_session = $param['user_session'];
    $user_id = $user_session['id']; 
    $request = $param['request']; 
    $to_user_id = $request['to_user_id'];
    $target_id = $request['target_id'];
     

    $user_class->update_notification_status($target_id,$to_user_id,1,$db);
  
  
}

function update_notification_status_close($param){
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class']; 
    $user_session = $param['user_session'];
    $user_id = $user_session['id']; 
    $request = $param['request'];  
    $target_id = $request['target_id'];
     
    $user_class->update_notification_status($target_id,$user_id,1,$db);
  
}

function read_roles($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $user_class = $param['user_class'];
    $request = $param['request'];
    $no_roles = isset($request['no_roles']) ? true : false ; 
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ; 

     //secure the admin role 
    $admin_role_id = 13;
    if(intval($_SESSION['cc_user']['role_id']) != $admin_role_id){
        $no_admin = " AND id NOT IN ($admin_role_id) ";
    }else{
        $no_admin = "";
    }

    $list_obj = $user_class->read_roles($search,$no_admin,$utility_class,$db);

    $json = [];
    if($no_roles){
        $json[] = ['id'=>'0', 'text'=>'No roles'];
    }
    foreach($list_obj as $row){ 
          $json[] = ['id'=>$row['name'], 'text'=>$row['name']];
    } 

    echo json_encode($json);
}

function read_notification_description($target_id,$from_user_id,$notification_type,$description,$param){
    $db = $param['db'];
    $user_class = $param['user_class'];
    $utility_class = $param['utility_class']; 
    $ticket_class = $param['ticket_class']; 

    switch(intval($notification_type)){
        case 1:
        case 3:
            // read ticket information
            $ticket_info_obj = $ticket_class->read_ticket_information($target_id,$utility_class,$db); 
            $arr_data = array();
            foreach($ticket_info_obj as $row){ 
                $row = $utility_class->arrayNullToBlank($row);
                $arr_data = $row;
            } 
               $display_name =  $arr_data['firstname'].' '.substr($arr_data['lastname'],0,1); 
                $display_name = ucwords(strtolower($display_name));
                $replace_parameter = array(
                    '<user>'=>$display_name,
                    '<ref_no>'=>$arr_data['reference_no'],
                    '<title>'=>$arr_data['title'],
                    '<description>'=>$arr_data['description'], //str_replace("\n"," ",$arr_data['description']),
                    '<category>'=>$arr_data['sub_category'],
                    '<priority>'=>$arr_data['priority_level'],
                    '<brand>'=>$arr_data['brand'],
                    '<model>'=>$arr_data['model'],
                    '<variant>'=>$arr_data['model_variant'],
                );
                return strtr($description,$replace_parameter);
        // break;

        case 2:
        case 4:
          // read ticket information
            $ticket_info_obj = $ticket_class->read_ticket_information($target_id,$utility_class,$db);
            $arr_data = array();
            foreach($ticket_info_obj as $row){ 
                $row = $utility_class->arrayNullToBlank($row);
                $arr_data = $row;
            }

            $user_info_obj = $user_class->read_user_information($from_user_id,$db);
            $user_data = array();
            foreach($user_info_obj as $user_row){ 
                $user_row = $utility_class->arrayNullToBlank($user_row);
                $user_data = $user_row;
            }

                $display_name =  $user_data['firstname']. ' '.substr($user_data['lastname'],0,1); 
                $display_name = ucwords(strtolower($display_name));
                $replace_parameter = array(
                    '<user>'=>$display_name,
                    '<ref_no>'=>$arr_data['reference_no'],
                    '<title>'=>$arr_data['title'],
                    '<description>'=>$arr_data['description'], //str_replace("\n"," ",$arr_data['description']),
                    '<category>'=>$arr_data['sub_category'],
                    '<priority>'=>$arr_data['priority_level'],
                    '<brand>'=>$arr_data['brand'],
                    '<model>'=>$arr_data['model'],
                    '<variant>'=>$arr_data['model_variant'],
                );
                return strtr($description,$replace_parameter);
        // break;
    }

}

function read_positions($param){ 
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $user_class = $param['user_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db -> escape($request['search']) : '' ; 
    $position_list_obj = $user_class->read_positions($search,$utility_class,$db);

    $json = [];
    foreach($position_list_obj as $row){ 
          $json[] = ['id'=>$row['name'], 'text'=>$row['name']];
    } 

    echo json_encode($json);
}

function update_user_role($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $user_session = $param['user_session']; 

    $user_id = intval($request['user_id']);
    $role_id  = $utility_class->isNotEmpty($request['role_id']) ? $user_class->read_role_id_by_name($request['role_id'],$utility_class,$db) : ''; 

    $user_class->update_user_role($user_id,$role_id,$db);

     $return_arr['message'] = "Success.";
            $return_arr['status'] = 1;
            echo json_encode($return_arr); 
}
function read_users_list($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $user_session = $param['user_session']; 
    
    $search = $db->escape($request['search']);
    $offset = $request['offset'];
    $limit = $request['limit'];
    
    if($request['filter_role'] == '0'){
        $filter_role_id = 0;
    }else{
        $filter_role_id  = $utility_class->isNotEmpty($request['filter_role']) ? $user_class->read_role_id_by_name($request['filter_role'],$utility_class,$db) : ''; 
    }

    //secure the admin role 
    $admin_role_id = 13;
    if(intval($user_session['role_id']) != $admin_role_id){
        $no_admin = " AND r.id NOT IN ($admin_role_id) ";
    }else{
        $no_admin = "";
    }  

    $user_list_array = $user_class->read_user_list($user_session['id'],
                                                        $filter_role_id,
                                                        $no_admin,
                                                        $search,
                                                        $offset,
                                                        $limit,
                                                        $utility_class,$db);

    $json_arr['total'] = $user_list_array[0];
    $user_list_obj = $user_list_array[1];
    
    $json_arr['rows'] = array();

    $counter = $request['offset'] + 1;

    foreach($user_list_obj as $row){
        $row = $utility_class->arrayNullToBlank($row);
         $json_arr['rows'] = array_merge($json_arr['rows'],
            array(array(
                'no'=>$counter++,
                'id'=>$row['id'],
                'name'=>$row['name'],
                'user_id'=>$row['id_number'],
                'mobile'=>'+63'.$row['mobile'],
                'email'=>$row['email'],
                'position'=>$row['position'],
                'role_id'=>$row['role_id'],
                'role'=>$row['role'],
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_viber_subscription($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $user_session = $param['user_session']; 

    $viber_obj = $user_class->read_viber_subscription($user_session['id'],$utility_class,$db);
    $viber_arr = array();
    foreach($viber_obj as $viber_row){
        $viber_arr = $viber_row;
    }

    $json_arr['status'] = count($viber_arr);
    $json_arr['user_id'] = $user_session['id'];
       echo json_encode($json_arr);
    
}

//web service for ticket information viewing
function b8b3f5864711eca0f900ff70631b9a55($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $global_system_settings = $param['global_system_settings'];

    if(!isset($request['asa_id'])){
        $json_arr['status'] = 0 ;
        $json_arr['message'] = 'ASA ID is required.';
        echo json_encode($json_arr);
        exit;
    }

    if(!isset($request['ticket_id'])){
            $json_arr['message'] = "Ticket ID is required.";
            $json_arr['status'] = 0;
            echo json_encode($json_arr);
            exit;
    }

    $asa_id  = $request['asa_id'];
    $user_obj  = $user_class->read_user_by_source_id($asa_id,$utility_class,$db);
    $user_arr = array();
    foreach($user_obj as $user_row){
        $user_arr = $user_row;
    }
 
    //for saving sessions using api
    // $where_statement = " AND (u.`id` = ".$user_arr['id'].") ";
    // $user_class->system_user_security($where_statement,array(),'main',$utility_class,$db); 
    
    $to_user_id = $user_arr['id'];
    $from_user_id = $user_arr['id'];
    $target_id = $request['ticket_id'];
    $type = 1; //ticket id
    $token = $db->select('SELECT UUID()'); 
    $user_class->create_user_login_token($to_user_id,$from_user_id,$target_id,$token,$type,$utility_class,$db);
                            
    $url_params = array(
        'token'=>$token,
        'type'=>$type,
        'id'=>$target_id, 
    );
    $append_link = $global_system_settings['url']."token.php"."?".http_build_query($url_params); 
    // $append_link = urlencode($append_link);


    // echo $append_link;
    $json_arr['status'] = 1;
    $json_arr['url'] = $append_link;
    echo json_encode($json_arr);

}

//web service for dashboard viewing
function bb8da4865711eca0f900ff70631b9a14($param){
    $db = $param['db'];
    $utility_class = $param['utility_class']; 
    $user_class = $param['user_class'];
    $request = $param['request']; 
    $global_system_settings = $param['global_system_settings'];

    if(!isset($request['asa_id'])){
        $json_arr['status'] = 0 ;
        $json_arr['message'] = 'ASA ID is required.';
        echo json_encode($json_arr);
        exit;
    }

    $asa_id  = $request['asa_id'];
    $user_obj  = $user_class->read_user_by_source_id($asa_id,$utility_class,$db);
    $user_arr = array();
    foreach($user_obj as $user_row){
        $user_arr = $user_row;
    }

    if(count($user_arr) <= 0){
        //create asa user 
          $asa_id_to_system = $utility_class -> curl_me(   
            $global_system_settings['url'].'app/models/user.php',
            array('model'=>'signin_api_asa','asa_id'=>$request['asa_id']),
            'POST');

            $asa_id_to_system_arr =  json_decode($asa_id_to_system,true);
            
            if(!intval($asa_id_to_system_arr['status'])){
                $json_arr['status'] = 0;
                $json_arr['message'] = "Token generation failed.";
                $json_arr['id'] = $request['asa_id'];
                echo json_encode($json_arr);
                exit;
            }
           
        $params['model'] = 'signin_api_asa';
        $params['asa_id'] = $request['asa_id'];
        $params['api'] = true; 
        $main_uri =  $global_system_settings['url'];
        $resp =  $utility_class -> curl_me(
        $main_uri.'app/models/user.php', 
        $params,
        'POST'); 
        $resp_arr = json_decode($resp,true);

       $user_arr['id'] = $resp_arr['id']; //sample data


    }
 
    $to_user_id = $user_arr['id'];
    $from_user_id = $user_arr['id'];
    $target_id = 0;
    $type = 5; // proceed to tasks
    $token = $db->select('SELECT UUID()'); 
    $user_class->create_user_login_token($to_user_id,$from_user_id,$target_id,$token,$type,$utility_class,$db);
                            
    $url_params = array(
        'token'=>$token,
        'type'=>$type,
        'id'=>$target_id, 
    );
    $append_link = $global_system_settings['url']."token.php"."?".http_build_query($url_params); 
    // $append_link = urlencode($append_link);


    // echo $append_link;
    $json_arr['status'] = 1;
    $json_arr['url'] = $append_link;
    echo json_encode($json_arr);

}
 
?>