<?php
// if(isset($_REQUEST['api'])){ 
//     include_once dirname(__FILE__) . '/../../../cfg/db_api.php'; 
// }else{ 
include_once dirname(__FILE__) . '/../../../cfg/db_api.php';
// if(!intval($global_user_status)){ 
//     echo $global_user_message;
//     exit; 
// }
// } 

// echo $db->select("SELECT REPLACE(UUID(), '-', '')");exit; //gen key

include_once dirname(__FILE__) . '/../../../app/classes/ticket_class.php';
include_once dirname(__FILE__) . '/../../../app/classes/brand_class.php';
include_once dirname(__FILE__) . '/../../../app/classes/model_class.php';
include_once dirname(__FILE__) . '/../../../app/classes/upload_class.php';
include_once dirname(__FILE__) . '/../../../app/classes/user_class.php';
include_once dirname(__FILE__) . '/../../app/classes/sms_class.php';
include_once dirname(__FILE__) . '/../../../app/classes/utility.php';

$utility_class = new Utility();
$ticket_class = new Ticket();
$brand_class = new Brand();
$model_class = new Model();
$user_class = new User();
$sms_class = new Sms();
$upload_class = new Upload();

$server_method = $_SERVER["REQUEST_METHOD"];

if (isset($_REQUEST['key'])) {
    $function_name = $db->escape($_REQUEST['key']);
    $parameters = array(
        'db' => $db,
        'utility_class' => $utility_class,
        'brand_class' => $brand_class,
        'model_class' => $model_class,
        'ticket_class' => $ticket_class,
        'sms_class' => $sms_class,
        'upload_class' => $upload_class,
        'server_method' => $server_method,
        'user_class' => $user_class,
        'global_system_settings' => $global_system_settings,
        'user_session' => $session_user,
        // 'global_system_settings'=>$global_system_settings,
        'request' => $_REQUEST,
    );
    call_user_func($function_name, $parameters);
} else {
    echo "Invalid Request.";
    exit;
}

function create_ticket($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $sms_class = $param['sms_class'];
    $is_new_ticket = $request['is_new_ticket'];

    $array_data = json_decode($request['json_data'], true);
    foreach ($array_data as $key => $value) {
        $array_data[$key] = $db->escape($array_data[$key]);
    }

    $ticket_attachments = json_decode($request['attachments'], true);

    // get category id
    $sub_category_id = $ticket_class->read_sub_category_id_by_name($array_data['category'], $utility_class, $db);
    // get main category id
    $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id, $utility_class, $db);
    $category_arr = array();
    foreach ($category_obj as $category_row) {
        $category_arr = $category_row;
    }

    // print_r($category_arr);exit; 
    $cat_show_vehicle = $category_arr['show_vehicle'];
    $category_id = $category_arr['category_id'];

    // get priority id
    $priority_id = $ticket_class->read_priority_level_id_by_name($array_data['priority_level'], $utility_class, $db);
    // insert main ticket

    $ticket_id = 0;

    //if the sub category is under vehicle catgory execute this 
    // current Vehicle Category is 2, change it depends to your database category table
    $brand_id = '';
    if (intval($cat_show_vehicle) === 1) {
        // get brand id
        $brand_id = $brand_class->read_brand_id_by_name($array_data['brand'], $utility_class, $db);
        if (!$utility_class->isNotEmpty($brand_id)) {
            $return_arr['message'] = "Brand is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        // get model id
        $model_id = $model_class->read_model_id_by_name_n_brand_id($brand_id, $array_data['model'], $utility_class, $db);
        if (!$utility_class->isNotEmpty($model_id)) {
            $return_arr['message'] = "Model is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        if (!$utility_class->isNotEmpty($array_data['plate_cs'])) {
            $return_arr['message'] = "Plate or CS is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        // get model variant id
        $model_variant_id = $array_data['model_variant_id'];
        if (!$utility_class->isNotEmpty($model_variant_id) && $utility_class->isNotEmpty($array_data['model_variant'])) {
            $model_variant_id = $model_class->insert_model_variant($model_id, $array_data['model_variant'], $utility_class, $db);
        }

        if ($is_new_ticket) {
            $ticket_id = $ticket_class->create_ticket($user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], 1, $utility_class, $db);
            $ticket_class->create_vehicle_type_ticket(
                $ticket_id,
                $model_id,
                $model_variant_id,
                $array_data['plate_cs'],
                $array_data['vin'],
                $array_data['year_model'],
                $utility_class,
                $db
            );
        } else {
            $ticket_id = $request['ticket_id'];
            $ticket_class->update_ticket($ticket_id, $user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], $utility_class, $db);
            $ticket_type_vehicle_obj =  $ticket_class->read_vehicle_type_ticket($ticket_id, $utility_class, $db);
            $ticket_type_vehicle_arr = array();
            foreach ($ticket_type_vehicle_obj as $row_vehicle_type) {
                $ticket_type_vehicle_arr = $row_vehicle_type;
            }

            if (count($ticket_type_vehicle_arr) > 0) {
                $ticket_class->update_vehicle_type_ticket(
                    $ticket_id,
                    $model_id,
                    $model_variant_id,
                    $array_data['plate_cs'],
                    $array_data['vin'],
                    $array_data['year_model'],
                    1,
                    $utility_class,
                    $db
                );
            } else {
                $ticket_class->create_vehicle_type_ticket(
                    $ticket_id,
                    $model_id,
                    $model_variant_id,
                    $array_data['plate_cs'],
                    $array_data['vin'],
                    $array_data['year_model'],
                    $utility_class,
                    $db
                );
            }
        }
    } else {
        if ($is_new_ticket) {
            // Insert no type (general) ticket and no 
            $ticket_id = $ticket_class->create_ticket($user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], 1, $utility_class, $db);
        } else {
            $ticket_id = $request['ticket_id'];
            $ticket_class->update_ticket($ticket_id, $user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], $utility_class, $db);
            $ticket_class->update_vehicle_type_ticket_status($ticket_id, 0, $utility_class, $db);
        }
    }

    if ($is_new_ticket) {
        //assign ref no.
        $ref_no = 1000 + intval($ticket_id);
        $ticket_class->create_ticket_ref_no($ticket_id, $ref_no, $db);
    }
    // if(count($ticket_attachments) > 0){
    // insert attachments
    foreach ($ticket_attachments as $ticket_attachment) {
        $ticket_class->create_ticket_attachment($ticket_id, $ticket_attachment['change_name'], $ticket_attachment['original_name'], $utility_class, $db);
    }
    // }

    if (!$is_new_ticket) {
        // update remove attachments
        $attachment_ids_arr = json_decode($request['remove_attachments'], true);
        if (count($attachment_ids_arr) > 0) {
            $attachment_ids = implode(',', $attachment_ids_arr);
            $ticket_class->update_ticket_attachment_status($attachment_ids, 0, $utility_class, $db);
        }
    }

    if ($is_new_ticket) {
        $return_arr['message'] = "Ticket has been added.";
    } else {
        $return_arr['message'] = "Ticket has been updated.";
    }

    //  SEND NOTIF
    if ($is_new_ticket) {
        $from_user_id = $user_session['id'];
        $notification_type_id = 3; //Send Notification to experts  (System Notification)
        if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
            if ($utility_class->isNotEmpty($brand_id)) {
                $expert_users_obj = $user_class->read_user_by_category_id_and_brand_id(2, $brand_id, $db);
                $expert_users_arr = array();
                foreach ($expert_users_obj as $expert_users_arr) {
                    //fetch experts loop
                    $to_user_id = $expert_users_arr['id'];
                    if ($from_user_id != $to_user_id) {
                        $target_id = $ticket_id;
                        $notification_id = $user_class->create_user_notification($notification_type_id, $from_user_id, $to_user_id, $target_id, 1, $utility_class, $db);
                    }
                }
            }
        }

        // send sms to expert

        $notification_type_id = 1; //Send Notification to experts  (System Notification)
        if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
            $description = $user_class->read_notification_template_by_id($notification_type_id, $utility_class, $db);
            $display_name =  $user_session['firstname'] . ' ' . substr($user_session['lastname'], 0, 1);
            $display_name = ucwords(strtolower($display_name));
            $replace_parameter = array(
                '<user>' => $display_name,
                '<ref_no>' => $ref_no,
                '<title>' => $array_data['title'],
                '<description>' => $array_data['description'], //str_replace("\n"," ",$arr_data['description']),
                '<category>' => $array_data['category'],
                '<priority>' => $array_data['priority_level'],
                '<brand>' => $array_data['brand'],
                '<model>' => $array_data['model'],
                '<variant>' => $array_data['model_variant'],
            );
            $sms_description = strtr($description, $replace_parameter);

            if ($utility_class->isNotEmpty($brand_id)) {

                $active_api_sql_obj = $user_class->read_active_api($utility_class, $db);
                $active_api_array = array();
                foreach ($active_api_sql_obj as $row) {
                    $active_api_array  = $row;
                }
                if (count($active_api_array) > 0) {
                    $user_data_obj = $user_class->read_user_by_category_id_and_brand_id(2, $brand_id, $db);
                    // $user_data_arr = array();
                    foreach ($user_data_obj as $user_data_row) {

                        $message_will_be_sent = "";
                        // $user_data_arr = array_merge($user_data_arr,array($user_data_row));
                        $to_user_id = $user_data_row['id'];
                        if ($from_user_id != $to_user_id) {

                            // start create login token
                            $token = $db->select('SELECT UUID()');
                            $user_class->create_user_login_token($to_user_id, $from_user_id, $ticket_id, $token, 1, $utility_class, $db);

                            $url_params = array(
                                'token' => $token,
                                'type' => 1,
                                'category' => 'tickets',
                                'action' => 'view',
                                'id' => $ticket_id,
                                'notification' => "[$ticket_id,$to_user_id]",
                            );
                            $append_link = $global_system_settings['url'] . "token.php" . "?" . http_build_query($url_params);
                            $append_link = urlencode($append_link);
                            $append_link = $utility_class->curl_me(
                                "https://s.autohub.ph/?url=$append_link&format=text",
                                array(),
                                'GET'
                            );
                            // echo $append_link;exit;
                            $message_will_be_sent = $sms_description . "\n\nClick to view: " . $append_link;
                            // end create login token

                            // $replace_parameter = array(
                            //     '[no]' => '0' . $user_data_row['mobile'],
                            //     '[msg]' => addslashes($message_will_be_sent),
                            // );
                            // $final_template = strtr($active_api_array['json_parameters'], $replace_parameter);
                            // $final_template = preg_replace("/\\n/m", "\\n", $final_template);
                            // $final_template = str_replace("\'", "'", $final_template);

                            $array_data['mobile'] =  '0' . $user_data_row['mobile'];
                            $array_data['message'] = $message_will_be_sent;
                            $array_data['data'] = $active_api_array;
                            $sms_status = $sms_class->{$active_api_array['name']}($array_data);


                            // $sms_status = $utility_class->curl_me(
                            //     $active_api_array['base_url'],
                            //     json_decode($final_template, true),
                            //     'POST',
                            //     $active_api_array['headers']
                            // );

                            if ($sms_status == $active_api_array['sent_response']) {
                                //send succcess
                            } else {
                                //send failed
                            }
                        }
                    }
                }
            }
        }
    }

    $return_arr['id'] = $ticket_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);
}


function create_ticket_reply($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $user_class = $param['user_class'];
    $sms_class = $param['sms_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $global_system_settings = $param['global_system_settings'];

    $array_data = json_decode($request['json_data'], true);
    foreach ($array_data as $key => $value) {
        $array_data[$key] = $db->escape($array_data[$key]);
    }

    $ticket_id = $request['ticket_id'];
    $ticket_description = $array_data['ticket_reply'];
    $ticket_status = intval($array_data['chk_close_ticket']); //ignored by line below

    $ticket_info_arr = array();
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);
    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);
        $ticket_info_arr = $row;
    }

    $ticket_reopen_status = /*intval*/ ($array_data['chk_reopen_ticket']);
    $ticket_escalated_solve_status = /*intval*/ ($array_data['chk_escalated_solve_ticket']);
    $ticket_final_status = /*intval*/ ($array_data['txt_final_status']);
    if ($utility_class->isNotEmpty($ticket_final_status) || $utility_class->isNotEmpty($ticket_reopen_status) || $utility_class->isNotEmpty($ticket_escalated_solve_status)) {

        if ($ticket_final_status || $ticket_escalated_solve_status) {
            $ticket_status = 3; //closed or complete
            if ($ticket_escalated_solve_status) {
                $ticket_final_status = 2; //escalated
            }
        } else {
            $ticket_status = 2; //in progress
        }

        if ($ticket_reopen_status) {
            $ticket_status = 2; //in progress
        }
    } else {
        // same sa old yung status 
        // fetch customer current status & final status 
        $ticket_status = $utility_class->isNotEmpty($ticket_info_arr['ticket_status_id']) ? $ticket_info_arr['ticket_status_id'] : '2';
        $ticket_final_status =  $ticket_info_arr['final_status_id'];
    }

    $reply_ticket_id = $ticket_class->create_reply_ticket($user_session['id'], $ticket_id, $ticket_description, $ticket_status, $ticket_final_status, $utility_class, $db);

    //record reopen ticket
    if ($ticket_reopen_status) {
        $ticket_class->create_reopen_ticket($reply_ticket_id, $db);
    }

    //record escalated status ticket
    if ($ticket_escalated_solve_status) {
        $escalated_type = 1; // 1 means solve
        $ticket_class->create_escalated_ticket($reply_ticket_id, $escalated_type, $db);
    }
    $ticket_attachments = json_decode($request['attachments'], true);

    foreach ($ticket_attachments as $ticket_attachment) {
        $ticket_class->create_reply_ticket_attachment($reply_ticket_id, $ticket_attachment['change_name'], $ticket_attachment['original_name'], $utility_class, $db);
    }


    $from_user_id = $user_session['id'];

    // INSERT reply notification 
    $notification_type_id = 4; //Reply Ticket System Notification
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        $to_user_id = $ticket_info_arr['user_id'];
        if ($from_user_id != $to_user_id) {
            $target_id = $ticket_id;
            $user_class->create_user_notification($notification_type_id, $from_user_id, $to_user_id, $target_id, 1, $utility_class, $db);
        }
    }

    // send sms to expert


    $notification_type_id = 2; //Send Notification to experts  (System Notification)
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        $to_user_id = $ticket_info_arr['user_id'];
        if ($from_user_id != $to_user_id) {

            $active_api_sql_obj = $user_class->read_active_api($utility_class, $db);
            $active_api_array = array();
            foreach ($active_api_sql_obj as $row) {
                $active_api_array  = $row;
            }

            if (count($active_api_array) > 0) {
                $description = $user_class->read_notification_template_by_id($notification_type_id, $utility_class, $db);
                $display_name =  $user_session['firstname'] . ' ' . substr($user_session['lastname'], 0, 1);
                $display_name = ucwords(strtolower($display_name));
                $replace_parameter = array(
                    '<user>' => $display_name,
                    '<ref_no>' => $ticket_info_arr['reference_no'],
                    '<title>' => $ticket_info_arr['title'],
                    '<description>' => $ticket_info_arr['description'], //str_replace("\n"," ",$arr_data['description']),
                    '<category>' => $ticket_info_arr['sub_category'],
                    '<priority>' => $ticket_info_arr['priority_level'],
                    '<brand>' => $ticket_info_arr['brand'],
                    '<model>' => $ticket_info_arr['model'],
                    '<variant>' => $ticket_info_arr['model_variant'],
                );
                $sms_description = strtr($description, $replace_parameter);

                // start create login token
                $token = $db->select('SELECT UUID()');
                $user_class->create_user_login_token($to_user_id, $from_user_id, $ticket_id, $token, 2, $utility_class, $db);

                $url_params = array(
                    'token' => $token,
                    'type' => 2,
                    'category' => 'tickets',
                    'action' => 'view',
                    'id' => $ticket_id,
                    'notification' => "[$ticket_id,$to_user_id]",
                );
                $append_link = $global_system_settings['url'] . "token.php" . "?" . http_build_query($url_params);
                $append_link = urlencode($append_link);
                $append_link = $utility_class->curl_me(
                    "https://s.autohub.ph/?url=$append_link&format=text",
                    array(),
                    'GET'
                );
                $sms_description = $sms_description . "\n\nClick to view: " . $append_link;
                // end create login token

                // $replace_parameter = array(
                //     '[no]' => '0' . $ticket_info_arr['mobile'],
                //     '[msg]' => addslashes($sms_description),
                // );
                // $final_template = strtr($active_api_array['json_parameters'], $replace_parameter);
                // $final_template = preg_replace("/\\n/m", "\\n", $final_template);
                // $final_template = str_replace("\'", "'", $final_template);
                // $sms_status = $utility_class->curl_me(
                //     $active_api_array['base_url'],
                //     json_decode($final_template, true),
                //     'POST',
                //     $active_api_array['headers']
                // );

                $array_data['mobile'] =  '0' . $ticket_info_arr['mobile'];
                $array_data['message'] = $sms_description;
                $array_data['data'] = $active_api_array;
                $sms_status = $sms_class->{$active_api_array['name']}($array_data);

                if ($sms_status == $active_api_array['sent_response']) {
                    //send succcess
                } else {
                    //send failed
                }
            }
        }
    }
    $return_arr['message'] = "Response submitted.";
    $return_arr['id'] = $reply_ticket_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);
}
function create_ticket_header($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $is_new_ticket = true;
    if ($utility_class->isNotEmpty($request['id'])) {
        $is_new_ticket = false;
    }

    $array_data = json_decode($request['json_data'], true);
    foreach ($array_data as $key => $value) {
        $array_data[$key] = $db->escape($array_data[$key]);
    }

    // get category id
    $sub_category_id = $ticket_class->read_sub_category_id_by_name($array_data['category'], $utility_class, $db);
    // get main category id
    $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id, $utility_class, $db);
    $category_arr = array();
    foreach ($category_obj as $category_row) {
        $category_arr = $category_row;
    }

    $cat_show_vehicle = $category_arr['show_vehicle'];
    $category_id = $category_arr['category_id'];

    // get priority id
    $priority_id = $request['priority_id'];
    // insert main ticket

    $ticket_id = $request['id'];
    if ($is_new_ticket) {
        $ticket_id = $ticket_class->create_ticket($user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], 0, $utility_class, $db);
    } else {
        $ticket_class->update_ticket($ticket_id, $user_session['id'], $sub_category_id, $priority_id, $array_data['title'], $array_data['description'], $utility_class, $db);
    }


    $brand_id = '';
    if (intval($cat_show_vehicle) === 1) {
        // get brand id
        $brand_id = $brand_class->read_brand_id_by_name($array_data['brand'], $utility_class, $db);
        if (!$utility_class->isNotEmpty($brand_id)) {
            $return_arr['message'] = "Brand is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        // get model id
        $model_id = $model_class->read_model_id_by_name_n_brand_id($brand_id, $array_data['model'], $utility_class, $db);
        if (!$utility_class->isNotEmpty($model_id)) {
            $return_arr['message'] = "Model is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        if (!$utility_class->isNotEmpty($array_data['plate_cs'])) {
            $return_arr['message'] = "Plate or CS is required...";
            $return_arr['status'] = 0;
            echo json_encode($return_arr);
            exit;
        }
        // get model variant id
        $model_variant_id = $array_data['model_variant_id'];
        if (!$utility_class->isNotEmpty($model_variant_id) && $utility_class->isNotEmpty($array_data['model_variant'])) {
            $model_variant_id = $model_class->insert_model_variant($model_id, $array_data['model_variant'], $utility_class, $db);
        }

        // $ticket_id = $ticket_class->create_ticket($user_session['id'],$sub_category_id,$priority_id,$array_data['title'],$array_data['description'],$utility_class,$db);
        if ($is_new_ticket) {
            $ticket_class->create_vehicle_type_ticket_v2(
                $ticket_id,
                $model_id,
                $model_variant_id,
                $array_data['plate_cs'],
                $array_data['vin'],
                $array_data['year_model'],
                $array_data['mileage'],
                $array_data['chk_breakdown'],
                $array_data['chk_on_site'],
                $array_data['workshop_visit'],
                0,
                $utility_class,
                $db
            );
        } else {
            $ticket_class->update_vehicle_type_ticket_v2(
                $ticket_id,
                $model_id,
                $model_variant_id,
                $array_data['plate_cs'],
                $array_data['vin'],
                $array_data['year_model'],
                $array_data['mileage'],
                $array_data['chk_breakdown'],
                $array_data['chk_on_site'],
                $array_data['workshop_visit'],
                0,
                $utility_class,
                $db
            );
        }
    }

    //assign ref no.
    $ref_no = 1000 + intval($ticket_id);
    $ticket_class->create_ticket_ref_no($ticket_id, $ref_no, $db);

    $ticket_class->create_ticket_progress_status($ticket_id, $user_session['id'], 1, $utility_class, $db);

    if ($is_new_ticket) {
        $return_arr['message'] = "Add Success...";
    } else {
        $return_arr['message'] = "Change Success...";
    }
    $return_arr['status'] = 1;
    $return_arr['id'] = $ticket_id;
    echo json_encode($return_arr);
}
function update_ticket_vehicle_customer($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];


    $array_data = json_decode($request['json_data'], true);
    foreach ($array_data as $key => $value) {
        $array_data[$key] = $db->escape($array_data[$key]);
    }


    $ticket_id = $request['id'];

    // print_r($request);
    $ticket_class->update_ticket_customer(
        $ticket_id,
        $array_data['complaint'],
        $array_data['work_performed'],
        $array_data['fault_codes'],
        $utility_class,
        $db
    );

    $return_arr['status'] = 1;
    $return_arr['message'] = "Success.";
    echo json_encode($return_arr);
}
function create_ticket_final($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $sms_class = $param['sms_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $status = $request['status'];



    $ticket_id = $request['id'];
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);
    $ticket_info_arr = array();

    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);
        $ticket_info_arr = $row;
    }

    $ticket_class->update_ticket_status($ticket_id, $status, $utility_class, $db);
    $ticket_class->update_vehicle_type_ticket_status($ticket_id, $status, $utility_class, $db);
    $ticket_class->update_ticket_date_creation($ticket_id, $utility_class, $db);

    // loggerr
    $log_data['user_id'] = $user_session['id'];
    $log_data['target_id'] = $ticket_id;
    $log_data['description'] = 'Created a ticket';
    //important
    $log_data['type'] = 2; //create ticket
    $log_data['db'] = $db;
    $GLOBALS['logger_class']->log($log_data);

    if (intval($ticket_info_arr['priority_level_id']) === 1) { //info ticket
        $ticket_class->create_ticket_progress_status($ticket_id, $user_session['id'], 3, $utility_class, $db);
        $return_arr['status'] = 1;
        $return_arr['message'] = "Success.";
        echo json_encode($return_arr);
        exit;
    }

    //  SEND NOTIF 
    $brand_id = $ticket_info_arr['brand_id'];
    $from_user_id = $user_session['id'];
    $notification_type_id = 3; //Send Notification to experts  (System Notification)
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        if ($utility_class->isNotEmpty($brand_id)) {
            $expert_users_obj = $user_class->read_user_by_category_id_and_brand_id(2, $brand_id, $db);
            $expert_users_arr = array();
            foreach ($expert_users_obj as $expert_users_arr) {
                //fetch experts loop
                $to_user_id = $expert_users_arr['id'];
                if ($from_user_id != $to_user_id) {
                    $target_id = $ticket_id;
                    $notification_id = $user_class->create_user_notification($notification_type_id, $from_user_id, $to_user_id, $target_id, 1, $utility_class, $db);
                }
            }
        }
    }

    $notification_type_id = 1; //Send Notification to experts  (System Notification)
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        $description = $user_class->read_notification_template_by_id($notification_type_id, $utility_class, $db);
        $display_name =  $user_session['firstname'] . ' ' . substr($user_session['lastname'], 0, 1);
        $display_name = ucwords(strtolower($display_name));
        $replace_parameter = array(
            '<user>' => $display_name,
            '<ref_no>' => $ticket_info_arr['reference_no'],
            '<title>' => $ticket_info_arr['title'],
            '<description>' => $ticket_info_arr['description'], //str_replace("\n"," ",$arr_data['description']),
            '<category>' => $ticket_info_arr['category'],
            '<priority>' => $ticket_info_arr['priority_level'],
            '<brand>' => $ticket_info_arr['brand'],
            '<model>' => $ticket_info_arr['model'],
            '<variant>' => $ticket_info_arr['model_variant'],
        );
        $sms_description = strtr($description, $replace_parameter);

        if ($utility_class->isNotEmpty($brand_id)) {

            $active_api_sql_obj = $user_class->read_active_api($utility_class, $db);
            $active_api_array = array();
            foreach ($active_api_sql_obj as $row) {
                $active_api_array  = $row;
            }
            if (count($active_api_array) > 0) {
                $user_data_obj = $user_class->read_user_by_category_id_and_brand_id(2, $brand_id, $db);
                // $user_data_arr = array();
                foreach ($user_data_obj as $user_data_row) {

                    $message_will_be_sent = "";
                    // $user_data_arr = array_merge($user_data_arr,array($user_data_row));
                    $to_user_id = $user_data_row['id'];
                    if ($from_user_id != $to_user_id) {

                        // start create login token
                        $token = $db->select('SELECT UUID()');
                        $user_class->create_user_login_token($to_user_id, $from_user_id, $ticket_id, $token, 1, $utility_class, $db);

                        $url_params = array(
                            'token' => $token,
                            'type' => 1,
                            // 'category'=>'tickets',
                            // 'action'=>'view',
                            'id' => $ticket_id,
                            // 'notification'=>"[$ticket_id,$to_user_id]",
                        );
                        $append_link = $global_system_settings['url'] . "token.php" . "?" . http_build_query($url_params);
                        $append_link = urlencode($append_link);
                        $append_link = $utility_class->curl_me(
                            "https://s.autohub.ph/?url=$append_link&format=text",
                            array(),
                            'GET'
                        );
                        // echo $append_link;exit;
                        $message_will_be_sent = $sms_description . "\n\nClick to view: " . $append_link;
                        // end create login token

                        // $replace_parameter = array(
                        //     '[no]' => '0' . $user_data_row['mobile'],
                        //     '[msg]' => addslashes($message_will_be_sent),
                        // );
                        // $final_template = strtr($active_api_array['json_parameters'], $replace_parameter);
                        // $final_template = preg_replace("/\\n/m", "\\n", $final_template);
                        // $final_template = str_replace("\'", "'", $final_template);

                        // $sms_status = $utility_class->curl_me(
                        //     $active_api_array['base_url'],
                        //     json_decode($final_template, true),
                        //     'POST',
                        //     $active_api_array['headers']
                        // );

                        $array_data['mobile'] =  '0' . $user_data_row['mobile'];
                        $array_data['message'] = $message_will_be_sent;
                        $array_data['data'] = $active_api_array;
                        $sms_status = $sms_class->{$active_api_array['name']}($array_data);

                        if ($sms_status == $active_api_array['sent_response']) {
                            //send succcess
                        } else {
                            //send failed
                        }
                    }
                }
            }
        }
    }



    $return_arr['status'] = 1;
    $return_arr['message'] = "Success.";
    echo json_encode($return_arr);
}
function create_ticket_reply_v2($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $user_class = $param['user_class'];
    $sms_class = $param['sms_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $global_system_settings = $param['global_system_settings'];

    $array_data = json_decode($request['json_data'], true);
    foreach ($array_data as $key => $value) {
        $array_data[$key] = $db->escape($array_data[$key]);
    }

    $ticket_id = $request['ticket_id'];
    $ticket_description = $array_data['ticket_reply'];

    $ticket_info_arr = array();
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);
    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);
        $ticket_info_arr = $row;
    }

    if (intval($ticket_info_arr['ticket_status_id']) === 1) {
        $progress_status = 2;
        $ticket_class->create_ticket_progress_status($ticket_id, $user_session['id'], $progress_status, $utility_class, $db);
    } else {
        $progress_status = intval($ticket_info_arr['ticket_status_id']);
    }

    $reply_ticket_id = $ticket_class->create_reply_ticket_v2($user_session['id'], $ticket_id, $ticket_description, $progress_status, $utility_class, $db);

    $ticket_attachments = json_decode($request['attachments'], true);

    foreach ($ticket_attachments as $ticket_attachment) {
        $ticket_class->create_reply_ticket_attachment($reply_ticket_id, $ticket_attachment['change_name'], $ticket_attachment['original_name'], $utility_class, $db);
    }

    // loggerr
    $log_data['user_id'] = $user_session['id'];
    $log_data['target_id'] = $ticket_id;
    $log_data['description'] = 'Reply to ticket';
    //important
    $log_data['type'] = 3; //reply ticket
    $log_data['db'] = $db;
    $GLOBALS['logger_class']->log($log_data);

    $from_user_id = $user_session['id'];
    // INSERT reply notification 
    $notification_type_id = 4; //Reply Ticket System Notification
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        $to_user_id = $ticket_info_arr['user_id'];
        if ($from_user_id != $to_user_id) {
            $target_id = $ticket_id;
            $user_class->create_user_notification($notification_type_id, $from_user_id, $to_user_id, $target_id, 1, $utility_class, $db);
        }
    }


    // send sms 
    $notification_type_id = 2; //Send Notification to experts  (System Notification)
    if ($user_class->read_notification_type_if_active($notification_type_id, $db)) {
        $to_user_id = $ticket_info_arr['user_id'];
        if ($from_user_id != $to_user_id) {

            $active_api_sql_obj = $user_class->read_active_api($utility_class, $db);
            $active_api_array = array();
            foreach ($active_api_sql_obj as $row) {
                $active_api_array  = $row;
            }

            if (count($active_api_array) > 0) {
                $description = $user_class->read_notification_template_by_id($notification_type_id, $utility_class, $db);
                $display_name =  $user_session['firstname'] . ' ' . substr($user_session['lastname'], 0, 1);
                $display_name = ucwords(strtolower($display_name));
                $replace_parameter = array(
                    '<user>' => $display_name,
                    '<ref_no>' => $ticket_info_arr['reference_no'],
                    '<title>' => $ticket_info_arr['title'],
                    '<description>' => $ticket_info_arr['description'], //str_replace("\n"," ",$arr_data['description']),
                    '<category>' => $ticket_info_arr['sub_category'],
                    '<priority>' => $ticket_info_arr['priority_level'],
                    '<brand>' => $ticket_info_arr['brand'],
                    '<model>' => $ticket_info_arr['model'],
                    '<variant>' => $ticket_info_arr['model_variant'],
                );
                $sms_description = strtr($description, $replace_parameter);

                // start create login token
                $token = $db->select('SELECT UUID()');
                $user_class->create_user_login_token($to_user_id, $from_user_id, $ticket_id, $token, 2, $utility_class, $db);

                $url_params = array(
                    'token' => $token,
                    'type' => 2,
                    // 'category'=>'tickets',
                    // 'action'=>'view',
                    'id' => $ticket_id,
                    // 'notification'=>"[$ticket_id,$to_user_id]",
                );
                $append_link = $global_system_settings['url'] . "token.php" . "?" . http_build_query($url_params);
                $append_link = urlencode($append_link);
                $append_link = $utility_class->curl_me(
                    "https://s.autohub.ph/?url=$append_link&format=text",
                    array(),
                    'GET'
                );
                $sms_description = $sms_description . "\n\nClick to view: " . $append_link;
                // end create login token

                // $replace_parameter = array(
                //     '[no]' => '0' . $ticket_info_arr['mobile'],
                //     '[msg]' => addslashes($sms_description),
                // );
                // $final_template = strtr($active_api_array['json_parameters'], $replace_parameter);
                // $final_template = preg_replace("/\\n/m", "\\n", $final_template);
                // $final_template = str_replace("\'", "'", $final_template);
                // $sms_status = $utility_class->curl_me(
                //     $active_api_array['base_url'],
                //     json_decode($final_template, true),
                //     'POST',
                //     $active_api_array['headers']
                // );

                $array_data['mobile'] =  '0' . $ticket_info_arr['mobile'];
                $array_data['message'] = $sms_description;
                $array_data['data'] = $active_api_array;
                $sms_status = $sms_class->{$active_api_array['name']}($array_data);

                if ($sms_status == $active_api_array['sent_response']) {
                    //send succcess
                } else {
                    //send failed
                }
            }
        }
    }

    $return_arr['message'] = "Response submitted.";
    $return_arr['id'] = $reply_ticket_id;
    $return_arr['status'] = 1;
    echo json_encode($return_arr);
}
function update_ticket_status($param)
{

    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['id'];
    $status = $request['status'];
    $status_id = $ticket_class->read_ticket_status_id_by_name($status, $utility_class, $db);

    $ticket_class->create_ticket_progress_status($ticket_id, $user_session['id'], $status_id, $utility_class, $db);

    // loggerr
    $log_data['user_id'] = $user_session['id'];
    $log_data['target_id'] = $ticket_id;
    $log_data['description'] = "Change status to $status";
    //important
    $log_data['type'] = 4; //change ticket status
    $log_data['db'] = $db;
    $GLOBALS['logger_class']->log($log_data);

    $return_arr['status'] = 1;
    $return_arr['message'] = "Success.";
    echo json_encode($return_arr);
}
function update_ticket_attachments($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $model_class = $param['model_class'];
    $brand_class = $param['brand_class'];
    $user_class = $param['user_class'];
    $global_system_settings = $param['global_system_settings'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['id'];
    $ticket_attachments = json_decode($request['attachments'], true);

    $ticket_class->remove_all_ticket_attachment_status($ticket_id, $utility_class, $db);

    foreach ($ticket_attachments as $ticket_attachment) {
        $ticket_class->create_ticket_attachment($ticket_id, $ticket_attachment['change_name'], $ticket_attachment['original_name'], $utility_class, $db);
    }

    $return_arr['status'] = 1;
    $return_arr['message'] = "Success.";
    echo json_encode($return_arr);
}

// function create_ticket_attachment($param){
//     $db = $param['db'];
//     $utility_class = $param['utility_class'];
//     $ticket_class = $param['ticket_class']; 
//     $upload_class = $param['upload_class']; 
//     $request = $param['request'];

//     $response = $upload_class->create_attachment($_FILES['file'],$utility_class,$db);

//     echo json_encode($response); 
// }


function read_sub_categories($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $category_list_obj = $ticket_class->read_sub_categories($search, $utility_class, $db);

    $json = [];
    foreach ($category_list_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }

    echo json_encode($json);
}


function read_sections($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $category_list_obj = $ticket_class->read_sections($search, $utility_class, $db);

    $json = [];
    foreach ($category_list_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }

    echo json_encode($json);
}

function read_final_status($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $category_list_obj = $ticket_class->read_final_status($search, $utility_class, $db);

    $json = [];
    foreach ($category_list_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }

    echo json_encode($json);
}

function read_priority_level($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $category_list_obj = $ticket_class->read_priority_level($search, $utility_class, $db);

    $json = [];
    foreach ($category_list_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }

    echo json_encode($json);
}

function read_ticket_data($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $ticket_id = $request['ticket_id'];
    $json['rows'] = array();
    $json['attachments'] = array();

    $ticket_id = $request['ticket_id'];
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);


    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);

        $json['rows'] = array(
            'category' => $row['sub_category'],
            'title' => $row['title'],
            'description' => $row['description'],
            // 'sub_category_id'=>$row['sub_category_id'],
            // 'sub_category'=>$row['sub_category'],
            // 'subject'=>$row['title'],
            // 'description'=>$row['description'],
            // 'priority_id'=>$row['priority_level_id'],
            'priority_level' => $row['priority_level'],
            // 'brand_id'=>$row['brand_id'],
            'brand' => $row['brand'],
            // 'model_id'=>$row['model_id'],
            'model' => $row['model'],
            'model_variant_id' => $row['model_variant_id'],
            'model_variant' => $row['model_variant'],
            'year_model' => $row['year_model'],
            'plate_cs' => $row['plate_cs'],
            'vin' => $row['vin'],
            // 'category_id'=>$row['category_id'],
            // 'ticket_status_id'=>$row['ticket_status_id'],
            // 'ticket_status'=>$row['ticket_status'],
        );
    }


    $ticket_attach_obj = $ticket_class->read_ticket_attachments($ticket_id, $utility_class, $db);
    foreach ($ticket_attach_obj as $row) {
        $file = dirname(__FILE__) . '/../../../dist/attachments/' . $row['attachment_name'];
        $unreadable_size = (is_file($file) ? filesize($file) : 0);
        $readable_file_size = $utility_class->humanFileSize($unreadable_size);
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
        $json['attachments'] = array_merge($json['attachments'], array(array(
            'id' => $row['id'],
            'change_name' => $row['attachment_name'],
            'original_name' => $row['original_name'],
            'date' => $row['date_addedf'],
            'size' => $readable_file_size,
            'unreadable_size' => $unreadable_size,
            'icon' => $fa_icon,
        )));
    }
    echo json_encode($json);
}





function read_ticket_list($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];


    // print_r($request);exit;

    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $offset = $request['offset'];
    $limit = $request['limit'];
    $owned_ticket_only = isset($request['owned_ticket_only']) ? $db->escape($request['owned_ticket_only']) : '';

    // Filter by Category
    $filter_category = json_decode(isset($request['filter_category']) ? $request['filter_category'] : "[]", true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode(isset($request['filter_status']) ? $request['filter_status'] : "[]", true);
    // print_r($filter_status);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';


    // Filter by priority
    $filter_priority = json_decode(isset($request['filter_priority']) ? $request['filter_priority'] : "[]", true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';


    $filter_start_date = isset($request['start_date']) ? $request['start_date'] : '';
    $filter_end_date = isset($request['end_date']) ? $request['end_date'] : '';

    $filter_brand_id = isset($request['filter_brand']) && $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = isset($request['filter_model']) && $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';

    $ticket_list_array = $ticket_class->read_ticket_list(
        1,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        $filter_status_ids_str,
        // $filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );

    $json_arr['total'] = $ticket_list_array[0];
    $ticket_list_obj = $ticket_list_array[1];

    $json_arr['rows'] = array();


    $counter = $request['offset'] + 1;

    foreach ($ticket_list_obj as $row) {
        //  $row = $utility_class->arrayNullToBlank($row);
        $display_name =  $row['firstname'] . ' ' . substr($row['lastname'], 0, 1);
        $json_arr['rows'] = array_merge(
            $json_arr['rows'],
            array(array(
                'no' => $counter++,
                'id' => $row['id'],
                'reference_no' => $row['reference_no'],
                'date' => $row['date_addedw'],
                'datew' => date("F j, Y", strtotime($row['date_addedf'])),
                'category' => $row['sub_category'],
                'vehicle' => $row['brand'] . ' - ' . $row['model'],
                'plate_cs' => $row['plate_cs'],
                'title' => $row['title'],
                'priority' => $row['priority_level'],
                'status' => $row['status'],
                'created_by' => $display_name,
            ))
        );
    }

    echo json_encode($json_arr);
}



function read_ticket_list_autocomplete($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];

    // print_r($request);exit;

    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $offset = $request['offset'];
    $limit = $request['limit'];

    $ticket_list_obj = $ticket_class->read_ticket_list_autocomplete(
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $json_arr['rows'] = array();
    foreach ($ticket_list_obj as $row) {
        $json_arr['rows'] = array_merge(
            $json_arr['rows'],
            array(array(
                'id' => $row['id'],
                'text' => $row['title'],
            ))
        );
    }

    echo json_encode($json_arr);
}

function read_ticket_category($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $category_list_obj = $ticket_class->read_priority_level('', $utility_class, $db);
    $json = [];
    foreach ($category_list_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }
    echo json_encode($json);
}

function read_ticket_information($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['ticket_id'];
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);

    $json = array();

    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);

        $display_name =  $row['firstname'] . ' ' . substr($row['lastname'], 0, 1);
        $display_name = ucwords(strtolower($display_name));
        $json = array(
            'lbl_ticket_subject' => $row['title'],
            'lbl_reference_no' => $row['reference_no'],
            'lbl_ticket_info' => 'Created by ' . $display_name . ' on ' . $row['date_addedf'],
            'lbl_ticket_date_created_by' => $row['date_addedf'],
            'lbl_ticket_description' => str_replace("\n", "<br>", $row['description']),
            'lbl_ticket_priority' => $row['priority_level'],
            'lbl_ticket_category' => $row['sub_category'],
            'lbl_kb_category' => $row['sub_category'], /*for kb */
            'lbl_kb_posted_date' => $row['date_addedf'], /*for kb */
            'lbl_ticket_brand' => $row['brand'],
            'lbl_ticket_model' => $row['model'],
            'lbl_ticket_mv' => $row['model_variant'],
            'lbl_ticket_ym' => $row['year_model'],
            'lbl_ticket_plate_cs' => $row['plate_cs'],
            'lbl_ticket_vin' => $row['vin'],
            'lbl_ticket_mileage' => $row['mileage'] . ' km',
            'lbl_ticket_created_by' => $display_name,
            'lbl_ticket_workshop_visit' => $row['workshop_visit_count'],
            'lbl_ticket_complaint' => str_replace("\n", "<br>", $row['complaint']), //$row['complaint'],
            'lbl_ticket_work_done' => str_replace("\n", "<br>", $row['work_performed']), //$row['work_performed'],
            'lbl_ticket_fault_codes' => $row['fault_codes'],
            'lbl_ticket_status' => $row['ticket_status'],
            'lbl_ticket_breakdown' => (intval($row['breakdown']) ? 'Yes' : 'No'),
            'lbl_ticket_on_site' => (intval($row['on_site']) ? 'Yes' : 'No'),

            'category_id' => $row['category_id'],
            'priority_id' => $row['priority_level_id'],
            'show_vehicle' => $row['show_vehicle'],
            'ticket_type' => $row['type'],
            'ticket_status_id' => $row['ticket_status_id'],
            'ticket_rating' => $row['rating'],
            'is_owner' => ($row['user_id'] == $user_session['id']) ? 1 : 0,
        );
    }
    echo json_encode($json);
}

function read_ticket_attachments($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];

    $ticket_id = $request['ticket_id'];
    $ticket_info_obj = $ticket_class->read_ticket_attachments($ticket_id, $utility_class, $db);

    $json = array();



    foreach ($ticket_info_obj as $row) {
        $file = dirname(__FILE__) . '/../../../dist/attachments/' . $row['attachment_name'];
        $readable_file_size = $utility_class->humanFileSize((is_file($file) ? filesize($file) : 0));
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        // echo $file_ext;exit;
        $fa_icon = $utility_class->getFileIcon($file_ext);
        $json[] = array(
            'id' => $row['id'],
            'change_name' => $row['attachment_name'],
            'original_name' => $row['original_name'],
            'date' => $row['date_addedf'],
            'size' => $readable_file_size,
            'icon' => $fa_icon,
        );
    }
    echo json_encode($json);
}

function read_ticket_replies($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['ticket_id'];
    $offset = $request['offset'];
    $limit = $request['limit'];

    $order = $request['order'];
    $ticket_replies_obj = $ticket_class->read_ticket_replies($ticket_id, $offset, $limit, $order, $utility_class, $db);
    // $ticket_replies_obj = $ticket_class->read_ticket_replies($ticket_id,$offset,$limit,$utility_class,$db);

    $json['rows'] = array();
    $json['attachments'] = array();
    foreach ($ticket_replies_obj as $row) {
        // echo $user_session['id'] .' - '. $row['owner_id'] ."\n";
        $json['rows'] = array_merge($json['rows'], array(array(
            'id' => $row['id'],
            'ticket_id' => $row['ticket_id'],
            'user' => $row['firstname'] . ' ' . $row['lastname'],
            'creator' => ($row['from_user'] == $row['owner_id']) ? ' (Creator)' : '',
            'remove' => ($user_session['id'] == $row['from_user']) ? 'Remove' : '',
            'description' => str_replace("\n", "<br>", $row['description']),
            'ticket_status' => $row['ticket_status'],
            'date_added' => $row['date_addedf'],
            'final_status_id' => $row['final_status_id'],
            'reopen_ticket_id' => $row['reopen_ticket_id'],
            'escalated_ticket_id' => $row['escalated_ticket_id'],
        )));
        $ticket_replies_attachment_obj = $ticket_class->read_ticket_reply_attachments($row['id'], $utility_class, $db);
        foreach ($ticket_replies_attachment_obj as $row) {
            $json['attachments'] = array_merge($json['attachments'], array(array(
                'id' => $row['id'],
                'reply_id' => $row['ticket_reply_id'],
                'attachment_name' => $row['attachment_name'],
                'original_name' => $row['original_name'],
            )));
        }
    }






    echo json_encode($json);
}

function read_ticket_replies_v2($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['ticket_id'];
    $offset = $request['offset'];
    $limit = $request['limit'];

    $order = $request['order'];
    $ticket_replies_obj = $ticket_class->read_ticket_replies($ticket_id, $offset, $limit, $order, $utility_class, $db);

    $json['rows'] = array();
    $json['attachments'] = array();
    foreach ($ticket_replies_obj as $row) {
        // echo $user_session['id'] .' - '. $row['owner_id'] ."\n";
        $json['rows'] = array_merge($json['rows'], array(array(
            'id' => $row['id'],
            'ticket_id' => $row['ticket_id'],
            'user' => $row['firstname'] . ' ' . $row['lastname'],
            'creator' => ($row['from_user'] == $row['owner_id']) ? ' (Creator)' : '',
            'remove' => ($user_session['id'] == $row['from_user']) ? 'Remove' : '',
            'reply_owner' => ($user_session['id'] == $row['from_user']) ? 1 : 0,
            'description' => str_replace("\n", "<br>", $row['description']),
            'ticket_status' => $row['ticket_status'],
            'date_added' => $row['date_addedf'],
        )));
        $ticket_replies_attachment_obj = $ticket_class->read_ticket_reply_attachments($row['id'], $utility_class, $db);
        foreach ($ticket_replies_attachment_obj as $row) {
            $json['attachments'] = array_merge($json['attachments'], array(array(
                'id' => $row['id'],
                'reply_id' => $row['ticket_reply_id'],
                'attachment_name' => $row['attachment_name'],
                'original_name' => $row['original_name'],
            )));
        }
    }

    echo json_encode($json);
}


function read_ticket_activities($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];

    $ticket_id = $request['ticket_id'];
    $offset = $request['offset'];
    $limit = $request['limit'];

    $order = $request['order'];
    $ticket_activities_obj = $ticket_class->read_ticket_activities($ticket_id, $offset, $limit, $order, $utility_class, $db);

    $json['rows'] = array();
    foreach ($ticket_activities_obj as $row) {
        $json['rows'] = array_merge($json['rows'], array(array(
            'id' => $row['id'],
            'user' => $row['firstname'] . ' ' . $row['lastname'],
            'description' => str_replace("\n", "<br>", $row['description']),
            'date_added' => $row['date_addedf'],
        )));
    }

    echo json_encode($json);
}

function read_ticket_status($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $ticket_status_obj = $ticket_class->read_ticket_status('', $utility_class, $db);
    $json = [];
    foreach ($ticket_status_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }
    echo json_encode($json);
}
function read_ticket_available_status($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $ticket_id = $request['ticket_id'];

    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);
    $ticket_info_arr = array();
    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);
        $ticket_info_arr = $row;
    }

    $exclude_status = $ticket_info_arr['ticket_status_id'] . ',' . '1';

    $ticket_status_obj = $ticket_class->read_ticket_available_status($exclude_status, $utility_class, $db);
    $json = [];
    foreach ($ticket_status_obj as $row) {
        $json[] = ['id' => $row['name'], 'text' => $row['name']];
    }
    echo json_encode($json);
}
function read_category_id_by_sub_category_name($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];

    // get category id
    if ($utility_class->isNotEmpty($request['sub_category'])) {

        $sub_category_id = $ticket_class->read_sub_category_id_by_name($request['sub_category'], $utility_class, $db);
        // get main category id
        $category_obj = $ticket_class->read_category_id_by_sub_category_id($sub_category_id, $utility_class, $db);
        $category_arr = array();
        foreach ($category_obj as $category_row) {
            $category_arr = $category_row;
        }

        $cat_show_vehicle = $category_arr['show_vehicle'];
        $category_id = $category_arr['category_id'];
    } else {
        $cat_show_vehicle = 0;
        $category_id = 0;
    }

    $return_arr['category_id'] = $category_id;
    $return_arr['show_vehicle'] = $cat_show_vehicle;
    echo json_encode($return_arr);
}

function delete_ticket_reply($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $ticket_reply_id = $request['ticket_reply_id'];

    $ticket_class->delete_ticket_reply($ticket_reply_id, 0, $db);

    $json['message'] = "Successfully removed.";
    echo json_encode($json);
}

function delete_ticket($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $ticket_id = $request['id'];

    $status = 0;
    $ticket_class->update_ticket_status($ticket_id, $status, $utility_class, $db);

    $json['status'] = 1;
    $json['message'] = "Successfully removed.";
    echo json_encode($json);
}

function read_data_countings($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];


    // START
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];

    $search = '';
    $offset = '';
    $limit = '';
    $owned_ticket_only = '';

    // Filter by Category
    $filter_category = json_decode($request['filter_category'], true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode($request['filter_status'], true);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';

    // Filter by priority
    $filter_priority = json_decode($request['filter_priority'], true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';


    $filter_start_date = $request['start_date'];
    $filter_end_date = $request['end_date'];

    $filter_brand_id = $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';



    $return_arr['on_hold_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "1", //$filter_status_ids_str,
        // true,//$filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['in_progress_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "2", //$filter_status_ids_str,
        // false,//$filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['solve_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "3",
        // $filter_status_ids_str_null,
        // 1,//$filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['not_solve_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "4,5",
        // $filter_status_ids_str_null,
        // 2,//$filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    // $return_arr['on_hold_total'] =  $ticket_class->read_ticket_count_by_progress(1,$db);
    // $return_arr['in_progress_total'] =  $ticket_class->read_ticket_count_by_progress(2,$db);
    // $return_arr['solve_total'] =  $ticket_class->read_ticket_count_by_final_status(1,$db);
    // $return_arr['not_solve_total'] =  $ticket_class->read_ticket_count_by_final_status(2,$db);

    echo json_encode($return_arr);
}

function read_open_close_graph($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];

    // START
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];

    $search = '';
    $offset = '';
    $limit = '';
    $owned_ticket_only = '';

    // Filter by Category
    $filter_category = json_decode($request['filter_category'], true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode($request['filter_status'], true);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';
    // check if has level 1
    // $filter_status_ids_str_null = in_array(1,$filter_status_ids) ? true : false ; 

    // // Filter by final Status
    // $filter_final_status = json_decode($request['filter_final_status'],true);
    // $filter_final_status_ids = array();
    // if(count($filter_final_status) > 0){
    //     $filter_final_status_names = "'" . implode("','", $filter_final_status) . "'";
    //     $status_id_list_obj = $ticket_class->read_ticket_final_status_ids_by_names($filter_final_status_names,$utility_class,$db);
    //     foreach($status_id_list_obj as $status_id_list){
    //         $filter_final_status_ids[] = $status_id_list['id'];
    //     }
    // }
    // $filter_final_status_ids_str = count($filter_final_status_ids) > 0 ? implode(",",$filter_final_status_ids) : '' ;
    //  $filter_escalated_status = array();
    // if(in_array('Escalated (Solve)',$filter_final_status)){
    //     $filter_escalated_status[] = 1;
    // }
    // $filter_escalated_str =  count($filter_escalated_status) > 0 ? implode(",",$filter_escalated_status) : '' ;

    // Filter by priority
    $filter_priority = json_decode($request['filter_priority'], true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';


    $filter_start_date = $request['start_date'];
    $filter_end_date = $request['end_date'];

    $filter_brand_id = $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';




    $tikcet_obj = $ticket_class->read_ticket_list(
        4,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        $filter_status_ids_str,
        // $filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    // $tikcet_obj = $ticket_class->read_open_close_graph_open($db);
    $tikcet_arr['recieve'] = array();
    foreach ($tikcet_obj as $tikcet_row) {
        $tikcet_arr['recieve'] = array_merge($tikcet_arr['recieve'], array($tikcet_row));
    }

    $tikcet_obj = $ticket_class->read_ticket_list(
        5,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        $filter_status_ids_str,
        // $filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    // $tikcet_obj = $ticket_class->read_open_close_graph_close($db);
    $tikcet_arr['close'] = array();
    foreach ($tikcet_obj as $tikcet_row) {
        $tikcet_arr['close'] = array_merge($tikcet_arr['close'], array($tikcet_row));
    }

    echo json_encode($tikcet_arr);
}

function read_active_support_count($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];

    // START
    $user_session = $param['user_session'];
    $brand_access_arr =  $user_session['json_brand'];

    $search = '';
    $offset = '';
    $limit = '';
    $owned_ticket_only = '';

    // Filter by Category
    $filter_category = json_decode($request['filter_category'], true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode($request['filter_status'], true);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';
    // check if has level 1
    // $filter_status_ids_str_null = in_array(1,$filter_status_ids) ? true : false ; 

    // // Filter by final Status
    // $filter_final_status = json_decode($request['filter_final_status'],true);
    // $filter_final_status_ids = array();
    // if(count($filter_final_status) > 0){
    //     $filter_final_status_names = "'" . implode("','", $filter_final_status) . "'";
    //     $status_id_list_obj = $ticket_class->read_ticket_final_status_ids_by_names($filter_final_status_names,$utility_class,$db);
    //     foreach($status_id_list_obj as $status_id_list){
    //         $filter_final_status_ids[] = $status_id_list['id'];
    //     }
    // }
    // $filter_final_status_ids_str = count($filter_final_status_ids) > 0 ? implode(",",$filter_final_status_ids) : '' ;
    //  $filter_escalated_status = array();
    // if(in_array('Escalated (Solve)',$filter_final_status)){
    //     $filter_escalated_status[] = 1;
    // }
    // $filter_escalated_str =  count($filter_escalated_status) > 0 ? implode(",",$filter_escalated_status) : '' ;

    // Filter by priority
    $filter_priority = json_decode($request['filter_priority'], true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';


    $filter_start_date = $request['start_date'];
    $filter_end_date = $request['end_date'];

    $filter_brand_id = $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';


    $tikcet_brand_obj = $ticket_class->read_ticket_list(
        3,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        $filter_status_ids_str,
        // true,//$filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );

    // $tikcet_brand_obj = $ticket_class->read_ticket_active_support_count_per_brand($db);
    $tikcet_brand_arr = array();
    foreach ($tikcet_brand_obj as $tikcet_brand_row) {
        $tikcet_brand_arr = array_merge($tikcet_brand_arr, array($tikcet_brand_row));
    }


    $brand_list_obj = $brand_class->read_brands('', $brand_access_arr, $utility_class, $db);
    $brands = [];
    foreach ($brand_list_obj as $row) {
        $count = 0;
        foreach ($tikcet_brand_arr as $sub_array) {
            if (@$sub_array['id'] == $row['id']) {
                $count =  $sub_array['count'];
            }
        }
        if ($utility_class->isNotEmpty($filter_brand_id)) {
            if ($filter_brand_id == $row['id']) {
                $brands[] = ['id' => $row['id'], 'name' => $row['name'], 'count' => $count];
            }
        } else {
            $brands[] = ['id' => $row['id'], 'name' => $row['name'], 'count' => $count];
        }
    }

    echo json_encode($brands);
}

function update_ticket_type($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $type = $request['type'];
    $ticket_id = $request['ticket_id'];

    $ticket_class->update_ticket_type($ticket_id, $type, $utility_class, $db);

    $json_arr['message'] = "Type updated.";
    $json_arr['status'] = 1;

    echo json_encode($json_arr);
}
function create_ticket_rating($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $user_session = $param['user_session'];
    $request = $param['request'];

    $ticket_id = $request['id'];
    $rating = $request['rating'];

    $progress_id = $ticket_class->read_latest_progress_status_id($ticket_id, $db);

    $ticket_class->create_ticket_rating($user_session['id'], $ticket_id, $progress_id, $rating, $utility_class, $db);

    // loggerr
    $log_data['user_id'] = $user_session['id'];
    $log_data['target_id'] = $ticket_id;
    $log_data['description'] = 'Rate a ticket with ' . $rating . ' stars.';
    //important
    $log_data['type'] = 5; //create ticket
    $log_data['db'] = $db;
    $GLOBALS['logger_class']->log($log_data);

    $json_arr['message'] = "Rated.";
    $json_arr['status'] = 1;

    echo json_encode($json_arr);
}

//view all open tickets
function e9a08ee861a11eca0f900ff70631b9a1($param)
{
    header('Content-type: application/json; charset=utf-8');
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];
    $user_class = $param['user_class'];
    $request = $param['request'];


    //check required parameters 
    if (!isset($request['asa_id'])) {
        $json_arr['message'] = "ASA ID is required.";
        $json_arr['status'] = 0;
        echo json_encode($json_arr);
        exit;
    }
    if (!isset($request['offset'])) {
        $json_arr['message'] = "Offset is required.";
        $json_arr['status'] = 0;
        echo json_encode($json_arr);
        exit;
    }
    if (!isset($request['limit'])) {
        $json_arr['message'] = "Limit is required.";
        $json_arr['status'] = 0;
        echo json_encode($json_arr);
        exit;
    }


    $asa_id  = $request['asa_id'];
    $user_obj  = $user_class->read_user_by_source_id($asa_id, $utility_class, $db);
    $user_arr = array();
    foreach ($user_obj as $user_row) {
        $user_arr = $user_row;
    }

    $where_statement = " AND (u.`id` = " . $user_arr['id'] . ") ";
    $user_class->system_user_security($where_statement, array(), 'main', $utility_class, $db);

    $user_session = $_SESSION['cc_user'];
    $brand_access_arr =  $user_session['json_brand'];

    // print_r($request);exit;

    $search = isset($request['search']) ? $db->escape($request['search']) : '';
    $offset = $request['offset'];
    $limit = $request['limit'];
    $owned_ticket_only = isset($request['owned_ticket_only']) ? $db->escape($request['owned_ticket_only']) : '';

    // Filter by Category
    $filter_category = json_decode(isset($request['filter_category']) ? $request['filter_category'] : "[]", true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode(isset($request['filter_status']) ? $request['filter_status'] : '["On Hold","In Progress"]', true);
    // print_r($filter_status);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';


    // Filter by priority
    $filter_priority = json_decode(isset($request['filter_priority']) ? $request['filter_priority'] : "[]", true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';


    $filter_start_date = isset($request['start_date']) ? $request['start_date'] : '';
    $filter_end_date = isset($request['end_date']) ? $request['end_date'] : '';

    $filter_brand_id = isset($request['filter_brand']) && $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = isset($request['filter_model']) && $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';

    $ticket_list_array = $ticket_class->read_ticket_list(
        1,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        $filter_status_ids_str,
        // $filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );

    $json_arr['total'] = $ticket_list_array[0];
    $ticket_list_obj = $ticket_list_array[1];

    $json_arr['rows'] = array();


    $counter = $request['offset'] + 1;

    foreach ($ticket_list_obj as $row) {
        //  $row = $utility_class->arrayNullToBlank($row);
        $display_name =  $row['firstname'] . ' ' . substr($row['lastname'], 0, 1);
        $json_arr['rows'] = array_merge(
            $json_arr['rows'],
            array(array(
                'no' => $counter++,
                'id' => $row['id'],
                'reference_no' => $row['reference_no'],
                'date' => $row['date_addedw'],
                'datew' => date("F j, Y", strtotime($row['date_addedf'])),
                'category' => $row['sub_category'],
                'vehicle' => $row['brand'] . ' - ' . $row['model'],
                'plate_cs' => $row['plate_cs'],
                'title' => $row['title'],
                'priority' => $row['priority_level'],
                'status' => $row['status'],
                'created_by' => $display_name,
            ))
        );
    }

    echo json_encode($json_arr);
}

//read ticket information
function a135806862111eca0f900ff70631b9a8($param)
{
    header('Content-type: application/json; charset=utf-8');
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    $json['rows'] = array();
    $json['attachments'] = array();

    //check required parameters 
    if (!isset($request['ticket_id'])) {
        $json_arr['message'] = "Ticket ID is required.";
        $json_arr['status'] = 0;
        echo json_encode($json_arr);
        exit;
    }

    $ticket_id = $request['ticket_id'];
    $ticket_info_obj = $ticket_class->read_ticket_information($ticket_id, $utility_class, $db);


    foreach ($ticket_info_obj as $row) {
        $row = $utility_class->arrayNullToBlank($row);

        $display_name =  $row['firstname'] . ' ' . substr($row['lastname'], 0, 1);
        $display_name = ucwords(strtolower($display_name));
        $json['rows'] = array(
            'ticket_subject' => $row['title'],
            'reference_no' => $row['reference_no'],
            'ticket_info' => 'Created by ' . $display_name . ' on ' . $row['date_addedf'],
            'ticket_date_created_by' => $row['date_addedf'],
            'ticket_description' => str_replace("\n", "<br>", $row['description']),
            'ticket_priority' => $row['priority_level'],
            'ticket_category' => $row['sub_category'],
            'kb_category' => $row['sub_category'], /*for kb */
            'kb_posted_date' => $row['date_addedf'], /*for kb */
            'ticket_brand' => $row['brand'],
            'ticket_model' => $row['model'],
            'ticket_mv' => $row['model_variant'],
            'ticket_ym' => $row['year_model'],
            'ticket_plate_cs' => $row['plate_cs'],
            'ticket_vin' => $row['vin'],
            'ticket_mileage' => $row['mileage'] . ' km',
            'ticket_created_by' => $display_name,
            'ticket_workshop_visit' => $row['workshop_visit_count'],
            'ticket_complaint' => str_replace("\n", "<br>", $row['complaint']), //$row['complaint'],
            'ticket_work_done' => str_replace("\n", "<br>", $row['work_performed']), //$row['work_performed'],
            'ticket_fault_codes' => $row['fault_codes'],
            'ticket_status' => $row['ticket_status'],
            'ticket_breakdown' => (intval($row['breakdown']) ? 'Yes' : 'No'),
            'ticket_on_site' => (intval($row['on_site']) ? 'Yes' : 'No'),

            // 'category_id'=>$row['category_id'],
            // 'priority_id'=>$row['priority_level_id'],
            // 'show_vehicle'=>$row['show_vehicle'],
            // 'ticket_type'=>$row['type'],
            // 'ticket_status_id'=>$row['ticket_status_id'],
            'ticket_rating' => $row['rating'],
        );
    }


    $ticket_attach_obj = $ticket_class->read_ticket_attachments($ticket_id, $utility_class, $db);
    foreach ($ticket_attach_obj as $row) {
        $file = dirname(__FILE__) . '/../../../dist/attachments/' . $row['attachment_name'];
        $unreadable_size = (is_file($file) ? filesize($file) : 0);
        $readable_file_size = $utility_class->humanFileSize($unreadable_size);
        $file_ext  = pathinfo($file, PATHINFO_EXTENSION);
        $fa_icon = $utility_class->getFileIcon($file_ext);
        $json['attachments'] = array_merge($json['attachments'], array(array(
            'id' => $row['id'],
            'change_name' => $row['attachment_name'],
            'original_name' => $row['original_name'],
            'date' => $row['date_addedf'],
            'size' => $readable_file_size,
            'unreadable_size' => $unreadable_size,
            'icon' => $fa_icon,
        )));
    }
    echo json_encode($json);
}

//read ticket replies
function fb7a6812864311eca0f900ff70631b9a($param)
{
    header('Content-type: application/json; charset=utf-8');
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $request = $param['request'];
    // $user_session = $param['user_session'];

    $offset = 0; //$request['offset'];
    $limit = 999; //$request['limit'];

    $order = "DESC"; //$request['order'];

    //check required parameters 
    if (!isset($request['ticket_id'])) {
        $json_arr['message'] = "Ticket ID is required.";
        $json_arr['status'] = 0;
        echo json_encode($json_arr);
        exit;
    }

    $ticket_id = $request['ticket_id'];


    $ticket_replies_obj = $ticket_class->read_ticket_replies($ticket_id, $offset, $limit, $order, $utility_class, $db);

    $json['rows'] = array();
    // $json['attachments'] = array();
    foreach ($ticket_replies_obj as $row) {
        $json['rows'] = array_merge($json['rows'], array(array(
            'id' => $row['id'],
            'ticket_id' => $row['ticket_id'],
            'user' => $row['firstname'] . ' ' . $row['lastname'],
            'creator' => ($row['from_user'] == $row['owner_id']) ? ' (Creator)' : '',
            // 'remove'=>($user_session['id'] == $row['from_user']) ? 'Remove' : '' ,
            // 'reply_owner'=>($user_session['id'] == $row['from_user']) ? 1 : 0 , 
            'description' => str_replace("\n", "<br>", $row['description']),
            'ticket_status' => $row['ticket_status'],
            'date_added' => $row['date_addedf'],
        )));
        // $ticket_replies_attachment_obj = $ticket_class->read_ticket_reply_attachments($row['id'],$utility_class,$db);
        // foreach($ticket_replies_attachment_obj as $row){    
        // $json['attachments'] = array_merge($json['attachments'],array(array( 
        //     'id'=>$row['id'],
        //     'reply_id'=>$row['ticket_reply_id'],
        //     'attachment_name'=>$row['attachment_name'],
        //     'original_name'=>$row['original_name'],
        // )));
        // }
    }

    echo json_encode($json);
}

function e1c7b533865c11eca0f900ff70631b9a($param)
{
    $db = $param['db'];
    $utility_class = $param['utility_class'];
    $ticket_class = $param['ticket_class'];
    $user_class = $param['user_class'];
    $request = $param['request'];
    $brand_class = $param['brand_class'];
    $model_class = $param['model_class'];


    $asa_id  = $request['asa_id'];
    $user_obj  = $user_class->read_user_by_source_id($asa_id, $utility_class, $db);
    $user_arr = array();
    foreach ($user_obj as $user_row) {
        $user_arr = $user_row;
    }

    $where_statement = " AND (u.`id` = " . $user_arr['id'] . ") ";
    $user_class->system_user_security($where_statement, array(), 'main', $utility_class, $db);

    $user_session = $_SESSION['cc_user'];
    $brand_access_arr =  $user_session['json_brand'];


    $search = '';
    $offset = '';
    $limit = '';
    $owned_ticket_only = '1';

    // Filter by Category
    $filter_category = json_decode(isset($request['filter_category']) ? $request['filter_category'] : "[]", true);
    $filter_category_ids = array();
    if (count($filter_category) > 0) {
        $filter_category_names = "'" . implode("','", $filter_category) . "'";
        $category_id_list_obj = $ticket_class->read_ticket_sub_category_ids_by_names($filter_category_names, $utility_class, $db);
        foreach ($category_id_list_obj as $category_id_list) {
            $filter_category_ids[] = $category_id_list['id'];
        }
    }
    $filter_category_ids_str = count($filter_category_ids) > 0 ? implode(",", $filter_category_ids) : '';

    // Filter by Status
    $filter_status = json_decode(isset($request['filter_status']) ? $request['filter_status'] : '["On Hold","In Progress"]', true);
    // print_r($filter_status);
    $filter_status_ids = array();
    if (count($filter_status) > 0) {
        $filter_status_names = "'" . implode("','", $filter_status) . "'";
        $status_id_list_obj = $ticket_class->read_ticket_status_ids_by_names($filter_status_names, $utility_class, $db);
        foreach ($status_id_list_obj as $status_id_list) {
            $filter_status_ids[] = $status_id_list['id'];
        }
    }
    $filter_status_ids_str = count($filter_status_ids) > 0 ? implode(",", $filter_status_ids) : '';


    // Filter by priority
    $filter_priority = json_decode(isset($request['filter_priority']) ? $request['filter_priority'] : "[]", true);
    $filter_priority_ids = array();
    if (count($filter_priority) > 0) {
        $filter_priority_names = "'" . implode("','", $filter_priority) . "'";
        $priority_id_list_obj = $ticket_class->read_ticket_priority_ids_by_names($filter_priority_names, $utility_class, $db);
        foreach ($priority_id_list_obj as $priority_id_list) {
            $filter_priority_ids[] = $priority_id_list['id'];
        }
    }
    $filter_priority_ids_str = count($filter_priority_ids) > 0 ? implode(",", $filter_priority_ids) : '';

    $filter_start_date = isset($request['start_date']) ? $request['start_date'] : '';
    $filter_end_date = isset($request['end_date']) ? $request['end_date'] : '';

    $filter_brand_id = isset($request['filter_brand']) && $utility_class->isNotEmpty($request['filter_brand']) ? $brand_class->read_brand_id_by_name($request['filter_brand'], $utility_class, $db) : '';
    $filter_model_id = isset($request['filter_model']) && $utility_class->isNotEmpty($request['filter_model']) ? $model_class->read_model_id_by_name_n_brand_id($filter_brand_id, $request['filter_model'], $utility_class, $db) : '';


    $return_arr['on_hold_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "1", //$filter_status_ids_str,
        // true,//$filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['in_progress_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "2", //$filter_status_ids_str,
        // false,//$filter_status_ids_str_null,
        // $filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['solve_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "3",
        // $filter_status_ids_str_null,
        // 1,//$filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    $return_arr['not_solve_total'] =  $ticket_class->read_ticket_list(
        2,
        $user_session['id'],
        $owned_ticket_only,
        $filter_category_ids_str,
        "4,5",
        // $filter_status_ids_str_null,
        // 2,//$filter_final_status_ids_str,
        // $filter_escalated_str,
        $filter_priority_ids_str,
        $filter_start_date,
        $filter_end_date,
        $filter_brand_id,
        $filter_model_id,
        $brand_access_arr,
        $search,
        $offset,
        $limit,
        $utility_class,
        $db
    );
    // $return_arr['on_hold_total'] =  $ticket_class->read_ticket_count_by_progress(1,$db);
    // $return_arr['in_progress_total'] =  $ticket_class->read_ticket_count_by_progress(2,$db);
    // $return_arr['solve_total'] =  $ticket_class->read_ticket_count_by_final_status(1,$db);
    // $return_arr['not_solve_total'] =  $ticket_class->read_ticket_count_by_final_status(2,$db);

    echo json_encode($return_arr);
}
