-- MySQL dump 10.13  Distrib 8.0.24, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: autoph_golf
-- ------------------------------------------------------
-- Server version	8.0.29

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `golf_clubs`
--

DROP TABLE IF EXISTS `golf_clubs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_clubs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_clubs`
--

LOCK TABLES `golf_clubs` WRITE;
/*!40000 ALTER TABLE `golf_clubs` DISABLE KEYS */;
INSERT INTO `golf_clubs` VALUES (1,'WACK WACK',1),(2,'ALTA VISTA',1),(3,'PHIL. NAVY GOLF CLUB',1),(4,'STA. ELENA',1),(5,'FOREST HILLS',1),(6,'TAGAYTAY MIDLANDS',1),(7,'RIVIERA GOLF',1),(8,'RIVIERA',1),(9,'EAGLE RIDGE',1),(10,'KEPPEL SINGAPORE',1),(11,'ORCHARD',1),(12,'MANILA SOUTHWOORDS',1),(13,'EAST RIDGE',1),(14,'GOLF PH',1),(15,'ALABANG',1),(16,'MANILA SOUTHWOODS',1),(17,'SUMMIT POINT',1),(18,'TAGAYTAY HIGHLANDS',1),(19,'ALABANG COUNTRY CLUB',1),(20,'SOUTHLINKS GC',1),(21,'SOUTHWOODS',1),(22,'VETERANS GOLF',1),(23,'CAMP AGUINALDO',1),(24,'ROYAL NORTHWOODS',1),(25,'MT. MALARAYAT',1),(26,'VALLEY GOLF',1),(27,'ANVAYA COVE',1),(28,'MIDLANDS',1),(29,'AGUINALDO',1),(30,'AYALA GREENFIELDS',1),(31,'CLUB INTRAMUROS',1),(32,'NOMADS GC',1),(33,'N/A',1),(34,'VILLAMOR GOLF',1),(35,'APO',1),(36,'DOLE KALSANGI',1),(37,'SHERWOOD HILLS',1),(38,'SOUTH LINKS',1),(39,'CANLUBANG GOLF',1),(40,'MIMOSA',1),(41,'BEVERLY PLACE GOLF CLUB',1),(42,'ROYALE TAGAYTAY',1),(43,'NOMADS GOLF CLUB',1),(44,'SPLENDIDO',1),(45,'SOUTH FORBES',1),(46,'BEVERLY PLACE',1),(47,'ANVAYA',1),(48,'PHIL NAVY GOLF',1),(49,'PHIL. ARMY GOLF',1),(50,'APO GOLF',1),(51,'PUEBLO DE ORO',1),(52,'GOLF MANITOBA',1),(53,'SOUTHLINKS',1),(54,'PHIL. NAVY GOLF',1),(55,'VILLAMOR',1),(56,'CAMP JOHN HAY',1),(57,'CALATAGAN GOLF',1),(58,'MANILA GOLF',1),(59,'EAGLE RIDGE/SOUTHWOODS',1);
/*!40000 ALTER TABLE `golf_clubs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_companies`
--

DROP TABLE IF EXISTS `golf_companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_companies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_companies`
--

LOCK TABLES `golf_companies` WRITE;
/*!40000 ALTER TABLE `golf_companies` DISABLE KEYS */;
INSERT INTO `golf_companies` VALUES (1,'ASIAN HOSPITAL',1),(2,'AYALA LAND',1),(3,'JMK-09 CONSTRUCTION',1),(4,'BANKERS ASSOCIATION OF THE PHILS.',1),(5,'MOREBUILDERS INC.',1),(6,'FORT BONIFACIO DEV\'T CORP.',1),(7,'PRESIDENT',1),(8,'VP',1),(9,'BPMS FRANCHISE CORP',1),(10,'RMBC',1),(11,'JCTA CONST. & DEV. CORP.',1),(12,'WOW SAMGYUP - TAGAYTAY',1),(13,'COASTWISE LITHERAGE CORP.',1),(14,'CYMATIC ASIA',1),(15,'LIONKING INDL CORP',1),(16,'MAA ASSURANCE',1),(17,'LUCKYU, INC.',1),(18,'PAGCOR',1),(19,'PETROBULK MARITIME SERVICES INC.',1),(20,'RRS ELECTRIC CORPORATION',1),(21,'JASANE INC.',1),(22,'RCC GLOBAL ENTERTAINMENT INC',1),(23,'GMMANINGAS CONST',1),(24,'MONDE NISSIN CORP.',1),(25,'ROCKOIL TRADING',1),(26,'GTS',1),(27,'KLEAN ATHLETE',1),(28,'SM CINEMA',1),(29,'VILLA & CRUZ ATTORNEYS-AT-LAW',1),(30,'KING JORGE CAR CARE SPECIALIST',1),(31,'TEXTILE MILLS CORP.',1),(32,'GLAZINUM GLASS CORP.',1),(33,'VERCIDE ENGINEERING',1),(34,'SUMITOMO CORP.',1),(35,'SAMGLO TRADING',1),(36,'FUJI ZIPPER INC.',1),(37,'BOAC MARKETING',1),(38,'ASCOTT LIMITED',1),(39,'ASIA LINK CARGO PHILS., INC.',1),(40,'1024 CONSTRUCTION & DEVT CORP ',1),(41,'SBF RENTAL SERVICES',1),(42,'KARLIVAN MDSG. ',1),(43,'TITAN AD TECH., INC.',1),(44,'DMJ FILTECH',1),(45,'REDACHEM INGREDIENTS PHILIPPINES, INC. ',1),(46,'PNB SECURITIES',1),(47,'CLOUDIAN, INC.',1),(48,'UCPB GEN. INSURANCE CO., INC.',1),(49,'ADB',1),(50,'CRESTWELL MARKETING CORP.',1),(51,'PRO-VET INTERNATIONAL CORP.',1),(52,'AEGILSPORTS ',1),(53,'TIM ENGINEERING SYSTEMS SOLUTIONS CORP.',1),(54,'WESTERN UNION PROCESSING SERVICES INC. ',1),(55,'VELA TERRACES ',1),(56,'DOCTOR',1),(57,'THE DIY HARDWARE ',1),(58,'SAN MIGUEL CORP ',1),(59,'PHILASPHALT DEV\'T CORP',1),(60,'RETIRED',1),(61,'GSIS',1),(62,'RCBC BANK',1),(63,'AREZA GROUP OF COMPANIES',1),(64,'GLOBAL KONSTRUCTION',1),(65,'ONE LINQ SOLUTIONS INC.',1),(66,'SOCOTEC CERTIFICATION PHILS. INC.',1),(67,'ABS-CBN',1),(68,'ZARK\'S BURGER',1),(69,'VESPA PASIG ',1),(70,'MARIGOLD MANUFACTURING CORP.',1),(71,'POWER STROKE MOTOR PRODUCTS CORP.',1),(72,'OKADA MANILA',1),(73,'JCBJ TRADING & CONTSRUCTION',1),(74,'GMJ CONSTRUCTION',1),(75,'RIX-GROUP',1),(76,'MACROASIA CORP',1),(77,'MENLO HEALTH & WELLNESS INNOVATIONS, INC.',1),(78,'PRIALTO',1),(79,'FUTURA WINDOW DéCOR PRODS.',1),(80,'NGCP',1),(81,'FREE',1),(82,'I-CONSTECH CORP',1),(83,'LAGUNA TECHNO PARK ASSOCIATION INC',1),(84,'GREENPRO AIR  CONDITIONING SYSTEM',1),(85,'CABALCE ELECTRICAL CONSTRUCTOR INC.',1),(86,'MOBILECT POWER CORP.',1),(87,'J. E. MANALO & CO., INC.STA. CLARA INTERNATIO',1),(88,'CYCON INC',1),(89,'N.C. PASTOR CONSTRUCTION',1),(90,'REVILO BUILDERS ARCHITECTURAL & ENGINEERING S',1),(91,'ALVEZ COMMERCIAL INC.',1),(92,'PILIPINAS SHELL PETROLEUM CORPORATION',1),(93,'SHELL',1),(94,'EASTWEST BANK',1),(95,'TRUCKING LOGISTICS',1),(96,'GLOBAL CREATIVE MULTIMEDIA ADVERTISING',1),(97,'YULON FINANCE PHILIPPINES CORPORATION',1),(98,'HONG TAI NETWORK SERVICE',1),(99,'KENSHIN JAPANESE IZAKAYA RESTAURANT COMPANY',1),(100,'ACCESS TRIP TRANSPORT SERVICE',1),(101,'EYELECTRIC INC',1),(102,'SPI SEMICON ASIA INC',1),(103,'JETCLUB',1),(104,'MEYADO',1),(105,'RFM CORPORATION',1),(106,'INTERPACIFIC JADE',1),(107,'SECURITY BANK',1),(108,'SB CAPITAL INVESTMENT CORPORATION',1),(109,'CREATIVESPARX INC.',1),(110,'BEER BELOW ZERO',1),(111,'MANGO REMITTANCE C U PHILS. INC',1),(112,'DE OCAMPO MEMORIAL COLLEGE INC',1),(113,'GLOBE',1),(114,'BPI FAMILY SAVINGS BANK INC.',1),(115,'SMARTCOAT CONSTRUCTION & SERVICES',1),(116,'BLS INTERNATIONAL VISA SERVICES PHILIPPINES I',1),(117,'BAMBU CAFE',1),(118,'ANIMO ,MAGAZINE',1),(119,'BOY KANIN',1),(120,'LA BANCA CRUISE',1),(121,'AT LAGMAY LAW OFFICE',1),(122,'PRADERA SENIORS',1),(123,'LAGRISOLA CONST.',1),(124,'INKFINITEC PRINTING',1),(125,'FUTURA WINDOW D?COR PRODS.',1);
/*!40000 ALTER TABLE `golf_companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_courses`
--

DROP TABLE IF EXISTS `golf_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_courses`
--

LOCK TABLES `golf_courses` WRITE;
/*!40000 ALTER TABLE `golf_courses` DISABLE KEYS */;
INSERT INTO `golf_courses` VALUES (1,'Norman',1),(2,'Faldo',1);
/*!40000 ALTER TABLE `golf_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_divisions`
--

DROP TABLE IF EXISTS `golf_divisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_divisions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_divisions`
--

LOCK TABLES `golf_divisions` WRITE;
/*!40000 ALTER TABLE `golf_divisions` DISABLE KEYS */;
INSERT INTO `golf_divisions` VALUES (1,'Player',1),(2,'Sponsor',1);
/*!40000 ALTER TABLE `golf_divisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_events`
--

DROP TABLE IF EXISTS `golf_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(95) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_events`
--

LOCK TABLES `golf_events` WRITE;
/*!40000 ALTER TABLE `golf_events` DISABLE KEYS */;
INSERT INTO `golf_events` VALUES (1,'101010 2022',NULL,1);
/*!40000 ALTER TABLE `golf_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_other_infos`
--

DROP TABLE IF EXISTS `golf_player_other_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_other_infos` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `player_id` bigint DEFAULT NULL,
  `event_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `flight_user_id` bigint DEFAULT NULL,
  `index` varchar(100) DEFAULT NULL,
  `hcdp` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_player_other_infos_fk1_idx` (`player_id`),
  KEY `golf_player_other_infos_fk3_idx` (`flight_user_id`),
  KEY `golf_player_other_infos_fk4_idx` (`event_id`),
  CONSTRAINT `golf_player_other_infos_fk1` FOREIGN KEY (`player_id`) REFERENCES `golf_players` (`id`),
  CONSTRAINT `golf_player_other_infos_fk3` FOREIGN KEY (`flight_user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_player_other_infos_fk4` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_other_infos`
--

LOCK TABLES `golf_player_other_infos` WRITE;
/*!40000 ALTER TABLE `golf_player_other_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_player_other_infos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_status`
--

DROP TABLE IF EXISTS `golf_player_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_status` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_status`
--

LOCK TABLES `golf_player_status` WRITE;
/*!40000 ALTER TABLE `golf_player_status` DISABLE KEYS */;
INSERT INTO `golf_player_status` VALUES (1,'Invited ',1),(2,'Paid ',1),(3,'Unpaid',1),(4,'Disable',1);
/*!40000 ALTER TABLE `golf_player_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_players`
--

DROP TABLE IF EXISTS `golf_players`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_players` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `year` int DEFAULT NULL,
  `course_id` bigint DEFAULT NULL,
  `team_id` bigint DEFAULT NULL,
  `division_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `course` varchar(45) DEFAULT NULL,
  `flight` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_players_fk1_idx` (`course_id`),
  KEY `golf_players_fk2_idx` (`division_id`),
  KEY `golf_players_fk3_idx` (`team_id`) /*!80000 INVISIBLE */,
  KEY `golf_players_fk4_idx` (`user_id`),
  CONSTRAINT `golf_players_fk1` FOREIGN KEY (`course_id`) REFERENCES `golf_courses` (`id`),
  CONSTRAINT `golf_players_fk2` FOREIGN KEY (`division_id`) REFERENCES `golf_divisions` (`id`),
  CONSTRAINT `golf_players_fk3` FOREIGN KEY (`team_id`) REFERENCES `golf_teams` (`id`),
  CONSTRAINT `golf_players_fk4` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_players`
--

LOCK TABLES `golf_players` WRITE;
/*!40000 ALTER TABLE `golf_players` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_players` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_positions`
--

DROP TABLE IF EXISTS `golf_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_positions`
--

LOCK TABLES `golf_positions` WRITE;
/*!40000 ALTER TABLE `golf_positions` DISABLE KEYS */;
INSERT INTO `golf_positions` VALUES (1,'DOCTOR',1),(2,'PROJECT MANAGER',1),(3,'GM',1),(4,'CONSULTANT',1),(5,'PRESIDENT',1),(6,'SR. MANAGER/HEAD, COMMERCIAL BUSINESS GROUP',1),(7,'PRADERA SENIORS',1),(8,'VP',1),(9,'MANAGER',1),(10,'RETIRED',1),(11,'DIRECTOR',1),(12,'PRESIDENT/CEO',1),(13,'CEO',1),(14,'SVP',1),(15,'MANAGING DIRECTOR',1),(16,'DIRECTOR/ADMIN MANAGER',1),(17,'CHIEF OF OPERATIONS',1),(18,'VP OPERATIONS',1),(19,'KAM',1),(20,'SR. MANAGER',1),(21,'PARTNER',1),(22,'OWNER',1),(23,'SOO',1),(24,'COUNTRY MANAGER',1),(25,'ACTOR',1),(26,'DIR. OF SALES & MARKETING',1),(27,'PROPRIETOR',1),(28,'FWD LIFE INSURANCE',1),(29,'CAPT.',1),(30,'TREASURER',1),(31,'PRESIDENT/GM',1),(32,'HEAD OF BUSINESS DEVELOPMENT ',1),(33,'GENERAL MANAGER',1),(34,'INDEPENDENT DIRECTOR',1),(35,'BOARD MEMBER',1),(36,'EVP/CONSUMER LENDING GROUP HEAD ',1),(37,'SVP/ DIVISION HEAD PRODUCT MARKETING HEAD FOR',1),(38,'CHAIRMAN',1),(39,'FRANCHISEE',1),(40,'ADMIN MANAGER',1),(41,'DIRECTOR-LOYALTY MARKETING',1),(42,'AVP, PREMIUM MARKERING',1),(43,'OWNER/PRESIDENT',1),(44,'PRESIDENT/COO',1),(45,'COUNTRY GM',1),(46,'VP- HEAD OF INTERNAL AUDIT',1),(47,'PRESIDENT / CEO',1),(48,'AREA MANAGER ',1),(49,'ARCHITECT',1),(50,'ENGINEER',1),(51,'CONTRACTOR',1),(52,'CUSTOMER OPERATIONS EXCELLENCE MANAGER',1),(53,'SUPPLY OPERATIONS MANAGER',1),(54,'BUSINESS MANAGER',1),(55,'RT COMPLIANCE EXECUTIVE',1),(56,'SHELL',1),(57,'SAVP',1),(58,'VP+HEAD - CLC SR SALES',1),(59,'SAVP+HEAD - TELESALES, CARD ACTIVATION, AND S',1),(60,'SAVP+HEAD - CLC TELEMARKETING SALES CHANNEL',1),(61,'STORE MANAGER',1),(62,'AVP+HEAD, BANCASSURANCE',1),(63,'PRESIDENT AND CEO',1),(64,'VICE PRESIDENT - SALES DIVISION',1),(65,'BUSINESSMAN',1),(66,'DIRECTOR OF SALES',1),(67,'VP + HEAD OPERATIONS + SUPPLY CHAIN',1),(68,'KEY ACCOUNT MANAGER',1),(69,'HEAD, CMS SALES & SERVICE DELIVERY',1),(70,'VP-OPERATIONS',1),(71,'CLUSTER HEAD',1),(72,'VP / GROUP HEAD',1),(73,'SENIOR MANAGER / TEAM HEAD',1),(74,'AVP/DIVISION HEAD',1),(75,'MARKETING HEAD',1),(76,'CHMAN',1),(77,'PRES & GM',1),(78,'LINE MANAGER',1);
/*!40000 ALTER TABLE `golf_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_modules`
--

DROP TABLE IF EXISTS `golf_sms_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_modules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_modules`
--

LOCK TABLES `golf_sms_modules` WRITE;
/*!40000 ALTER TABLE `golf_sms_modules` DISABLE KEYS */;
INSERT INTO `golf_sms_modules` VALUES (1,'101010 Invitation');
/*!40000 ALTER TABLE `golf_sms_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_report`
--

DROP TABLE IF EXISTS `golf_sms_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_report` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sms_settings_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `target_id` bigint DEFAULT NULL,
  `event_id` bigint DEFAULT NULL,
  `response` text,
  PRIMARY KEY (`id`),
  KEY `golf_sms_report_fk1_idx` (`sms_settings_id`),
  KEY `golf_sms_report_fk2_idx` (`event_id`),
  CONSTRAINT `golf_sms_report_fk1` FOREIGN KEY (`sms_settings_id`) REFERENCES `golf_sms_settings` (`id`),
  CONSTRAINT `golf_sms_report_fk2` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_report`
--

LOCK TABLES `golf_sms_report` WRITE;
/*!40000 ALTER TABLE `golf_sms_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_sms_report` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_settings`
--

DROP TABLE IF EXISTS `golf_sms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_settings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `module_id` bigint DEFAULT NULL,
  `schedule` varchar(100) DEFAULT NULL,
  `message_header` text,
  `message_body` text,
  `message_footer` text,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_sms_settings_fk1_idx` (`module_id`),
  CONSTRAINT `golf_sms_settings_fk1` FOREIGN KEY (`module_id`) REFERENCES `golf_sms_modules` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_settings`
--

LOCK TABLES `golf_sms_settings` WRITE;
/*!40000 ALTER TABLE `golf_sms_settings` DISABLE KEYS */;
INSERT INTO `golf_sms_settings` VALUES (1,1,NULL,NULL,'Join the 10th 10-10-10 Fun Charity Golf Tournament!\n\nDate: October 10, 2022 (Monday)\nVenue: The Orchard Golf & Country Club, Cavite\n\nPLAYERS DIVISION:\nTeam Registration Fee: Php 10,000.00 ( 1 team of 2 players)\n\nFor more details please call/sms: \n\nJOHN CHAN(Players Division)\nMobile: 0917-807-4768\n\nMAE VALDEZ(Sponsors Division)\nMobile: 0920-955-7999\nEmail: 101010-fungolf@autohubgroup.com\n\nThank you and see you there!\n\n-- Willy Tee Ten',NULL,1);
/*!40000 ALTER TABLE `golf_sms_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_teams`
--

DROP TABLE IF EXISTS `golf_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_teams` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_teams`
--

LOCK TABLES `golf_teams` WRITE;
/*!40000 ALTER TABLE `golf_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users`
--

DROP TABLE IF EXISTS `golf_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `firstname` varchar(95) DEFAULT NULL,
  `middlename` varchar(95) DEFAULT NULL,
  `lastname` varchar(95) DEFAULT NULL,
  `mobile` varchar(45) DEFAULT NULL,
  `email` varchar(95) DEFAULT NULL,
  `other_mobile` varchar(45) DEFAULT NULL,
  `other_email` varchar(95) DEFAULT NULL,
  `username` varchar(45) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `is_admin` tinyint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `company_id` bigint DEFAULT NULL,
  `position_id` bigint DEFAULT NULL,
  `active` tinyint DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `unhs_id` varchar(95) DEFAULT NULL,
  `club_id` bigint DEFAULT NULL,
  `handicap` varchar(95) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index5` (`firstname`,`lastname`,`mobile`),
  KEY `golf_users_fk1_idx` (`club_id`),
  KEY `golf_users_fk2_idx` (`company_id`),
  KEY `golf_users_fk3_idx` (`position_id`),
  CONSTRAINT `golf_users_fk1` FOREIGN KEY (`club_id`) REFERENCES `golf_clubs` (`id`),
  CONSTRAINT `golf_users_fk2` FOREIGN KEY (`company_id`) REFERENCES `golf_companies` (`id`),
  CONSTRAINT `golf_users_fk3` FOREIGN KEY (`position_id`) REFERENCES `golf_positions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=761 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users`
--

LOCK TABLES `golf_users` WRITE;
/*!40000 ALTER TABLE `golf_users` DISABLE KEYS */;
INSERT INTO `golf_users` VALUES (1,'Clarence','Acedera','Andaya','9389592854','clarenceandaya8@gmail.com',NULL,NULL,'clrkz','$2y$10$WllXm6G1LKwuzyocGyjrWe04DmUbRGXDnsyH3Fmt.IYawAHVZdmuW',1,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(2,'LORENCIO',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.1/UNHS SEPT.'),(3,'ADAMSON',NULL,'GO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'NH/UNHS.PH/MANDATORY 10'),(4,'RAMON',NULL,'GARCIA JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'23.9/SEPT UNHS'),(5,'EDWIN',NULL,'BERMUDEZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'--------'),(6,'ERICH',NULL,'LINGAD',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.0 / SEPT UNHS'),(7,'JOO YOUNG',NULL,'LEE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'14.9/SEPT UNHS'),(8,'ORLANDO',NULL,'MANINGAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17/SEPT. UNHS'),(9,'EDWIN',NULL,'ABESAMIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  10.70 '),(10,'VICTOR',NULL,'VITAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17.7/ SEPT UNHS'),(11,'MARK',NULL,'SAMBAR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'23.4/ SEPT. UNHS'),(12,'ARIEL \"HYUBS\"',NULL,'AZARCON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(13,'ZANJO',NULL,'MARUDO  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'28.0/ NOT UNHS/MANDATORY 10'),(14,'JAYSON',NULL,'GAINZA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(15,'RAMIL',NULL,'BERNARDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(16,'GENE',NULL,'DE JESUS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'19/ SEPT UNHS'),(17,'DON',NULL,'DE JESUS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.40 '),(18,'ABRAHAM \"DODIE\"',NULL,'CABASAL ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'18.3/ UNHS SEPT.'),(19,'JEFFREY',NULL,'DY TAN ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  8.30 '),(20,'DON DON',NULL,'DE GUZMAN ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'NH/UNHS.PH'),(21,'JERRY',NULL,'YBANEZ ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(22,'BENITO',NULL,'DE LEON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.3/ SEPT UNHS.PH'),(23,'MANOLO \"MOLLIE\"',NULL,'ANTONIL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'12.9/SEPT. UNHS.PH'),(24,'EMMANUEL \"MANNIE\"',NULL,'ALCANTARA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'26.0/SEPT. UNHS'),(25,'WINSTON \"WINNIE\"',NULL,'CHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'27.7/ SEPT. UNHS'),(26,'JEFFERSON',NULL,'BONGAT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(27,'ULYSSES',NULL,'GARCES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'NH/UNHS.PH'),(28,'RICKY',NULL,'TY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(29,'GRAHAM',NULL,'HARRIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.6/SEPT.UNHS'),(30,'DINDO',NULL,'REYES  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.50 '),(31,'WILLIAM',NULL,'SEGUN ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  10.00 '),(32,'JOSEPH',NULL,'ARGUELLES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'7/ SEPT. UNHS'),(33,'ROEL',NULL,'RODOLFO  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'18.4/SEPT. UNHS'),(34,'MARK ANTHONY',NULL,'SULTAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'20.5/SEPT. UNHS'),(35,'JOHNNY',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'24.8/SEPT. UNHS'),(36,'RONILO \"RONNIE\"',NULL,'OLAGUERA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  13.00 '),(37,'STEVE',NULL,'JARVIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.30 '),(38,'CHRISTIAN',NULL,'LOZANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  8.60 '),(39,'JUN',NULL,'LACSON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  19.20 '),(40,'EMILIANO \"EMIL\"',NULL,'JOVEN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'13.7/SEPT. UNHS'),(41,'RICHARD',NULL,'ALBANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'19.0/ AUG. UNHS'),(42,'GLENN',NULL,'CHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(43,'RODNEY',NULL,'DIZON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'10.4/SEPT. UNHS'),(44,'EPHRAIM',NULL,'DEL ROSARIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'23.6/ AUG. UNHS'),(45,'EXEQUIEL',NULL,'DELGADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:10',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'NH/UNHS.PH'),(46,'DENNIS',NULL,'CHAN ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'12.7/ SEPT. UNHS'),(47,'JESS',NULL,'CABEL  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  14.40 '),(48,'JOHNNY',NULL,'SHEW ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(49,'MATTHEW',NULL,'BAXTER ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'9.5 /SEPT. UNHS'),(50,'JOSE ROMAN',NULL,'MAGAT II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'18.7/ SEPT. UNHS'),(51,'MICHAEL',NULL,'AQUINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17.7/ AUG. UNHS'),(52,'JOSEPH',NULL,'DE GUZMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'36/ SEPT. UNHS'),(53,'CLARO',NULL,'ARRIOLA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'29.4/ SEPT. UNHS'),(54,'ALEX',NULL,'TY  /  (1 FLIGHT)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  23.50 '),(55,'HERBERT',NULL,'HUIT  /  (1 FLIGHT)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(56,'JOCSON',NULL,'GAN  /  (1 FLIGHT)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'10.1R'),(57,'PAUL',NULL,'GRUBA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'10.6R'),(58,'ERWIN',NULL,'DE LA CRUZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'16.7/ SEPT. UNHS'),(59,'JOSEPH \"BUDDY\"',NULL,'MADRIGAL ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.2/SEPT. UNHS'),(60,'FRANCIS',NULL,'GO  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  24.00 '),(61,'JAKE',NULL,'ONG  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.00 '),(62,'DANILO \"DONNIES\"',NULL,'ALAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'22.9/ SEPT UNHS'),(63,'DAVID',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'20.5/ SEPT UNHS'),(64,'CONG. REYNALDO',NULL,'UMALI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  20.20 '),(65,'JAN JOSEPH',NULL,'UMALI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(66,'JOSELITO \"JOEY\"',NULL,'BAINGAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'16.9/ SEP UNHS'),(67,'RENE CHESTER',NULL,'PANGAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(68,'MARK ANTHONY',NULL,'MEDINA ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17.2/ SEPT UNHS'),(69,'MARLON',NULL,'BORBON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'23.7/ SEPT. UNHS'),(70,'MELVIN',NULL,'CARLOS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'15.3/SEPT. UNHS'),(71,'JOHN EDRIC',NULL,'GARCIA ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  27.10 '),(72,'CHEOK PIN',NULL,'LEE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'26.9/SEPT. UNHS'),(73,'ALAN',NULL,'CHNG  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  23.00 '),(74,'OH LOCK',NULL,'SOON  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(75,'JOAQUIN \"JOAO\"',NULL,'GANCAYCO  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  21.50 '),(76,'CRISPIN',NULL,'TORRES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(77,'ZALDY',NULL,'VILLA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'4.7/ SEPT. UNHS'),(78,'ISABELO',NULL,'AFRICA ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'23.7/SEPT. UNHS'),(79,'RICHIE',NULL,'HERRERA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(80,'DONAVAN',NULL,'YU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.2/ SEPT. UNHS'),(81,'ROD',NULL,'PEREZ ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  16.10 '),(82,'ALLEN RAYMOND',NULL,'QUA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'21.8/SEPT UNHS'),(83,'ANTHONY',NULL,'ATENDIDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'22.0/SEPT. UNHS'),(84,'ELPIDIO \"JUN\"',NULL,'PAGADOR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'13.5/SEPT. UNHS'),(85,'DANNY',NULL,'BATINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'24.6/SEPT. UNHS'),(86,'TIMOTHY',NULL,'GO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'10.1/SEPT. UNHS'),(87,'RAYMOND',NULL,'CO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'5.2/SEPT. UNHS'),(88,'RUDY',NULL,'RAGRAGIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17.9/ SEPT. UNHS'),(89,'ROLANDO',NULL,'TOLORES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'16.1/ SEPT. UNHS'),(90,'DANILO',NULL,'MONTENEJO JR. ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'NH/UNHS.PH'),(91,'VICTORINO',NULL,'FELIPE JR. ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(92,'ARNEL',NULL,'RACADIO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'18.2/UNHS SEPT'),(93,'DANILO',NULL,'SEBASTIAN - REYES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'16.3/UNHS SEPT'),(94,'GERARD',NULL,'CARIASO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  23.80 '),(95,'JOSEPH EVEREST',NULL,'BUNGAY ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.90 '),(96,'LEONIDES',NULL,'TAGLE JR. ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'14.9/UNHS SEPT'),(97,'JAY',NULL,'VALDEZ  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'12.6/UNHS SEPT'),(98,'NEMESIO',NULL,'PAGTAKHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'12.2/UNHS SEPT'),(99,'BENJAMIN',NULL,'BATHAN JR.  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'22.6/UNHS SEPT'),(100,'GINO',NULL,'BONIFACIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(101,'VIC',NULL,'AGU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(102,'ALBERT',NULL,'GARCIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(103,'REX LUIS',NULL,'GOQUINGCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  10.00 '),(104,'CARL VINCENT',NULL,'ADAO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(105,'ENRICO RAPHAEL',NULL,'NACINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  20.10 '),(106,'AUGUSTO',NULL,'LAGMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  20.40 '),(107,'REX',NULL,'DRILON II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  13.10 '),(108,'ROMEO',NULL,'CHONG ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  13.80 '),(109,'JOSE RAULITO',NULL,'PARAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.30 '),(110,'JASON',NULL,'PORCIUNCULA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  17.50 '),(111,'SAMUEL',NULL,'BALTAZAR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  19.60 '),(112,'DANILO',NULL,'ROLEDA (VERBAL)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  13.30 '),(113,'RAUL',NULL,'CORRO   (VERBAL)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.70 '),(114,'DEXTER',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'15.3/ SEPT UNHS'),(115,'CHRISTOPHER',NULL,'OCAMPO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'20.7/ SEPT UNHS'),(116,'HUBERT',NULL,'BARLIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.00 '),(117,'JULIUS',NULL,'TEJADA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  27.10 '),(118,'ENRICO \"ERIC\"',NULL,'TENSUAN  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  12.30 '),(119,'ROBERT GERALD',NULL,'NAZAL II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  14.60 '),(120,'EDUARD',NULL,'JOSE ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  24.30 '),(121,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(122,'JONG',NULL,'ARCANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.30 '),(123,'DOROTEO  \"TEY\"',NULL,'SORNET  ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  16.20 '),(124,'STANLEY',NULL,'CHUA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  22.30 '),(125,'WASHINGTON',NULL,'ONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  19.00 '),(126,'CESAR',NULL,'MONTANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(127,'RICO',NULL,'TOLENTINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.60 '),(128,'ROSETEN',NULL,'TUGAFF',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  7.10 '),(129,'ALEJANDRO',NULL,'DANGANAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  22.00 '),(130,'GABRIEL',NULL,'NOCUM JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  13.40 '),(131,'EFREN',NULL,'DE LEON ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  10.20 '),(132,'CLEMENT',NULL,'CHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  19.90 '),(133,'EUGENIO',NULL,'CHEUNG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  17.20 '),(134,'SAMUEL',NULL,'GAN NASIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  14.60 '),(135,'RAOUL MICHAEL',NULL,'VIRAY JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  15.70 '),(136,'RICHARD JAY',NULL,'LISTA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  17.40 '),(137,'ROBBIE',NULL,'DINGLASAN III',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.90 '),(138,'ROLANDO',NULL,'BOOL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  12.10 '),(139,'DENNIS',NULL,'LAMUG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  18.70 '),(140,'RAMON',NULL,'GARCIA JR.','9178421888',NULL,'9209721888',NULL,NULL,NULL,NULL,'2022-07-15 13:06:19',NULL,NULL,NULL,NULL,1,1,NULL,1,'  23.60 '),(141,'MITSUHIRO',NULL,'HIGASHIDA',NULL,'MHIGASHIDA@KENKOTOKINA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:19',NULL,NULL,NULL,NULL,1,1,NULL,2,'  14.60 '),(142,'REUBEN',NULL,'LISTA JR.','9178930858','RLISTAJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'  17.30 '),(143,'REUJENSON',NULL,'LISTA','9175839225','REUJEN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'  18.70 '),(144,'RICHARD JAY',NULL,'LISTA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'  18.70 '),(145,'RYAN',NULL,'CRUZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:20',NULL,NULL,NULL,NULL,1,1,NULL,4,'  19.80 '),(146,'ATTY. DANILO',NULL,'ROLEDA','9189259833','ROLEDAD@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:20',NULL,NULL,NULL,NULL,1,1,NULL,5,'  13.70 '),(147,'RICHARD',NULL,'LIMCACO','9198840032','RTLIMCACO@YAHOO.CON',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:20',NULL,NULL,NULL,NULL,1,1,NULL,6,'  21.70 '),(148,'MICHAEL',NULL,'DEL MORAL','9173083384','MDELMORAL@FPGINS.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:20',NULL,NULL,NULL,NULL,1,1,NULL,7,'  18.60 '),(150,'ELPIDIO \"JUN\"',NULL,'PAGADOR','9178005598','RABORARJAYPEE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,'21267',5,'  16.60 '),(151,'DANNY',NULL,'BATINO','9178828847','CONTI.BEN03@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,9,'  23.70 '),(152,'DENNIS',NULL,'CHAN','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,21,'11.2'),(153,'ADAM',NULL,'GLEW',NULL,'ADAM.GLEW@BULWELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(154,'PAUL HARVEY',NULL,'CAMPOSANO','9178133488','HARVEYCAMPOSANO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(155,'PAULO',NULL,'GONZALES','9175531581','PAUGONZI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(156,'CHARLES',NULL,'MERIOLES','9088512456','CMERIOLES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(157,'LOCK SOON',NULL,'OH ','9178706868','ISOH58@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:21',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(158,'ERICH',NULL,'LINGAD','9178310608','ERICH@MOVEITPH.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,11,'  19.50 '),(159,'JOO YOUNG',NULL,'LEE',NULL,'JYLEE@HANJIN.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,12,'  15.60 '),(160,'ATTY. CONSTANTINO \"BANJO\"',NULL,'NAVARRO','9175292360','NAVARROLAWPH@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,13,'  18.50 '),(161,'EDGARDO',NULL,'BROCAL','9178131860','EMB.BUILDERS.INC@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,2,'  16.40 '),(162,'RODOLFO \"BONG\"',NULL,'BROBIO','9177916835','RVBROBIO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,5,'  3.40 '),(163,'NOEL',NULL,'BONGAT','9178588816',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,5,'  16.10 '),(164,'LORENCIO',NULL,'LIM','9989555262','LOCHITRDG@YAHOO.COM','9088794708',NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,5,'20.8'),(165,'DEXTER',NULL,'LIM ','9188338833','DEXYULIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:22',NULL,NULL,NULL,NULL,1,1,NULL,11,'FOREST = 18.2'),(166,'EMMANUEL \"MANNIE\"',NULL,'ALCANTARA','9178948143','ECA@ECALCANTARALAW.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,15,'  29.10 '),(167,'RAMON',NULL,'DIZON','9178948163','RAMON.D.DIZON@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,16,'  27.20 '),(168,'LAURO  \"ROBBIE\"',NULL,'LEVISTE  II','9178318331','LAUROLEVISTE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,17,'  27.70 '),(169,'DAN',NULL,'SALVADOR III','9178480605','JON2SALVADOR@YAHOO.COM','9989572037',NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,18,'  4.70 '),(170,'CRISPIN \"CRIS\"',NULL,'CARREON','9178870467','CRIS.CARREON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,19,'  11.30 '),(171,'FERDINAND  \"FERDI\"',NULL,'YU','9178317878','FERDIYU@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,16,'  24.90 '),(172,'PHILBERT',NULL,'PAMINTUAN','9175977460','PHILBERT_PAMINTUAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,20,'  29.30 '),(173,'EDWARD RAYMOND',NULL,'MORALES','9177922996','MORALESJEDI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,3,'  24.90 '),(174,'JOSEPH \"BUDDY\"',NULL,'MADRIGAL','9188030759','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,21,'  22.00 '),(175,'ERWIN',NULL,'DELA CRUZ','9175346750','ERWIN.DELACRUZ@JAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,11,'  17.50 '),(176,'MIGUEL',NULL,'OZAETA','9175858616','MNLOZAETA@NOMURA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,1,'  5.60 '),(177,'AKIHIRO',NULL,'OZASA',NULL,'AKIHIRO.OZASA@NOMURA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(178,'ALLAN',NULL,'PUA','9209520667','RA_PUA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,22,'NH'),(179,'RAMIL',NULL,'BERNARDO',NULL,'BERNARA6@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,22,'  21.80 '),(180,'ADRIAN',NULL,'TAN','9178491683','ADRIAN@AXIS3D.HK',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,12,'  20.50 '),(181,'DAVE',NULL,'NICHOLSON','9998856650','DAVENICHOLSON84@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(182,'MICKEY',NULL,'SANCHEZ','9498897751','M.SANCHEZ@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(183,'JOHNNY',NULL,'DAVID','9209056079','J.DAVID@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(184,'FRANCIS',NULL,'GO','9178934653','FSG.PAIRCARGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(185,'DICKSON',NULL,'ESCOLAR','9285064958','D_ESCOLAR@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(186,'ROEL',NULL,'MAGLAYA','9177942889','ROEL202@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,23,'  9.40 '),(187,'RICO',NULL,'PAGULAYAN','9178987427',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,24,'  19.30 '),(188,'ISABELO',NULL,'AFRICA','9188305117','OP@UCPBGEN.COM','9175305117',NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,4,'  22.50 '),(189,'RICARDO',NULL,'BARICAN JR.','9178108720','RSB@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,9,'  23.60 '),(190,'JUSTINO',NULL,'MACAPAGAL','9177914927','JAY_MACAPAGAL@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,48,8,1,1,NULL,8,'12.2'),(191,'JOEL',NULL,'LIBO-ON',NULL,'JOEL_LIBO-ON@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,8,'  13.90 '),(192,'ROMEO',NULL,'CHONG ','9178160561','G2CITC@GMAIL.COM',NULL,'SARAH_C02002@YAHOO.COM',NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,22,5,1,1,NULL,18,'10.2'),(193,'JOSE RAULITO',NULL,'PARAS','9178086050','JREP711@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,25,'MIDLANDS (15.2)'),(195,'MANOLO \"MOLLIE\"',NULL,'ANTONIL','9209523195','MDANTONIL11@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,'22543',9,'  12.70 '),(196,'EPHRAIM',NULL,'DE MESA','9189488655','EPHRAIMFAUSTINO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,23,'  15.50 '),(197,'VIGILART',NULL,'DAVID','9178684454','VGDAVID@STACLARAPOWER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,26,'SOUTHLINKS = 23.2'),(198,'ORLANDO',NULL,'MANINGAS ','9178869116','ORLANMANINGAS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,23,18,1,1,NULL,47,'17.3'),(199,'ROBERTO \"BOBBY\"',NULL,'GONZALES','9175378930','BOBBYGONZALES@MSTTRADING.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,11,'  16.90 '),(200,'ROBERTO \"BOBBY\"',NULL,'RONQUILLO','9175691388','BARTRONQUILLO@YAHOO.COM','9209430920','SHARKPHIL@GMAIL.COM',NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,28,'  18.80 '),(201,'ERLO',NULL,'TENEDERO','9178677576','TENEDERO.E0@ISUZUALABANG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,29,'THERE ARE 2 E. TENEDERO (AGUINALDO 16.3/SHERWOOD 13)'),(202,'ROLANDO \"OLAN\"',NULL,'BOOL','9209107214','RCBOOL@OSAPHILS.COM',NULL,'OLANBOOL@GMAIL.COM',NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,17,'  12.20 '),(203,'DENNIS',NULL,'LAMUG','9988401061','DENNIS.LAMUG@JGSPETROCHEM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,26,'  16.50 '),(204,'VICTOR',NULL,'GENUINO','9209149500','VSGENUINO@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,1,'  18.10 '),(205,'REDEL',NULL,'DOMINGO','9088886741','RMDOMINGO@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,13,'NH'),(206,'VICTOR',NULL,'VITAL ','9178925855','VICTOR.VITAL@FIRSTMETRO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,1,'  19.20 '),(207,'MARK ANDERSON ',NULL,'SAMBAR','9173287468','SAMBAR.ANDERSON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,1,'  25.60 '),(208,'RONILO \"RONNIE\"',NULL,'OLAGUERA','9178496669','RONNIE.OLAGUERA@TIMENGINEERING.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,11,'  12.10 '),(209,'STEPHEN \"STEVE\"',NULL,'JARVIS','9178114117','STEPEN@TVSHOP.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,11,'  14.40 '),(210,'ARIEL \"HYUBS\"',NULL,'AZARCON ','9175440419','ANOBANGTRIPMO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,67,25,1,1,'N/A',33,'NH'),(211,'LEWIS ALFRED \"L.A.\"',NULL,'TENORIO','9177091227','LEWIS_ALFRED@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(212,'ERIC',NULL,'ANG','9175322222','7ERICANG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,27,'NH'),(213,'ZANJO',NULL,'MARUDO','9178202583','ZMARUDO23@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(214,'JERRYME',NULL,'GARCIA','9988494938','JERRYMEGARCIA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,9,'N/A'),(215,'RICO',NULL,'MACALINTAL','9178650632','RICO.MACALINTAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,9,'  29.40 '),(216,'EDMUNDO',NULL,'NAVARRO, JR.','9988494941','EDMUNDNAVARROJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,13,'  27.80 '),(217,'ARNEL',NULL,'DEUNIDA',NULL,'ARNEL.DEUNIDA@ISUZUPHIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,9,'  23.00 '),(218,'VICENTE \"VIC\"',NULL,'BELISARIO','9988494940','VBBELISARIO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,13,'  23.80 '),(219,'ERIC',NULL,'WAMBANGCO','9178503742','WAMBANGCO.ED@ISUZUPASIG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(220,'EXEQUIEL',NULL,'DELGADO','9175298799','EXEQUIELDELGADO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(221,'EPHRAIM',NULL,'DEL ROSARIO','9175833381','EDELROSARIO0604@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,5,'ANVAYA COVE = 21.3'),(223,'JUAN ARMANDO',NULL,'DE BORJA','9175127712','JDEBORJA@ADB.ORG',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(224,'RAYMUND',NULL,'CHUA ','9178329128','RAYMUNDCCHUA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,50,30,1,1,NULL,33,' NH '),(225,'EDISON',NULL,'CO','9175290875','EDISONCO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(226,'LEONIDES \"LEO\"',NULL,'TAGLE JR.','9175325959','LEO.TAGLE@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,30,'  17.60 '),(227,'JAY',NULL,'VALDEZ','9189171849','JVALDEZ@ICTSI.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,11,'  12.50 '),(228,'ELMER',NULL,'SALDIVAR','9175215388',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,48,' NH '),(229,'ATTY. BILLY',NULL,'SUMAGUI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(230,'ERNEST',NULL,'VILLAREAL','9178180368','ERNEST.VILLAREAL@ABOITIZ.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,15,'  14.50 '),(231,'ULYSSES',NULL,'SEVILLA','9178253168','SEVILLA_LAW@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,31,'N/A'),(232,'CHEOK PIN',NULL,'LEE','9178083937','CHEOKPINLEE@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,8,'  28.30 '),(233,'YEW GHEE',NULL,'TAN','9178662244','YEWGHEE.TAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,8,'(NOT REGISTERED) 30'),(234,'HOCK HENG',NULL,'SEE','9178003333','JSEE208@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,4,'  11.80 '),(235,'BOON KHOON',NULL,'TAN','9175845860','JUNGLEKING@MSN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,8,'  19.70 '),(236,'CHRISTOPHER',NULL,'TY',NULL,'CETY@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,32,'  13.90 '),(237,'NATHANIEL',NULL,'SIONGCO',NULL,'NLSIONGCO@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:23',NULL,NULL,NULL,NULL,1,1,NULL,13,'  17.10 '),(238,'FRANCIS NEIL',NULL,'MENDOZA','9175885789','FRMENDOZA@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,20,'  19.20 '),(239,'RICHARD',NULL,'SALCEDO','9178180674','RCSALCEDO@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,20,'  5.20 '),(240,'JAN VINCENT',NULL,'TANDINGAN','9175883682','JATANDINGAN@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,20,'  14.10 '),(241,'DOMINIC',NULL,'TRIA','9175889590','DETRIA@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,113,71,1,1,NULL,NULL,NULL),(242,'VICENTE PAUL \"VINCE\"',NULL,'HIZON','9178931170','VINCEHIZON@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,32,'  9.20 '),(243,'EDUARDO ANTONIO \"TON-TON\"',NULL,'GUTIERREZ JR.','9499923380','ANTONIO_GUTIERREZ68@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,26,'  6.80 '),(244,'COCOY',NULL,'SULAIK','9178996158','COCOYSULAIK@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,22,'  9.30 '),(245,'MARVIN',NULL,'CAPARROS','9175282818','MARVIN@RSCAMNL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,15,'  5.70 '),(246,'ADONES',NULL,'BALUYOT','917813550','ATB_DES@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,1,'  10.40 '),(247,'SMOKEY',NULL,'MANALOTO','9178330844','SMOKEYMANALOTO@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'  10.00 '),(248,'ARCHIE',NULL,'ALEMANIA','9053861849','ARCHIEALEMANIA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,25,1,1,'N/A',33,'NH'),(249,'ABRAHAM',NULL,'CABASAL, JR.','9175114945','JETHROCK888@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,34,'  18.40 '),(250,'JERRY',NULL,'YBAñEZ','9178250545','JERRYYBANEZ1661@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,22,'NO UNHS        29'),(251,'JOEY',NULL,'ORDINANZA','9177242209','JOSYSTEMENTERPRISES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,22,'NO UNHS          27'),(252,'DON DON ',NULL,'DE GUZMAN','9178152425','DDDG32003@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,22,'NO UNHS          26'),(253,'GINO',NULL,'BONIFACIO','9989595214','GINOB@MHAWII.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,77,13,1,1,NULL,30,'24.1'),(254,'DOMINGO \"DINGO\"',NULL,'BONIFACIO','9088820627','DINGOB@MHAWII.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,4,'  21.10 '),(255,'LUCIO \"JUN\" ',NULL,'HORFILLA','9209291790','LTH1021@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,35,'  10.50 '),(257,'RAMON JAIME',NULL,'TABUENA JR.','9175355620','RJRTABUENA@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,11,'  14.80 '),(258,'LUIS',NULL,'BONOAN','9175765847','LSBONOAN@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'N/A'),(259,'JEFFREY',NULL,'NAVA','9178552195','JEFF.NAVA@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,30,'  14.90 '),(260,'JOHN BENEDICT',NULL,'DELOS SANTOS','9178867860','JB.DELOSSANTOS@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,30,'  24.50 '),(261,'RAYMUND \"TED\"',NULL,'ALMEDA','9178384647',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'  16.70 '),(262,'FEDERICO \"RICKY\"',NULL,'SANDOVAL  II','9178193206',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,1,'  25.50 '),(263,'SAMUEL',NULL,'GAN NASIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,26,'  14.50 '),(264,'BIMBOY',NULL,'ZETHA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,26,'  19.90 '),(265,'ROMY',NULL,'TAGLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(266,'DANNY',NULL,'TAGLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(267,'GREGORY',NULL,'WEI','9178075018','GREGORY_WEI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,16,'  18.80 '),(268,'ERIC',NULL,'HO','9175237618','ERICHO5888@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,16,'  15.20 '),(269,'ELEAZAR \"ELL\"',NULL,'CARSULA','9189059737','ECARSULA@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,37,'  11.80 '),(270,'JOSE RAMON',NULL,'MAGAT II','9178212624','JRAMON@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,11,'  14.30 '),(271,'RAFAEL ',NULL,'NACINO','9175116307','RALPHMNACINO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,8,'  22.10 '),(272,'ROCCO',NULL,'NACINO','9178721030','ROCCO_NACINO21@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'N/A'),(273,'KOK HIN',NULL,'LIM','9178974510','KOKHIN_LIM@CANON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,4,'  17.10 '),(274,'JOJO',NULL,'BOLIMA','9175854516','JOJO_BOLIMA@CANON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'N/A'),(275,'SVEN',NULL,'RITTER',NULL,'SVEN.J.RITTER@ROLLS-ROYCEMOTORS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(276,'GOV. PEDRO \"PETER\"',NULL,'MEDALLA JR.','9209279952','GOV_MEDALLA@YAHOO.COM','9175207383',NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,30,NULL),(277,'MARIO',NULL,'LOPEZ','9175073225','MALOPEZ@TURFCOM.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,17,'  13.90 '),(278,'JEROME',NULL,'BALDOZ','9177260021',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,34,'  18.20 '),(279,'VICTORINO',NULL,'FELIPE JR.','9175219853','VIC.FELIPE@RATECHINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'N/A'),(280,'DANILO',NULL,'MONTENEJO JR.',NULL,'DGMONTENEJO@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,33,'N/A'),(281,'RUDY',NULL,'RAGRAGIO','9209458485','RUDY.RAGRAGIO@RATECHINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,30,'  17.00 '),(282,'ROLANDO',NULL,'TOLORES','9178870357','RTOLORES@TRANSORIENTPH.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,9,'  19.30 '),(283,'CHARLES',NULL,'LIM',NULL,'BOBOYLIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,8,'  35.00 '),(284,'ROMEO',NULL,'VILLABONA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:24',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(285,'CENON CHABOUY',NULL,'LAURENA IV','9175851582',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(286,'JOHN MARC',NULL,'ANDAYA','9175012889',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,24,'12.7'),(287,'DR. GEORGE EMMANUEL',NULL,'COMIA','9178390737','GEORGECOMIA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,1,1,1,1,NULL,38,' NH '),(288,'STEPHEN JOHN',NULL,'COMIA','9178814634','STEPHEN_COMIA@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,2,2,1,1,NULL,39,'15.9'),(289,'GLEN',NULL,'CHAN','9175543822','GLENNMELJOSHLUKE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,22,'14'),(290,'RODNEY',NULL,'DIZON','9178978168','RODNEYDIZON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,5,'11.1'),(291,'DR. JAMES',NULL,'CO SHU MING','9174900954','JCOSHUMING@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,8,'16'),(292,'JOSEPH OWEN',NULL,'FULO','9178947827','JOFULO@SPLI.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,8,'7.7'),(293,'JOSEPH',NULL,'KABIGTING ','9174900954','JOSEPH.KABIGTING09@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,3,3,1,1,NULL,8,'13.9'),(294,'ISMAEL \"JUN\"',NULL,'ESTELA JR. ','9209514057','IGE@BDO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,4,4,1,1,'19566',8,'  15.90 '),(295,'ROBERTO \"BOBBY\"',NULL,'BUENCAMINO','9175830013','BOBBYGOODROAD@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,5,5,1,1,'N/A',33,'NH'),(296,'MARC',NULL,'BUENCAMINO','9178858168','MMBUENCAMINO@FBDCORP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,6,6,1,1,'N/A',33,'NH'),(297,'CLEMENTE',NULL,'CHAN','9175217171','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,22,'15.7'),(298,'CAMILO',NULL,'PADA','9175761657',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,22,'8.9'),(299,'EUGENIO',NULL,'CHEUNG','9209017777',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,8,'15.5'),(300,'JUAN MIGUEL',NULL,'CANTERO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,'47224',8,'  13.10 '),(301,'EMILIANO \"EMIL\"',NULL,'JOVEN','9178161122','BONG_JOVEN@YAHOO.COM','9177101984',NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,7,7,1,1,'66154',40,'  15.10 '),(302,'RICHARD',NULL,'ALBANO','9177101984','RICHARDALBANO84@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,122,8,1,1,NULL,41,'16.7'),(303,'JASON',NULL,'PORCIUNCULA','9189114088','JCP@EASTWESTHEALTHCARE.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,NULL,NULL,1,1,NULL,11,'13.5'),(304,'CESAR ENRIQUE',NULL,'MEDINA','9778468808','CSM@BPMSFC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:33',NULL,NULL,9,8,1,1,NULL,42,'13.4'),(306,'ROGER',NULL,'MANJARES','9178146845','MANJARESROGER@MAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,10,5,1,1,NULL,5,'8.9'),(307,'FRANCISCO \"JON\"',NULL,'DE LEON JR.','9178458880','FDJR@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'1335',23,'  14.10 '),(308,'HARBIE',NULL,'FLORES','9175839838','HARBIEFLORES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,22,'14.5'),(309,'RICHARD ',NULL,'ROQUE','9178286277','KIDTEC999@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,26,'23.3'),(310,'NOEL',NULL,'DEL ROSARIO','9565681355','NOEL.DR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,43,'33.4'),(311,'MICHAEL',NULL,'ROQUE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'28665',30,'  16.90 '),(312,'MICHAEL',NULL,'CATRAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'64171',43,'  23.70 '),(313,'JAY JAY',NULL,'ALINDADA','9209258033','JCTACONST@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,11,5,1,1,NULL,6,'18'),(314,'GERARDO',NULL,'ROMULADEZ','9175203963','GTROMUALDEZ@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,12,9,1,1,NULL,6,'20.1'),(315,'RAYMOND',NULL,'SANTOS','9178294944','CHISNTS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,13,NULL,1,1,NULL,11,'14.5'),(316,'EDGARDO',NULL,'VICENTE','9175847317','MAGVILLE12@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,10,1,1,NULL,44,'24.3'),(317,'VICTOR STUART',NULL,'FERNANDEZ','9158888869',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,42,'14'),(318,'ENGR. NOEL',NULL,'BAYBAY','9175016492',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(319,'WHARTON',NULL,'CHAN ','9175016492',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'N/A',33,'NH'),(320,'GABRIEL PAULO \"GP\"',NULL,'VALERO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'68789',45,'  24.10 '),(321,'BENITO \"BERNIE\"',NULL,'DE LEON','9178400644','BNL@EMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'22786',9,'  22.70 '),(324,'ALAN',NULL,'CHNG','9174709336','ALANCHNG_ACBC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,14,11,1,1,'N/A',33,'NH'),(325,'ROBERT',NULL,'YAO','9175269198','LKC22A@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,15,3,1,1,'15293',4,'  12.80 '),(326,'DANIEL',NULL,'GO','9175267619','DANIELGO@MAA.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,16,12,1,1,NULL,4,' NH '),(327,'DINDO',NULL,'REYES','9176851995','DINDOREYES95@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,23,'18'),(328,'WILLIAM',NULL,'SEGUN','9175507100','WILLIAM_SEGUN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,8,'10'),(329,'HERMAN',NULL,'MEDINA-CUE','9178405819',NULL,'9175285698',NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,8,'26.1'),(330,'ANTHONY',NULL,'SUNTAY ','9178422537',NULL,'9189499220',NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,9,'16.1'),(331,'JOSE PEPITO',NULL,'BENGZON III','9173030721','PEPZ.BENGZON@LUCKYU.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,17,13,1,1,NULL,21,'10.8'),(332,'EDWIN',NULL,'BERMUDEZ','9178417213','EDWIN7154@ICLOUD.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,18,14,1,1,NULL,9,'13.6'),(333,'RICO',NULL,'TOLENTINO','9179639123','RICOTOLENTINO929@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,46,'17.1'),(334,'RAOUL MICHAEL \"JAY\"',NULL,'VIRAY','9175302496','VIRAYJAY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,19,15,1,1,'26188',21,'  13.30 '),(335,'CARLOS',NULL,'SANTOS','9178332119','CARLOS.SANTOS0518@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,10,1,1,NULL,23,'21.8'),(336,'VICTOR',NULL,'GARLITOS','9175220407',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,23,'36.4'),(337,'CARL IAN',NULL,'ONG','9778129694','CARLIANZONG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,4,'22.9'),(338,'ENZO',NULL,'HERMOSA','9178948430','ENZOHERMOSA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,26,' NH '),(339,'MARTIN',NULL,'AMONCIO','9228325678','MARTINAMONCIO516@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,20,16,1,1,NULL,33,' NH '),(340,'CHRISTIAN',NULL,'DAVID','9178808749','RRS.CHRISTIANDAVID@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,21,17,1,1,NULL,33,' NH '),(342,'JOSE RAULITO',NULL,'PARAS','9178486050','JREP711@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,25,'14.3'),(343,'DANILO \"DANNY\"',NULL,'BATINO','9399235773','DANNY@MEDIAMAJIC.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,10,1,1,'28467',30,'  22.60 '),(344,'LUIS \"CHITO\"',NULL,'BERMUDEZ','9178828847','CHITOBERMUDEZ@GMAIL.COM','9088600825',NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,10,1,1,'N/A',9,'NH'),(345,'CHARLES \"BOBOY\"',NULL,'LIM','9175816168','BOBOYLIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'65640',8,'  30.20 '),(346,'FORTUNATO',NULL,'DIMAGIBA','9178574397','FLDIMAGIBA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'19542',8,'  28.70 '),(348,'ALEXANDER',NULL,'FESTEJO ','9176788099','ALEX_FESTEJO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,24,19,1,1,NULL,24,'23.2'),(349,'ROMEO',NULL,'TAGLE ','9189049880',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,25,5,1,1,NULL,47,'20.4'),(350,'ELEAZAR \"BIMBOY\"',NULL,'ZETHA','9175711775','ELZETHA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,26,5,1,1,'41840',26,'  15.10 '),(351,'RICHARD JAY',NULL,'LISTA','9175366947','RJLISTA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,27,13,1,1,NULL,48,'15.6'),(352,'ARTURO EDUARDO',NULL,'CARBALLO JR.','9178012865','ARTURO.CARBALLO@SMSUPERMALLS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,28,20,1,1,NULL,48,' NH '),(353,'RYAN JAN',NULL,'CRUZ ','9178030927',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,29,21,1,1,NULL,48,' NH '),(354,'JEROME EMMANUEL',NULL,'AUSTRIA','9178770380','JEROMEAAUSTRIA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,30,22,1,1,NULL,48,' NH '),(355,'CLARO',NULL,'ARRIOLA','9176767098','CLARO_ONEPITCH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,31,5,1,1,NULL,48,'27'),(356,'JOSEPH',NULL,'DE GUZMAN','9255868398','GLAZINUM1@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,32,5,1,1,NULL,49,'28.8'),(357,'JERUSALEM',NULL,'VERCIDE','9177141708','VERCIDEJERUSALEM2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,33,23,1,1,NULL,50,'12.4'),(358,'RICO',NULL,'DOCENA','9175992998','RICO.DOCENA@SHI-G.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,34,24,1,1,NULL,9,' 16.60R '),(359,'ASEC. FREDERICK \"RICKY\"',NULL,'ALEGRE','9178910800',NULL,'9269503816',NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'19263',8,'  17.10 '),(360,'MARK ANTHONY',NULL,'SULTAN','9175286684','MARK@SAMGLO.COM',NULL,'MARKANTHONYSULTAN@GMAIL.COM',NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,35,5,1,1,'21374',18,'  23.50 '),(361,'JOHNNY',NULL,'LIM','9175114745','JOHNNYCOLIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,36,5,1,1,NULL,51,'24.4'),(362,'RUDY',NULL,'YU ','9175369878',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,37,5,1,1,'22374',18,'  22.30 '),(365,'ATTY. AVELINO',NULL,'SUMAGUI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'N/A',52,'NH'),(367,'CHRISTOPOLUS \"CHRIS\"',NULL,'COCHING','9178310510','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,38,26,1,1,'24533',21,'  20.60 '),(368,'JAN ANTHONY S.A.',NULL,'COCHING','9179578383','JACOCHING@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,39,9,1,1,NULL,21,'10.3'),(369,'CASIMIRO \"CASEY\"',NULL,'FAYLONA ','9175366646','CASEY.FAYLONA@THE-ASCOTT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,'68496',53,'  32.50 '),(370,'MIKIHISA',NULL,'TAKAYAMA ','9216576747','TAKAYAMA.MIKIHISA@SOJITZ.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(371,'YOSUKE',NULL,'NISHI','9178660367',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(372,'MUTSUHIRO',NULL,'OSHIKIRI ','9178403554',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(373,'ALVIN',NULL,'DALIDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(374,'CRIS MON ',NULL,'IGTIBEN JR.','9175010395',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,40,5,1,1,NULL,9,'18.9'),(375,'SHERWIN',NULL,'FERRER','9158199090',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,41,27,1,1,NULL,11,'7.4'),(376,' CELSO',NULL,'ANG ','9178999599','ANGCELSO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,42,22,1,1,NULL,6,'28.8'),(377,'MICHAEL',NULL,'DY ','9189375532','MIKEDY70Y@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,43,3,1,1,NULL,41,'13.9'),(378,'LOWELL ',NULL,'HAYNO ','9088754953',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,44,11,1,1,NULL,22,'21.3'),(379,'RICO',NULL,'DELOS REYES ','9175021001','RICO.DELOSREYES@REDACHEM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,45,3,1,1,NULL,11,'23.7'),(380,'DAN',NULL,'SALVADOR IV ','9178441918','DANSALVADOR4@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,46,28,1,1,'30774',43,'  12.80 '),(381,'CAPT. IRENEO \"NEO\"',NULL,'ENDOZO','9267530299',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,NULL,29,1,1,'67757',54,'  19.60 '),(383,'RICH',NULL,'QUIN ','9175141777','RICH.QUIN@CLOUDIAN-GLOBAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,47,13,1,1,'N/A',33,'NH'),(384,'EDGARDO',NULL,'ROSARIO ','9175303273','BUTCH_ROSARIO@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,48,14,1,1,NULL,9,'33.6'),(386,'JOEL',NULL,'LIBO-ON ','9177930916','JOEL_LIBO-ON@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,48,14,1,1,NULL,8,'12.6'),(387,'FRANCISCO',NULL,'NOB ','9178143588','FRANCIS_NOB@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,48,8,1,1,'2452',25,'  34.90 '),(388,'DENNIS JOSEPH',NULL,'UY ','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:34',NULL,NULL,49,NULL,1,1,NULL,5,'25.2'),(390,'ALFRED',NULL,'NG ','9176273535','ALFREDNG.PROVET@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,51,31,1,1,NULL,33,' NH '),(391,'ARNEL',NULL,'GARCIA ','9108566871','AEGIL514@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,52,11,1,1,NULL,25,'13.7'),(392,'RONILO \"RONNIE\"',NULL,'OLAGUERA','9399133818','RONNIE.OLAGUERA@TIMENGINEERING.NET.PH','9178496669',NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,53,5,1,1,'16587',11,'  11.70 '),(393,'NEMESIO',NULL,'PAQGTAKHAN','9178038702',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'33374',11,'  10.80 '),(394,'RAMMY',NULL,'NAGUIAT ','9175245535','RAMMY.NAGUIAT@WU.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,54,32,1,1,NULL,23,'23.3'),(395,'JOSE MARTIN',NULL,'VELASQUEZ','9178502214','JMV0107@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,55,22,1,1,NULL,19,'17'),(396,'DR. MERICO \"RICO\"',NULL,'ARGUELLES','9209298751','MERICO_75@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,56,1,1,1,'6290',23,'  28.40 '),(397,'RAYMOND',NULL,'TAN','9178403301','RTAN@DIY.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,57,33,1,1,NULL,26,'24'),(398,'ROBERT JOSEPH \"JAY\"',NULL,'DE CLARO','9188102671','JAY.DECLARO@PEOPLE4U.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'14557',4,'  10.10 '),(399,'JOHN',NULL,'GALANG','9175964907','JOHN.GALANG@PEOPLE4U.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(400,'SEC. MARGARITO \"GARY\"',NULL,'TEVES ','9178105766','GBTEVES@YAHOO.COM','9189631943',NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,58,34,1,1,'3957',19,'  14.40 '),(401,'LITO',NULL,'CASTRILLO ','9188883303',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,59,12,1,1,'24393',21,'  12.40 '),(402,'MABUHAY \"BOY\"',NULL,'ROSERO ','9178423785','BOYROSERO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,60,10,1,1,'0.15247',4,'  29.10 '),(403,'WILFREDO \"WILLY\"',NULL,'MALDIA ','9188411828','WILFREDOCMALDIA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,61,35,1,1,'0.3711',55,'  15.70 '),(404,'ROMMEL ',NULL,'LATINAZO ','9189903284','RSLATINAZO@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,62,36,1,1,'21267',26,'  13.50 '),(405,'EMMANUEL MARI',NULL,'VALDES','9175102437','EKVALDES@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,62,37,1,1,'38684',26,'  22.90 '),(406,'CESAR',NULL,'AREZA','9175804888',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,63,38,1,1,'52174',21,'21.60R'),(407,'CESAR',NULL,'AREZA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(408,'IAN KIT',NULL,'BERCADEZ','9178169631','IANBERCADEZ@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,64,11,1,1,'46574',24,'  17.20 '),(409,'MARGARITO \"GARY\"',NULL,'CATRAL','9178873317','GARY_CATRAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,64,5,1,1,'49151',24,'  24.50 '),(410,'MARK',NULL,'SALVADOR','9178480585','MARK.SALVADOR@ONELINQ.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,65,5,1,1,'36993',30,'  29.50 '),(411,'PAUL',NULL,'BAGATSING','9188921450','PAUL.BAGATSING@SOCOTEC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,66,15,1,1,'4352',30,'  28.10 '),(413,'ZANJO',NULL,'MARUDO ',NULL,'ZMARUDO23@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,67,25,1,1,'N/A',23,'NH'),(414,'ALAN',NULL,'CARANDANG ','9665008167','ALANCABC214@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,68,39,1,1,'N/A',33,'NH'),(415,'JEVIS ',NULL,'AGUILA ','9178252088','AGUILAJEVIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,69,NULL,1,1,'67157',23,'  23.20 '),(416,'JON',NULL,'NAZARIO','9177072802','JNAZARIO@PSTROKE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,70,9,1,1,'N/A',33,'NH'),(417,'VICENTE FILAMER',NULL,'ROSELL','9088945658','VROSELL@MSITA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,71,40,1,1,'54295',5,'  6.50 '),(418,'JOE',NULL,'SAM','9176363032','JOE.SAM@OKADAMANILA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,72,41,1,1,'N/A',33,'NH'),(419,'VINCENT',NULL,'LIM','9178090626','VINCENT.LIM@OKADAMANILA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,72,42,1,1,'14812',4,'  10.80 '),(420,'JAMES',NULL,'JAUDIAN','9178200578','JAMES.B@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,73,3,1,1,'38794',37,'  16.70 '),(421,'JOHN DOMINIC',NULL,'PULIDO','9178903144','JPULIDO85@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'18062',56,'  15.10 '),(422,'LAURO \"ROBBIE\"',NULL,'LEVISTE II','9178928229',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'33352',17,'  28.90 '),(423,'JC',NULL,'LEVISTE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'48109',17,'  24.30 '),(424,'DARYL',NULL,'RECIO','9175507385','DARYLDARYLDARYL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'N/A',33,'NH'),(425,'CHITO',NULL,'ILANO','9158199090',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'N/A',33,'NH'),(426,'MIKE',NULL,'YANEZA','9176242450','MY_CES@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'N/A',33,'NH'),(427,'RAUL',NULL,'LAGRISOLA','9054819777','RAULJLAGRISOLA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,123,77,1,1,NULL,57,' NH '),(428,'GERARDO \"GERRY\"',NULL,'JASPIO','9178482688',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,74,43,1,1,'19741',8,'  13.90 '),(429,'ATTY. GLENN',NULL,'SUBIA','9178447936',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'20381',8,'  15.20 '),(430,' JONG SUG \"JAMES\"',NULL,'HAN /  NO PARTNER  ','9178814950','JSHAN852003@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'12938',5,'  2.10 '),(431,'EMMANUEL',NULL,'BANGUI','9178207688','ESBANGUI@RIX-GROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,75,15,1,1,'N/A',33,'NH'),(432,'RAY',NULL,'FARES','9178207688','ESBANGUI@RIX-GROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'N/A',33,'NH'),(433,'REY MANUEL \"REY\"',NULL,'ZERRUDO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'48753',53,'  21.80 '),(434,'JEFFREY MICHAEL \"JEFF\"',NULL,'GOULD',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'68084',44,'  20.90 '),(435,'JOSEPH',NULL,'CHUA',NULL,'JOECHUA@MACROASIACORP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,76,44,1,1,'30145',58,'  14.80 '),(436,'DANIEL',NULL,'WEE','9175772929','DANIEL.WEE@THE-ASCOTT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,38,45,1,1,NULL,33,' NH '),(437,'MICHAEL',NULL,'SY','9175873838','SYMIKEL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,NULL,8,'18.2'),(438,'DR. ADRIAN PAULO \"IAN\"',NULL,'LAUREL','9178803710','ARLAUREL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'42625',59,'  11.10 '),(440,'MARK',NULL,'SALUNGA','9998812636','MSALUNGA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,78,24,1,1,NULL,33,' NH '),(441,'RANDY',NULL,'YAP','9178861490',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,125,18,1,1,NULL,33,' NH '),(442,'EDWIN',NULL,'NATIVIDAD','9175027599','EMNATIVIDAD@NGCP.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,80,46,1,1,NULL,33,' NH '),(444,'JESS',NULL,'CABEL','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,NULL,9,'17.9'),(445,'ALLAN',NULL,'YAP','9178515555','ALLANYAP7829@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'13757',5,'  9.50 '),(446,'RAUL',NULL,'OLEA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'25570',21,'  6.80 '),(447,'JIMMY',NULL,'CU ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'15861',11,'28.5R'),(448,'BERNIE',NULL,'NGO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(449,'WILLIE',NULL,'TE ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,81,NULL,1,1,'13640',5,'  16.70 '),(450,'ANTHONY \"TONY\"',NULL,'INGALLA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:35',NULL,NULL,NULL,NULL,1,1,'16154',11,'  6.20 '),(451,'ENRIQUE RICKY',NULL,'SOLAS','9228693241','SALES@ICONSTECH.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,47,1,1,NULL,NULL,NULL),(452,'MIGUEL MIKE',NULL,'CASTRO','9988690771','INANG404@YAHOO.COM.AU',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,83,4,1,1,NULL,NULL,NULL),(453,'ARDON',NULL,'DADULO','9175344470','ARDONLLOYD@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,84,33,1,1,NULL,NULL,NULL),(454,'WILLY',NULL,'CABALCE','9188007767','WILLY_CABALCE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,85,5,1,1,NULL,NULL,NULL),(455,'GILBERT',NULL,'MAGBUTAY','9209226441','GIBMA2003@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,33,1,1,NULL,NULL,NULL),(456,'JUN ',NULL,'BONIFACIO ','9189912947','JB_837@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,48,1,1,NULL,NULL,NULL),(457,'WILFREDO',NULL,'CRUZ','9175338001','WILLIZ_CRUZ@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,49,1,1,NULL,NULL,NULL),(458,'PAULO',NULL,'GONZALES','9209090147','JPG.FENESTRAMCORP@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,13,1,1,NULL,NULL,NULL),(459,'JAD',NULL,'DIVINAGRACIA ','9209605766','MOBILECTPOWER@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,86,5,1,1,NULL,NULL,NULL),(460,'CLARO JR.',NULL,'BAGALSO','9267493937','CLAROJR.BAGALSO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,87,4,1,1,NULL,NULL,NULL),(461,'DOMINGO',NULL,'DE LEON','9209527449','DOMNIC_DL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,50,1,1,NULL,NULL,NULL),(462,'MARCELO',NULL,'RODELAS','9189052575',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,NULL,1,1,NULL,NULL,NULL),(463,'CYRIL',NULL,'SALAMANGUE','9188672767','CCS_CYCONINC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,88,5,1,1,NULL,NULL,NULL),(464,'BERNABE',NULL,'BALBA','9285033260',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(465,'ANTONIO JR.',NULL,'SALAMAT','9088959713','TONYTIWAY89@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,27,1,1,NULL,NULL,NULL),(466,'ANCHING',NULL,'PASTOR','9189109594','NCPCS147@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,89,51,1,1,NULL,NULL,NULL),(467,'ANGEL',NULL,'OLIVER','9089969945','REVILO_BUILDERS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,90,2,1,1,NULL,NULL,NULL),(468,'CALOY',NULL,'DOMINGO','9083932270','KARLO168@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,2,1,1,NULL,NULL,NULL),(469,'JUN ',NULL,'ONTANILLAS','9328687685',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,82,NULL,1,1,NULL,NULL,NULL),(470,'EFREN',NULL,'ALVEZ','9209855555','ALVEZCOMMERCIAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,91,13,1,1,NULL,NULL,NULL),(471,'RANDY',NULL,'ANASTACIO','9175234250','RANDY.ANASTACIO@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,92,52,1,1,NULL,NULL,NULL),(472,'GUS',NULL,'MATHAY','9175349417','GUS.MATHAY@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,92,53,1,1,NULL,NULL,NULL),(473,'ALLAN',NULL,'CANEDO','9175157611','ALLAN.CANEDO@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,92,54,1,1,NULL,NULL,NULL),(474,'SHERWIN',NULL,'YAP','9209530573','SHERWIN.YAP@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,92,55,1,1,NULL,NULL,NULL),(475,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(476,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(477,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(478,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(479,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(480,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(481,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(482,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(483,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(484,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(485,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(486,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(487,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(488,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(489,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(490,'SHELL',NULL,'SHELL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,93,56,1,1,NULL,NULL,NULL),(491,'GERRY',NULL,'MAGDALES','9175815546','GCMAGDALES@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,57,1,1,NULL,NULL,NULL),(492,'ALEXANDER',NULL,'CRISOLOGO','9178589804','ADCRISOLOGO@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,58,1,1,NULL,NULL,NULL),(493,'ROD',NULL,'ISIDRO','9178990323','RCISIDRO@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,59,1,1,NULL,NULL,NULL),(494,'MIKE',NULL,'GOLEZ','9178296247','MLGOLEZ@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,60,1,1,NULL,NULL,NULL),(495,'RODEL',NULL,'CUETO','9998857495','RGCUETO@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,61,1,1,NULL,NULL,NULL),(496,'HENRY',NULL,'SALAZAR','9178954235','HDSALAZAR@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,61,1,1,NULL,NULL,NULL),(497,'MOISES',NULL,'LAMPANO','9088869963','MGLAMPANO@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,62,1,1,NULL,NULL,NULL),(498,'JOHNGIL',NULL,'GERONIMO','9088869947','JMGERONIMO@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,94,57,1,1,NULL,NULL,NULL),(499,'EASTWEST BANK',NULL,'EASTWEST BANK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(500,'EASTWEST BANK',NULL,'EASTWEST BANK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(501,'EASTWEST BANK',NULL,'EASTWEST BANK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(502,'EASTWEST BANK',NULL,'EASTWEST BANK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(503,'EMIRATES',NULL,'EMIRATES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(504,'EMIRATES',NULL,'EMIRATES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(505,'EMIRATES',NULL,'EMIRATES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(506,'EMIRATES',NULL,'EMIRATES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:48',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(507,'RYAN',NULL,'LORENZO','9175243673','RLORENZ@FORD.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(508,'ROEL',NULL,'HERNANDEZ','9988494430','RHERNANDEZ@CHEQSYSTEMS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(509,'RICHARD',NULL,'ABENDON','9778319506','RICHSO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(510,'RYAN',NULL,'SANTOS','9171207930',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(511,'TENG',NULL,'ALBERT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(512,'JONG',NULL,'CASTANEDA','9178973034','JONG_CASTANEDA@PH.NYKLINE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(513,'RODEL',NULL,'GALLEGA','9175273894','RGALLEGA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(514,'JOY',NULL,'GALLEGA','9175056638',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(516,'FAME',NULL,'DE LOS SANTOS','9178948219',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(517,'MARTIN',NULL,'GUANTES','9178948234',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(518,'BOK',NULL,'MALANTIC','9178948351',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(519,'JUN ',NULL,'DAVID','9175825756',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,95,NULL,1,1,NULL,NULL,NULL),(520,'HENRY',NULL,'ONGCHAN','9178416868',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(521,'MON',NULL,'YUPANGCO','9178365216',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(522,'RUDOLF',NULL,'GO','9178981171',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(523,'MEGAFIBER',NULL,'MEGAFIBER',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(524,'MEGAFIBER',NULL,'MEGAFIBER',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(525,'MIKE',NULL,'SHIH','9175089852','MIKESY@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,96,NULL,1,1,NULL,NULL,NULL),(526,'TONY',NULL,'LIN','9195684011','YY_TONY_LIN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(527,'STEVEN',NULL,'HU','9176386108','STEVEN.HU@YULON-FINANCE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,97,63,1,1,NULL,NULL,NULL),(528,'ELLERY CHOCK',NULL,'CAMACHO','9209011905','ELLERY.CAMACHO@YULON-FINANCE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,97,64,1,1,NULL,NULL,NULL),(529,'JIANGXING',NULL,'HUANG','9452046616','DAVIDHUANGXIHE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,98,NULL,1,1,NULL,NULL,NULL),(530,'DAVID',NULL,'HUANG','9452046616','DAVIDHUANGXIHE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,98,NULL,1,1,NULL,NULL,NULL),(531,'SONIA',NULL,'SHIH','9175080778','MRMMOMSONIA@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(532,'HAYOUNG',NULL,'AN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(533,'ALFREDO AL',NULL,'PANLILIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(534,'JUAN VICTOR JOVY',NULL,'HERNANDEZ','9189144731','JIHERNANDEZ@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(535,'ALBERT MITCHELL MITCH',NULL,'LOCSIN','9399391854','ALLOCSIN@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(536,'VIC',NULL,'TRIA','9209027980','VYTRIA@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(537,'JOSEPH IAN JOJO',NULL,'GENDRANO','9199999538','JGGENDRANO@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(538,'JOHN',NULL,'GONZALES','9199999701','JORGONZALES@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(539,'GENE',NULL,'DE GUZMAN','9189054341','GSDEGUZMAN@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(540,'EMERSON SANDY',NULL,'ROQUE',NULL,'ECROQUE@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(541,'RONALD ONALD',NULL,'DAVID',NULL,'RBDAVID@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(542,'VICTOR',NULL,'ALIWALS','9189015744','VICTOR@MAXIMUSCAPITALINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(543,'ALVIN',NULL,'MARTINEZ','9199113687','AIMARTINEZ@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(544,'KENT',NULL,'DE LA CALZADA','9189000206','KCDELACALZADA@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(545,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(546,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(547,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(548,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(549,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(550,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(551,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(552,'STANDARD INSURANCE',NULL,'STANDARD INSURANCE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(553,'BUBOY',NULL,'PUZON','9175288758',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(554,'ALBERT',NULL,'DICHAVES','9188999995',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(555,'OLIVE',NULL,'VELAZQUES','9178052650',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(556,'CONRAD',NULL,'LOPEZ','9175308292',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(557,'DUDAY',NULL,'BALTAZAR','9175255094',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(558,'MARC',NULL,'PUA','9178888318',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(559,'LEO',NULL,'ESCUETA','9178421838','ESCUETALEO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(560,'ALEX',NULL,'CLAVERIA','9178172539',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(561,'AYI',NULL,'BEECH','9175351048','KENSHINJIRCO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,99,5,1,1,NULL,NULL,NULL),(562,'KOKI',NULL,'BEECH','9175366969','FBEECHACCESSTRIP@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,100,65,1,1,NULL,NULL,NULL),(563,'REY',NULL,'ARAOS','9178431791','PRESIDENT@EYELECTRIC.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,101,5,1,1,NULL,NULL,NULL),(564,'DAVID',NULL,'LIM','9985781370','DWL@SPISEMICON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,102,5,1,1,NULL,NULL,NULL),(565,'ANH',NULL,'VU',NULL,'VU.ANH@JETCLUBASIA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,103,66,1,1,NULL,NULL,NULL),(566,'JAMIE',NULL,'MERDAUNT','9177169626','JAMIEMERDAUNT@MEYADO.ASIA',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,104,NULL,1,1,NULL,NULL,NULL),(567,'MARVIN',NULL,'JOVERO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(568,'GILBERT',NULL,'VALLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(569,'PAGCOR',NULL,'PAGCOR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(570,'PAGCOR',NULL,'PAGCOR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(571,'PAINTING 1',NULL,'PAINTING 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(572,'MELCHOR CHOY',NULL,'BACSA','9177753200','MBBACSA@RFM.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,105,67,1,1,NULL,NULL,NULL),(573,'SAMUEL',NULL,'GAN','9178906698','MBBACSA@RFM.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,106,65,1,1,NULL,NULL,NULL),(578,'ROBBIE',NULL,'PABLO','9175731034','RPABLO@SECURITYBANK.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,107,69,1,1,NULL,NULL,NULL),(579,'AURELIO NOEL',NULL,'DAYRIT','9175296454','NDAYRIT@SECURITYBANK.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,108,5,1,1,NULL,NULL,NULL),(580,'EUGENE',NULL,'DIMAANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(581,'EDGAR',NULL,'VALENZUELA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(582,'U-FREIGHT',NULL,'U-FREIGHT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(583,'U-FREIGHT',NULL,'U-FREIGHT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(584,'BRIXTON',NULL,'AW','9178108211','BRIXTON_3333@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,109,5,1,1,NULL,NULL,NULL),(585,'EDWIN',NULL,'ERMITA','9178945595','BRIXTON_3333@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,109,70,1,1,NULL,NULL,NULL),(586,'LUIGI',NULL,'NUNEZ','9188822901','LUIGI.NUNEZ@BEERBELOWZERO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,110,13,1,1,NULL,NULL,NULL),(587,'JOSE JONAS III',NULL,'COCHICO','9178977097','JONAS.COCHICO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,111,47,1,1,NULL,NULL,NULL),(588,'VICENTE',NULL,'DE OCAMPO','9189057726','VAADEOCAMPO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,112,5,1,1,NULL,NULL,NULL),(590,'DENNIS',NULL,'FRONDA',NULL,'DTFRONDA@BPI.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,114,72,1,1,NULL,NULL,NULL),(591,'FERRANDO',NULL,'SANTIAGO',NULL,'FMSANTIAGO@BPI.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,114,73,1,1,NULL,NULL,NULL),(592,'REDILBERTO',NULL,'LOPEZ',NULL,'RVLOPEZ@BPI.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,114,74,1,1,NULL,NULL,NULL),(593,'VINCE',NULL,'CALA',NULL,'VACALA@BPI.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,114,73,1,1,NULL,NULL,NULL),(594,'TONY REY',NULL,'PARADO','9755139884',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,115,NULL,1,1,NULL,NULL,NULL),(595,'NESTOR',NULL,'ETA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(596,'BDO',NULL,'BDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(597,'BDO',NULL,'BDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(598,'FOTON',NULL,'FOTON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(599,'FOTON',NULL,'FOTON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(600,'FOTON',NULL,'FOTON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(601,'FOTON',NULL,'FOTON',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(602,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(603,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(604,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(605,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(606,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(607,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(608,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(609,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(610,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(611,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(612,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(613,'NISSAN',NULL,'NISSAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(614,'JAGMOHAN ROBIN',NULL,'TAMBER','9178313636','JAGMOHANTAMBER@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,116,11,1,1,NULL,NULL,NULL),(615,'ABRAHAM',NULL,'ARAYATA','9178303336','AJARAYATA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,117,33,1,1,NULL,NULL,NULL),(616,'JJ',NULL,'OH','9178965303',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(617,'ALBERT',NULL,'DELOS SANTOS','9178252782','AVDELOSSANTOS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,118,5,1,1,NULL,NULL,NULL),(618,'JED',NULL,'LLANES',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,119,NULL,1,1,NULL,NULL,NULL),(619,'KARL',NULL,'DELOS SANTOS','9175483218','KARLGDELOSSANTOS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,120,75,1,1,NULL,NULL,NULL),(620,'CARLOS',NULL,'MOLINA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:49',NULL,NULL,119,NULL,1,1,NULL,NULL,NULL),(632,'ANDREW',NULL,'LAGMAY','9173264945','ATLAGMAY@ATLAW.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,121,76,1,1,NULL,33,' NH '),(636,'JUAN MIGUEL',NULL,'CANTERO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,8,'13.1'),(647,'MICHAEL',NULL,'ROQUE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,30,'16.9'),(648,'MICHAEL',NULL,'CATRAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,43,'23.7'),(668,'RAUL',NULL,'LAGRISOLA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(682,'CHARLES BOBOY',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(701,'ATTY. AVELINO',NULL,'SUMAGUI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,52,' NH '),(708,'ATSUSHI',NULL,'NAJIMA (NO PARTNER)','9178122330',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,33,' NH '),(711,'ALVIN',NULL,'DALIDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(714,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(715,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(716,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(717,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(720,'SAMUEL RAYMUND',NULL,'RAMOS','9176241630','SNRAMOS@ROCKETMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,124,78,1,1,NULL,43,'24.7'),(721,'NOLI',NULL,'MENDOZA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(722,'EFREN',NULL,'CABOTEJA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(723,'REAGAN',NULL,'FERNANDEZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(732,'JOSEPH',NULL,'CHUA (NO PARTNER)',NULL,'JOECHUA@MACROASIACORP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,76,44,1,1,NULL,58,'14.8'),(734,'JIMMY',NULL,'CU ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,11,' 28.5R '),(735,'BERNIE',NULL,'NGO ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(736,'TONY',NULL,'LIM HING',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(737,'WILLIE',NULL,'TE ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,81,NULL,1,1,NULL,5,'16.7'),(748,'ANTHONY TONY',NULL,'INGALLA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,11,'6.2'),(755,'SEC. GARY',NULL,'TEVES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(756,'SEC. GARY',NULL,'TEVES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(757,'SEC. GARY',NULL,'TEVES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(758,'SEC. GARY',NULL,'TEVES ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:50',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(760,'ELPIDIO JUN',NULL,'PAGADOR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-15 13:06:51',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `golf_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users_login_session_token`
--

DROP TABLE IF EXISTS `golf_users_login_session_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users_login_session_token` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `token` varchar(95) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_UNIQUE` (`user_id`),
  KEY `login_token_fk1_idx` (`user_id`),
  CONSTRAINT `login_token_fk1` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users_login_session_token`
--

LOCK TABLES `golf_users_login_session_token` WRITE;
/*!40000 ALTER TABLE `golf_users_login_session_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_users_login_session_token` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-07-15 13:23:32
