<?php

use App\Router;


Router::get('/test', 'TestController@test')->setName('test');

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['middleware' => \App\Middlewares\Admin::class], function () {
        Router::get('/', 'DefaultController@mainIndex')->setName('main');
    });

    Router::get('/user_access', function () {
        echo "Not admin";
    })->setName('user.access');
});
Router::get('/smss', function () {
    $number = "09389592854";
    $message = "Test 4";
    $key = "ea9aa2fd529446b2bc046f6b05127380";

    $url = 'https://api.autohub.ph/v1/sms/default';
    $params = array('key' => $key, 'mobile' => $number, 'message' => $message);
    $param = array(
        'http' => array(
            'header'  => "",
            'method'  => 'POST',
            'content' => http_build_query($params),
        ),
    );
    $context  = stream_context_create($param);
    return file_get_contents($url, false, $context);
})->setName('user.access');

Router::group(['prefix' => '/admin'], function () {
    Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
        Router::group(['prefix' => '/configurations'], function () {
            Router::get('/sms_settings', 'Admin\ConfigurationController@smsIndex')->setName('admin.configuration.sms');

            Router::post('/setup_sms', 'Admin\ConfigurationController@smsSetup')->setName('admin.configuration.setup');
        });

        Router::group(['prefix' => '/data_management'], function () {
            Router::post('/add_player', 'Admin\DataManagementController@addPlayer')->setName('admin.data_management.add_player');
            Router::get('/search_user', 'Admin\DataManagementController@searchUser')->setName('admin.data_management.search_user');
        });
    });
});

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    // sidebar hrefs
    Router::get('/add_player_page', 'Admin\DataManagementController@addPlayerPage')->setName('admin.configuration.add_player_page');
    Router::get('/list_player_page', 'Admin\DataManagementController@listPlayerPage')->setName('admin.configuration.list_player_page');
});
