<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['prefix' => '/sms'], function () {
        Router::group(['middleware' => \App\Middlewares\Token::class], function () {
            Router::get('/invitation', 'SmsController@invitationIndex')->setName('sms.invitation');
            Router::get('/invitation/{id}', 'SmsController@invitationDataIndex')->setName('sms.invitation.data')->where(['id' => '[0-9]+']);
            Router::get('/qr', 'SmsController@qrIndex')->setName('sms.qr');
            Router::get('/qr/{id}', 'SmsController@qrDataIndex')->setName('sms.qr.data')->where(['id' => '[0-9]+']);
            Router::get('/reminder', 'SmsController@reminderIndex')->setName('sms.reminder');
            Router::get('/reminder/{id}', 'SmsController@reminderDataIndex')->setName('sms.reminder.data')->where(['id' => '[0-9]+']);
        });


        Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
            Router::post('/', 'SmsController@createTextBlast')->setName('sms.create');
            Router::post('/listData/count', 'SmsController@listDataCount')->setName('sms.list.data.status.count');
            Router::get('/list', 'SmsController@list')->setName('sms.list');
            Router::get('/listData', 'SmsController@listData')->setName('sms.list.data');
            Router::get('/options', 'SmsController@settingsOptions')->setName('sms.settings.options');
        });
    });
});
