<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Token::class], function () {
});


Router::group(['prefix' => '/public'], function () {
    Router::group(['middleware' => \App\Middlewares\Token::class], function () {
        Router::get('/course_flight/{event_id}', 'UserController@courseFlightIndexPublic')->setName('public.course_flight')->where(['event_id' => '[0-9]+']);
    });

    Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
        Router::post('/course_flight/list', 'UserController@courseFlightData')->setName('public.course_flight.data');
        Router::get('/team/filter/options', 'UserController@teamFilterOptions')->setName('public.users.team.filter.options');

        // Router::post('/list', 'UserController@courseFlightData')->setName('course_flight.data');
    });
});
