<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['prefix' => '/events'], function () {
        Router::group(['middleware' => \App\Middlewares\Token::class], function () {
            Router::get('/', 'EventController@eventsIndex')->setName('events');
            Router::get('/{id}', 'EventController@eventsData')->setName('events.data')->where(['id' => '[0-9]+']);

            Router::get('/import/{id}', 'EventController@usersImportIndex')->setName('events.import')->where(['id' => '[0-9]+']);
        });


        Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
            Router::post('/', 'EventController@create')->setName('events.create');
            Router::get('/list', 'EventController@list')->setName('events.list');
            Router::post('/dashboard/{event_id}', 'EventController@getDashboard')->setName('events.dashboard')->where(['event_id' => '[0-9]+']);
            Router::post('/status', 'EventController@status')->setName('events.status');
            Router::post('/fetch', 'EventController@fetch')->setName('events.fetch');
            Router::get('/options', 'EventController@options')->setName('events.options');
            Router::post('/import', 'EventController@usersImport')->setName('events.import.store');
            Router::post('/template', 'EventController@template')->setName('events.template');
             Router::post('/bootEvent', 'EventController@getEventBoot')->setName('events.bootEvent'); //modify
            Router::post('/loadbootEvent', 'EventController@getEventBoot2')->setName('events.loadBootEvent'); //modify
            Router::post('/checkBoooth', 'EventController@checkBoooth')->setName('events.checkBooth'); //modify
        });
    });
});
