<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['prefix' => '/configurations'], function () {
        Router::group(['middleware' => \App\Middlewares\Token::class], function () {
            Router::get('/admins', 'UserController@adminsIndex')->setName('admins');
            Router::group(['prefix' => '/sms'], function () {
                Router::get('/templates', 'SmsController@templatesIndex')->setName('sms.templates');
            });
        });

        Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
            Router::group(['prefix' => '/sms'], function () {
                Router::get('/templates/list', 'SmsController@templatesList')->setName('sms.templates.list');
                Router::post('/templates/create', 'SmsController@templatesCreate')->setName('sms.templates.create');
                Router::post('/templates/status', 'SmsController@templateUpdateStatus')->setName('sms.templates.status');
                Router::post('/templates/fetch', 'SmsController@templateFetch')->setName('sms.templates.fetch');
            });
        });

        Router::group(['prefix' => '/devices'], function () {
            Router::group(['middleware' => \App\Middlewares\Token::class], function () {
                Router::get('/', 'DeviceController@devicesIndex')->setName('devices');
            });


            Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
                Router::get('/list', 'DeviceController@list')->setName('devices.list');
                Router::post('/status', 'DeviceController@status')->setName('devices.status');
                Router::post('/remove', 'DeviceController@remove')->setName('devices.remove');
            });
        });
    });
});
