<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::get('/auth_generate', function () {
        echo \App\Utilities\Cookie::get('Authorization');
    });
});

Router::group(['middleware' => \App\Middlewares\AuthVerification::class], function () {
    Router::get('/auth_verify', function () {
        echo "Access Granted!";
    });
});

Router::get('/session', function () {
    session_unset();
    session_destroy();
});


Router::group(['middleware' => \App\Middlewares\Token::class], function () {
    Router::group(['middleware' => \App\Middlewares\NotAuth::class], function () {
        Router::get('/login', 'AuthController@loginIndex')->setName('login');
    });
    Router::get('/logout', 'AuthController@logout')->setName('logout');
});

Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
    Router::post('/login', 'AuthController@loginData')->setName('login.data');
});

Router::get('/hash', function () {
    $password = input('data');
    echo \App\Utilities\Hash::hash($password);
});
