/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here

  var myList = null;
  var search_type_filter = [];
  const $tableList = $("#tableList");
  const $TeamForm = $("#TeamForm");
  const $TeamPopForm = $("#TeamPopForm");
  const $UserForm = $("#UserForm");
  const $EventForm = $("#EventForm");
  var user_id = "";
  var create_from_mate = false;
  var store_from_list = false;

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function initActionRemove() {
    myList.on("click", "[data-action-remove]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-remove]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      // const id = myList.row(row).data().id; //$(this).attr('data-action-remove');
      Swal.fire({
        title: "Are you sure, you want to remove this player to this team?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, remove it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: remove_user_from_team,
            data: {
              id: data.player_id,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              toast("success", result.message);
              myList.draw(false);
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
    // });
  }
  function initActionEvent() {
    myList.on("click", "[data-action-event]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-event]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      resetPlayerForm();

      user_id = myList.row(row).data().id;
      $("#selected_user").text(myList.row(row).data().name);

      $.ajax({
        url: fetch_player_uri,
        data: {
          user_id: user_id,
          event_id: $('select[name="event"]').val(),
          csrf_token: $("meta[name='csrf-token']").attr("content"),
        },
        type: "POST",
        dataType: "json",
        beforeSend: function () {},
        success: function (result) {
          if (result.length === 0) {
            return false;
          }
          if (result.team_id) {
            $("select[name='team']")
              .empty()
              .append(
                new Option(result.team_name, result.team_id, false, false)
              )
              .trigger("change");
          }

          if (result.partner_id) {
            $("select[name='mate']")
              .empty()
              .append(
                new Option(result.partner_name, result.partner_id, false, false)
              )
              .trigger("change");
          }
          $("select[name='course']").val(result.course_id).trigger("change");
          $("select[name='division']")
            .val(result.division_id)
            .trigger("change");

          $("select[name='course_n']").val(result.course).trigger("change");
          $("select[name='flight_n']").val(result.flight).trigger("change");
          $("select[name='registration_type']")
            .val(result.registration_type)
            .trigger("change");
          $("select[name='registration_status']")
            .val(result.registration_status)
            .trigger("change");
        },
        error: function () {},
      });

      $(".user_section").hide();
      $(".team_section").show();
      store_from_list = true;
      $("#modal_event").modal("show");
    });
    // });
  }

  function resetPlayerForm() {
    $('select[name="mate"]').empty().trigger("change");
    $('select[name="team"]').empty().trigger("change");

    $("select[name='course'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='division'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='course_n'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='flight_n'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_type'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_status'] option:first")
      .prop("selected", true)
      .trigger("change");
  }
  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        myList.search($("#txt_search").val()).draw();
      }, 500)
    );

    const search_type_default = "Member Name";
    const search_types = [
      "Member ID",
      "Member Name",
      "Member Email",
      "Member Mobile",
    ];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        myList.draw(false);
        //  }
      });
    });

    // Delete a record
    $tableList.on("click", "td.table-action > a action-delete", function (e) {
      e.preventDefault();
    });

    var cols = [
      {
        title: "ID",
        data: "id",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "5%",
      },
      {
        title: "Name",
        data: "name",
        className: "align-middle p-1 dt-left",
        orderable: true,
        width: "20%",
      },
      {
        title: "Team",
        data: "team",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Course",
        data: "course",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Division",
        data: "division",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Flight",
        data: "course_flight",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "5%",
      },
      {
        title: "Date Added",
        data: "p_created_at",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Action",
        data: null,
        orderable: false,
        width: "10%",
        className: "align-middle p-1 dt-center",
        render: function (data, type, row, meta) {
          return `
                   <div class="row justify-content-center">
                           <a data-action-event style="cursor:pointer;" class="m-1 btn btn-sm btn-primary btn-icon" title="Edit"><i class="fa fa-pen"></i></a> 
                           <a data-action-remove style="cursor:pointer;" class="m-1 btn btn-sm btn-danger btn-icon" title="Remove"><i class="fa fa-trash"></i></a>
                   </div>
                   `;
        },
      },
    ];

    myList = $tableList.DataTable({
      //  fnInitComplete: function() {
      //      initActionRemove();
      //  },
      fnDrawCallback: function () {},
      //  columnDefs: [{
      //      width: 200,
      //      targets: 0
      //  }],
      /* Disable initial sort */
      order: [[5, "desc"]],
      retrieve: true,
      columns: cols,
      //  data: data,
      paging: true,
      lengthChange: false,
      searching: true,
      //  ordering: true,
      pageLength: 10,
      info: true,
      autoWidth: false,
      responsive: true,
      processing: true,
      fixedColumns: true,
      serverSide: true,
      //  ajax: "/admin/products/list",
      ajax: {
        url: team_member_list_uri,
        data: function (d) {
          return $.extend({}, d, {
            search_type: search_type_filter,
            team_id: $('select[name="team_filter"]').val(),
            event_id: $('select[name="event"]').val(),
            course: $('select[name="filter_course"]').val(),
            course_n: $('select[name="filter_course_n"]').val(),
            flight_n: $('select[name="filter_flight_n"]').val(),
          });
        },
      },
      sDom: "lrtip",
    });
  }

  function tableEvents() {
    initActionRemove();
    initActionEvent();
  }

  $(function () {
    initList();
    tableEvents();

    $TeamPopForm.validate({
      rules: {
        team_name: {
          required: true,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $TeamPopForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("event_id", $('select[name="event"]').val());
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_team_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_team_pop").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              var newOption = new Option(
                result.name,
                result.team_id,
                false,
                false
              );
              $("#modal_event select[name='team']")
                .empty()
                .append(newOption)
                .trigger("change");

              $("#modal_team_pop").modal("hide");
            } else if (parseInt(result.status) === 2) {
              toastr.remove();
              toastr.error(result.message);
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_team_pop").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_team_pop").prop("disabled", false);
          },
        });
      },
    });
    $TeamForm.validate({
      rules: {
        team_name: {
          required: true,
        },
        event_id: {
          required: true,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $TeamForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        // formData.append("event_id", id);
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_team_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_team").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              $("#modal_team").modal("hide");
            } else if (parseInt(result.status) === 2) {
              toastr.remove();
              toastr.error(result.message);
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_team").prop("disabled", false);
            $('select[name="event_id"]').empty().trigger("change");
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_team").prop("disabled", false);
          },
        });
      },
    });

    $EventForm.validate({
      rules: {},
      messages: {
        team: "This field is required.",
      },
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $EventForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);

        if (store_from_list) {
          formData.append("user_id", user_id);
        } else {
          formData.append("user_id", $("select[name='user']").val());
        }

        formData.append("event", $('select[name="event"]').val());
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_add_to_evt_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_event").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              // var newOption = new Option(result.name, result.id, false, false);
              // $('select[name="team"]').empty().trigger("change");

              // $("select[name='team']").append(newOption).trigger("change");
              myList.draw(false);
              $("#modal_event").modal("hide");
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_event").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_event").prop("disabled", false);
          },
        });
      },
    });

    $UserForm.validate({
      rules: {
        firstname: {
          required: true,
        },
        lastname: {
          required: true,
        },
        email: {
          email: true,
        },
        mobile: {
          digits: true,
          minlength: 5,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $UserForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);

        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_users_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");
              $("#modal_user").modal("hide");
              if (create_from_mate) {
                $("select[name='mate']")
                  .empty()
                  .append(new Option(result.name, result.id, false, false))
                  .trigger("change");
              } else {
                $("select[name='user']")
                  .empty()
                  .append(new Option(result.name, result.id, false, false))
                  .trigger("change");
              }
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save").prop("disabled", false);
          },
        });
      },
    });

    const $btn_add_mate = $("#btn_add_mate");
    $btn_add_mate.on("click", function () {
      create_from_mate = true;
      $UserForm.trigger("reset");
      $("#modal_user").modal("show");
      $("input[name=firstname]").trigger("focus");
    });

    $("#btn_add_member").hide();
    $('select[name="team_filter"]').on("change", function (event) {
      if (!isEmpty($(this).val()) && parseInt($(this).val())) {
        $("#btn_add_member").show();
      } else {
        $("#btn_add_member").hide();
      }
    });
    $("#btn_add_team").on("click", function () {
      $("#modal_team_pop input[name=team_name]").val("");
      $("#modal_team_pop").modal("show");
      $("#modal_team_pop input[name=team_name]").trigger("focus");
    });
    $("[name=event], [name=event_id]").select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: event_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('select[name="mate"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search name.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: user_mate_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: $('select[name="event"]').val(),
            exclude_id: store_from_list
              ? user_id
              : $('select[name="user"]').val(),
            limit: 15,
            course: $('select[name="course_n"]').val(),
            flight: $('select[name="flight_n"]').val(),
            course_cat: $('select[name="course"]').val(),
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $(
      'select[name="team_filter"],select[name="filter_course"],select[name="filter_course_n"],select[name="filter_flight_n"]'
    ).on("change", function (event) {
      myList.draw(false);
    });

    $('select[name="event"]').on("change", function (event) {
      $('select[name="team_filter"]').empty().trigger("change");
      if (!isEmpty($(this).val()) && parseInt($(this).val())) {
      } else {
      }
    });

    $('[name="team_filter"],[name="team"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: team_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: $('select[name="event"]').val(),
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('select[name="user"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search name.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: event_team_user_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            team_id: $('select[name="team_filter"]').val(),
            event_id: $('select[name="event"]').val(),
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $(document).on("click", ".dropdown-filter,.daterangepicker", function (e) {
      e.stopPropagation();
    });
    const $btn_create = $("#btn_create");

    $btn_create.on("click", function () {
      $("input[name=team_name]").val("");
      $("#modal_team").modal("show");
      // $("input[name=team_name]").trigger("focus");
      $("select[name=event_id]").trigger("focus");
    });

    const $btn_add_user = $("#btn_add_user");
    $btn_add_user.on("click", function () {
      create_from_mate = false;
      $UserForm.trigger("reset");
      $("#modal_user").modal("show");
      $("input[name=firstname]").trigger("focus");
    });

    $("#btn_add_member").on("click", function () {
      // $('select[name="team_user"]').empty().trigger("change");
      // $("#modal_team_user").modal("show");
      // $("select[name=team_user]").trigger("focus");

      resetPlayerForm();
      $(".team_section").hide();
      $(".user_section").show();
      //set team to
      $("select[name='team']")
        .empty()
        .append(
          new Option(
            "selected",
            $('select[name="team_filter"]').val(),
            false,
            false
          )
        )
        .trigger("change");

      $("#selected_user").text("Add Team Member");
      store_from_list = false;

      $('select[name="user"]').empty().trigger("change");
      $("#modal_event").modal("show");
    });

    $("#div_event_date").datetimepicker({
      format: "L",
    });
    $("[data-mask]").inputmask();

    $("#reload-list").on("click", function () {
      myList.draw(false);
    });
    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });

    //comfig
    $(document).on("show.bs.modal", ".modal", function () {
      const zIndex = 1040 + 10 * $(".modal:visible").length;
      $(this).css("z-index", zIndex);
      setTimeout(() =>
        $(".modal-backdrop")
          .not(".modal-stack")
          .css("z-index", zIndex - 1)
          .addClass("modal-stack")
      );
    });
    $(document).on("select2:open", () => {
      document.querySelector(".select2-search__field").focus();
    });
  });
})();
