/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here
  var search_type_filter = [];

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function ajaxData() {
    $.ajax({
      url: url.list,
      data: {
        search_type: search_type_filter,
        search: $("#txt_search").val(),
        team_id: $('select[name="team_filter"]').val(),
        event_id: event_id,
        course: $('select[name="filter_course"]').val(),
        course_n: $('select[name="filter_course_n"]').val(),
        flight_n: $('select[name="filter_flight_n"]').val(),
        csrf_token: $("meta[name='csrf-token']").attr("content"),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {
        $(".course_flight").empty("");
      },
      success: function (result) {
        toastr.remove();
        if (!Object.keys(result.data).length) {
          $(".record").hide();
          $(".no-record").show();
          return false;
        }
        $(".no-record").hide();
        $(".record").show();
        for (var i = 1; i <= 18; i++) {
          if (!result.show) {
            if (typeof result.data[i] === "undefined") {
              continue;
            }
          }

          const str = "ABC";
          for (var j = 0; j < str.length; ++j) {
            var chr = str.charAt(j);

            if (!result.show) {
              if (typeof result.data[i][chr] === "undefined") {
                continue;
              }
            }

            $(".course_flight").append(
              `
              <tr>
              <td class="p-0" align="center" colspan="6">
                  <div class="p-1 text-center bg-dark font-weight-normal">
                      <span class="text-lg">Flight ` +
                (i + "" + chr) +
                `</span>
                  </div>
                  </th>
              </tr>
              `
            );
            if (typeof result.data[i] !== "undefined") {
              if (typeof result.data[i][chr] !== "undefined") {
                $.each(result.data[i][chr], function (iii, vvv) {
                  $(".course_flight").append(
                    `
                  <tr class="text-center text-md">
                                      <td class=" align-middle p-1 dt-center">
                                      <a data-id=` +
                      vvv.id +
                      ` style="color: #007bff; cursor:pointer; text-decoration: underline;">
                                      ` +
                      (vvv.firstname + " " + vvv.lastname) +
                      `
                      </a></td>
                      <td class=" align-middle p-1 dt-center">` +
                      (vvv.partner ? vvv.partner : `--`) +
                      `</td>
                                      <td class=" align-middle p-1 dt-center">` +
                      vvv.course +
                      `</td>
                      <td class=" align-middle p-1 dt-center">` +
                      vvv.team +
                      `</td> 
                                      <td class=" align-middle p-1 dt-center">` +
                      (vvv.attendance
                        ? `<span class="text-sm badge badge-success font-weight-normal">Present | ` +
                          vvv.attendance +
                          `</span>`
                        : `<span class="text-sm badge badge-danger font-weight-normal">Out</span>`) +
                      `</td> 
                                     
                </tr>
              `
                  );
                });
              } else {
                if (result.show) {
                  $(".course_flight").append(`
                    <tr>
                      <td class="text-center text-danger" colspan="6">No record...</th>
                    </tr>
                `);
                }
              }
            } else {
              if (result.show) {
                $(".course_flight").append(`
                    <tr>
                      <td class="text-center text-danger" colspan="6">No record...</th>
                    </tr>
                `);
              }
            }
            //check if data exist to current loop
          }
        }
      },
      error: function () {
        toast("error", "Error has occurred. Try again.");
      },
    });
  }

  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        ajaxData();
      }, 500)
    );

    const search_type_default = "Member Name";
    const search_types = [
      "Member ID",
      "Member Name",
      "Member Email",
      "Member Mobile",
    ];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        ajaxData();
        //  }
      });
    });
  }

  $(function () {
    initList();
    ajaxData();

    $(
      'select[name="team_filter"],select[name="filter_course"],select[name="filter_course_n"],select[name="filter_flight_n"]'
    ).on("change", function (event) {
      ajaxData();
    });

    $('[name="team_filter"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: url.team_filter_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: event_id,
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $("#div_event_date").datetimepicker({
      format: "L",
    });
    $("[data-mask]").inputmask();

    $("#reload-list").on("click", function () {
      ajaxData();
    });

    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });

    $(document).on("select2:open", () => {
      document.querySelector(".select2-search__field").focus();
    });
  });
})();
