/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here
  var search_type_filter = [];
  const $UserForm = $("#UserForm");
  const $EventForm = $("#EventForm");
  const $TeamPopForm = $("#TeamPopForm");
  var create_from_mate = false;
  var store_from_list = false;
  var user_id = "";

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function initActionUser() {
    $("[data-id]").each(function () {
      $(this).on("click", function () {
        user_id = $(this).attr("data-id");
        console.log(user_id);

        $.ajax({
          url: url.fetch_user_uri,
          data: {
            id: user_id,
            csrf_token: $("meta[name='csrf-token']").attr("content"),
          },
          type: "POST",
          dataType: "json",
          beforeSend: function () {
            toast("info", "Fetching...");
          },
          success: function (result) {
            // console.log(result);
            toastr.remove();
            $UserForm.trigger("reset");

            $.each(result, function (index, value) {
              $("input[name=" + index + "]").val(value);
            });
            create_from_mate = false;
            $("#modal_user").modal("show");
            $("input[name=firstname]").trigger("focus");
          },
          error: function () {
            toast("error", "Error has occurred. Try again.");
          },
        });
      });
    });
  }

  function resetPlayerForm() {
    $('select[name="mate"]').empty().trigger("change");
    $('select[name="team"]').empty().trigger("change");

    $("select[name='course'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='division'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='course_n'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='flight_n'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_type'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_status'] option:first")
      .prop("selected", true)
      .trigger("change");
  }
  function initActionEvent() {
    $("[data-action-event]").each(function () {
      $(this).on("click", function () {
        resetPlayerForm();

        user_id = $(this).attr("data-action-event");
        console.log(user_id);

        // var row = $(this).closest("tr");
        // user_id = myList.row(row).data().id;
        // $("#selected_user").text(myList.row(row).data().name);

        $.ajax({
          url: url.fetch_player_uri,
          data: {
            user_id: user_id,
            event_id: $('select[name="event"]').val(),
            csrf_token: $("meta[name='csrf-token']").attr("content"),
          },
          type: "POST",
          dataType: "json",
          beforeSend: function () {},
          success: function (result) {
            if (result.length === 0) {
              return false;
            }
            if (result.team_id) {
              $("select[name='team']")
                .empty()
                .append(
                  new Option(result.team_name, result.team_id, false, false)
                )
                .trigger("change");
            }

            if (result.partner_id) {
              $("select[name='mate']")
                .empty()
                .append(
                  new Option(
                    result.partner_name,
                    result.partner_id,
                    false,
                    false
                  )
                )
                .trigger("change");
            }
            $("select[name='course']").val(result.course_id).trigger("change");
            $("select[name='division']")
              .val(result.division_id)
              .trigger("change");

            $("select[name='course_n']").val(result.course).trigger("change");
            $("select[name='flight_n']").val(result.flight).trigger("change");
            $("select[name='registration_type']")
              .val(result.registration_type)
              .trigger("change");
            $("select[name='registration_status']")
              .val(result.registration_status)
              .trigger("change");
          },
          error: function () {},
        });

        $(".user_section").hide();
        $(".team_section").show();
        store_from_list = true;
        $("#modal_event").modal("show");
      });
    });
  }

  function ajaxData() {
    $.ajax({
      url: url.list,
      data: {
        search_type: search_type_filter,
        search: $("#txt_search").val(),
        team_id: $('select[name="team_filter"]').val(),
        event_id: $('select[name="event"]').val(),
        course: $('select[name="filter_course"]').val(),
        course_n: $('select[name="filter_course_n"]').val(),
        flight_n: $('select[name="filter_flight_n"]').val(),
        csrf_token: $("meta[name='csrf-token']").attr("content"),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {
        $(".course_flight").empty("");
      },
      success: function (result) {
        toastr.remove();
        if (!Object.keys(result.data).length) {
          $(".record").hide();
          $(".no-record").show();
          return false;
        }
        $(".no-record").hide();
        $(".record").show();
        for (var i = 1; i <= 18; i++) {
          if (!result.show) {
            if (typeof result.data[i] === "undefined") {
              continue;
            }
          }

          const str = "ABC";
          for (var j = 0; j < str.length; ++j) {
            var chr = str.charAt(j);

            if (!result.show) {
              if (typeof result.data[i][chr] === "undefined") {
                continue;
              }
            }

            $(".course_flight").append(
              `
              <tr>
              <td class="p-0" align="center" colspan="6">
                  <div class="p-1 text-center bg-dark font-weight-normal">
                      <span class="text-lg">Flight ` +
                (i + "" + chr) +
                `</span>
                  </div>
                  </th>
              </tr>
              `
            );
            if (typeof result.data[i] !== "undefined") {
              if (typeof result.data[i][chr] !== "undefined") {
                $.each(result.data[i][chr], function (iii, vvv) {
                  $(".course_flight").append(
                    `
                  <tr class="text-center text-md">
                                      <td class=" align-middle p-1 dt-center">
                                      <a data-id=` +
                      vvv.id +
                      ` style="color: #007bff; cursor:pointer; text-decoration: underline;">
                                      ` +
                      (vvv.firstname + " " + vvv.lastname) +
                      `
                      </a></td>
                      <td class=" align-middle p-1 dt-center">` +
                      (vvv.partner ? vvv.partner : `--`) +
                      `</td>
                                      <td class=" align-middle p-1 dt-center">` +
                      vvv.course +
                      `</td>
                      <td class=" align-middle p-1 dt-center">` +
                      vvv.team +
                      `</td> 
                                      <td class=" align-middle p-1 dt-center">` +
                      (vvv.attendance
                        ? `<span class="text-sm badge badge-success font-weight-normal">Present | ` +
                          vvv.attendance +
                          `</span>`
                        : `<span class="text-sm badge badge-danger font-weight-normal">Out</span>`) +
                      `</td> 
                                      <td data-action-event="` +
                      vvv.id +
                      `" class=" align-middle p-1 dt-center">
                                      <span style="cursor:pointer;" class="text-sm badge badge-primary font-weight-normal">Transfer</span>
                  </td>
                </tr>
              `
                  );
                });
              } else {
                if (result.show) {
                  $(".course_flight").append(`
                    <tr>
                      <td class="text-center text-danger" colspan="6">No record...</th>
                    </tr>
                `);
                }
              }
            } else {
              if (result.show) {
                $(".course_flight").append(`
                    <tr>
                      <td class="text-center text-danger" colspan="6">No record...</th>
                    </tr>
                `);
              }
            }
            //check if data exist to current loop
          }
        }

        initActionUser();
        initActionEvent();
      },
      error: function () {
        toast("error", "Error has occurred. Try again.");
      },
    });
  }

  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        ajaxData();
      }, 500)
    );

    const search_type_default = "Member Name";
    const search_types = [
      "Member ID",
      "Member Name",
      "Member Email",
      "Member Mobile",
    ];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        ajaxData();
        //  }
      });
    });
  }

  $(function () {
    initList();
    $("[name=event]").select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: url.event_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $(
      'select[name="team_filter"],select[name="filter_course"],select[name="filter_course_n"],select[name="filter_flight_n"]'
    ).on("change", function (event) {
      ajaxData();
    });

    $('select[name="event"]').on("change", function (event) {
      $('select[name="team_filter"]').empty().trigger("change");
      if (!isEmpty($(this).val()) && parseInt($(this).val())) {
      } else {
      }
    });

    $('select[name="mate"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search name.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: url.user_mate_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: $('select[name="event"]').val(),
            exclude_id: store_from_list
              ? user_id
              : $('select[name="user"]').val(),
            limit: 15,
            course: $('select[name="course_n"]').val(),
            flight: $('select[name="flight_n"]').val(),
            course_cat: $('select[name="course"]').val(),
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('[name="team"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: url.team_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: $('select[name="event"]').val(),
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('[name="team_filter"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Please Select";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: url.team_filter_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: $('select[name="event"]').val(),
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $("#div_event_date").datetimepicker({
      format: "L",
    });
    $("[data-mask]").inputmask();

    $("#reload-list").on("click", function () {
      ajaxData();
    });

    $("#public-list").on("click", function () {
      if (!parseInt($('select[name="event"]').val())) {
        toastr.error("Select event first.");
        return false;
      }
      window.open(url.public_list + $('select[name="event"]').val(), "_blank");
    });

    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });

    $EventForm.validate({
      rules: {},
      messages: {
        team: "This field is required.",
      },
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $EventForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);

        if (store_from_list) {
          formData.append("user_id", user_id);
        } else {
          formData.append("user_id", $("select[name='user']").val());
        }

        formData.append("event", $('select[name="event"]').val());
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: url.create_add_to_evt_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_event").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              // var newOption = new Option(result.name, result.id, false, false);
              // $('select[name="team"]').empty().trigger("change");

              // $("select[name='team']").append(newOption).trigger("change");
              ajaxData();
              $("#modal_event").modal("hide");
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_event").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_event").prop("disabled", false);
          },
        });
      },
    });

    $("#btn_add_team").on("click", function () {
      $("#modal_team_pop input[name=team_name]").val("");
      $("#modal_team_pop").modal("show");
      $("#modal_team_pop input[name=team_name]").trigger("focus");
    });

    const $btn_add_mate = $("#btn_add_mate");
    $btn_add_mate.on("click", function () {
      create_from_mate = true;
      $UserForm.trigger("reset");
      $("#modal_user").modal("show");
      $("input[name=firstname]").trigger("focus");
    });

    $TeamPopForm.validate({
      rules: {
        team_name: {
          required: true,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $TeamPopForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("event_id", $('select[name="event"]').val());
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: url.create_team_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_team_pop").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              var newOption = new Option(
                result.name,
                result.team_id,
                false,
                false
              );
              $("#modal_event select[name='team']")
                .empty()
                .append(newOption)
                .trigger("change");

              $("#modal_team_pop").modal("hide");
            } else if (parseInt(result.status) === 2) {
              toastr.remove();
              toastr.error(result.message);
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_team_pop").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_team_pop").prop("disabled", false);
          },
        });
      },
    });

    $UserForm.validate({
      rules: {
        firstname: {
          required: true,
        },
        lastname: {
          required: true,
        },
        email: {
          email: true,
        },
        mobile: {
          digits: true,
          minlength: 5,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $UserForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        if (!create_from_mate) {
          formData.append("user_id", user_id);
        }
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: url.create_users_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");
              $("#modal_user").modal("hide");
              ajaxData();
              if (create_from_mate) {
                var newOption = new Option(
                  result.name,
                  result.id,
                  false,
                  false
                );
                $("select[name='mate']")
                  .empty()
                  .append(newOption)
                  .trigger("change");
              }
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save").prop("disabled", false);
          },
        });
      },
    });

    //comfig
    $(document).on("show.bs.modal", ".modal", function () {
      const zIndex = 1040 + 10 * $(".modal:visible").length;
      $(this).css("z-index", zIndex);
      setTimeout(() =>
        $(".modal-backdrop")
          .not(".modal-stack")
          .css("z-index", zIndex - 1)
          .addClass("modal-stack")
      );
    });
    $(document).on("select2:open", () => {
      document.querySelector(".select2-search__field").focus();
    });
  });
})();
