<?php

namespace App\Models;

use App\Core\Database;
use App\Core\Model;

class Sms extends Model
{
    public function getSettings($array_data)
    {
        $query = "SELECT * FROM golf_sms_settings WHERE 1 AND id = ?";
        $paramType = "i";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function createLog($array_data)
    {
        $query = "INSERT INTO `golf_sms_report` (`send_sms_id`,`created_at`,`target_id`,`response`) VALUES (?,?,?,?)";
        $paramType = "isis";
        return Database::connect()->insert($query, $paramType, $array_data);
    }
    public function createTextBlast($array_data)
    {
        $query = "INSERT INTO `golf_sms_send` (
        `progress`,
        `user_id`,
        `data`,
        `created_at`,
        `description`,
        `status`) VALUES (?,?,?,?,?,?)";
        $paramType = "sisssi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getSmsStatus($array_data)
    {
        $query = "SELECT * FROM golf_sms_report WHERE 1 AND send_sms_id = ? AND target_id = ? AND response = 1 ";
        $paramType = "ii";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function getExist($array_data)
    {
        $query = "SELECT COUNT(1) FROM golf_sms_report sr 
        INNER JOIN golf_sms_send ss 
        ON sr.send_sms_id = ss.id
        AND  JSON_UNQUOTE(JSON_EXTRACT(ss.`data`, '$.event_id')) = ?
        AND  JSON_UNQUOTE(JSON_EXTRACT(ss.`data`, '$.sms_settings_id')) = ?
        WHERE sr.target_id = ?
        AND sr.response = 1
        AND ss.status = 1 ";
        $paramType = "iii";
        return Database::connect()->select($query, $paramType, $array_data);
    }

    public function getQuery()
    {
        return  "SELECT %s FROM golf_sms_send ss
        INNER JOIN golf_users u
        ON ss.user_id = u.id
        LEFT OUTER JOIN golf_events e 
        ON e.id = JSON_UNQUOTE(JSON_EXTRACT(ss.`data`, '$.event_id'))
        WHERE 1 
        AND ss.status = 1
        %s /*type*/
        %s 
        %s 
        %s
        ";
    }

    public function getQueryData()
    {
        return  "SELECT 
        %s
        FROM golf_sms_report sr
        LEFT OUTER JOIN golf_users u 
        ON sr.target_id = u.id
        WHERE 1 
        %s  /*filters*/
        AND sr.send_sms_id = ?
        %s 
        %s
        ";
    }
    public function getSms($array_data)
    {
        $fields = "  e.id as event_id,e.name as event_name,ss.*,u.firstname,u.lastname, CONCAT(u.firstname,' ' ,u.lastname) as user";
        $query = sprintf($this->getQuery(), $fields, $array_data['type'],  $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getSmsData($array_data)
    {
        $fields = "  sr.*,CONCAT(u.firstname,' ',u.lastname) as target,u.mobile  ";
        $query = sprintf($this->getQueryData(), $fields, $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);
        $paramType = "si";
        $paramValue = array(
            $array_data['search_keyword'],
            $array_data['id'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getSmsDataListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getQueryData(),
            $fields,
            'AND  ?',
            '',
            ''
        );
        $paramType = "si";
        $paramValue = array(
            "1",
            $array_data['id'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getSmsDataListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getQueryData(),
            $fields,
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "si";
        $paramValue = array(
            $array_data['search_keyword'],
            $array_data['id'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }


    public function getSmsListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getQuery(),
            $fields,
            $array_data['type'],
            'AND  ?',
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array("1");
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getSmsListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getQuery(),
            $fields,
            $array_data['type'],
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getSmsSend($array_data)
    {
        $query = "SELECT * FROM golf_sms_send ss WHERE 1 
        AND ss.progress = ? 
        AND JSON_UNQUOTE(JSON_EXTRACT(ss.`data`, '$.type')) = ?
        ORDER BY created_at ASC LIMIT 1";
        $paramType = "ss";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);

        // echo $query;
        // exit;

        return count($response) > 0 ? $response[0] : $response;
    }
    public function updateSmsSend($array_data)
    {
        $query = "UPDATE golf_sms_send SET progress = ? WHERE 1 AND id = ?";
        $paramType = "si";
        return  Database::connect()->update($query, $paramType, $array_data);
    }

    public function getSmsOptions($array_data)
    {
        $query = "SELECT id,name as text FROM golf_sms_settings
                WHERE 1 
                AND name LIKE ? 
                AND status = 1 
                ORDER BY `id` DESC
                LIMIT ?";

        $paramType = "si";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }

    public function getTotalCount($array_data)
    {
        $query = "SELECT COUNT(1) FROM golf_sms_report WHERE send_sms_id=  ? ";
        $paramType = "i";
        return Database::connect()->select($query, $paramType, $array_data);
    }
    public function getStatusCount($array_data)
    {
        $query = "SELECT COUNT(1) FROM golf_sms_report WHERE send_sms_id =  ? AND response = ?";
        $paramType = "is";
        return Database::connect()->select($query, $paramType, $array_data);
    }

    public function updateTemplate($array_data)
    {
        $query = "UPDATE `golf_sms_settings` SET `name` = ?, `message_body`=? , status = ?,`event_id` = ? WHERE id = ?";
        $paramType = "ssiii";
        return  Database::connect()->update($query, $paramType, $array_data);
    }

    public function createTemplate($array_data)
    {
        $query = "INSERT INTO `golf_sms_settings` (`name`,`created_at`,`message_body`,`status`,`event_id`) VALUES (?,?,?,?,?)";
        $paramType = "sssii";
        return  Database::connect()->insert($query, $paramType, $array_data);
    }


    ////////////
    public function getTemplateQuery()
    {
        return "SELECT %s FROM golf_sms_settings t
        WHERE 1
        AND t.status = 1  
        %s /*filters*/
        %s /*order*/
        %s /*limit*/
        
         ";
    }
    public function getTemplates($array_data)
    {
        $fields = " t.* ";
        $query = sprintf($this->getTemplateQuery(), $fields, $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);

        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getTemplatesCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getTemplateQuery(),
            $fields,
            'AND  ?',
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array("1");
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getTemplatesFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getTemplateQuery(),
            $fields,
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function updateTemplateStatus($array_data)
    {
        $query = "UPDATE golf_sms_settings SET status = ? WHERE id = ?";
        $paramType = "ii";
        return Database::connect()->update($query, $paramType, $array_data);
    }

    public function getTemplate($array_data)
    {
        $query = "SELECT ss.*,e.id as event_id, e.name as event_name FROM golf_sms_settings  ss
        LEFT OUTER JOIN golf_events e
        ON ss.event_id = e.id
        WHERE 1 AND ss.id = ? ";
        $paramType = "i";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
}
