<?php

namespace App\Models;

use App\Core\Database;
use App\Core\Model;

class Import extends Model
{


    public function getImportFields($module_id)
    {
        $query = "SELECT * FROM import_module_fields WHERE 1 AND module_id = ?";
        $queryType = "i";
        $queryValue = array(
            $module_id,
        );
        return Database::connect()->runQuery($query, $queryType, $queryValue);
    }
    public function updateImportFields($array_data)
    {
        $query = "UPDATE `import_module_fields` SET `field`=? WHERE 1 AND id = ?";
        $queryType = "si";
        $queryValue = array(
            strtoupper($array_data['value']),
            $array_data['key'],
        );

        return Database::connect()->update($query, $queryType, $queryValue);
    }

    public function  getSummaryIndex($str, $col_count, $array)
    {
        for ($i = 0; $i < $col_count; $i++) {
            if (in_array($str, $array, true)) {
                return $i;
            }
        }
        return -2;
    }



    function getFieldName($row, $col_count, $array_data)
    {

        for ($i = 0; $i < $col_count; $i++) {
            if (in_array(trim($row[$i]), $array_data, true)) {
                return $row[$i];
            }
        }
        return "";
    }

    function checkExist($row_arr, $field, $headers_arr)
    {
        if (empty($field)) {
            return "";
        }
        $key = array_search($field, $headers_arr);
        return  isset($row_arr[$key]) ? $row_arr[$key] : '';
    }
}
