<?php

namespace App\Models;

use App\Core\Database;
use App\Core\Model;

class Event extends Model
{
    public function getEvent($array_data)
    {
        $query = "SELECT * FROM golf_events WHERE 1 AND id = ?";
        $paramType = "i";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

  


    public function getEventTemplate($array_data)
    {
        $query = "SELECT ss.id,ss.name FROM golf_sms_settings ss
        INNER JOIN golf_events e
        ON ss.event_id = e.id
        WHERE 1 
        AND ss.event_id =  ?
        AND ss.status = 1
        LIMIT 1
        ";
        $paramType = "i";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function createEvent($array_data)
    {
        $query = "INSERT INTO `golf_events` (`name`,`created_at`,`date`,`description`,`status`) VALUES (?,?,?,?,?)";
        $paramType = "ssssi";
        return  Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getEventOptions($array_data)
    {
        $query = "SELECT id,name as text FROM golf_events
                WHERE 1 
                AND name LIKE ? 
                AND status = 1 
             
                ORDER BY `id` DESC
                LIMIT ?";

        $paramType = "si";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }

    public function updateEvent($array_data)
    {
        $query = "UPDATE `golf_events` SET `name` = ? ,`date` = ?,`description`=? , status = ? WHERE id = ?";
        $paramType = "sssii";
        return  Database::connect()->update($query, $paramType, $array_data);
    }

    public function getEvents($array_data)
    {
        $fields = " e.id,e.name,e.date,e.created_at,
        (SELECT  
        COUNT(1)
        FROM `golf_users` u
                LEFT OUTER JOIN golf_players p 
                ON u.id = p.user_id
                WHERE 1 
                AND u.status = 1 
                AND u.active = 1 
                AND p.status = 1
                AND u.is_admin IS NULL 
                AND p.event_id = e.id) as joined  ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_events e
        WHERE 1
        AND e.status = 1
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf($queryf, $fields, $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);
        // echo $query;
        // exit;
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getEventsListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_events e
        WHERE 1
        AND e.status = 1
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf(
            $queryf,
            $fields,
            'AND  ?',
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array("1");
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getEventsListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_events e
        WHERE 1
        AND e.status = 1
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf(
            $queryf,
            $fields,
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function updateEventStatus($array_data)
    {
        $query = "UPDATE golf_events SET status = ? WHERE id = ?";
        $paramType = "ii";
        return Database::connect()->update($query, $paramType, $array_data);
    }
    public function getEventBoot($event_id)
    {
        $fields = " et.event_id,et.boot_id,b.id,b.code,b.name";
        $queryf = "SELECT %s /*fields*/
        FROM event_booth_tagging et
        LEFT JOIN booth b ON et.boot_id = b.id

        WHERE 1
        AND et.active= 1
        AND et.event_id =".$event_id;
        $query = sprintf(
            $queryf,
            $fields,
        );
        return Database::connect()->runQueries($query);
        // $paramType = "i";
        // $paramValue = array($array_data);
        // return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getEventBootPlayer($event_id,$player_id)
    {
        $fields = " et.event_id,et.boot_id,b.id,b.code,b.name,ep.created_at as date_claimed";
        $queryf = "SELECT %s /*fields*/
        FROM event_booth_tagging et
        LEFT JOIN booth b ON et.boot_id = b.id
        LEFT JOIN event_booth_player ep ON et.event_id = ep.event_id AND et.boot_id = ep.booth_id AND ep.player_id=".$player_id." AND ep.active=1
        WHERE 1
        AND et.active= 1
        AND et.event_id =".$event_id." ORDER BY b.name ASC";
        $query = sprintf(
            $queryf,
            $fields,
        );
        // echo $query;exit;
        return Database::connect()->runQueries($query);
        // $paramType = "i";
        // $paramValue = array($array_data);
        // return Database::connect()->select($query, $paramType, $paramValue);
    }
}
