<?php

namespace App\Models;

//Tips for impelementing codes

use App\Core\Model;
use App\Core\Database;

class Device extends Model
{
    public function getDevices($array_data)
    {
        $fields = " * ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_devices 
        WHERE 1 
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf($queryf, $fields, $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);
        // echo $query;
        // exit;
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getDevicesListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_devices
        WHERE 1 
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf(
            $queryf,
            $fields,
            'AND  ?',
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array("1");
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getDevicesListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";
        $queryf = "SELECT %s /*fields*/
        FROM golf_devices
        WHERE 1 
        %s /*filters*/
        %s /*sort & order*/
        %s /*limit*/
        ";
        $query = sprintf(
            $queryf,
            $fields,
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function updateDeviceStatus($array_data)
    {
        $query = "UPDATE golf_devices SET status = ? WHERE id = ?";
        $paramType = "ii";
        return Database::connect()->update($query, $paramType, $array_data);
    }
    public function removeDevice($array_data)
    {
        $query = "DELETE FROM golf_devices  WHERE id = ?";
        $paramType = "i";
        return Database::connect()->update($query, $paramType, $array_data);
    }
}
