<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\View;
use App\Utilities\Utility;
use App\Utilities\Auth;

class SmsController extends Controller
{
    private $sms;
    private $user;
    function __construct()
    {
        $this->sms = new \App\Models\Sms;
        $this->user = new \App\Models\User;
    }
    public function invitationIndex()
    {
        $page_title = "Text Blast Send Invitation";
        View::render('sms/invitation', get_defined_vars());
    }

    public function qrIndex()
    {
        $page_title = "Text Blast Send QR";
        View::render('sms/qr', get_defined_vars());
    }

    public function qrDataIndex($id)
    {
        $page_title = "Text Blast QR Report";
        View::render('sms/qr.data', get_defined_vars());
    }


    public function reminderIndex()
    {


        $course_options = "";
        $division_options = "";

        $course_response = $this->user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $this->user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        $page_title = "Text Blast Send Reminder";

        View::render('sms/reminder', get_defined_vars());
    }

    public function reminderDataIndex($id)
    {
        $page_title = "Text Blast Reminder Report";
        View::render('sms/reminder.data', get_defined_vars());
    }


    public function templatesIndex()
    {
        $page_title = "SMS Templates";
        View::render('sms/template/list', get_defined_vars());
    }

    public function invitationDataIndex($id)
    {
        $page_title = "Text Blast Report";
        View::render('sms/invitation.data', get_defined_vars());
    }

    public function createTextBlast()
    {

        // `progress`,
        // `user_id`,
        // `data`,
        // `created_at`,
        // `description`,
        // `status`

        switch (input('type')) {
            case 'invitation':
                $data = array(
                    "event_id" => input("event"),
                    "sms_settings_id" => input("template"),
                    "exclude_texted" => input("chk_exclude"),
                    "type" => input('type'),
                );
                break;
            case 'qr':
                $data = array(
                    "event_id" => input("event"),
                    "sms_settings_id" => input("template"),
                    "exclude_texted" => input("chk_exclude"),
                    "type" => input('type'),
                );
                break;
            case 'reminder':
                $data = array(
                    "event_id" => input("event"),
                    "sms_settings_id" => input("template"),
                    "exclude_texted" => input("chk_exclude"),
                    "registration_status" => input("registration_status"),
                    "division" => input('division'),
                    "course" => input('course'),
                    "type" => input('type'),
                );
                break;
            default:
                response()->json(array(
                    "status" => 0,
                    "message" => "Type not found.",
                ));
        }

        $array_data = array(
            "pending",
            Auth::user()->id,
            json_encode($data),
            date('Y-m-d H:i:s'),
            input('txt_description'),
            1,
        );

        // $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        $id = $this->sms->createTextBlast($array_data);

        response()->json(array(
            "status" => 1,
            "id" => $id,
            "message" => "Successfully saved.",
        ));
    }



    public function list()
    {

        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');
        $array_data['type'] = " AND JSON_UNQUOTE(JSON_EXTRACT(ss.`data`, '$.type')) = '" . input('type') . "' ";

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY ss.created_at DESC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND ss.id = ? ";
                    break;
                case "Event Name":
                    $array_data['filters'] = " AND e.name LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "User Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
            }
        }

        // print_r($array_data);
        // exit;
        $results =  $this->sms->getSms($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $result['data'][] = array(
                "id" => $row['id'],
                "created_at" => date('m/d/Y', strtotime($row['created_at'])),
                "user" => $row['firstname'] . ' ' . $row['lastname'],
                "event_id" => $row['event_id'],
                "event_name" => $row['event_name'],
                "progress" => $row['progress'],
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->sms->getSmsListCount($array_data);
        $result['recordsFiltered'] = $this->sms->getSmsListFilteredCount($array_data);

        response()->json($result);
    }

    public function listDataCount()
    {
        $id = input('id');
        $total = $this->sms->getTotalCount(array($id));
        $success = $this->sms->getStatusCount(array($id, 1));
        response()->json(array(
            "success" => $success,
            "failed" => ($total - $success),
        ));
    }

    public function listData()
    {

        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');
        $array_data['id'] = input('id');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY target ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND sr.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
            }
        }

        // print_r($array_data);
        // exit;
        $results =  $this->sms->getSmsData($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $row = Utility::emptyNullArray($row);
            $result['data'][] = array(
                "id" => $row['id'],
                "target" => $row['target'],
                "mobile" => $row['mobile'],
                "created_at" => date('m/d/Y', strtotime($row['created_at'])),
                "response" => $row['response'],
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->sms->getSmsDataListCount($array_data);
        $result['recordsFiltered'] = $this->sms->getSmsDataListFilteredCount($array_data);

        response()->json($result);
    }

    public function cron() //deprecated
    {

        ini_set('max_execution_time', '0');
        set_time_limit(0);
        //same code above
        ini_set('memory_limit', '-1');

        // curl -H "App-Dev-Id: 626ca81708a1f" https://localhost/cron/lto/orcr_plate/sms --insecure
        // curl -H "app-dev-id: 626ca81708a1f" http://golf.autohub.ph/cron/sms

        $headers = apache_request_headers();

        if (!isset($headers['App-Dev-Id'])) {
            echo "Access Denied";
            exit;
        }
        if ($headers['App-Dev-Id'] != "626ca81708a1f") {
            echo "Invalid Key";
            exit;
        }

        $response = $this->sms->getSmsSend(array("pending"));


        if (!empty($response)) {

            $response_data = json_decode($response['data'], true);

            $sms_settings = $this->sms->getSettings(array($response_data['sms_settings_id']));

            if (empty($sms_settings)) {
                response()->json(array("status" => 0, "message" => "Invalid sms_settings_id."));
            }

            if (empty($sms_settings['message_body'])) {
                response()->json(array("status" => 0, "message" => "Message is empty."));
            }


            if (!$sms_settings['status']) {
                response()->json(array("status" => 0, "message" => "Sms template is disabled."));
            }

            $event_id = $response_data['event_id'];
            $event  = new \App\Models\Event();
            $event_data = $event->getEvent(array($event_id));

            if (empty($event_data)) {
                response()->json(array("status" => 0, "message" => "Invalid event_id."));
            }

            $this->sms->updateSmsSend(array("in_progress", $response['id']));

            //fetch all user for loop
            $user  = new \App\Models\User();
            $users = $user->getPlayersGroupByMobile();
            $sms_api = config('api')->sms;
            $array_data['uri'] = $sms_api['uri'];

            $counter['failed'] = 0;
            $counter['success'] = 0;
            foreach ($users as $users_row) {
                //check if already send
                $sms_status_arr = $this->sms->getSmsStatus(array($response['id'], $users_row['id']));
                if (empty($sms_status_arr)) {

                    $replace_parameter = array(
                        '{firstname}' => $users_row['firstname'],
                        '{lastname}' => $users_row['lastname'],
                        '{name}' => $users_row['firstname'] . ' ' . $users_row['lastname'],
                        '{email}' => $users_row['email'],
                        '{mobile}' => $users_row['mobile'],
                    );

                    $formatted_message = strtr($sms_settings['message_body'], $replace_parameter);

                    $array_data['parameters'] = array(
                        "key" => $sms_api['key'],
                        "mobile" => $users_row['mobile'],
                        "message" => $formatted_message,
                    );
                    $sms_response  = '{"status":1,"message":"success"}'; //Utility::curl($array_data); 

                    $sms_response = json_decode($sms_response, true);

                    if ($sms_response['status'] == "1") {
                        $counter['success']++;
                        $sms_response_status = $sms_response['status'];
                    } else {
                        $counter['failed']++;
                        $sms_response_status =  $sms_response['response'];
                    }
                    $this->sms->createLog(array(
                        $response['id'],
                        date('Y-m-d H:i:s'),
                        $users_row['id'],
                        $sms_response_status,
                    ));
                }
            }


            $this->sms->updateSmsSend(array("complete", $response['id']));

            response()->json(array("status" => 1, "message" => "Done.", "total" => count($users), "success" => $counter['success'], "failed" => $counter['failed']));
        }
        response()->json(array("status" => 1, "message" => "No pending sms."));
    }



    public function settingsOptions()
    {

        $array_data['search'] = input('search');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');


        $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $this->sms->getSmsOptions(
            array(
                $array_data['search'],
                $array_data['limit']
            )
        ));

        response()->json($results);
    }



    public function templatesCreate()
    {

        $array_data = array(
            input('txt_name'),
            date('Y-m-d H:i:s'),
            input('txt_template'),
            1,
            empty(input('event')) ? null  : input('event'),
        );

        $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        if (input('template_id')) {
            $array_data[] = input('template_id');
            unset($array_data[1]);
            $array_data = array_values($array_data);
            $template_id = input('template_id');
            $this->sms->updateTemplate($array_data);
        } else {
            $template_id = $this->sms->createTemplate($array_data);
        }

        response()->json(array(
            "status" => 1,
            "template_id" => $template_id,
            "message" => "Successfully saved.",
        ));
    }

    public function templatesList()
    {

        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY t.name ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND t.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND t.name LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
            }
        }

        $results =  $this->sms->getTemplates($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $result['data'][] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "created_at" => $row['created_at'] ? date('m/d/Y', strtotime($row['created_at'])) : NULL,
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->sms->getTemplatesCount($array_data);
        $result['recordsFiltered'] = $this->sms->getTemplatesFilteredCount($array_data);

        response()->json($result);
    }

    public function templateUpdateStatus()
    {
        $this->sms->updateTemplateStatus(
            array(
                intval(input('status')) ? input('status') : null,
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }

    public function templateFetch()
    {

        $response =  $this->sms->getTemplate(
            array(
                input('id'),
            )
        );

        response()->json($response);
    }
}
