<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\View;
use App\Utilities\Utility;
use App\Utilities\Uuid;
use App\Utilities\Auth;

class EventController extends Controller
{
    private $event;
    private $user;
    function __construct()
    {
        $this->event = new \App\Models\Event;
        $this->user = new \App\Models\User;
    }

    public function eventsIndex()
    {
        $page_title = "Events List";
        View::render('event/list', get_defined_vars());
    }

    public function dashboard($event_id)
    {
        $array_data['course'] = !empty(input('course')) ? (input('course') == 'no' ? ' AND p.course_id IS NULL ' : ' AND p.course_id = ' . input('course')) : '';
        $array_data['division'] = !empty(input('division')) ? (input('division') == 'no' ? ' AND p.division_id IS NULL ' : ' AND p.division_id = ' . input('division')) : '';
        $array_data['course_n'] = !empty(input('course_n')) ? (input('course_n') == 'no' ? ' AND p.course IS NULL ' : ' AND p.course = "' . input('course_n') . '"') : '';
        $array_data['flight_n'] = !empty(input('flight_n')) ? (input('flight_n') == 'no' ? ' AND p.flight IS NULL ' : ' AND p.flight = "' . input('flight_n') . '"') : '';

        $array_data['where'] = $array_data['division'] . $array_data['course'] . $array_data['course_n'] . $array_data['flight_n'];

        $array_data['id'] = $event_id;
        $array_data['filters'] = " AND pa.id IS NOT NULL AND p.registration_status = 'registered' ";
        $present = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND pa.id IS NULL AND p.registration_status = 'registered' ";
        $absent = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.division_id = 2 ";
        $sponsor_division = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.division_id = 1 ";
        $player_division = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.registration_status = 'registered' ";
        $registered = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.registration_status = 'unregistered' ";
        $unregistered = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.registration_type = 'paid' ";
        $paid = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.registration_type = 'unpaid' ";
        $unpaid = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.course_id = 1 ";
        $player_course = $this->user->getDashboard($array_data);

        $array_data['filters'] = " AND p.course_id = 2 ";
        $palmer_course = $this->user->getDashboard($array_data);

        return array(
            "present" => $present,
            "absent" => $absent,
            "sponsor_division" => $sponsor_division,
            "player_division" => $player_division,
            "registered" => $registered,
            "unregistered" => $unregistered,
            "paid" => $paid,
            "unpaid" => $unpaid,
            "player_course" => $player_course,
            "palmer_course" => $palmer_course,
        );
    }

    public function getDashboard($event_id)
    {
        $dashboard = $this->dashboard($event_id);
        response()->json(array(
            "status" => 1,
            "data" => $dashboard,
            "message" => "Success",
        ));
    }

    public function eventsData($id)
    {
        $user = new \App\Models\User();
        $course_options = "";
        $division_options = "";

        $course_response = $user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        $event_data  = $this->event->getEvent(array($id));
        $page_title = $event_data['name'] . " Participants";
        $dashboard = $this->dashboard($id);
        // print_r($dashboard);
        // exit;
        $checkBooth =($this->event->getEventBoot($id)->num_rows > 0 ? '' : 'hidden');
        View::render('event/joined', get_defined_vars());
    }

    public function checkBoooth(){
            $event_id = input('event_id');
            $res = $this->event->getEventBoot($event_id);
            if($res->num_rows>0){return intval(1);}else{return intval(0);}
        }
        //modify
       public function getEventBoot($event_id)
       {
            $data = [];
            // $event_id = input('event_id');
            $res = $this->event->getEventBoot($event_id);
            // var_dump($res);
            if($res->num_rows>0)
            {
                foreach ($res as $boot) {
                    $data[] = [
                        'event_id'=> $boot['event_id'],
                        'boothName' => $boot['name'],
                        'booth_id' => $boot['id'],
                        'booth_code' => $boot['code'],
                        // 'orderable' => true,
                        // 'width' => '5%',
                       
                    ];
                }
            }
            return $data;
            
            // return response()->json($data);
        }
        //modify
        public function getEventBoot2()
       {
            $data = [];
            $event_id = input('event_id');
            $player_id = input('player_id');
            $res = $this->event->getEventBootPlayer($event_id,$player_id);
            // echo $res;exit;

            if($res->num_rows>0)
            {
                foreach ($res as $booth) {
                 
                    $data[] = [
                        'event_id'=> $booth['event_id'],
                        'boothName' => $booth['name'],
                        'booth_id' => $booth['id'],
                        'booth_code' => $booth['code'],
                        'claimed_date' => ($booth['date_claimed'] !=NULL ? date('h:i A',strtotime($booth['date_claimed'])) : NULL), // if player already claimed
                        'player_id' => $player_id
                        // 'orderable' => true,
                        // 'width' => '5%',
                       
                    ];
                }
            }
            
            return response()->json($data);
        }

    public function create()
    {

        $array_data = array(
            input('txt_name'),
            date('Y-m-d H:i:s'),
            input('txt_event_date') ? date('Y-m-d H:i:s', strtotime(input('txt_event_date'))) : NULL,
            input('txt_description'),
            1,
        );

        $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        if (input('event_id')) {
            $array_data[] = input('event_id');
            unset($array_data[1]);
            $array_data = array_values($array_data);
            $event_id = input('event_id');
            $this->event->updateEvent($array_data);
        } else {
            $event_id = $this->event->createEvent($array_data);
        }

        response()->json(array(
            "status" => 1,
            "event_id" => $event_id,
            "message" => "Successfully saved.",
        ));
    }
    public function status()
    {
        $this->event->updateEventStatus(
            array(
                intval(input('status')) ? input('status') : null,
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }

    public function fetch()
    {

        $response =   $this->event->getEvent(
            array(
                input('id'),
            )
        );

        $response['date'] = empty($response['date']) ? null : date('m/dY', strtotime($response['date']));
        response()->json($response);
    }
    public function list()
    {

        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY e.date DESC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND e.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND e.name LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
            }
        }

        $results =  $this->event->getEvents($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $result['data'][] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "created_at" => $row['created_at'],
                "joined" => $row['joined'],
                "date" =>  $row['date'] ? date('m/d/Y', strtotime($row['date'])) : NULL,
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->event->getEventsListCount($array_data);
        $result['recordsFiltered'] = $this->event->getEventsListFilteredCount($array_data);

        response()->json($result);
    }

    public function options()
    {

        $array_data['search'] = input('search');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');


        $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $this->event->getEventOptions(
            array(
                $array_data['search'],
                $array_data['limit']
            )
        ));
        // $results =  $this->inventory->getLocations($array_data);


        response()->json($results);
    }

    public function template()
    {

        $results = $this->event->getEventTemplate(
            array(
                input('id')
            )
        );
        response()->json($results);
    }

    public function usersImportIndex($id)
    {
        View::render('event/import', get_defined_vars());
    }
    public function usersImport()
    {

        ini_set('max_execution_time', '0');
        set_time_limit(0);
        //same code above
        ini_set('memory_limit', '-1');

        $disk_dir = env('APP_DISK') . input('dir');
        if (!file_exists($disk_dir)) {
            mkdir($disk_dir, 0777, true);
        }

        $log_dir = env('APP_DISK') . input('log_dir');
        if (!file_exists($log_dir)) {
            mkdir($log_dir, 0777, true);
        }


        $import = new \App\Models\Import;

        $import_fields = array(
            'FIRST NAME',
            'LAST NAME',
            'SUFFIX',
            'MOBILE NUMBER',
            'MOBILE NUMBER 2',
            'PHONE',
            'EMAIL ADDRESS',
            'EMAIL ADDRESS 2',
            'MEMBERSHIP',
            'HANDICAP INDEX',
            'UNHS ID',
            'COMPANY',
            'DESIGNATION',
            //START EVENTS FIELDS
            'TEAM',
            'DATE',
            'COURSE TYPE',
            'COURSE',
            'FLIGHT',
            'DIVISION',
            'REGISTRATION',
            'REGISTRATION TYPE',
            'OR NO.',
            'AMOUNT',
            'NOTE',
            'MULLIGANS',
        );


        $object = input()->file('file', $defaultValue = null);
        if ($object->getSize() <= 0) {
            $response['message'] = "File is empty";
            $response['status'] = 0;
            response()->json($response);
        } else {
            //check extension
            $valid_ext =  array('xls', 'csv', 'xlsx');
            if (!in_array($object->getExtension(), $valid_ext)) {
                $response['message'] = "Invalid file extension";
                $response['status'] = 0;
                response()->json($response);
            }

            //gen filename
            $destinationFilename = sprintf('%s.%s', Uuid::long(), $object->getExtension());
            //move file
            $full_dir = $disk_dir . '/' . $destinationFilename;
            $object->move($full_dir);

            // start import process
            $GLOBALS['total_data_count'] = 0;
            $GLOBALS['not_inserted_data_count'] = 0;
            $GLOBALS['inserted_data_count'] = 0;
            $GLOBALS['not_inserted_list_v2'] = array();
            $GLOBALS['data_count_list_v2'] = array();

            $file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($full_dir);
            $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);
            try {

                $spreadsheet = $reader->load($full_dir);
                //remove excel after store to phpspreadsheet
                unlink($full_dir);

                $data = $spreadsheet->getActiveSheet()->toArray();
                $highestRow = $spreadsheet->getActiveSheet()->getHighestRow();
                $highestColumn =  $spreadsheet->getActiveSheet()->getHighestColumn();
                $ColumnNumber = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);

                $data = array_map(array(new Utility(), 'removeNonAscii'), $data);
                $data = array_map(array(new Utility(), 'toUpperCase'), $data);

                $header_column_found = false;
                foreach ($data as $row) {
                    if (!empty(array_filter($row))) {
                        // echo 'Not empty row';
                    } else {
                        continue;
                    }
                    // $row = array_filter($row);
                    // $row = array_values($row);

                    if (!$header_column_found) {

                        // get matched field from database and excel globals
                        $issue_summary_index = $import->getSummaryIndex('SUMMARY', $ColumnNumber, $row);
                        $GLOBALS['fname'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[0]));
                        $GLOBALS['lname'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[1]));
                        $GLOBALS['suffix'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[2]));
                        $GLOBALS['mobile'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[3]));
                        $GLOBALS['other_mobile'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[4]));
                        $GLOBALS['phone'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[5]));
                        $GLOBALS['email'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[6]));
                        $GLOBALS['other_email'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[7]));
                        $GLOBALS['membership'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[8]));
                        $GLOBALS['handicap'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[9]));
                        $GLOBALS['unhs'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[10]));
                        $GLOBALS['company'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[11]));
                        $GLOBALS['designation'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[12]));

                        $GLOBALS['team'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[13]));
                        $GLOBALS['date'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[14]));
                        $GLOBALS['course_type'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[15]));
                        $GLOBALS['course'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[16]));
                        $GLOBALS['flight'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[17]));
                        $GLOBALS['division'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[18]));
                        $GLOBALS['registration'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[19]));
                        $GLOBALS['registration_type'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[20]));
                        $GLOBALS['or_no'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[21]));
                        $GLOBALS['amount'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[22]));
                        $GLOBALS['note'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[23]));
                        $GLOBALS['mulligans'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[24]));

                        // check required fields
                        if (
                            !empty($GLOBALS['fname']) &&
                            !empty($GLOBALS['lname']) //&&
                            // !empty($GLOBALS['mobile'])
                        ) {
                            $header_column_found = true;
                            $GLOBALS['row_headers'] = $row;
                            continue;
                        }
                    } else {
                        $GLOBALS['total_data_count']++;

                        $data_fname = $import->checkExist($row, $GLOBALS['fname'], $GLOBALS['row_headers']);
                        $data_lname = $import->checkExist($row, $GLOBALS['lname'], $GLOBALS['row_headers']);
                        $data_suffix = $import->checkExist($row, $GLOBALS['suffix'], $GLOBALS['row_headers']);
                        $data_suffix = Utility::alphaNumericOnly($data_suffix);

                        $data_mobile = $import->checkExist($row, $GLOBALS['mobile'], $GLOBALS['row_headers']);
                        $data_other_mobile = $import->checkExist($row, $GLOBALS['other_mobile'], $GLOBALS['row_headers']);
                        $data_phone = $import->checkExist($row, $GLOBALS['phone'], $GLOBALS['row_headers']);

                        if (!empty($data_mobile)) {
                            $data_mobile = Utility::remove_non_numeric($data_mobile);
                            $data_mobile = Utility::fix_mobile_format($data_mobile);
                        }
                        if (!empty($data_other_mobile)) {
                            $data_other_mobile = Utility::remove_non_numeric($data_other_mobile);
                            $data_other_mobile = Utility::fix_mobile_format($data_other_mobile);
                        }

                        $data_email = $import->checkExist($row, $GLOBALS['email'], $GLOBALS['row_headers']);
                        $data_other_email = $import->checkExist($row, $GLOBALS['other_email'], $GLOBALS['row_headers']);

                        if (!empty($data_email)) {
                            $data_email = Utility::validateEmail($data_email);
                        }
                        if (!empty($data_other_email)) {
                            $data_other_email = Utility::validateEmail($data_other_email);
                        }


                        $data_membership = $import->checkExist($row, $GLOBALS['membership'], $GLOBALS['row_headers']);
                        $data_handicap = $import->checkExist($row, $GLOBALS['handicap'], $GLOBALS['row_headers']);
                        $data_unhs = $import->checkExist($row, $GLOBALS['unhs'], $GLOBALS['row_headers']);
                        $data_company = $import->checkExist($row, $GLOBALS['company'], $GLOBALS['row_headers']);
                        $data_designation = $import->checkExist($row, $GLOBALS['designation'], $GLOBALS['row_headers']);

                        if (empty($data_company)) {
                            $data_company_id = null;
                        } else {
                            // $data_company = Utility::removeNonAscii($data_company);
                            $data_company_arr = $this->user->getCompany(array($data_company));
                            if (empty($data_company_arr)) {
                                $data_company_id =  $this->user->createCompany(array($data_company));
                            } else {
                                $data_company_id = $data_company_arr['id'];
                            }
                        }
                        if (empty($data_designation)) {
                            $data_designation_id = null;
                        } else {
                            // $data_designation = Utility::removeNonAscii($data_designation);
                            $data_designation_arr = $this->user->getPosition(array($data_designation));
                            if (empty($data_designation_arr)) {
                                $data_designation_id =  $this->user->createPosition(array($data_designation));
                            } else {
                                $data_designation_id = $data_designation_arr['id'];
                            }
                        }

                        if (empty($data_membership)) {
                            $data_membership_id = null;
                        } else {
                            // $data_membership = Utility::removeNonAscii($data_membership);
                            $data_membership_arr = $this->user->getClub(array($data_membership));
                            if (empty($data_membership_arr)) {
                                $data_membership_id =  $this->user->createClub(array($data_membership));
                            } else {
                                $data_membership_id = $data_membership_arr['id'];
                            }
                        }

                        //Validations
                        if (empty($data_fname)) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("NO FIRST NAME"), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }
                        if (empty($data_lname)) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("NO LAST NAME"), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }

                        $array_data = array(
                            $data_fname,
                            null,
                            $data_lname,
                            $data_suffix,
                            $data_mobile,
                            $data_email,
                            $data_other_mobile,
                            $data_other_email,
                            $data_phone,
                            null,
                            null,
                            null,
                            date('Y-m-d H:i:s'),
                            null,
                            null,
                            $data_company_id,
                            $data_designation_id,
                            $data_unhs,
                            $data_membership_id,
                            $data_handicap,
                            1,
                            1,
                        );

                        $array_data = Utility::nullEmptyArray($array_data);


                        $user_id = $this->user->createUser($array_data);

                        if (empty(intval($user_id))) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("FAILED TO CREATE USER " . $user_id), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }

                        //start add player to events
                        $data_course = $import->checkExist($row, $GLOBALS['course_type'], $GLOBALS['row_headers']);
                        $data_course = strtolower(trim($data_course));
                        $data_course = empty(config('course')->id[$data_course]) ? null : config('course')->id[$data_course];

                        // $data_team =  $import->checkExist($row, $GLOBALS['team'], $GLOBALS['row_headers']);
                        // if (!empty($data_team)) {
                        //     $data_team_data = array(
                        //         input('event_id'),
                        //         $data_team,
                        //         date('Y-m-d H:i:s'),
                        //         1,
                        //     );

                        //     $data_team_data = array_map(array(new Utility(), 'cleanString'), $data_team_data);
                        //     $data_team_data = Utility::nullEmptyArray($data_team_data);
                        //     $data_team = $this->user->createTeam($data_team_data);
                        // }


                        ////////////////////////////////
                        $data_team =  $import->checkExist($row, $GLOBALS['team'], $GLOBALS['row_headers']);
                        if (!empty($data_team)) {

                            $team_cleaned = array_map(array(new Utility(), 'cleanString'), array(input('event_id'), $data_team));
                            // print_r($team_cleaned);

                            $data_team_arr = $this->user->getTeam($team_cleaned);

                            // print_r($data_team_arr);

                            if (empty($data_team_arr)) {
                                $data_team_data = array(
                                    input('event_id'),
                                    $data_team,
                                    date('Y-m-d H:i:s'),
                                    1,
                                );

                                $data_team_data = array_map(array(new Utility(), 'cleanString'), $data_team_data);
                                $data_team_data = Utility::nullEmptyArray($data_team_data);
                                $data_team = $this->user->createTeam($data_team_data);
                            } else {
                                $data_team = $data_team_arr['id'];
                            }
                        }
                        ////////////////////////////////


                        $data_division = $import->checkExist($row, $GLOBALS['division'], $GLOBALS['row_headers']);
                        $data_division = strtolower(trim($data_division));
                        $data_division = empty(config('division')->id[$data_division]) ? null : config('division')->id[$data_division];

                        $data_course_n = $import->checkExist($row, $GLOBALS['course'], $GLOBALS['row_headers']);
                        $data_flight_n = $import->checkExist($row, $GLOBALS['flight'], $GLOBALS['row_headers']);

                        $data_mate = $this->user->getMate(array(
                            input('event_id'),
                            $user_id,
                        ));

                        $data_registration = $import->checkExist($row, $GLOBALS['registration'], $GLOBALS['row_headers']);
                        $data_registration = strtolower(trim($data_registration));
                        $data_registration = empty(config('registration')->status[$data_registration]) ? null : config('registration')->status[$data_registration];

                        $data_registration_type = $import->checkExist($row, $GLOBALS['registration_type'], $GLOBALS['row_headers']);
                        $data_registration_type = strtolower(trim($data_registration_type));
                        $data_registration_type = empty(config('registration')->type[$data_registration_type]) ? null : config('registration')->type[$data_registration_type];

                        $registration_date = $data_registration == 'registered' ? date('Y-m-d H:i:s') : null;

                        $data_date = $import->checkExist($row, $GLOBALS['date'], $GLOBALS['row_headers']);
                        $data_date = empty($data_date) ? date('Y-m-d H:i:s') :  date('Y-m-d H:i:s', strtotime($data_date));


                        $array_data = array(
                            input('event_id'),
                            $data_course,
                            $data_team,
                            $data_division,
                            $user_id,
                            $data_course_n,
                            $data_flight_n,
                            $data_mate,
                            $data_registration,
                            $data_registration_type,
                            $registration_date,
                            $data_date,
                            1,
                        );

                        $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
                        $array_data = Utility::nullEmptyArray($array_data);
                        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

                        $player_id = $this->user->createPlayer($array_data);

                        if (empty(intval($player_id))) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("FAILED TO CREATE PLAYER " . $player_id), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }

                        $data_mulligans = $import->checkExist($row, $GLOBALS['mulligans'], $GLOBALS['row_headers']);
                        if (is_numeric($data_mulligans) && !empty($data_mulligans)) {
                            $array_data = array(
                                input('event_id'),
                                $data_mulligans,
                                Auth::user()->id,
                                $user_id,
                                date('Y-m-d H:i:s'),
                                1,
                            );

                            $mulligan_id = $this->user->updateMulligan($array_data);
                        }

                        // echo $mulligan_id . ' ';
                        // exit;
                        //end add player to events

                        $GLOBALS['not_inserted_list_v2'][] = array_merge(array("SUCCESS IMPORT"), $row);
                        $GLOBALS['inserted_data_count']++;
                    }
                }

                if (!$header_column_found) {
                    $return_arr["status"] = 2;
                    $return_arr["message"] = " Header not found.";
                    response()->json($return_arr);
                } else {
                    $return_arr["status"] = 1;
                    $return_arr["gen_file"] = $destinationFilename;
                    $return_arr["orig_file"] = $object->getFilename();
                    $return_arr["total"] = $GLOBALS['total_data_count'];
                    $return_arr["inserted"] = $GLOBALS['inserted_data_count'];
                    $return_arr["not_inserted"] = $GLOBALS['not_inserted_data_count'];
                    $return_arr["message"] = " File Uploaded.";


                    ///START GEN LOG
                    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

                    $GLOBALS['data_count_list_v2'][] = array("Total Data", (string) ($GLOBALS['total_data_count']));
                    $GLOBALS['data_count_list_v2'][] = array("Inserted Data", (string) ($GLOBALS['inserted_data_count']));
                    $GLOBALS['data_count_list_v2'][] = array("Not Inserted Data", (string) ($GLOBALS['not_inserted_data_count']));
                    // $GLOBALS['data_count_list_v2'][] = array("Import By", (string) Session::get('user')['first_name'] . ' ' . Session::get('user')['last_name']);
                    $GLOBALS['data_count_list_v2'][] = array("Import Date", (string)  date('F d, Y'));


                    $data_count_list_v2_count = count($GLOBALS['data_count_list_v2']);

                    $spreadsheet
                        ->getActiveSheet()
                        ->getStyle('B' . ($data_count_list_v2_count + 1) . ':' . (string) $highestColumn . ($data_count_list_v2_count + 1))
                        ->getFill()
                        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('FFFF00');
                    $spreadsheet
                        ->getActiveSheet()
                        ->getStyle('A' . ($data_count_list_v2_count + 1) . '')
                        ->getFill()
                        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('FF0000');

                    $spreadsheet->getActiveSheet()->getStyle('A' . ($data_count_list_v2_count + 1))
                        ->getFont()->getColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_WHITE);

                    $sheet = $spreadsheet->getActiveSheet();
                    for ($i = 'A'; $i != $highestColumn; $i++) {
                        $sheet->getColumnDimension($i)->setAutoSize(true);
                    }

                    foreach ($GLOBALS['not_inserted_list_v2'] as $key => $subArr) {
                        unset($subArr[intval($issue_summary_index) + 1]);
                        $GLOBALS['not_inserted_list_v2'][$key] = $subArr;
                    }

                    unset($GLOBALS['row_headers'][intval($issue_summary_index)]);

                    usort($GLOBALS['not_inserted_list_v2'], function ($a, $b) {
                        return $a[0] <=> $b[0];
                    });

                    $GLOBALS['not_inserted_list_v2'] = array_merge(array(array_map("strtoupper", array_merge(array('SUMMARY'), $GLOBALS['row_headers']))),  $GLOBALS['not_inserted_list_v2']);

                    if ($data_count_list_v2_count > 0) {
                        $GLOBALS['not_inserted_list_v2'] = array_merge($GLOBALS['data_count_list_v2'], $GLOBALS['not_inserted_list_v2']);
                    }

                    $sheet->fromArray($GLOBALS['not_inserted_list_v2'], NULL, 'A1');
                    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
                    $writer->save($log_dir .  '/' . $destinationFilename);

                    //END GEN LOG
                    // echo json_encode($return_arr);
                    response()->json($return_arr);
                }
            } catch (\Exception $e) {
                $response['message'] = "Error has occured " . $e;
                $response['status'] = 0;
                response()->json($response);
            }
        }
    }
    public function usersTemplateDownload()
    {
        $log_dir = env('APP_DISK') . "/import/users/";
        $file = $log_dir . 'User_Event_Template.xlsx';

        $fp = fopen($file, 'rb');

        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=User_Event_Template.xlsx");
        header("Content-Length: " . filesize($file));
        fpassthru($fp);
    }
}
