<?php
namespace App\Console\Commands;

class SmsReminderCron
{
    public static function start()
    {
        ini_set('max_execution_time', '0');
        set_time_limit(0);
        //same code above
        ini_set('memory_limit', '-1');

        $type = "reminder";
        $sms = new \App\Models\Sms();
        $response = $sms->getSmsSend(array("pending", $type));


        if (!empty($response)) {

            $response_data = json_decode($response['data'], true);

            $sms_settings = $sms->getSettings(array($response_data['sms_settings_id']));

            if (empty($sms_settings)) {
                // response()->json(array("status" => 0, "message" => "Invalid sms_settings_id."));
                echo json_encode(array("status" => 0, "message" => "Invalid sms_settings_id."));
            }

            if (empty($sms_settings['message_body'])) {
                // response()->json(array("status" => 0, "message" => "Message is empty."));
                echo json_encode(array("status" => 0, "message" => "Message is empty."));
            }


            if (!$sms_settings['status']) {
                // response()->json(array("status" => 0, "message" => "Sms template is disabled."));
                echo json_encode(array("status" => 0, "message" => "Sms template is disabled."));
            }

            $event_id = $response_data['event_id'];
            $event  = new \App\Models\Event();
            $event_data = $event->getEvent(array($event_id));

            if (empty($event_data)) {
                // response()->json(array("status" => 0, "message" => "Invalid event_id."));
                echo json_encode(array("status" => 0, "message" => "Invalid event_id."));
            }

            $sms->updateSmsSend(array("in_progress", $response['id']));

            //fetch all user for loop
            $user  = new \App\Models\User();
            //get only participants of this event
            $division_id = $response_data['division'];
            $course_id = $response_data['course'];
            $registration_status = $response_data['registration_status'];
            $filters  = " AND p.event_id = " . $event_id;

            if (!empty($division_id)) {
                $filters  .= " AND p.division_id = " . $division_id;
            }
            if (!empty($course_id)) {
                $filters  .= " AND p.course_id = " . $course_id;
            }

            if (!empty($registration_status) && $registration_status != 'all') {
                $filters  .= " AND p.registration_status = '" . $registration_status . "'";
            }

            $users = $user->getEventPlayersGroupByMobile2($filters);


            $sms_api = config('api')->sms;

            $array_data['uri'] = $sms_api['uri'];

            $counter['failed'] = 0;
            $counter['success'] = 0;
            foreach ($users as $users_row) {

                //check if already send
                $sms_status_arr = $sms->getSmsStatus(array($response['id'], $users_row['id']));

                if (empty($sms_status_arr)) {

                    //exclude if already texted with same event and template
                    if (!empty($response_data['exclude_texted'])) {
                        $get_exist = $sms->getExist(array($event_id, $response_data['sms_settings_id'], $users_row['id']));
                        if ($get_exist) {
                            continue;
                        }
                    }

                    // generate qr data
                    if (str_contains($sms_settings['message_body'], '{qr}')) {
                        // $qr_data['id'] = intval($users_row['id']);
                        // $qr_data['data'] = array(
                        //     array(
                        //         "event_id" => intval($event_id)
                        //     ),
                        // );

                        // $qr_link = env('APP_URL') . "/api/v1/qr?data=" . \App\Utilities\Encrypt::encode(json_encode($qr_data));

                        // $shorten_api = config('api')->shorten;
                        // /* $shorten_qr['parameters']*/
                        // $parameters =  http_build_query(array(
                        //     "key" => $shorten_api['key'],
                        //     "url" => urlencode($qr_link),
                        //     "format" => "text",
                        // ));

                        // $shorten_qr['uri'] = $shorten_api['uri'] . "?" . $parameters;
                        // // $shorten_qr['header'] =  ["Content-Type: application/x-www-form-urlencoded"];
                        // $qr_shorten_link  = \App\Utilities\Utility::curl($shorten_qr);
                        $qr_data['id'] = intval($users_row['id']);
                        $qr_data['data'] =
                            array(
                                "event_id" => intval($event_id)
                            );

                        $qr_link = env('EVENT_API_URL') . "/qr?data=" . \App\Utilities\Encrypt::encode(json_encode($qr_data));

                        $shorten_api = config('api')->shorten;
                        /* $shorten_qr['parameters']*/
                        $parameters =  http_build_query(array(
                            "key" => $shorten_api['key'],
                            "url" => urlencode($qr_link),
                            "format" => "text",
                        ));

                        $shorten_qr['uri'] = $shorten_api['uri'] . "?" . $parameters;
                        // $shorten_qr['header'] =  ["Content-Type: application/x-www-form-urlencoded"];
                        
                        // print_r($shorten_qr);
                        // exit;

                        $qr_shorten_link  = \App\Utilities\Utility::curl2($shorten_qr);
                    } else {
                        $qr_shorten_link = "";
                    }

                    $player_data = $user->getPlayer(
                        array(
                            $event_id,
                            $users_row['id'],
                        )
                    );

                    $partner = "";
                    if (str_contains($sms_settings['message_body'], '{partner}')) {
                        $partner = $player_data['partner_name'];
                    }

                    $course_location = "";
                    if (str_contains($sms_settings['message_body'], '{course_location}')) {
                        $course_location = $player_data['course'];
                        if (empty($course_location)) {
                            continue;
                        }
                    }

                    $flight_location = "";
                    if (str_contains($sms_settings['message_body'], '{flight_location}')) {
                        $flight_location = $player_data['flight'];
                        if (empty($flight_location)) {
                            continue;
                        }
                    }


                    $replace_parameter = array(
                        '{firstname}' => $users_row['firstname'],
                        '{lastname}' => $users_row['lastname'],
                        '{name}' => $users_row['firstname'] . ' ' . $users_row['lastname'],
                        '{email}' => $users_row['email'],
                        '{mobile}' => $users_row['mobile'],
                        '{qr}' => $qr_shorten_link,  //shorten this this
                        '{partner}' => $partner,  //shorten this this
                        '{course_location}' => $course_location,
                        '{flight_location}' => $flight_location,
                    );

                    $formatted_message = strtr($sms_settings['message_body'], $replace_parameter);

                    // // $myfile = fopen("schedluer2.txt", "w") or die("Unable to open file!");
                    // // fwrite($myfile, $formatted_message);
                    // // fclose($myfile);
                    // // $users_row['mobile'] = "09389592854";

                    // $array_data['parameters'] = array(
                    //     "key" => $sms_api['key'],
                    //     "mobile" => $users_row['mobile'],
                    //     "message" => $formatted_message,
                    // );
                    // $sms_response  = \App\Utilities\Utility::curl($array_data);
                    // // $sms_response  = '{"status":1,"message":"success"}'; //Utility::curl($array_data); 

                    // $sms_response = json_decode($sms_response, true);

                    // if (!empty($sms_response['status']) && $sms_response['status'] == "1") {
                    //     $counter['success']++;
                    //     $sms_response_status = $sms_response['status'];
                    // } else {
                    //     $counter['failed']++;
                    //     $sms_response_status =  $sms_response['response'];
                    // }
                    // $sms->createLog(array(
                    //     $response['id'],
                    //     date('Y-m-d H:i:s'),
                    //     $users_row['id'],
                    //     $sms_response_status,
                    // ));

                    // $sms_data = ['mobile' => $users_row['mobile'], 'message' => $formatted_message];
                    // $sms_response  = \App\Utilities\Utility::curl($sms_data);
                    // $sms_response4 = json_decode($sms_response, true);
                    // $sms_response = json_decode($sms_response, true);

                    // if (isset($sms_response['Error']) && !$sms_response['Error']) {
                    //     $counter['success']++;
                    //     $sms_response_status = 1;
                    // } else {
                    //     $counter['failed']++;
                    //     $sms_response_status = $sms_response4;
                    // }

                    $sms_data = ['mobile' => $users_row['mobile'], 'message' => $formatted_message];
                        $raw_response  = \App\Utilities\Utility::curl($sms_data);
                    //     $sms->createLog(array(
                    //     $response['id'],
                    //     date('Y-m-d H:i:s'),
                    //     $users_row['id'],
                    //   $raw_response,
                    // ));

                        $sms_response = json_decode($raw_response, true);
                        
                        // // log raw + parsed
                        // $log_status = is_array($sms_response) ? json_encode($sms_response) : $raw_response;

                        // // Check if $sms_response is valid
                        // if (is_array($sms_response) && isset($sms_response['Error']) && !$sms_response['Error'] && ($sms_response['TotalCreditUsed']>0) && ($sms_response['Failed'] ==0)) {
                        //     $counter['success']++;
                        //     $sms_response_status = 1;
                        // } else {
                        //     $counter['failed']++;
                        //     $sms_response_status = $sms_response ? $sms_response : "Invalid response from SMS API";
                        // }
                        
                        if (!is_array($sms_response)) {
                            $sms_response_status = "Invalid response from SMS API: " . var_export($sms_response, true);
                            $counter['failed']++;
                        } elseif (isset($sms_response['Error']) && $sms_response['Error']) {
                            $sms_response_status = "Provider error: " . ($sms_response['Message'] ?? "Unknown");
                            $counter['failed']++;
                        // } elseif (($sms_response['TotalCreditUsed'] ?? 0) > 0) {
                        //     $sms_response_status = "Sent successfully";
                        //     $counter['success']++;
                        } elseif(is_array($sms_response) && isset($sms_response['Error']) && !$sms_response['Error'] && ($sms_response['TotalCreditUsed']>0) && ($sms_response['Failed'] ==0)){
                            $counter['success']++;
                            $sms_response_status = 1;
                        } else {
                            $sms_response_status = "Unknown status: " . json_encode($sms_response);
                            $counter['failed']++;
                        }


                    $sms->createLog(array(
                        $response['id'],
                        date('Y-m-d H:i:s'),
                        $users_row['id'],
                        $sms_response_status,
                    ));

                }
            }


            $sms->updateSmsSend(array("complete", $response['id']));

            // response()->json(array("status" => 1, "message" => "Done.", "total" => count($users), "success" => $counter['success'], "failed" => $counter['failed']));
            echo json_encode(array("response"=>print_r($sms_response) ,"status" =>  $sms_response_status, "message" => "Done.", "total" => count($users), "success" => $counter['success'], "failed" => $counter['failed']));
        }
        // response()->json(array("status" => 1, "message" => "No pending sms."));
        echo json_encode(array("status" => 1, "message" => "No pending sms."));
    }
}
