-- MySQL dump 10.13  Distrib 8.0.24, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: autoph_golf
-- ------------------------------------------------------
-- Server version	8.0.29

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `golf_clubs`
--

DROP TABLE IF EXISTS `golf_clubs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_clubs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_clubs`
--

LOCK TABLES `golf_clubs` WRITE;
/*!40000 ALTER TABLE `golf_clubs` DISABLE KEYS */;
INSERT INTO `golf_clubs` VALUES (1,'FOREST HILLS',1),(2,'EAGLE RIDGE',1),(3,'ORCHARD',1),(4,'RIVIERA',1),(5,'SOUTHWOODS',1),(6,'AGUINALDO',1),(7,'SAN JUANICO GOLF',1),(8,'MIDLANDS',1),(9,'MANILA GOLF',1),(10,'WACK WACK',1),(11,'EASTRIDGE',1),(12,'ALABANG COUNTRY CLUB',1),(13,'ARCHITECT GOLF CLUB',1),(14,'SUMMIT',1),(15,'SUMMIT POINT',1),(16,'VALLEY GOLF',1),(17,'GOLF PH GOLF CLUB',1),(18,'CAPITOL HILLS',1),(19,'STA. ELENA',1),(20,'NOMADS',1),(21,'VILLAMOR',1),(22,'EAST RIDGE',1),(23,'VETERANS GOLF',1),(24,'RIVIERA/TAGAYTAY',1),(25,'MALARAYAT GOLF',1),(26,'RIVIERA GOLF',1),(27,'TAGAYTAY MIDLAND',1),(28,'ALABANG GOLF',1),(29,'BEVERLY PLACE',1),(30,'MT. MALARAYAT',1),(31,'ORCHARD/ TAGAYTAY',1),(32,'ORCHARD/PUEBLO DE ORO',1),(33,'ROYALE TAGAYTAY',1),(34,'APO GOLF',1),(35,'ALABANG/ORCHARD/EAGLE',1),(36,'ALABANG',1),(37,'PHIL. ARMY GOLF',1),(38,'CAMP AGUINALDO',1),(39,'PHIL. NAVY GOLF',1),(40,'MIDLANDS/VALLEY',1),(41,'EAGLE RIDGE/SOUTHWOODS',1),(42,'ANVAYA',1),(43,'BEVERLY HILLS',1),(44,'MACTAN',1),(45,'ALTA VISTA',1),(46,'PHIL. NAVY GOLF CLUB',1),(47,'TAGAYTAY MIDLANDS',1),(48,'KEPPEL SINGAPORE',1),(49,'MANILA SOUTHWOORDS',1),(50,'GOLF PH',1),(51,'MANILA SOUTHWOODS',1),(52,'TAGAYTAY HIGHLANDS',1),(53,'SOUTHLINKS GC',1),(54,'ROYAL NORTHWOODS',1),(55,'ANVAYA COVE',1),(56,'AYALA GREENFIELDS',1),(57,'CLUB INTRAMUROS',1),(58,'NOMADS GC',1),(59,'N/A',1),(60,'VILLAMOR GOLF',1),(61,'APO',1),(62,'DOLE KALSANGI',1),(63,'SHERWOOD HILLS',1),(64,'N/A FROM UNHS',1),(65,'MIDLANDS/ACC',1),(66,'AGUINALDO GOLF',1),(67,'SOUTH FORBES',1),(68,'MIMOSA',1),(69,'GREENFIELDS',1),(70,'PHIL ARMY GOLF',1),(71,'NOMADS GOLF CLUB',1),(72,'ACCI',1),(73,'SOUTHLINKS',1),(74,'AYALA GREENFIELD',1),(75,'SHERWOOD',1),(76,'MALARAYAT',1),(77,'BEVERLY PLACE GOLF CLUB',1),(78,'LAKEWOOD',1),(79,'VETERANS',1),(80,'PHIL. NAVY OLF',1),(81,'TAGAYDAY MIDLANDS',1),(82,'NAVY',1),(83,'ALABANG / MIDLANDS',1),(84,'SAN JUANICO GOLF PARK',1),(85,'ORCHARDS',1),(86,'CANLUBANG',1),(87,'NEGROS OCCIDENTAL GOLF',1),(88,'NONE',1),(89,'SOUTHWOODS & VALLEY',1),(90,'NORTHWOOD',1),(91,'RIVIERA, EAGLE RIDGE',1),(92,'VALLEY',1),(93,'VALLEY GOLF/ EASTRIDGE',1),(94,'MIMOSA/ MALIRAYAT',1),(95,'MIDLANDS,ALABANG, ORCHARD,',1),(96,'MIDLANDS,ALABANG,',1),(97,'FERNANDO AIRBASE',1),(98,'THAILAND',1),(99,'BEGINNER',1),(100,'MELROSE(SCOTLAND)',1),(101,'CALATAGAN GOLF CLUB',1),(102,'MIMOSA/VETERANS SENIOR',1),(103,'STA ELENA',1),(104,'RIVERA',1),(105,'MIDLANDS,ORCHARD,NAVY,',1),(106,'LYNX BLACKCAT',1),(107,'SOUTH WOOD',1),(108,'ZAMBOANGA CITY',1),(109,'WACK-WACK',1),(110,'BRACE GOLD CLUB',1),(111,'CEBU COUNTRY CLUB',1),(112,'PNGC, CAPITOL',1),(113,'MIMOSA / VETERANS',1),(114,'DAVAO',1),(115,'ROYAL NORTHWOOD',1),(116,'TAGAYTAY  MIDLANDS',1),(117,'MIDLAND',1),(118,'STA.ELENA',1);
/*!40000 ALTER TABLE `golf_clubs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_companies`
--

DROP TABLE IF EXISTS `golf_companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_companies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_companies`
--

LOCK TABLES `golf_companies` WRITE;
/*!40000 ALTER TABLE `golf_companies` DISABLE KEYS */;
INSERT INTO `golf_companies` VALUES (1,'S & K METAL',1),(2,'TUFF CHEMICAL',1),(3,'NEWTON MULTI SALES',1),(4,'SIN HAP LEE TRADING',1),(5,'TIN TIN BAZAR INC',1),(6,'MIT-AIR INC',1),(7,'BNL INDUSTRIAL MFG CORP',1),(8,'POWER DOCS TRADING & LEASING INC',1),(9,'STRONG CITY INC.',1),(10,'CATRO-CANILAO LAW OFFICE',1),(11,'SHELL TACLOBAN',1),(12,'WAD TRADERS',1),(13,'CARBERT TRADING',1),(14,'TACLOBAN MABUHAY GLASS SUPPLY',1),(15,'SOUTHERN AUTO SUPPLY',1),(16,'SAMGLO TRADING INC',1),(17,'FUJI ZIPPER',1),(18,'EMAPCO',1),(19,'PAIRCARGO',1),(20,'SGV & CO',1),(21,'EMMANUEL ALCANTARA & ASSOCIATES',1),(22,'STA. LUCIA PROPERTY MGT, INC.',1),(23,'ROMULO LAW OFFICE',1),(24,'AFP GLOBAL',1),(25,'I CONSTECH CORPORATION',1),(26,'MONDIAL TOURS',1),(27,'TIM ENGINEERING',1),(28,'GOLD INC',1),(29,'GOLD INC.',1),(30,'BOYSEN PAINT',1),(31,'ACCENT BUILDER',1),(32,'ARKIPINAS BUILDERS',1),(33,'RS CONSULTANT MANAGEMENT',1),(34,'SOLID GROUP FINANCES',1),(35,'MOVE IT',1),(36,'STOLT TANK CONTAINERS',1),(37,'MADE DISTRIBUTION',1),(38,'NPI',1),(39,'UNILAB',1),(40,'GEM / RC OFF. OF DISTRICT GOV.',1),(41,'BUSINESS MIRROR',1),(42,'GM ENTERPRISES',1),(43,'U-FREIGHT PHILIPPINES INC',1),(44,'PAGCOR',1),(45,'INQUIRER PHILIPPINES',1),(46,'CATS MOTORS',1),(47,'KLASSIK MIDORI',1),(48,'DDO, QC',1),(49,'ARCO METAL PRODUCTS CO. INC.',1),(50,'ARDCORP',1),(51,'CONTACT DESIGN',1),(52,'MADRIGAL-BAYOT',1),(53,'SURIYA SPA',1),(54,'GOLDPLAN INSURANCE SERVICES',1),(55,'TOUR MASTER GOLF INC',1),(56,'CABALCE ELECTRICAL CONTRACTORS',1),(57,'STORE MASTERS,INC.',1),(58,'RS CAPARROS & ASSOCIATES',1),(59,'CASQUEJO PAWNSHOPS',1),(60,'CA LOGISTICS CORPORATION',1),(61,'CARRY ALL TRANSPORT CORPORATION',1),(62,'FAMOUS SECRET PRECISION MACHINING INC.',1),(63,'NISSAN',1),(64,'LA SUERTE CIGARETTE FACTORY',1),(65,'UNION BANK OF THE PHILIPPINES',1),(66,'MAKATI MEDICAL CENTER',1),(67,'LIQUIGAZ',1),(68,'LINAHEIM CORPORATE SERVICES, INC.',1),(69,'ER DE SOTO ENTERPRISES',1),(70,'MAYBANK PHILIPPINES',1),(71,'LEO G. DOMINGUEZ CONSULTANCY INC.',1),(72,'FORTUNE GENERAL INSURANCE CORP.',1),(73,'ELECTROMARK MULTI SALES INC.',1),(74,'CHEMSTAR IMPORT & EXPORT CORPORATION',1),(75,'JARDINE DISTRIBUTION',1),(76,'STA. CRUZ PAWNSHOP',1),(77,'TOTAL ( PHILIPPINES )',1),(78,'DAIICHI PROPERTIES & DEV\'T INC.',1),(79,'KIA SUCAT',1),(80,'WHEALTH/PABC',1),(81,'MIZUNO',1),(82,'PEPSI COLA PRODUCTS PHILS. INC.',1),(83,'CLUBCAR PHILIPPINES',1),(84,'STANDARD INSURANCE CO., INC.',1),(85,'KIA BATANGAS',1),(86,'ALL AIRPORTS /  GEN. DE VERA / GEN. LANTION',1),(87,'ANGIE / FOREST HILLS',1),(88,'FUJI ZIPPER INC.',1),(89,'HP BUILDERS',1),(90,'A-LIST BIOPHARMA NEUTRICEUTICALS CORP.',1),(91,'KIM KAT ENTERPRISES',1),(92,'TABLERIA LA CONFIANZA CO. INC',1),(93,'EASTWEST BANK',1),(94,'SALON DE MANILA',1),(95,'RELI GOMEZ/ DAN NOVENO/ JOJO VILLACARLOS',1),(96,'BANK OF COMMERCE',1),(97,'MIGHTY CORP',1),(98,'AYALA LAND INC',1),(99,'EMBASSY OF MALAYSIA',1),(100,'GERRY\'S GRILL',1),(101,'DYNAMIC OUTSOURCE SOLUTIONS 1, INC.',1),(102,'EURO CARPETS & INTERIORS',1),(103,'BDO',1),(104,'REYES HAIRCUTTERS',1),(105,'CRIME LABORATORY',1),(106,'RCS LOGISTICS PHILS INC.',1),(107,'MARIA ANA MIGUEL REALTY INC.,/357 BORACAY',1),(108,'R-II BUILDERS INC.',1),(109,'JOMSAN TRADING & ENG\'G SERVICES',1),(110,'SAMGLO TRADING INC.',1),(111,'OMNICON INC',1),(112,'TERE / VG / ABSOLUT',1),(113,'RCMW / ALABANG GOLFER / DENNIS HUANG',1),(114,'RIZGOLF SPORTS MARKETING',1),(115,'LYCEUM CAVITE-',1),(116,'LUZON IRON SANDS DEVELOPMENT CORP',1),(117,'LAWRENCE YOUNG / PAT HERNANDEZ / GENE SEBASTI',1),(118,'MADE DISTRIBUTION INC',1),(119,'BOAC MARKETING',1),(120,'MAE / PARAMOUNT INS.',1),(121,'SEAOIL',1),(122,'PILIPINAS TELESERVE',1),(124,'RHA MARKETING',1),(125,'TOTAL COMPONENT TECHNOLOGY',1),(126,'BRILLS MKTG CORP',1),(127,'PLASTIC CONTAINER PACKAGING',1),(128,'DDM BV',1),(129,'CORINTHIANS INTEGRATED SECURITY INC',1),(130,'OWEE',1),(131,'EASTERN STAR MARKETING',1),(132,'SINGAPORE PHILIPPINES ASSN INC',1),(133,'PRA',1),(134,'DYNAMIC OUTSOURCE SOLUTION',1),(135,'PMS SHIP AGENCY TMS',1),(136,'MAGSAYSAY TRANSPORT & LOGISTICS',1),(137,'ASIAN DRAGON MAGAZINE',1),(138,'MEISTER',1),(139,'MESTER',1),(140,'JOMSAR CONSTRUCTION AND DEVELOPMENT CORP',1),(141,'ROAD MATE TRADING',1),(142,'COOLMATE CORPORATION',1),(143,'HI INTEGRA HOMES INC',1),(144,'HBT',1),(145,'ANR UNLIMITED',1),(146,'GEN PACT',1),(147,'MEDIA CONST & DEV CORP',1),(148,'NAZARENO MEMORIAL SERVICES',1),(149,'AERO',1),(150,'HANKYU HANSHIN EXPRESS PHILS',1),(151,'CHONG INTL TRADING',1),(152,'AMPG LAW OFFICE',1),(153,'ST LUKES GLOBAL',1),(154,'ST. LUKES GLOBAL',1),(155,'LA FAMILIA FOOD',1),(156,'DEITY FOODS INC',1),(157,'VERIZON',1),(158,'MIDORI SAISHO CORP.',1),(159,'FAMOUS SECRET PRECISION MACHINING INC',1),(160,'AICHI FORGING COMPANY OF ASIA INC',1),(161,'JEP COOPERATIVE',1),(162,'MEGALAND DEV\'T CO.',1),(163,'CA LOGISTICS CORP',1),(164,'TOTAL ROAD TRANSPORT',1),(165,'LIQUIGOLD GAS CORP',1),(166,'TASCO INC',1),(167,'SAMAR MOTORWORLD INC',1),(168,'CIMTRONIXS PHILS INC',1),(169,'ASIA CARGO GROUP OF COMPANIES',1),(170,'CLOUDWARE',1),(171,'CASINO FILIPINO',1),(172,'SUPREME COURT',1),(173,'CITY GOVT OF LAGUNA',1),(174,'NEW TECH MEDIA',1),(175,'GAWANATO CONSTRUCTION',1),(176,'MP PEREZ BUILDERS',1),(177,'TUFF CHEMICAL & ADHESIVE CO',1),(178,'SK METAL',1),(179,'LION GRANITE COBSTRUCTION',1),(180,'UNICORN METAL',1),(181,'LBC',1),(182,'MAA GENERAL ASSURANCE PHILS',1),(183,'MANILA SOUTHCOAST DEVELOPMENT CORP',1),(184,'STA CRUZ PAWNSHOP',1),(185,'TABLERIA LA CONFIANZA INC',1),(186,'BOYSEN',1),(187,'DENN, INC',1),(188,'ICPI',1),(189,'MASTER COATING SPECIALIST',1),(190,'ABC DCOR CENTRE',1),(191,'TORQUE BUILDERS',1),(192,'OLYMPIA FOOD RESOURCES',1),(193,'8137601',1),(194,'9010421',1),(195,'8168845',1),(196,'9206779',1),(197,'6614609',1),(198,'5313369',1),(199,'8423296',1),(200,'4001522',1),(201,'8925555',1),(202,'8849099',1),(203,'3733970',1),(204,'9391221',1),(205,'8880888',1),(206,'8407918',1),(207,'8931296',1),(208,'2729125',1),(209,'7759104',1),(210,'8175378',1),(211,'8166129',1),(212,'8166501 LOC. 6862',1),(213,'(047)250-2251',1),(214,'4530046',1),(215,'5193270',1),(216,'6411800',1),(217,'4208000',1),(218,'6618071',1),(219,'7126610',1),(220,'9520107',1),(221,'6341074',1),(222,'6676388',1),(223,'8168462',1),(224,'8168404',1);
/*!40000 ALTER TABLE `golf_companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_courses`
--

DROP TABLE IF EXISTS `golf_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_courses`
--

LOCK TABLES `golf_courses` WRITE;
/*!40000 ALTER TABLE `golf_courses` DISABLE KEYS */;
INSERT INTO `golf_courses` VALUES (1,'Norman',1),(2,'Faldo',1);
/*!40000 ALTER TABLE `golf_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_devices`
--

DROP TABLE IF EXISTS `golf_devices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_devices` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `description` varchar(245) DEFAULT NULL,
  `device_id` varchar(145) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_id_UNIQUE` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_devices`
--

LOCK TABLES `golf_devices` WRITE;
/*!40000 ALTER TABLE `golf_devices` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_devices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_divisions`
--

DROP TABLE IF EXISTS `golf_divisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_divisions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_divisions`
--

LOCK TABLES `golf_divisions` WRITE;
/*!40000 ALTER TABLE `golf_divisions` DISABLE KEYS */;
INSERT INTO `golf_divisions` VALUES (1,'Player',1),(2,'Sponsor',1);
/*!40000 ALTER TABLE `golf_divisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_events`
--

DROP TABLE IF EXISTS `golf_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(95) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `date` date DEFAULT NULL,
  `description` text,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_events`
--

LOCK TABLES `golf_events` WRITE;
/*!40000 ALTER TABLE `golf_events` DISABLE KEYS */;
INSERT INTO `golf_events` VALUES (1,'101010 2022',NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `golf_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_mulligans`
--

DROP TABLE IF EXISTS `golf_mulligans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_mulligans` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_id` bigint DEFAULT NULL,
  `mulligan` int DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `player_id` bigint DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index5` (`event_id`,`player_id`,`status`),
  KEY `golf_mulligan_fk1_idx` (`event_id`),
  KEY `golf_mulligan_fk2_idx` (`user_id`),
  KEY `golf_mulligan_fk3_idx` (`player_id`),
  CONSTRAINT `golf_mulligan_fk1` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`),
  CONSTRAINT `golf_mulligan_fk2` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_mulligan_fk3` FOREIGN KEY (`player_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_mulligans`
--

LOCK TABLES `golf_mulligans` WRITE;
/*!40000 ALTER TABLE `golf_mulligans` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_mulligans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_attendance`
--

DROP TABLE IF EXISTS `golf_player_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_attendance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `player_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index3` (`player_id`,`status`),
  KEY `golf_player_attendance_fk1_idx` (`player_id`),
  CONSTRAINT `golf_player_attendance_fk1` FOREIGN KEY (`player_id`) REFERENCES `golf_players` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_attendance`
--

LOCK TABLES `golf_player_attendance` WRITE;
/*!40000 ALTER TABLE `golf_player_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_player_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_other_infos`
--

DROP TABLE IF EXISTS `golf_player_other_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_other_infos` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `player_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `flight_user_id` bigint DEFAULT NULL,
  `index` varchar(100) DEFAULT NULL,
  `hcdp` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_player_other_infos_fk1_idx` (`player_id`),
  KEY `golf_player_other_infos_fk3_idx` (`flight_user_id`),
  CONSTRAINT `golf_player_other_infos_fk1` FOREIGN KEY (`player_id`) REFERENCES `golf_players` (`id`),
  CONSTRAINT `golf_player_other_infos_fk3` FOREIGN KEY (`flight_user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_other_infos`
--

LOCK TABLES `golf_player_other_infos` WRITE;
/*!40000 ALTER TABLE `golf_player_other_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_player_other_infos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_player_status`
--

DROP TABLE IF EXISTS `golf_player_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_player_status` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_player_status`
--

LOCK TABLES `golf_player_status` WRITE;
/*!40000 ALTER TABLE `golf_player_status` DISABLE KEYS */;
INSERT INTO `golf_player_status` VALUES (1,'Invited ',1),(2,'Paid ',1),(3,'Unpaid',1),(4,'Disable',1);
/*!40000 ALTER TABLE `golf_player_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_players`
--

DROP TABLE IF EXISTS `golf_players`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_players` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_id` bigint DEFAULT NULL,
  `course_id` bigint DEFAULT NULL,
  `team_id` bigint DEFAULT NULL,
  `division_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `course` varchar(45) DEFAULT NULL,
  `flight` varchar(45) DEFAULT NULL,
  `partner_id` bigint DEFAULT NULL,
  `registration_type` varchar(45) DEFAULT NULL,
  `registration_status` varchar(45) DEFAULT NULL,
  `registration_date` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index7` (`event_id`,`user_id`,`status`),
  KEY `golf_players_fk1_idx` (`course_id`),
  KEY `golf_players_fk2_idx` (`division_id`),
  KEY `golf_players_fk3_idx` (`team_id`) /*!80000 INVISIBLE */,
  KEY `golf_players_fk4_idx` (`user_id`),
  KEY `golf_players_fk5_idx` (`event_id`),
  CONSTRAINT `golf_players_fk1` FOREIGN KEY (`course_id`) REFERENCES `golf_courses` (`id`),
  CONSTRAINT `golf_players_fk2` FOREIGN KEY (`division_id`) REFERENCES `golf_divisions` (`id`),
  CONSTRAINT `golf_players_fk3` FOREIGN KEY (`team_id`) REFERENCES `golf_teams` (`id`),
  CONSTRAINT `golf_players_fk4` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_players_fk5` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_players`
--

LOCK TABLES `golf_players` WRITE;
/*!40000 ALTER TABLE `golf_players` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_players` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_positions`
--

DROP TABLE IF EXISTS `golf_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_positions`
--

LOCK TABLES `golf_positions` WRITE;
/*!40000 ALTER TABLE `golf_positions` DISABLE KEYS */;
INSERT INTO `golf_positions` VALUES (1,'MANAGER',1),(2,'PROPRIETOR',1),(3,'PRESIDENT',1),(4,'MANAGER/OWNER',1),(5,'LAWYER',1),(6,'OWNER',1),(7,'MANAGING DIRECTOR',1),(8,'PARTNER',1),(9,'SENIOR PARTNER',1),(10,'MANAGING PARTNER',1),(11,'EVP',1),(12,'PRESIDENT & CEO',1),(13,'DIRECTOR OF SALES',1),(14,'VP',1),(15,'AREA MANAGER',1),(16,'PRINCIPAL ARCHITECT',1),(17,'ARCHITECT',1),(18,'PROJECT MANAGER ENGINEER',1),(19,'V.P / COMPTROLLER',1),(20,'GENERAL MANAGER',1),(21,'MD',1),(22,'OWEE',1),(23,'ACCOUNT EXECUTIVE',1),(24,'STRATEGIC MKTG & CRM MANAGER',1),(25,'C/O GEN DE VERA',1),(26,'CHAIRMAN',1),(27,'C/O JOEL DIMAS',1),(28,'VICE PRESIDENT/DIRECTOR',1),(29,'CO OWNER',1),(30,'CORP SECRETARY',1),(31,'ATTORNEY',1),(32,'GM',1),(33,'EXECUTIVE VP',1),(34,'CASHIER',1),(35,'C/O NELSON LU',1),(36,'PRESIDENT & COO',1),(37,'PLANNING DIV CHIEF',1),(38,'HEAD TAX SERVICES',1),(39,'HEAD ADVISORY SERVICES',1),(40,'C/O MIKE SHIH',1),(41,'AVP',1),(42,'ALABANG OFFICE MANAGER',1),(43,'C/O ELMER NGO',1),(44,'M.D',1),(45,'WEALTH CONSULTANT',1),(46,'CONSULATANT',1),(47,'REGIONAL SECURITY ADVISOR',1),(48,'VP & CRM HEAD',1),(49,'NATIONAL SFA MNGR.',1),(50,'PRESIDENT &CEO',1),(51,'SUPPLEMENT HEAD',1),(52,'BRANCH HEAD MARKETING & ENTERTAINMENT',1),(53,'SYSTEM STORAGE EXECUTIVE',1),(54,'SALES MANAGER',1),(55,'VICE PRESIDENT / GRP. GEN. MANAGER',1),(56,'D.P GM',1),(57,'VICE PRES',1),(58,'PRESIDENT / CEO',1),(59,'AVP, SUPPLY CHAN',1),(60,'DIRECTOR / SALES / BUSINESS DEV.',1),(61,'PRESIDENT / OWNER',1),(62,'CHIEF FINANCIAL OFFICER',1),(63,'CONSUMER LENDING GROUP',1),(64,'PUBLISHER',1),(65,'SALES PLANNING AND DISTRIBUTION',1),(66,'DEALER PRINCIPAL',1),(67,'BUSINESS DEVELOPMENT',1),(68,'SAVP & HEAD OF SME BUSINESS CORP.',1),(69,'PRICING MANAGER',1),(70,'SALES TEAM LEADER',1),(71,'ACCOUNT MANAGER',1),(72,'ASST. GEN. MANAGER',1),(73,'C/O BON',1),(74,'BUSINESS CENTER HEAD CENTRAL LUZON',1),(75,'VP MARKETING, SALES & AFTERSALES',1),(76,'AVP MANUFACTURING, ENGINEERING & QUALITY',1),(77,'MARKETING DIRECTOR',1),(78,'CASINO SHIFT MANAGER',1),(79,'ATTY',1),(80,'AVO CEMMERCIAL BANKING',1),(81,'FVP',1);
/*!40000 ALTER TABLE `golf_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_rewards`
--

DROP TABLE IF EXISTS `golf_rewards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_rewards` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `player_id` bigint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_reward_fk1_idx` (`user_id`),
  KEY `golf_reward_fk2_idx` (`player_id`),
  KEY `golf_reward_fk3_idx` (`event_id`),
  CONSTRAINT `golf_reward_fk1` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_reward_fk2` FOREIGN KEY (`player_id`) REFERENCES `golf_users` (`id`),
  CONSTRAINT `golf_reward_fk3` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_rewards`
--

LOCK TABLES `golf_rewards` WRITE;
/*!40000 ALTER TABLE `golf_rewards` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_rewards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_report`
--

DROP TABLE IF EXISTS `golf_sms_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_report` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `target_id` bigint DEFAULT NULL,
  `response` text,
  `send_sms_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_sms_report_fk1_idx` (`send_sms_id`),
  KEY `golf_sms_report_fk2_idx` (`target_id`),
  CONSTRAINT `golf_sms_report_fk1` FOREIGN KEY (`send_sms_id`) REFERENCES `golf_sms_send` (`id`),
  CONSTRAINT `golf_sms_report_fk2` FOREIGN KEY (`target_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1322 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_report`
--

LOCK TABLES `golf_sms_report` WRITE;
/*!40000 ALTER TABLE `golf_sms_report` DISABLE KEYS */;
INSERT INTO `golf_sms_report` VALUES (662,'2022-07-18 14:54:02',33,NULL,2),(663,'2022-07-18 14:54:02',661,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(664,'2022-07-18 14:54:03',1068,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(665,'2022-07-18 14:54:03',232,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(666,'2022-07-18 14:54:03',224,'1',2),(667,'2022-07-18 14:54:04',223,'1',2),(668,'2022-07-18 14:54:04',100,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(669,'2022-07-18 14:54:04',256,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(670,'2022-07-18 14:54:05',571,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(671,'2022-07-18 14:54:05',371,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(672,'2022-07-18 14:54:05',669,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(673,'2022-07-18 14:54:06',441,'{\"status\":400,\"name\":\"Bad Request\",\"desc\":\"invalid msisdn\"}',2),(674,'2022-07-18 14:54:06',478,'1',2),(675,'2022-07-18 14:54:07',164,'1',2),(676,'2022-07-18 14:54:07',60,'1',2),(677,'2022-07-18 14:54:08',1200,'1',2),(678,'2022-07-18 14:54:08',483,'1',2),(679,'2022-07-18 14:54:09',235,'1',2),(680,'2022-07-18 14:54:09',672,'1',2),(681,'2022-07-18 14:54:10',608,'1',2),(682,'2022-07-18 14:54:10',1311,'1',2),(683,'2022-07-18 14:54:11',333,'1',2),(684,'2022-07-18 14:54:11',646,'1',2),(685,'2022-07-18 14:54:12',284,'1',2),(686,'2022-07-18 14:54:13',1204,'1',2),(687,'2022-07-18 14:54:13',110,'1',2),(688,'2022-07-18 14:54:14',111,'1',2),(689,'2022-07-18 14:54:14',208,'1',2),(690,'2022-07-18 14:54:15',660,'1',2),(691,'2022-07-18 14:54:15',673,'1',2),(692,'2022-07-18 14:54:16',152,'1',2),(693,'2022-07-18 14:54:16',1199,'1',2),(694,'2022-07-18 14:54:17',699,'1',2),(695,'2022-07-18 14:54:17',508,'1',2),(696,'2022-07-18 14:54:18',166,'1',2),(697,'2022-07-18 14:54:18',466,'1',2),(698,'2022-07-18 14:54:19',559,'1',2),(699,'2022-07-18 14:54:19',177,'1',2),(700,'2022-07-18 14:54:20',553,'1',2),(701,'2022-07-18 14:54:20',378,'1',2),(702,'2022-07-18 14:54:21',1225,'1',2),(703,'2022-07-18 14:54:21',1096,'1',2),(704,'2022-07-18 14:54:22',668,'1',2),(705,'2022-07-18 14:54:22',205,'1',2),(706,'2022-07-18 14:54:23',395,'1',2),(707,'2022-07-18 14:54:23',1130,'1',2),(708,'2022-07-18 14:54:24',572,'1',2),(709,'2022-07-18 14:54:24',1071,'1',2),(710,'2022-07-18 14:54:25',1326,'1',2),(711,'2022-07-18 14:54:26',15,'1',2),(712,'2022-07-18 14:54:26',227,'1',2),(713,'2022-07-18 14:54:27',1064,'1',2),(714,'2022-07-18 14:54:27',17,'1',2),(715,'2022-07-18 14:54:28',16,'1',2),(716,'2022-07-18 14:54:28',1261,'1',2),(717,'2022-07-18 14:54:29',71,'1',2),(718,'2022-07-18 14:54:29',91,'1',2),(719,'2022-07-18 14:54:30',19,'1',2),(720,'2022-07-18 14:54:31',209,'1',2),(721,'2022-07-18 14:54:31',27,'1',2),(722,'2022-07-18 14:54:32',1266,'1',2),(723,'2022-07-18 14:54:32',643,'1',2),(724,'2022-07-18 14:54:33',1132,'1',2),(725,'2022-07-18 14:54:33',1285,'1',2),(726,'2022-07-18 14:54:34',168,'1',2),(727,'2022-07-18 14:54:34',1253,'1',2),(728,'2022-07-18 14:54:35',1075,'1',2),(729,'2022-07-18 14:54:35',1207,'1',2),(730,'2022-07-18 14:54:36',1256,'1',2),(731,'2022-07-18 14:54:36',356,'1',2),(732,'2022-07-18 14:54:37',1136,'1',2),(733,'2022-07-18 14:54:37',1155,'1',2),(734,'2022-07-18 14:54:38',394,'1',2),(735,'2022-07-18 14:54:38',381,'1',2),(736,'2022-07-18 14:54:39',23,'1',2),(737,'2022-07-18 14:54:39',87,'1',2),(738,'2022-07-18 14:54:40',350,'1',2),(739,'2022-07-18 14:54:40',502,'1',2),(740,'2022-07-18 14:54:41',302,'1',2),(741,'2022-07-18 14:54:41',43,'1',2),(742,'2022-07-18 14:54:42',141,'1',2),(743,'2022-07-18 14:54:42',1190,'1',2),(744,'2022-07-18 14:54:43',307,'1',2),(745,'2022-07-18 14:54:43',629,'1',2),(746,'2022-07-18 14:54:44',96,'1',2),(747,'2022-07-18 14:54:44',358,'1',2),(748,'2022-07-18 14:54:45',135,'1',2),(749,'2022-07-18 14:54:45',628,'1',2),(750,'2022-07-18 14:54:46',1308,'1',2),(751,'2022-07-18 14:54:46',347,'1',2),(752,'2022-07-18 14:54:47',1319,'1',2),(753,'2022-07-18 14:54:48',1284,'1',2),(754,'2022-07-18 14:54:48',125,'1',2),(755,'2022-07-18 14:54:48',421,'1',2),(756,'2022-07-18 14:54:49',1057,'1',2),(757,'2022-07-18 14:54:49',1084,'1',2),(758,'2022-07-18 14:54:50',587,'1',2),(759,'2022-07-18 14:54:50',631,'1',2),(760,'2022-07-18 14:54:52',107,'1',2),(761,'2022-07-18 14:54:52',1185,'1',2),(762,'2022-07-18 14:54:53',1165,'1',2),(763,'2022-07-18 14:54:53',4,'1',2),(764,'2022-07-18 14:54:54',1209,'1',2),(765,'2022-07-18 14:54:54',687,'1',2),(766,'2022-07-18 14:54:55',1267,'1',2),(767,'2022-07-18 14:54:55',621,'1',2),(768,'2022-07-18 14:54:56',324,'1',2),(769,'2022-07-18 14:54:56',165,'1',2),(770,'2022-07-18 14:54:57',476,'1',2),(771,'2022-07-18 14:54:57',544,'1',2),(772,'2022-07-18 14:54:58',136,'1',2),(773,'2022-07-18 14:54:58',1206,'1',2),(774,'2022-07-18 14:54:59',22,'1',2),(775,'2022-07-18 14:54:59',1290,'1',2),(776,'2022-07-18 14:55:00',1218,'1',2),(777,'2022-07-18 14:55:00',304,'1',2),(778,'2022-07-18 14:55:01',1113,'1',2),(779,'2022-07-18 14:55:01',239,'1',2),(780,'2022-07-18 14:55:02',456,'1',2),(781,'2022-07-18 14:55:02',624,'1',2),(782,'2022-07-18 14:55:03',1179,'1',2),(783,'2022-07-18 14:55:03',299,'1',2),(784,'2022-07-18 14:55:04',1144,'1',2),(785,'2022-07-18 14:55:04',575,'1',2),(786,'2022-07-18 14:55:05',609,'1',2),(787,'2022-07-18 14:55:06',703,'1',2),(788,'2022-07-18 14:55:06',156,'1',2),(789,'2022-07-18 14:55:07',1219,'1',2),(790,'2022-07-18 14:55:07',24,'1',2),(791,'2022-07-18 14:55:08',124,'1',2),(792,'2022-07-18 14:55:08',291,'1',2),(793,'2022-07-18 14:55:09',1269,'1',2),(794,'2022-07-18 14:55:09',1318,'1',2),(795,'2022-07-18 14:55:10',305,'1',2),(796,'2022-07-18 14:55:10',444,'1',2),(797,'2022-07-18 14:55:11',1220,'1',2),(798,'2022-07-18 14:55:11',485,'1',2),(799,'2022-07-18 14:55:12',175,'1',2),(800,'2022-07-18 14:55:12',1082,'1',2),(801,'2022-07-18 14:55:13',546,'1',2),(802,'2022-07-18 14:55:13',254,'1',2),(803,'2022-07-18 14:55:14',626,'1',2),(804,'2022-07-18 14:55:14',1191,'1',2),(805,'2022-07-18 14:55:15',336,'1',2),(806,'2022-07-18 14:55:15',439,'1',2),(807,'2022-07-18 14:55:16',67,'1',2),(808,'2022-07-18 14:55:16',498,'1',2),(809,'2022-07-18 14:55:17',1212,'1',2),(810,'2022-07-18 14:55:17',1306,'1',2),(811,'2022-07-18 14:55:18',1134,'1',2),(812,'2022-07-18 14:55:18',1222,'1',2),(813,'2022-07-18 14:55:19',278,'1',2),(814,'2022-07-18 14:55:19',1213,'1',2),(815,'2022-07-18 14:55:20',206,'1',2),(816,'2022-07-18 14:55:20',706,'1',2),(817,'2022-07-18 14:55:21',426,'1',2),(818,'2022-07-18 14:55:22',1085,'1',2),(819,'2022-07-18 14:55:22',1092,'1',2),(820,'2022-07-18 14:55:23',39,'1',2),(821,'2022-07-18 14:55:24',1286,'1',2),(822,'2022-07-18 14:55:24',603,'1',2),(823,'2022-07-18 14:55:25',1159,'1',2),(824,'2022-07-18 14:55:25',1052,'1',2),(825,'2022-07-18 14:55:26',56,'1',2),(826,'2022-07-18 14:55:26',393,'1',2),(827,'2022-07-18 14:55:27',1069,'1',2),(828,'2022-07-18 14:55:27',1264,'1',2),(829,'2022-07-18 14:55:28',442,'1',2),(830,'2022-07-18 14:55:28',671,'1',2),(831,'2022-07-18 14:55:29',234,'1',2),(832,'2022-07-18 14:55:29',104,'1',2),(833,'2022-07-18 14:55:30',670,'1',2),(834,'2022-07-18 14:55:30',454,'1',2),(835,'2022-07-18 14:55:31',1182,'1',2),(836,'2022-07-18 14:55:31',455,'1',2),(837,'2022-07-18 14:55:32',482,'1',2),(838,'2022-07-18 14:55:32',1305,'1',2),(839,'2022-07-18 14:55:33',493,'1',2),(840,'2022-07-18 14:55:33',1282,'1',2),(841,'2022-07-18 14:55:34',279,'1',2),(842,'2022-07-18 14:55:34',50,'1',2),(843,'2022-07-18 14:55:35',188,'1',2),(844,'2022-07-18 14:55:35',630,'1',2),(845,'2022-07-18 14:55:36',1138,'1',2),(846,'2022-07-18 14:55:36',337,'1',2),(847,'2022-07-18 14:55:37',430,'1',2),(848,'2022-07-18 14:55:37',1327,'1',2),(849,'2022-07-18 14:55:38',1145,'1',2),(850,'2022-07-18 14:55:38',144,'1',2),(851,'2022-07-18 14:55:39',591,'1',2),(852,'2022-07-18 14:55:39',300,'1',2),(853,'2022-07-18 14:55:40',222,'1',2),(854,'2022-07-18 14:55:40',314,'1',2),(855,'2022-07-18 14:55:41',353,'1',2),(856,'2022-07-18 14:55:41',255,'1',2),(857,'2022-07-18 14:55:42',162,'1',2),(858,'2022-07-18 14:55:42',319,'1',2),(859,'2022-07-18 14:55:43',317,'1',2),(860,'2022-07-18 14:55:43',320,'1',2),(861,'2022-07-18 14:55:44',1240,'1',2),(862,'2022-07-18 14:55:45',697,'1',2),(863,'2022-07-18 14:55:45',589,'1',2),(864,'2022-07-18 14:55:46',604,'1',2),(865,'2022-07-18 14:55:46',688,'1',2),(866,'2022-07-18 14:55:47',420,'1',2),(867,'2022-07-18 14:55:47',1297,'1',2),(868,'2022-07-18 14:55:48',1137,'1',2),(869,'2022-07-18 14:55:48',1201,'1',2),(870,'2022-07-18 14:55:49',449,'1',2),(871,'2022-07-18 14:55:49',251,'1',2),(872,'2022-07-18 14:55:50',1313,'1',2),(873,'2022-07-18 14:55:50',602,'1',2),(874,'2022-07-18 14:55:51',662,'1',2),(875,'2022-07-18 14:55:51',1314,'1',2),(876,'2022-07-18 14:55:52',182,'1',2),(877,'2022-07-18 14:55:52',432,'1',2),(878,'2022-07-18 14:55:53',457,'1',2),(879,'2022-07-18 14:55:53',1150,'1',2),(880,'2022-07-18 14:55:54',392,'1',2),(881,'2022-07-18 14:55:54',1254,'1',2),(882,'2022-07-18 14:55:55',207,'1',2),(883,'2022-07-18 14:55:55',20,'1',2),(884,'2022-07-18 14:55:56',290,'1',2),(885,'2022-07-18 14:55:56',109,'1',2),(886,'2022-07-18 14:55:57',121,'1',2),(887,'2022-07-18 14:55:57',330,'1',2),(888,'2022-07-18 14:55:58',357,'1',2),(889,'2022-07-18 14:55:58',119,'1',2),(890,'2022-07-18 14:55:59',503,'1',2),(891,'2022-07-18 14:55:59',1108,'1',2),(892,'2022-07-18 14:56:00',1203,'1',2),(893,'2022-07-18 14:56:00',1172,'1',2),(894,'2022-07-18 14:56:01',269,'1',2),(895,'2022-07-18 14:56:01',241,'1',2),(896,'2022-07-18 14:56:02',1097,'1',2),(897,'2022-07-18 14:56:02',252,'1',2),(898,'2022-07-18 14:56:03',1119,'1',2),(899,'2022-07-18 14:56:03',93,'1',2),(900,'2022-07-18 14:56:04',265,'1',2),(901,'2022-07-18 14:56:04',1061,'1',2),(902,'2022-07-18 14:56:05',14,'1',2),(903,'2022-07-18 14:56:05',551,'1',2),(904,'2022-07-18 14:56:06',313,'1',2),(905,'2022-07-18 14:56:06',199,'1',2),(906,'2022-07-18 14:56:07',183,'1',2),(907,'2022-07-18 14:56:07',1089,'1',2),(908,'2022-07-18 14:56:08',12,'1',2),(909,'2022-07-18 14:56:08',65,'1',2),(910,'2022-07-18 14:56:09',1105,'1',2),(911,'2022-07-18 14:56:09',438,'1',2),(912,'2022-07-18 14:56:10',178,'1',2),(913,'2022-07-18 14:56:10',346,'1',2),(914,'2022-07-18 14:56:11',1169,'1',2),(915,'2022-07-18 14:56:11',1251,'1',2),(916,'2022-07-18 14:56:12',59,'1',2),(917,'2022-07-18 14:56:12',311,'1',2),(918,'2022-07-18 14:56:13',272,'1',2),(919,'2022-07-18 14:56:13',1184,'1',2),(920,'2022-07-18 14:56:14',541,'1',2),(921,'2022-07-18 14:56:14',601,'1',2),(922,'2022-07-18 14:56:15',1215,'1',2),(923,'2022-07-18 14:56:15',268,'1',2),(924,'2022-07-18 14:56:16',1194,'1',2),(925,'2022-07-18 14:56:16',1171,'1',2),(926,'2022-07-18 14:56:17',388,'1',2),(927,'2022-07-18 14:56:18',51,'1',2),(928,'2022-07-18 14:56:18',53,'1',2),(929,'2022-07-18 14:56:18',607,'1',2),(930,'2022-07-18 14:56:19',1053,'1',2),(931,'2022-07-18 14:56:20',594,'1',2),(932,'2022-07-18 14:56:20',1115,'1',2),(933,'2022-07-18 14:56:21',401,'1',2),(934,'2022-07-18 14:56:21',683,'1',2),(935,'2022-07-18 14:56:22',145,'1',2),(936,'2022-07-18 14:56:22',11,'1',2),(937,'2022-07-18 14:56:23',240,'1',2),(938,'2022-07-18 14:56:23',1289,'1',2),(939,'2022-07-18 14:56:24',1072,'1',2),(940,'2022-07-18 14:56:24',233,'1',2),(941,'2022-07-18 14:56:25',325,'1',2),(942,'2022-07-18 14:56:25',155,'1',2),(943,'2022-07-18 14:56:26',331,'1',2),(944,'2022-07-18 14:56:27',114,'1',2),(945,'2022-07-18 14:56:27',62,'1',2),(946,'2022-07-18 14:56:28',1252,'1',2),(947,'2022-07-18 14:56:29',1244,'1',2),(948,'2022-07-18 14:56:29',61,'1',2),(949,'2022-07-18 14:56:30',187,'1',2),(950,'2022-07-18 14:56:30',678,'1',2),(951,'2022-07-18 14:56:31',142,'1',2),(952,'2022-07-18 14:56:31',1168,'1',2),(953,'2022-07-18 14:56:32',309,'1',2),(954,'2022-07-18 14:56:32',318,'1',2),(955,'2022-07-18 14:56:33',644,'1',2),(956,'2022-07-18 14:56:33',597,'1',2),(957,'2022-07-18 14:56:34',1066,'1',2),(958,'2022-07-18 14:56:34',584,'1',2),(959,'2022-07-18 14:56:35',705,'1',2),(960,'2022-07-18 14:56:35',1257,'1',2),(961,'2022-07-18 14:56:36',341,'1',2),(962,'2022-07-18 14:56:36',200,'1',2),(963,'2022-07-18 14:56:37',292,'1',2),(964,'2022-07-18 14:56:37',1329,'1',2),(965,'2022-07-18 14:56:38',184,'1',2),(966,'2022-07-18 14:56:38',349,'1',2),(967,'2022-07-18 14:56:39',620,'1',2),(968,'2022-07-18 14:56:39',408,'1',2),(969,'2022-07-18 14:56:40',83,'1',2),(970,'2022-07-18 14:56:40',167,'1',2),(971,'2022-07-18 14:56:41',600,'1',2),(972,'2022-07-18 14:56:41',690,'1',2),(973,'2022-07-18 14:56:42',88,'1',2),(974,'2022-07-18 14:56:42',1242,'1',2),(975,'2022-07-18 14:56:43',1276,'1',2),(976,'2022-07-18 14:56:43',310,'1',2),(977,'2022-07-18 14:56:44',49,'1',2),(978,'2022-07-18 14:56:44',180,'1',2),(979,'2022-07-18 14:56:45',1121,'1',2),(980,'2022-07-18 14:56:46',1070,'1',2),(981,'2022-07-18 14:56:46',579,'1',2),(982,'2022-07-18 14:56:47',41,'1',2),(983,'2022-07-18 14:56:47',676,'1',2),(984,'2022-07-18 14:56:48',201,'1',2),(985,'2022-07-18 14:56:48',129,'1',2),(986,'2022-07-18 14:56:49',64,'1',2),(987,'2022-07-18 14:56:49',250,'1',2),(988,'2022-07-18 14:56:50',247,'1',2),(989,'2022-07-18 14:56:50',46,'1',2),(990,'2022-07-18 14:56:51',1198,'1',2),(991,'2022-07-18 14:56:51',634,'1',2),(992,'2022-07-18 14:56:52',303,'1',2),(993,'2022-07-18 14:56:52',32,'1',2),(994,'2022-07-18 14:56:53',45,'1',2),(995,'2022-07-18 14:56:53',326,'1',2),(996,'2022-07-18 14:56:54',134,'1',2),(997,'2022-07-18 14:56:54',418,'1',2),(998,'2022-07-18 14:56:55',658,'1',2),(999,'2022-07-18 14:56:55',7,'1',2),(1000,'2022-07-18 14:56:56',191,'1',2),(1001,'2022-07-18 14:56:56',340,'1',2),(1002,'2022-07-18 14:56:57',615,'1',2),(1003,'2022-07-18 14:56:57',582,'1',2),(1004,'2022-07-18 14:56:58',549,'1',2),(1005,'2022-07-18 14:56:58',8,'1',2),(1006,'2022-07-18 14:56:59',213,'1',2),(1007,'2022-07-18 14:56:59',143,'1',2),(1008,'2022-07-18 14:57:00',1183,'1',2),(1009,'2022-07-18 14:57:00',219,'1',2),(1010,'2022-07-18 14:57:01',214,'1',2),(1011,'2022-07-18 14:57:01',1098,'1',2),(1012,'2022-07-18 14:57:02',44,'1',2),(1013,'2022-07-18 14:57:02',118,'1',2),(1014,'2022-07-18 14:57:03',550,'1',2),(1015,'2022-07-18 14:57:03',36,'1',2),(1016,'2022-07-18 14:57:04',228,'1',2),(1017,'2022-07-18 14:57:04',445,'1',2),(1018,'2022-07-18 14:57:05',77,'1',2),(1019,'2022-07-18 14:57:05',419,'1',2),(1020,'2022-07-18 14:57:06',248,'1',2),(1021,'2022-07-18 14:57:07',5,'1',2),(1022,'2022-07-18 14:57:07',115,'1',2),(1023,'2022-07-18 14:57:08',259,'1',2),(1024,'2022-07-18 14:57:08',1099,'1',2),(1025,'2022-07-18 14:57:09',126,'1',2),(1026,'2022-07-18 14:57:09',52,'1',2),(1027,'2022-07-18 14:57:10',298,'1',2),(1028,'2022-07-18 14:57:10',1208,'1',2),(1029,'2022-07-18 14:57:11',627,'1',2),(1030,'2022-07-18 14:57:11',1268,'1',2),(1031,'2022-07-18 14:57:12',78,'1',2),(1032,'2022-07-18 14:57:12',633,'1',2),(1033,'2022-07-18 14:57:13',1307,'1',2),(1034,'2022-07-18 14:57:13',6,'1',2),(1035,'2022-07-18 14:57:14',477,'1',2),(1036,'2022-07-18 14:57:14',1118,'1',2),(1037,'2022-07-18 14:57:15',338,'1',2),(1038,'2022-07-18 14:57:15',663,'1',2),(1039,'2022-07-18 14:57:16',569,'1',2),(1040,'2022-07-18 14:57:16',148,'1',2),(1041,'2022-07-18 14:57:17',563,'1',2),(1042,'2022-07-18 14:57:17',38,'1',2),(1043,'2022-07-18 14:57:18',1087,'1',2),(1044,'2022-07-18 14:57:18',1320,'1',2),(1045,'2022-07-18 14:57:19',1067,'1',2),(1046,'2022-07-18 14:57:19',242,'1',2),(1047,'2022-07-18 14:57:20',1250,'1',2),(1048,'2022-07-18 14:57:20',1195,'1',2),(1049,'2022-07-18 14:57:21',686,'1',2),(1050,'2022-07-18 14:57:21',657,'1',2),(1051,'2022-07-18 14:57:22',555,'1',2),(1052,'2022-07-18 14:57:22',1073,'1',2),(1053,'2022-07-18 14:57:23',294,'1',2),(1054,'2022-07-18 14:57:23',195,'1',2),(1055,'2022-07-18 14:57:24',312,'1',2),(1056,'2022-07-18 14:57:24',179,'1',2),(1057,'2022-07-18 14:57:25',461,'1',2),(1058,'2022-07-18 14:57:26',452,'1',2),(1059,'2022-07-18 14:57:26',618,'1',2),(1060,'2022-07-18 14:57:27',280,'1',2),(1061,'2022-07-18 14:57:27',276,'1',2),(1062,'2022-07-18 14:57:28',1127,'1',2),(1063,'2022-07-18 14:57:28',236,'1',2),(1064,'2022-07-18 14:57:29',351,'1',2),(1065,'2022-07-18 14:57:29',1271,'1',2),(1066,'2022-07-18 14:57:30',704,'1',2),(1067,'2022-07-18 14:57:31',590,'1',2),(1068,'2022-07-18 14:57:31',163,'1',2),(1069,'2022-07-18 14:57:32',1322,'1',2),(1070,'2022-07-18 14:57:32',1086,'1',2),(1071,'2022-07-18 14:57:33',154,'1',2),(1072,'2022-07-18 14:57:33',230,'1',2),(1073,'2022-07-18 14:57:34',1140,'1',2),(1074,'2022-07-18 14:57:34',1245,'1',2),(1075,'2022-07-18 14:57:35',140,'1',2),(1076,'2022-07-18 14:57:35',174,'1',2),(1077,'2022-07-18 14:57:36',1058,'1',2),(1078,'2022-07-18 14:57:36',1335,'1',2),(1079,'2022-07-18 14:57:37',339,'1',2),(1080,'2022-07-18 14:57:37',181,'1',2),(1081,'2022-07-18 14:57:38',361,'1',2),(1082,'2022-07-18 14:57:38',249,'1',2),(1083,'2022-07-18 14:57:39',573,'1',2),(1084,'2022-07-18 14:57:40',488,'1',2),(1085,'2022-07-18 14:57:40',69,'1',2),(1086,'2022-07-18 14:57:41',1126,'1',2),(1087,'2022-07-18 14:57:41',139,'1',2),(1088,'2022-07-18 14:57:42',176,'1',2),(1089,'2022-07-18 14:57:42',696,'1',2),(1090,'2022-07-18 14:57:43',13,'1',2),(1091,'2022-07-18 14:57:43',90,'1',2),(1092,'2022-07-18 14:57:44',1109,'1',2),(1093,'2022-07-18 14:57:44',57,'1',2),(1094,'2022-07-18 14:57:45',321,'1',2),(1095,'2022-07-18 14:57:45',415,'1',2),(1096,'2022-07-18 14:57:46',263,'1',2),(1097,'2022-07-18 14:57:46',562,'1',2),(1098,'2022-07-18 14:57:47',1088,'1',2),(1099,'2022-07-18 14:57:48',650,'1',2),(1100,'2022-07-18 14:57:48',1214,'1',2),(1101,'2022-07-18 14:57:49',1054,'1',2),(1102,'2022-07-18 14:57:49',210,'1',2),(1103,'2022-07-18 14:57:50',28,'1',2),(1104,'2022-07-18 14:57:50',31,'1',2),(1105,'2022-07-18 14:57:51',29,'1',2),(1106,'2022-07-18 14:57:51',30,'1',2),(1107,'2022-07-18 14:57:52',123,'1',2),(1108,'2022-07-18 14:57:52',1193,'1',2),(1109,'2022-07-18 14:57:53',1104,'1',2),(1110,'2022-07-18 14:57:53',1281,'1',2),(1111,'2022-07-18 14:57:54',352,'1',2),(1112,'2022-07-18 14:57:54',105,'1',2),(1113,'2022-07-18 14:57:55',1164,'1',2),(1114,'2022-07-18 14:57:55',1120,'1',2),(1115,'2022-07-18 14:57:56',1189,'1',2),(1116,'2022-07-18 14:57:56',1095,'1',2),(1117,'2022-07-18 14:57:57',606,'1',2),(1118,'2022-07-18 14:57:57',266,'1',2),(1119,'2022-07-18 14:57:58',647,'1',2),(1120,'2022-07-18 14:57:58',448,'1',2),(1121,'2022-07-18 14:57:59',414,'1',2),(1122,'2022-07-18 14:57:59',323,'1',2),(1123,'2022-07-18 14:58:00',464,'1',2),(1124,'2022-07-18 14:58:00',479,'1',2),(1125,'2022-07-18 14:58:01',641,'1',2),(1126,'2022-07-18 14:58:01',1249,'1',2),(1127,'2022-07-18 14:58:02',1192,'1',2),(1128,'2022-07-18 14:58:02',1246,'1',2),(1129,'2022-07-18 14:58:03',215,'1',2),(1130,'2022-07-18 14:58:03',1210,'1',2),(1131,'2022-07-18 14:58:04',1133,'1',2),(1132,'2022-07-18 14:58:04',190,'1',2),(1133,'2022-07-18 14:58:05',1131,'1',2),(1134,'2022-07-18 14:58:05',1211,'1',2),(1135,'2022-07-18 14:58:06',26,'1',2),(1136,'2022-07-18 14:58:06',554,'1',2),(1137,'2022-07-18 14:58:07',58,'1',2),(1138,'2022-07-18 14:58:07',149,'1',2),(1139,'2022-07-18 14:58:08',558,'1',2),(1140,'2022-07-18 14:58:08',267,'1',2),(1141,'2022-07-18 14:58:09',1188,'1',2),(1142,'2022-07-18 14:58:09',244,'1',2),(1143,'2022-07-18 14:58:10',698,'1',2),(1144,'2022-07-18 14:58:10',700,'1',2),(1145,'2022-07-18 14:58:12',1151,'1',2),(1146,'2022-07-18 14:58:13',1262,'1',2),(1147,'2022-07-18 14:58:13',1176,'1',2),(1148,'2022-07-18 14:58:14',679,'1',2),(1149,'2022-07-18 14:58:14',1107,'1',2),(1150,'2022-07-18 14:58:15',1094,'1',2),(1151,'2022-07-18 14:58:15',1338,'1',2),(1152,'2022-07-18 14:58:16',1056,'1',2),(1153,'2022-07-18 14:58:16',1302,'1',2),(1154,'2022-07-18 14:58:17',348,'1',2),(1155,'2022-07-18 14:58:17',649,'1',2),(1156,'2022-07-18 14:58:18',1239,'1',2),(1157,'2022-07-18 14:58:18',492,'1',2),(1158,'2022-07-18 14:58:19',1287,'1',2),(1159,'2022-07-18 14:58:19',1277,'1',2),(1160,'2022-07-18 14:58:20',1263,'1',2),(1161,'2022-07-18 14:58:20',1100,'1',2),(1162,'2022-07-18 14:58:21',25,'1',2),(1163,'2022-07-18 14:58:21',92,'1',2),(1164,'2022-07-18 14:58:22',1238,'1',2),(1165,'2022-07-18 14:58:22',1129,'1',2),(1166,'2022-07-18 14:58:23',306,'1',2),(1167,'2022-07-18 14:58:23',160,'1',2),(1168,'2022-07-18 14:58:24',1323,'1',2),(1169,'2022-07-18 14:58:24',1337,'1',2),(1170,'2022-07-18 14:58:25',677,'1',2),(1171,'2022-07-18 14:58:25',596,'1',2),(1172,'2022-07-18 14:58:26',10,'1',2),(1173,'2022-07-18 14:58:26',652,'1',2),(1174,'2022-07-18 14:58:27',1078,'1',2),(1175,'2022-07-18 14:58:27',1158,'1',2),(1176,'2022-07-18 14:58:28',1298,'1',2),(1177,'2022-07-18 14:58:28',599,'1',2),(1178,'2022-07-18 14:58:29',605,'1',2),(1179,'2022-07-18 14:58:29',113,'1',2),(1180,'2022-07-18 14:58:30',172,'1',2),(1181,'2022-07-18 14:58:30',1125,'1',2),(1182,'2022-07-18 14:58:31',578,'1',2),(1183,'2022-07-18 14:58:31',617,'1',2),(1184,'2022-07-18 14:58:32',568,'1',2),(1185,'2022-07-18 14:58:32',691,'1',2),(1186,'2022-07-18 14:58:33',1332,'1',2),(1187,'2022-07-18 14:58:33',675,'1',2),(1188,'2022-07-18 14:58:34',94,'1',2),(1189,'2022-07-18 14:58:34',379,'1',2),(1190,'2022-07-18 14:58:35',1154,'1',2),(1191,'2022-07-18 14:58:35',1146,'1',2),(1192,'2022-07-18 14:58:36',1059,'1',2),(1193,'2022-07-18 14:58:36',226,'1',2),(1194,'2022-07-18 14:58:37',1304,'1',2),(1195,'2022-07-18 14:58:37',667,'1',2),(1196,'2022-07-18 14:58:38',72,'1',2),(1197,'2022-07-18 14:58:38',1336,'1',2),(1198,'2022-07-18 14:58:39',98,'1',2),(1199,'2022-07-18 14:58:39',1090,'1',2),(1200,'2022-07-18 14:58:40',512,'1',2),(1201,'2022-07-18 14:58:40',262,'1',2),(1202,'2022-07-18 14:58:41',1217,'1',2),(1203,'2022-07-18 14:58:42',586,'1',2),(1204,'2022-07-18 14:58:42',585,'1',2),(1205,'2022-07-18 14:58:43',1312,'1',2),(1206,'2022-07-18 14:58:43',1112,'1',2),(1207,'2022-07-18 14:58:44',47,'1',2),(1208,'2022-07-18 14:58:44',665,'1',2),(1209,'2022-07-18 14:58:45',598,'1',2),(1210,'2022-07-18 14:58:45',666,'1',2),(1211,'2022-07-18 14:58:46',283,'1',2),(1212,'2022-07-18 14:58:46',1328,'1',2),(1213,'2022-07-18 14:58:47',1050,'1',2),(1214,'2022-07-18 14:58:47',547,'1',2),(1215,'2022-07-18 14:58:48',545,'1',2),(1216,'2022-07-18 14:58:48',355,'1',2),(1217,'2022-07-18 14:58:49',570,'1',2),(1218,'2022-07-18 14:58:49',120,'1',2),(1219,'2022-07-18 14:58:50',97,'1',2),(1220,'2022-07-18 14:58:50',132,'1',2),(1221,'2022-07-18 14:58:51',360,'1',2),(1222,'2022-07-18 14:58:51',112,'1',2),(1223,'2022-07-18 14:58:52',1167,'1',2),(1224,'2022-07-18 14:58:53',1288,'1',2),(1225,'2022-07-18 14:58:53',211,'1',2),(1226,'2022-07-18 14:58:54',257,'1',2),(1227,'2022-07-18 14:58:54',9,'1',2),(1228,'2022-07-18 14:58:55',1114,'1',2),(1229,'2022-07-18 14:58:55',565,'1',2),(1230,'2022-07-18 14:58:56',1051,'1',2),(1231,'2022-07-18 14:58:56',434,'1',2),(1232,'2022-07-18 14:58:57',1178,'1',2),(1233,'2022-07-18 14:58:57',1166,'1',2),(1234,'2022-07-18 14:58:58',645,'1',2),(1235,'2022-07-18 14:58:58',610,'1',2),(1236,'2022-07-18 14:58:59',694,'1',2),(1237,'2022-07-18 14:58:59',1093,'1',2),(1238,'2022-07-18 14:59:00',68,'1',2),(1239,'2022-07-18 14:59:00',674,'1',2),(1240,'2022-07-18 14:59:01',566,'1',2),(1241,'2022-07-18 14:59:01',588,'1',2),(1242,'2022-07-18 14:59:02',616,'1',2),(1243,'2022-07-18 14:59:03',1161,'1',2),(1244,'2022-07-18 14:59:03',1233,'1',2),(1245,'2022-07-18 14:59:04',619,'1',2),(1246,'2022-07-18 14:59:04',684,'1',2),(1247,'2022-07-18 14:59:05',417,'1',2),(1248,'2022-07-18 14:59:05',1236,'1',2),(1249,'2022-07-18 14:59:06',1324,'1',2),(1250,'2022-07-18 14:59:06',593,'1',2),(1251,'2022-07-18 14:59:07',513,'1',2),(1252,'2022-07-18 14:59:07',1148,'1',2),(1253,'2022-07-18 14:59:08',567,'1',2),(1254,'2022-07-18 14:59:08',1237,'1',2),(1255,'2022-07-18 14:59:09',217,'1',2),(1256,'2022-07-18 14:59:09',48,'1',2),(1257,'2022-07-18 14:59:10',639,'1',2),(1258,'2022-07-18 14:59:10',1196,'1',2),(1259,'2022-07-18 14:59:11',638,'1',2),(1260,'2022-07-18 14:59:11',1234,'1',2),(1261,'2022-07-18 14:59:12',1223,'1',2),(1262,'2022-07-18 14:59:12',682,'1',2),(1263,'2022-07-18 14:59:13',659,'1',2),(1264,'2022-07-18 14:59:13',1160,'1',2),(1265,'2022-07-18 14:59:14',1186,'1',2),(1266,'2022-07-18 14:59:14',564,'1',2),(1267,'2022-07-18 14:59:15',680,'1',2),(1268,'2022-07-18 14:59:15',486,'1',2),(1269,'2022-07-18 14:59:16',556,'1',2),(1270,'2022-07-18 14:59:16',1174,'1',2),(1271,'2022-07-18 14:59:17',509,'1',2),(1272,'2022-07-18 14:59:17',2,'1',2),(1273,'2022-07-18 14:59:18',1187,'1',2),(1274,'2022-07-18 14:59:19',3,'1',2),(1275,'2022-07-18 14:59:20',1156,'1',2),(1276,'2022-07-18 14:59:20',1230,'1',2),(1277,'2022-07-18 14:59:21',1310,'1',2),(1278,'2022-07-18 14:59:21',1111,'1',2),(1279,'2022-07-18 14:59:22',1149,'1',2),(1280,'2022-07-18 14:59:22',1299,'1',2),(1281,'2022-07-18 14:59:23',18,'1',2),(1282,'2022-07-18 14:59:23',66,'1',2),(1283,'2022-07-18 14:59:24',1243,'1',2),(1284,'2022-07-18 14:59:24',1076,'1',2),(1285,'2022-07-18 14:59:25',264,'1',2),(1286,'2022-07-18 14:59:25',1283,'1',2),(1287,'2022-07-18 14:59:26',592,'1',2),(1288,'2022-07-18 14:59:26',400,'1',2),(1289,'2022-07-18 14:59:27',622,'1',2),(1290,'2022-07-18 14:59:27',131,'1',2),(1291,'2022-07-18 14:59:28',1303,'1',2),(1292,'2022-07-18 14:59:28',1221,'1',2),(1293,'2022-07-18 14:59:29',640,'1',2),(1294,'2022-07-18 14:59:29',54,'1',2),(1295,'2022-07-18 14:59:30',21,'1',2),(1296,'2022-07-18 14:59:30',1315,'1',2),(1297,'2022-07-18 14:59:31',1147,'1',2),(1298,'2022-07-18 14:59:31',1101,'1',2),(1299,'2022-07-18 14:59:32',130,'1',2),(1300,'2022-07-18 14:59:32',322,'1',2),(1301,'2022-07-18 14:59:33',218,'1',2),(1302,'2022-07-18 14:59:33',122,'1',2),(1303,'2022-07-18 14:59:34',127,'1',2),(1304,'2022-07-18 14:59:34',490,'1',2),(1305,'2022-07-18 14:59:35',495,'1',2),(1306,'2022-07-18 14:59:36',153,'1',2),(1307,'2022-07-18 14:59:36',75,'1',2),(1308,'2022-07-18 14:59:37',427,'1',2),(1309,'2022-07-18 14:59:37',73,'1',2),(1310,'2022-07-18 14:59:38',293,'1',2),(1311,'2022-07-18 14:59:38',189,'1',2),(1312,'2022-07-18 14:59:39',295,'1',2),(1313,'2022-07-18 14:59:39',147,'1',2),(1314,'2022-07-18 14:59:40',243,'1',2),(1315,'2022-07-18 14:59:40',332,'1',2),(1316,'2022-07-18 14:59:41',484,'1',2),(1317,'2022-07-18 14:59:41',431,'1',2),(1318,'2022-07-18 14:59:42',106,'1',2),(1319,'2022-07-18 14:59:42',389,'1',2),(1320,'2022-07-18 14:59:43',1300,'1',2),(1321,'2022-07-18 14:59:43',260,'1',2);
/*!40000 ALTER TABLE `golf_sms_report` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_send`
--

DROP TABLE IF EXISTS `golf_sms_send`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_send` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `progress` varchar(50) DEFAULT NULL COMMENT 'pending\nin_progress\ncomplet',
  `user_id` bigint DEFAULT NULL,
  `data` text,
  `created_at` datetime DEFAULT NULL,
  `description` text,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `golf_send_sms_fk1_idx` (`user_id`),
  CONSTRAINT `golf_send_sms_fk1` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_send`
--

LOCK TABLES `golf_sms_send` WRITE;
/*!40000 ALTER TABLE `golf_sms_send` DISABLE KEYS */;
INSERT INTO `golf_sms_send` VALUES (2,'complete',1,'{\"event_id\":\"1\",\"sms_settings_id\":\"1\"}','2022-07-18 14:53:33','1st text blast',1);
/*!40000 ALTER TABLE `golf_sms_send` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_sms_settings`
--

DROP TABLE IF EXISTS `golf_sms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_sms_settings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `schedule` varchar(100) DEFAULT NULL,
  `message_header` text,
  `message_body` text,
  `message_footer` text,
  `status` tinyint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `event_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_sms_settings`
--

LOCK TABLES `golf_sms_settings` WRITE;
/*!40000 ALTER TABLE `golf_sms_settings` DISABLE KEYS */;
INSERT INTO `golf_sms_settings` VALUES (1,'101010 2022 Invitation',NULL,NULL,'Join the 10th 10-10-10 Fun Charity Golf Tournament!\r\n\r\nDate: October 10, 2022 (Monday)\r\nVenue: The Orchard Golf & Country Club, Cavite\r\n\r\nPLAYERS DIVISION:\r\nTeam Registration Fee: Php 10,000.00 ( 1 team of 2 players)\r\n\r\nFor more details please call/sms: \r\n\r\nJOHN CHAN(Players Division)\r\nMobile: 0917-807-4768\r\n\r\nMAE VALDEZ(Sponsors Division)\r\nMobile: 0920-955-7999\r\nEmail: 101010-fungolf@autohubgroup.com\r\n\r\nThank you and see you there!\r\n\r\n-- Willy Tee Ten',NULL,1,'2022-07-18 11:17:30',1);
/*!40000 ALTER TABLE `golf_sms_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_teams`
--

DROP TABLE IF EXISTS `golf_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_teams` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_id` bigint DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index3` (`event_id`,`name`),
  KEY `golf_teams_fk1_idx` (`event_id`),
  CONSTRAINT `golf_teams_fk1` FOREIGN KEY (`event_id`) REFERENCES `golf_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_teams`
--

LOCK TABLES `golf_teams` WRITE;
/*!40000 ALTER TABLE `golf_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users`
--

DROP TABLE IF EXISTS `golf_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `firstname` varchar(95) DEFAULT NULL,
  `middlename` varchar(95) DEFAULT NULL,
  `lastname` varchar(95) DEFAULT NULL,
  `mobile` varchar(45) DEFAULT NULL,
  `email` varchar(95) DEFAULT NULL,
  `other_mobile` varchar(45) DEFAULT NULL,
  `other_email` varchar(95) DEFAULT NULL,
  `username` varchar(45) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `is_admin` tinyint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `company_id` bigint DEFAULT NULL,
  `position_id` bigint DEFAULT NULL,
  `active` tinyint DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `unhs_id` varchar(95) DEFAULT NULL,
  `club_id` bigint DEFAULT NULL,
  `handicap` varchar(95) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index5` (`firstname`,`lastname`,`mobile`,`status`),
  UNIQUE KEY `username_UNIQUE` (`username`),
  KEY `golf_users_fk1_idx` (`club_id`),
  KEY `golf_users_fk2_idx` (`company_id`),
  KEY `golf_users_fk3_idx` (`position_id`),
  CONSTRAINT `golf_users_fk1` FOREIGN KEY (`club_id`) REFERENCES `golf_clubs` (`id`),
  CONSTRAINT `golf_users_fk2` FOREIGN KEY (`company_id`) REFERENCES `golf_companies` (`id`),
  CONSTRAINT `golf_users_fk3` FOREIGN KEY (`position_id`) REFERENCES `golf_positions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1340 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users`
--

LOCK TABLES `golf_users` WRITE;
/*!40000 ALTER TABLE `golf_users` DISABLE KEYS */;
INSERT INTO `golf_users` VALUES (1,'Admin',NULL,'Account','9389592854','clarenceandaya8@gmail.com',NULL,NULL,'admin','$2y$10$HVjH0A2h9D6bMTmlGJ0Preb3Te1Gx9e3erZIjvzXxi4mk7YpLgDfC',1,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(2,'STANLEY',NULL,'CHUA','9272043842','STAN_LEY_CHUA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,178,1,1,1,NULL,1,'18.5'),(3,'ROBERT',NULL,'CHUA TAN','9274505483','TUFFCHEMICAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,2,1,1,1,NULL,2,'22.60'),(4,'WASHINGTON',NULL,'ONG','9175267423','BIKE.NEWTON1@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,NULL,NULL,1,1,NULL,3,'19.00'),(5,'TSANG',NULL,'CHOI YUM','9178480696','SINHAPLEE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,4,2,1,1,NULL,4,'30.00'),(6,'JOHNSON',NULL,'CABALLEROS','9178531959','TRUEFLIGHT2003@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,5,NULL,1,1,NULL,5,'21.30'),(7,'ALBERT',NULL,'SEE','9178377960',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,6,3,1,1,NULL,5,'26.00'),(8,'BENITO',NULL,'DE LEON','9178400644','BNL@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,NULL,NULL,1,1,NULL,2,'21.3/ SEPT UNHS.PH'),(9,'MANOLO',NULL,'ANTONIL','9209523195','LSMA-ANTONIL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,8,4,1,1,NULL,2,'12.50'),(10,'DANILO',NULL,'ROLEDA','9189259833','ROLEDAD@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,9,3,1,1,NULL,1,'17.8'),(11,'EMMANUEL',NULL,'CANILAO','9178129028','CASTROCANILAO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,10,5,1,1,NULL,6,'22.60'),(12,'JOEY',NULL,'FORNIER','9178005888','JOEY.FORNIER@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(13,'BEN',NULL,'MALCONTENTO','9178921210','BEN@KBMALAWOFFICES.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,NULL,5,1,1,NULL,NULL,NULL),(14,'DON VICENTE',NULL,'MATE','9177999846','DVLTMATE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,NULL,NULL,1,1,NULL,7,'18.00'),(15,'WILSON',NULL,'UY','9173060028','REALWILSON_UY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,11,6,1,1,NULL,7,NULL),(16,'WALTER',NULL,'DIU','9173234261','WALTERDIU382@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,12,NULL,1,1,NULL,7,NULL),(17,'ROBERT',NULL,'ANDRADE','9173219688',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:11',NULL,NULL,13,NULL,1,1,NULL,7,NULL),(18,'WILLY',NULL,'JULIO','9285029495','TACLOBANMABUHAYGLASS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,14,6,1,1,NULL,84,NULL),(19,'MIKE CHEFFORD',NULL,'LEE','9174395750','M.CHEFFORD@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,15,1,1,1,NULL,84,NULL),(20,'KEVIN CHARLES',NULL,'LEUNG','9177077730','NEWGLORYGLASS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,7,NULL),(21,'JUDE',NULL,'BAKUNAWA','9399376499','BAKUJUDE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,7,NULL),(22,'MARK ANTHONY',NULL,'SULTAN','9175286684','MARK@SAMGLO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,31,'20.5/SEPT. UNHS'),(23,'JOHNNY',NULL,'LIM','9175114745','JJLIM_1219@YAHOO.COM.SG',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,17,3,1,1,NULL,3,'20.4'),(24,'MARC LAMBERTO',NULL,'REYES','9175311911','MARCREYES68@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,18,8,1,1,NULL,5,'10.70'),(25,'ESTEBAN',NULL,'ALMEDA','9189107458',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,18,9,1,1,NULL,5,'18.20'),(26,'JOSEPH',NULL,'MADRIGAL','9188030759','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,19,3,1,1,NULL,NULL,NULL),(27,'NELSON',NULL,'LU','9175000000','NDL_KIMKAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,56,'24.9'),(28,'WINSTON',NULL,'CHAN','9178948125','WINSTON.A.CHAN@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,20,8,1,1,NULL,8,'23.90'),(29,'MANNIE',NULL,'ALCANTARA','9178948143','EMMANUEL.C.ALCANTARA@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,20,38,1,1,NULL,95,'24.7'),(30,'RAMON',NULL,'DIZON','9178948163','RAMON.D.DIZON@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,51,'27.20'),(31,'GEMILO',NULL,'SAN PEDRO','9178948128','GEMILO.J.SAN.PEDRO@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,20,8,1,1,NULL,8,'15.80'),(32,'TOM',NULL,'CLEMENTE','9178330118','DEPUTY_TOM@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,22,NULL,1,1,NULL,NULL,NULL),(33,'VICENTE',NULL,'SANTOS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,22,11,1,1,NULL,NULL,NULL),(34,'DAVE',NULL,'DELA CRUZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,22,NULL,1,1,NULL,NULL,NULL),(35,'PARTNER',NULL,'NO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(36,'ANDOY',NULL,'PEREZ','9178438019','FCPEREZ888@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(37,'LEO',NULL,'TAGLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(38,'CONDRAD',NULL,'VIRINA','9178579700','CONRADO.VIRINA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(39,'HYUBS',NULL,'AZARCON','9175440419','ANOBANGTRIPMO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,6,'16'),(40,'ZANJOE',NULL,'MARUDO','9178202583',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(41,'EDGAR',NULL,'MORTIS','9178288142','EDGARMORTIZ@ROCKETMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,6,'29'),(42,'ZANJOE',NULL,'MARUDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(43,'RICO',NULL,'TOLENTINO','9175150929',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(44,'RAMIL',NULL,'BERNARDO','9178425696',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(45,'PERRY',NULL,'PE','9178330730','PERRY.PE@ROMULO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,23,8,1,1,NULL,9,'17.70'),(46,'SP',NULL,'SUMULONG','9178321183','SP.SUMULONG@AFPGLOBAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,24,5,1,1,NULL,10,'13.40'),(47,'OLAN',NULL,'BOOL','9209107214','RSBOOL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(48,'ENRIQUE',NULL,'SOLAS','9228693241','SALES@ICONSTECH.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,25,12,1,1,NULL,11,'15.1'),(49,'LEONARDO \"DING \"',NULL,'TEE','9178255512','DINGTEE123@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,3,'12.40'),(50,'JAVIER G.',NULL,'BERENGUER-TESTA','9175699585','JFBT@MONDIALTOURS.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,26,13,1,1,NULL,NULL,NULL),(51,'JAVIER G.',NULL,'BERENGUER-TESTA','9178113162','JBROCHA@CFSHARP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,14,1,1,NULL,12,'13.30'),(52,'RONNIE',NULL,'OLAGUERA','9178496669',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,27,14,1,1,NULL,3,'12.6'),(53,'STEPHEN',NULL,'JARVIS','9178114117','SJJARVIS@VISIONTV.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,3,'16.9'),(54,'RICKY',NULL,'ANASTACIO','9399228027','RSANASTACIO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(55,'ERMELO',NULL,'BALCUEVA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(56,'ADMIRAL REUBEN',NULL,'LISTA','9175478277','RLISTA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,105,'14'),(57,'REUBEN',NULL,'LISTA JR.','9178930858','RLISTAJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,210,3,1,1,NULL,112,'21'),(58,'NEIL',NULL,'MAGKILAT','9188038898','NEILMAGKILAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,186,15,1,1,NULL,86,NULL),(59,'TON',NULL,'BERREDO','9178079884','TONBEREDO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,31,16,1,1,NULL,13,'AGC 23'),(60,'ARNIE',NULL,'IDOS','9062242702','ARKIPINAS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,32,17,1,1,NULL,13,'AGC 25'),(61,'RAMON',NULL,'SANTIAGO','9178173517',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,33,18,1,1,NULL,NULL,'25.00'),(62,'EMILIANO',NULL,'JOVEN','9178161122','BONG_JOVEN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,19,1,1,NULL,113,'13'),(63,'GIL',NULL,'PENA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(64,'ERICH',NULL,'LINGAD','9178310608','ERICHL@ICPIMNL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,188,20,1,1,NULL,3,'20.1'),(65,'NEMESIO',NULL,'PAGTAKHAN','9178038702','N.PAGTAKHAN@STOLT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,3,'12.2/UNHS SEPT'),(66,'GEN. FRED',NULL,'DE VERA','9285033999','ABDJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,3,'19.9'),(67,'WILBERT',NULL,'YOUNG','9175358918','WILBERTYOUNG59@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,37,20,1,1,NULL,3,'15.8'),(68,'TOTI',NULL,'ZARA','9213809061',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,38,3,1,1,NULL,NULL,NULL),(69,'TEY',NULL,'SORNET','9178886477',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,38,NULL,1,1,NULL,NULL,NULL),(70,'ROBERT',NULL,'LARIANA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,39,NULL,1,1,NULL,NULL,NULL),(71,'ERIC',NULL,'TENSUAN','9173271503','SCEI_ERIC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:12',NULL,NULL,NULL,NULL,1,1,NULL,36,'13'),(72,'ROLANDO',NULL,'BOOL','9203107214','RCBOOL@OSAPHILS.COM',NULL,'RSBOOL@YAHOO.COM',NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'33297',15,NULL),(73,'DENNIS',NULL,'LAMUG','9988401061','DENNIS.LAMUG@JGSPETROCHEM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,16,'18.70'),(74,'ADAMSON',NULL,'GO   /  1 FLIGHT','9985520720','ADAMSON_GO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,'49807',17,NULL),(75,'RICHARD',NULL,'ROQUE','9985520720','KIDTEC999@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'49819',16,NULL),(76,'LORENCIO',NULL,'LIM / 1 FLIGHT','9989555262','LOCHITRDG@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,'54452',1,NULL),(77,'FRANCISCO \"JON\"',NULL,'DE LEON JR.  ','9178458880','FRANCISD17@HOTMAIL.COM',NULL,'FDJR17@GMAIL.COM',NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'1335',18,NULL),(78,'ALLAN',NULL,'YAP','9178515555','ALLANYAP7829@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'13757',1,NULL),(79,'RICHIE',NULL,'SANTOS ','9178515555','ALLANYAP7829@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(80,'ROMY',NULL,'YAO','9178515555','ALLANYAP7829@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'26240',5,NULL),(81,'RAUL',NULL,'OLEA','9178515555','ALLANYAP7829@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'25570',5,NULL),(82,'DENNIS',NULL,'CHAN/ 1 FLIGHT','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,'24412',5,NULL),(83,'TIMOTHY',NULL,'LIONG ','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'22620',2,NULL),(84,'JESS',NULL,'CABEL','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'49242',19,NULL),(85,'ARIEL',NULL,'DELA CRUZ','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'37723',5,NULL),(86,'JERRY',NULL,'YBAEZ/ 1 FLIGHT','9178250545','JSY@JETHROCK.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,'57510',20,NULL),(87,'ABRAHAM \" DODIE\"',NULL,'CABASAL','9175114945','CRANECAT1995@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'40179',21,NULL),(88,'AHAN',NULL,'CHONG','9178250545','JSY@JETHROCK.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(89,'FREDDIE',NULL,'PO','9178250545','JSY@JETHROCK.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(90,'VICTOR',NULL,'VITAL','9178925855','VLVITAL@ABCAPITAL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,10,'17.7/ SEPT UNHS'),(91,'MARK CORNELIUS',NULL,'SAMBAR','9173287468','SAMBAR.ANDERSON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'40326',10,NULL),(92,'JASON',NULL,'PORCIUNCULA','9189114088','JCP@EASTWESTHEALTHCARE.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,3,'17.50'),(93,'SAMUEL',NULL,'BALTAZAR','9177930956','BASA44@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'15605',3,NULL),(94,'GENE',NULL,'DE JESUS','9194533002','GCDEJESUS2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'19510',4,NULL),(95,'DR. MARK',NULL,'SISON','9194533002','GCDEJESUS2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'42119',22,NULL),(96,'CLEMENTE',NULL,'CHAN','9175217171','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'38691',23,NULL),(97,'ROMEO JOSEPH',NULL,'IGNACIO','9209319831','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'19712',24,NULL),(98,'EUGENIO',NULL,'CHEUNG','9209017777','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'41074',25,NULL),(99,'JUAN MIGUEL',NULL,'CANTERO','9175217171','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'47224',26,NULL),(100,'TEEK HONG',NULL,'KEE','6530127463','TEEK@CHEVRON.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'21933',27,NULL),(101,'LOCK SOON',NULL,'OH/ 1 FLIGHT','9178706868','LOCKSOON.OH@KEPPELLAND.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(102,'ALAN',NULL,'CHNG/ 1 FLIGHT','9174709336','ALANCHNG.ACBC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(103,'CHEOK PIN',NULL,'LEE/ 1 FLIGHT','9209706357','CHEOKPIN.LEE@YCH.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,NULL,NULL,'19922',4,NULL),(104,'GLENN',NULL,'CHAN','9175543822','GLENNMELJOSHLUKE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(105,'RODNEY',NULL,'DIZON','9178978168','RODNEYDIZON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,1,'10.4/SEPT. UNHS'),(106,'EDWIN',NULL,'BERMUDEZ','9994704865',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'--------'),(107,'EDWIN',NULL,'VILLANUEVA','9175261768','EDWIN.VILLANUEVA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'4139',28,NULL),(108,'EMILIANO \"BONG\"',NULL,'JOVEN','9178161122','BONG_JOVEN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'66154',29,NULL),(109,'RICHARD',NULL,'ALBANO','9177101984','RICHARDALBANO84@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,68,'19.0/ AUG. UNHS'),(110,'GILBERT',NULL,'VALLE','9088944533','GCVALLE@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(111,'JOSE MANUEL',NULL,'SANTOS','9088944536','JMASANTOS@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(112,'JERRY MARVIN',NULL,'JOVERO (1 FLIGHT)','9209493123','JMVJOVERO@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:21',NULL,NULL,NULL,NULL,1,1,'33339',15,NULL),(113,'NICOLO EDOARDO',NULL,'REYES (1 FLIGHT)','9189483669','NEYREYES@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(114,'ROMEO',NULL,'CHONG','9178160561','G2CITC@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,47,'13.80'),(115,'RAULITO',NULL,'PARAS','9178486050','JREP711@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,152,31,1,1,NULL,47,'20.5'),(118,'REY',NULL,'ARAOS','9178431791','PRESIDENT@EYELECTRIC.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,33,NULL),(119,'JOEL',NULL,'ELLO','9177728008','JOELELLO8888@YAHOO.COM','9088085448',NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(120,'LUCIO \"JUN\"',NULL,'HORFILLA JR.','9209291790','LTH1021@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'43270',34,NULL),(121,'JERUSALEM \"SALEM\"',NULL,'VERCIDE','9177141708','VERCIDEJERUSALEM2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'64385',34,NULL),(122,'CARL IAN',NULL,'ONG','9778129694','CARLIANZONG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'14967',19,NULL),(123,'ENZO',NULL,'HERMOSA','9178948430','ENZOHERMOSA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,16,NULL),(124,'DAVID',NULL,'LIM','9175314682','JCINTLCO@AOL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'2481',35,NULL),(125,'EDILBERTO \"BOBOT\"',NULL,'SARENAS','9175249149','JCINTLCO@AOL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'28431',36,NULL),(126,'RONILO \"RONNIE\"',NULL,'OLAGUERA','9178496665','RONNIE.OLAGUERA@TIMENGINEERING.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'16587',3,NULL),(127,'MICHAEL ANTHONY \"JOCK\"',NULL,'STACEY','9778415590','RONNIE.OLAGUERA@TIMENGINEERING.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'40489',3,NULL),(128,'JOSEPH',NULL,'MADRIGAL/ 1 FLIGHT','9188030759','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'25385',5,NULL),(129,'CHRISTOPOLUS',NULL,'COCHING','9178310510','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'24533',5,NULL),(130,'MIGUELITO',NULL,'SANCHEZ','9498897751','M.SANCHEZ@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(131,'RAUL',NULL,'ENRIQUEZ','9288200714','M.SANCHEZ@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'46529',37,NULL),(132,'RICKY',NULL,'TY','9209384376','TY_RKY@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(133,'HARRIS',NULL,'GRAHAM','9209384376','TY_RKY@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,3,NULL),(134,'CARLOS',NULL,'SANTOS','9178332119','CARLOS.SANTOS0518@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'39626',38,NULL),(135,'VICTOR',NULL,'GARLITOS','9175220407','CARLOS.SANTOS0518@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'2941',38,NULL),(136,'MARIANO ROBBIE',NULL,'DINGLASAN III','9175285087','ROBBIEDING@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'42195',19,NULL),(137,'RICHARD JAY',NULL,'LISTA/ 1 FLIGHT','9175366947','RJLISTA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'7217',39,NULL),(138,'SAMUEL',NULL,'GAN NASIS/ 1 FLIGHT','9178906698','SGANNASIS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'8457',16,NULL),(139,'RAOUL MICHAEL',NULL,'VIRAY JR. ','9178906698','SGANNASIS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'26188',5,NULL),(140,'JOSELITO \"JOEY\"',NULL,'BAINGAN','9178836408','JCBAINGAN@BAIVIINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,11,'16.9/ SEP UNHS'),(141,'RENE CHESTER \"CHEK\"',NULL,'PANGAN','9175209626','RCPANGAN@BAIVIINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'65636',11,NULL),(142,'AUGUSTO \"GUS\"',NULL,'LAGMAN','9178178477','GUSLAGMAN1@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'23190',2,NULL),(143,'REX',NULL,'DRILON II','9178415570','REX@DRILON.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'9025',40,NULL),(144,'CHARLES \"BOBOY\"',NULL,'LIM','9175816168','BOBOYLIM@GMAIL.COM','9165816158',NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'65640',4,NULL),(145,'ROMEO',NULL,'VILLABONA ','9178122612','AGGYSCAKES.SWEETS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'20498',4,NULL),(146,'ERNEL',NULL,'ESPELETA / 1 FLIGHT','9209031857','BOBOYLIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'19560',4,NULL),(147,'PAULINO \"PAUL\"',NULL,'ELEVADO III','9988664868','PAUL3.ELEVADO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19554',4,NULL),(148,'FORTUNATO',NULL,'DIMAGIBA JR.','9178574397','FLDIMAGIBA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(149,'MARCO',NULL,'ALDABA','9188045405','ALDABA_MARCO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19262',4,NULL),(150,'ARIEL \"HYUBS\"',NULL,'AZARCON/ 1FLIGHT','9175440419','ANOBANGTRIPMO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(151,'BEN',NULL,'PASCUAL',NULL,'BPASCUAL2528@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(152,'RAMIL',NULL,'BERNARDO','9155678811','BERNAR6@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(153,'ALAN',NULL,'CARANDANG','9982696301','ALANCABC214@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(154,'AGERICO \"GERRY\"',NULL,'VERZOLA','9178811201','VERZOLA.AGERICO@BDO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,23,NULL),(155,'RONNIE',NULL,'FABIAN','9178150407','RONNIEJFABIAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(156,'ISABELO',NULL,'AFRICA','9175305117','OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'14409',19,NULL),(157,'RICHMUND \"RICHIE\"',NULL,'HERRERA',NULL,'OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19679',4,NULL),(158,'DONAVAN',NULL,'YU / 1 FLIGHT','9175524496','DWTL30@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'15317',19,NULL),(159,'ROD',NULL,'PEREZ  ',NULL,'OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(160,'ATTY. MARK',NULL,'VERGARA','9189172731','DMDELACRUZ@STALUCIALAND.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'22325',27,NULL),(161,'DAVID \"DAVE\"',NULL,'DELA CRUZ','9189172731','DMDELACRUZ@STALUCIALAND.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'15902',3,NULL),(162,'MICHAEL',NULL,'SY','9175873838','SYMIKEL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'20392',4,NULL),(163,'DR. ADRIAN PAULO \"IAN\"',NULL,'LAUREL','9178803710','ARLAUREL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'42625',41,NULL),(164,'ARCHIE',NULL,'ALEMANIA','9053861849','ARCHIEALEMANIA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,59,'10.00'),(165,'BERT',NULL,'DE LEON','9175283388','BDL528@ICLOUD.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,5,NULL),(166,'VICTOR',NULL,'FERNANDEZ','9158888869','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:53:08',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(167,'ATTY. AVELINO \"BILLY\"',NULL,'SUMAGUI ','9178229829','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(168,'WHARTON (NOEL BAYBAY)',NULL,'CHAN ','9175016492','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(169,'ELMER',NULL,'SALDIVAR/ 1 FLIGHT','9175215388',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(170,'TONY',NULL,'ANDAYA','9175016492','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(171,'GERALD',NULL,'CEBALLOS','9175016492','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(172,'EPHRAIM FAUSTINO',NULL,'DE MESA ','9189488655','EPHRAIMFAUSTINO@GMAIL.COM','9567742003',NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'3534',38,NULL),(173,'ERICKSON',NULL,'ORBON','9175016492','VICTORECOVERY@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(174,'FORTUNATO \" ATOY \"',NULL,'CO JR.','9178836669',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(175,'THOMAS ROGENRIC \"OGIE\"',NULL,'CAJA','9175340810','OGIECAJA@MAYAADS.NET',NULL,'OGIECAJA@OMNISOURCE.PH',NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'15695',3,NULL),(176,'ASEC. FREDERICK \"RICKY\"',NULL,'ALEGRE','9178910800',NULL,'9289503816','FMALEGRE03@YAHOO.COM',NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19263',4,NULL),(177,'STUART',NULL,'SAMSON ','9164080957','STUART.SUBARULICA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(178,'ROLANDO',NULL,'GUTIERREZ ','9178072584','JON.GUTIERREZ01@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(179,'CLARENCE',NULL,'CHIONG JR.','9178668858','CJR.CHIONG@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(180,'VICTOR',NULL,'DELARMENTE ','9178255531','DELARMENTE.VICTOR@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(181,'ORLANDO',NULL,'MANINGAS','9178869116','ORLANDMANIGAS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,42,'17/SEPT. UNHS'),(182,'MARIO',NULL,'BALBUENA','9176278474',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,43,NULL),(183,'ELPIDIO \"JHUN\"',NULL,'PAGADOR','9178005598','RABORARJAYPEE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'21267',1,NULL),(184,'DANILO',NULL,'NUESCA','9178211816','DANILO.NUESCA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'51063',16,NULL),(185,'BENITO',NULL,'DE LEON/ 1FLIGHT','9178400644','BNL@EMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'22786',2,NULL),(186,'MANOLO \"MOLLIE\"',NULL,'ANTONIL/ 1FLIGHT','9209523195','MDANTONIL11@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,NULL,NULL,'22543',2,NULL),(187,'ROMMEL',NULL,'JUAN','9178174869','ROMMELJUAN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'40075',5,NULL),(188,'ERIC',NULL,'WAMBANGCO','9175715205','WAMBANGCO.ED@ISUZUPASIG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(189,'VICENTE',NULL,'BELISARIO','9988494940','VBBELISARIO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'36577',2,NULL),(190,'LUIS',NULL,'MAGTOTO','9184290486',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(191,'CHRISTOPHER \"CHRIS\"',NULL,'TANG ','9178381129',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'26068',5,NULL),(192,'MANUEL',NULL,'TAN','9178381129',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'13606',1,NULL),(193,'SONNY',NULL,'PANGILINAN ','9178381129',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(194,'NIXON',NULL,'LEE','9178381129',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'44757',22,NULL),(195,'HERBERT',NULL,'HUIT','9178656077','LARRY.ACERO@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(196,'MARIO',NULL,'NAVAL ','9178656077','LARRY.ACERO@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'25518',5,NULL),(197,'JOCSON',NULL,'GAN','9178656077','LARRY.ACERO@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'16033',1,NULL),(198,'ALEXANDER \"ALEX\"',NULL,'TY ','9178656077','LARRY.ACERO@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'26129',5,NULL),(199,'JAGMOHAN \"ROBIN\"',NULL,'TAMBER','9178003637',NULL,'9228003637',NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(200,'EMMANUEL',NULL,'HERMOSA','9178199197','ELHERMOSA@GMAIL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'46624',16,NULL),(201,'DENNIS JOSEPH',NULL,'UY','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'13694',1,NULL),(202,'RAYMUND',NULL,'CHUA ','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(203,'ALEX',NULL,'KIM ','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'13016',1,NULL),(204,'ROBERT',NULL,'DY ','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'12839',1,NULL),(205,'ALVIN',NULL,'HIPOLITO','9167783636','ALVINUHIPOLITO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(206,'ATTY. EDMUND',NULL,'ESPINA','9175390515','ATTY_ESPINA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(207,'JON',NULL,'NAZARIO','9177072802','JNAZARIO@PSTROKE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(208,'VINCENT FILAMER',NULL,'ROSELL','9088945658','VROSELL@MSITA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'54295',1,NULL),(209,'DR. JAMES',NULL,'CO SHU MING','9174900954','JCOSHUMING@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,4,NULL),(210,'JOSEPH OWEN',NULL,'FULO','9178947827','JOFULO@SPLI.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19591',4,NULL),(211,'ISMAEL \"JUN\"',NULL,'ESTELA JR.','9209514057','IGE@BDO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19566',4,NULL),(212,'JOSEPH',NULL,'KABIGTING','9174900954','JOSEPH.KABIGTING09@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'19781',4,NULL),(213,'HERMAN',NULL,'MEDINA-CUE','9178405819',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'20062',4,NULL),(214,'ANTHONY',NULL,'SUNTAY','9178422537','ANTHONYSUNTAY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,2,'20'),(215,'RICO',NULL,'TOLENTINO','9179639123','RICOTOLENTINO929@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,77,'15.60'),(216,'GARY',NULL,'LIM',NULL,'GARYLIM27@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'34970',44,NULL),(217,'RICHARD',NULL,'BERNABE','9228688122','SALES@CROWNPVC.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,'50799',20,NULL),(218,'BJ',NULL,'CADAYING','9675646415','ROMBER.TRADING07@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:22',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(219,'RAMON',NULL,'GARCIA JR.','9178421888','RAMON@ASIADEFENSE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:29',NULL,NULL,NULL,NULL,1,1,NULL,10,'23.9/SEPT UNHS'),(220,'MITSUHIRO',NULL,'HIGASHIDA',NULL,'MHIGASHIDA@KENKOTOKINA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,45,'14.60'),(222,'REUJENSON',NULL,'LISTA','9175839225','REUJEN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,210,67,1,1,NULL,112,'19'),(223,'RICHARD JAY',NULL,'LISTA','6328451536',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,46,'18.70'),(224,'RYAN',NULL,'CRUZ','6327558895',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,19,'19.80'),(225,'ATTY. DANILO',NULL,'ROLEDA','9189259833','ROLEDAD@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,1,'13.70'),(226,'RICHARD',NULL,'LIMCACO','9198840032','RTLIMCACO@YAHOO.CON',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,47,'21.70'),(227,'MICHAEL',NULL,'DEL MORAL','9173083384','MDELMORAL@FPGINS.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,26,'18.60'),(228,'ATTY. GLEN',NULL,'SUBIA','9178447936',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'16.10'),(229,'ELPIDIO \"JUN\"',NULL,'PAGADOR','9178005598','JAYPEERABORAR@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,1,'13.5/SEPT. UNHS'),(230,'DANNY',NULL,'BATINO','9178828847',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'24.6/SEPT. UNHS'),(231,'DENNIS',NULL,'CHAN','9178220078','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,159,3,1,1,NULL,5,'15.6'),(232,'ADAM',NULL,'GLEW','4401773861644','ADAM.GLEW@BULWELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(233,'PAUL HARVEY',NULL,'CAMPOSANO','9178133488','HARVEYCAMPOSANO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(234,'PAULO',NULL,'GONZALES','9175531581','PAUGONZI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(235,'CHARLES',NULL,'MERIOLES','9088512456','CMERIOLES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(236,'LOCK SOON',NULL,'OH','9178706868','LSOF58@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,48,'N/A'),(238,'JOO YOUNG',NULL,'LEE',NULL,'JYLEE@HANJIN.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,49,'15.60'),(239,'ATTY. CONSTANTINO \"BANJO\"',NULL,'NAVARRO','9175292360','NAVARROLAWPH@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,22,'18.50'),(240,'EDGARDO',NULL,'BROCAL','9178131860','EMB.BUILDERS.INC@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,45,'16.40'),(241,'RODOLFO \"BONG\"',NULL,'BROBIO','9177916835','RVBROBIO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,1,'3.40'),(242,'NOEL',NULL,'BONGAT','9178588816',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,1,'16.10'),(243,'LORENCIO',NULL,'LIM','9989555262','LOCHITRDG@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,50,'21.1/UNHS SEPT.'),(244,'DEXTER',NULL,'LIM','9188338833','DEXYULIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'FOREST = 18.2'),(245,'EMMANUEL \"MANNIE\"',NULL,'ALCANTARA','9178948143','ECA918@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,65,'26.0/SEPT. UNHS'),(247,'LAURO  \"ROBBIE\"',NULL,'LEVISTE  II','9178318331','LAUROLEVISTE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,15,'27.70'),(248,'DAN',NULL,'SALVADOR III','9178480605','JON2SALVADOR@YAHOO.COM','9989572037',NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,52,'4.70'),(249,'CRISPIN \"CRIS\"',NULL,'CARREON','9178870467','CRIS.CARREON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,12,'11.30'),(250,'FERDINAND  \"FERDI\"',NULL,'YU','9178317878','FERDIYU@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,51,'24.90'),(251,'PHILBERT',NULL,'PAMINTUAN','9175977460','PHILBERT_PAMINTUAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,53,'29.30'),(252,'EDWARD RAYMOND',NULL,'MORALES','9177922996','MORALESJEDI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,46,'24.90'),(253,'JOSEPH \"BUDDY\"',NULL,'MADRIGAL','9188030759','BUDDY.MADRIGAL@PAIRCARGO.COM','9175376735',NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,51,'21.2/SEPT. UNHS'),(254,'ERWIN',NULL,'DELA CRUZ','9175346750','ERWIN.DELACRUZ@JAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'17.50'),(255,'MIGUEL',NULL,'OZAETA','9175858616','MNLOZAETA@NOMURA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,10,'5.60'),(256,'AKIHIRO',NULL,'OZASA','6592978485','AKIHIRO.OZASA@NOMURA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(257,'ALLAN',NULL,'PUA','9209520667','RA_PUA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,23,'NH'),(258,'RAMIL',NULL,'BERNARDO',NULL,'BERNARA6@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,23,'21.80'),(259,'ADRIAN',NULL,'TAN','9178491683','ADRIAN@AXIS3D.HK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,49,'20.50'),(260,'DAVE',NULL,'NICHOLSON','9998856650','DAVENICHOLSON84@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(261,'MICKEY',NULL,'SANCHEZ','9498897751','M.SANCHEZ@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(262,'JOHNNY',NULL,'DAVID','9209056079','J.DAVID@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(263,'FRANCIS',NULL,'GO','9178934653','FSG.PAIRCARGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(264,'DICKSON',NULL,'ESCOLAR','9285064958','D_ESCOLAR@PAGSS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(265,'ROEL',NULL,'MAGLAYA','9177942889','ROEL202@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,38,'9.40'),(266,'RICO',NULL,'PAGULAYAN','9178987427',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,54,'19.30'),(267,'ISABELO',NULL,'AFRICA','9188305117','OP@UCPBGEN.COM','9175305117',NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,19,'22.50'),(268,'RICARDO',NULL,'BARICAN JR.','9178108720','RSB@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'23.60'),(269,'JUSTINO',NULL,'MACAPAGAL','9177914927','JAY-MACAPAGAL@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'14.70'),(270,'JOEL',NULL,'LIBO-ON',NULL,'JOEL_LIBO-ON@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'13.90'),(272,'JOSE RAULITO',NULL,'PARAS','9178086050','JREP711@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,76,'15.30'),(274,'MANOLO \"MOLLIE\"',NULL,'ANTONIL','9209523195','LSMA_ANTONIL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'12.9/SEPT. UNHS.PH'),(275,'EPHRAIM',NULL,'DE MESA','9189488655','EPHRAIMFAUSTINO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,38,'15.50'),(276,'VIGILART',NULL,'DAVID','9178684454','VGDAVID@STACLARAPOWER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,16,'SOUTHLINKS = 23.2'),(278,'ROBERTO \"BOBBY\"',NULL,'GONZALES','9175378930','BOBBYGONZALES@MSTTRADING.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'16.90'),(279,'ROBERTO \"BOBBY\"',NULL,'RONQUILLO','9175691388','BARTRONQUILLO@YAHOO.COM','9209430920','SHARKPHIL@GMAIL.COM',NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,8,'18.80'),(280,'ERLO',NULL,'TENEDERO','9178677576','TENEDERO.E0@ISUZUALABANG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,6,'THERE ARE 2 E. TENEDERO (AGUINALDO 16.3/SHERWOOD 13)'),(281,'ROLANDO \"OLAN\"',NULL,'BOOL','9209107214','RCBOOL@OSAPHILS.COM',NULL,'OLANBOOL@GMAIL.COM',NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,15,'12.20'),(283,'VICTOR',NULL,'GENUINO','9209149500','VSGENUINO@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,10,'18.10'),(284,'REDEL',NULL,'DOMINGO','9088886741','RMDOMINGO@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,22,'NH'),(286,'MARK ANDERSON',NULL,'SAMBAR','9173287468','SAMBAR.ANDERSON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,10,'25.60'),(287,'RONILO \"RONNIE\"',NULL,'OLAGUERA','9178496669','RONNIE.OLAGUERA@TIMENGINEERING.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'13.00'),(288,'STEPHEN \"STEVE\"',NULL,'JARVIS','9178114117','STEPEN@TVSHOP.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'14.40'),(289,'ARIEL \"HYUBS\"',NULL,'AZARCON','9175440419','ANOBATRIPMO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'MANDATORY 10'),(290,'LEWIS ALFRED \"L.A.\"',NULL,'TENORIO','9177091227','LEWIS_ALFRED@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(291,'ERIC',NULL,'ANG','9175322222','7ERICANG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,55,'NH'),(292,'ZANJO',NULL,'MARUDO','9178202583','ZMARUDO23@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,6,'28.0/ NOT UNHS/MANDATORY 10'),(293,'JERRYME',NULL,'GARCIA','9988494938','JERRYMEGARCIA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'N/A'),(294,'RICO',NULL,'MACALINTAL','9178650632','RICO.MACALINTAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'29.40'),(295,'EDMUNDO',NULL,'NAVARRO, JR.','9988494941','EDMUNDNAVARROJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,22,'27.80'),(296,'ARNEL',NULL,'DEUNIDA',NULL,'ARNEL.DEUNIDA@ISUZUPHIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,2,'23.00'),(297,'VICENTE \"VIC\"',NULL,'BELISARIO','9988494940','VBBELISARIO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,22,'23.80'),(298,'ERIC',NULL,'WAMBANGCO','9178503742','WAMBANGCO.ED@ISUZUPASIG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(299,'EXEQUIEL',NULL,'DELGADO','9175298799','EXEQUIELDELGADO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,64,'NH/UNHS.PH'),(300,'EPHRAIM',NULL,'DEL ROSARIO','9175833381','EDELROSARIO0604@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,42,'23.6/ AUG. UNHS'),(301,'DENNIS',NULL,'UY','9178308653','UY.DENNIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'ELENA = 20.5/MLA. GOLF = 20.7'),(302,'JUAN ARMANDO',NULL,'DE BORJA','9175127712','JDEBORJA@ADB.ORG',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(303,'RAYMUND',NULL,'CHUA','9178329128','RAYMUNDCCHUA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(304,'EDISON',NULL,'CO','9175290875',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(305,'LEONIDES \"LEO\"',NULL,'TAGLE JR.','9175325959','LEO.TAGLE@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,56,'17.60'),(306,'JAY',NULL,'VALDEZ','9189171849','JVALDEZ@ICTSI.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'12.50'),(307,'ELMER',NULL,'SALDIVAR','9175215388','ELMERYHYH@YAHOO.COM',NULL,'ELMERGG5@GMAIL.COM',NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(308,'ATTY. BILLY',NULL,'SUMAGUI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'N/A'),(309,'ERNEST',NULL,'VILLAREAL','9178180368','ERNEST.VILLAREAL@ABOITIZ.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,36,'13'),(310,'ULYSSES',NULL,'SEVILLA','9178253168','SEVILLA_LAW@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,57,'N/A'),(311,'CHEOK PIN',NULL,'LEE','9178083937','CHEOKPINLEE@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'28.30'),(312,'YEW GHEE',NULL,'TAN','9178662244','YEWGHEE.TAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'(NOT REGISTERED) 30'),(313,'HOCK HENG',NULL,'SEE','9178003333','JSEE208@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,19,'11.80'),(314,'BOON KHOON',NULL,'TAN','9175845860','JUNGLEKING@MSN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'19.70'),(315,'CHRISTOPHER',NULL,'TY',NULL,'CETY@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,58,'13.90'),(316,'NATHANIEL',NULL,'SIONGCO',NULL,'NLSIONGCO@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,22,'17.10'),(317,'FRANCIS NEIL',NULL,'MENDOZA','9175885789','FRMENDOZA@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,53,'19.20'),(318,'RICHARD',NULL,'SALCEDO','9178180674','RCSALCEDO@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,53,'5.20'),(319,'JAN VINCENT',NULL,'TANDINGAN','9175883682','JATANDINGAN@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,53,'14.10'),(320,'DOMINIC',NULL,'TRIA','9175889590','DETRIA@GLOBE.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,53,'9.90'),(321,'VICENTE PAUL \"VINCE\"',NULL,'HIZON','9178931170','VINCEHIZON@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,58,'9.20'),(322,'EDUARDO ANTONIO \"TON-TON\"',NULL,'GUTIERREZ JR.','9499923380','ANTONIO_GUTIERREZ68@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,16,'6.80'),(323,'COCOY',NULL,'SULAIK','9178996158','COCOYSULAIK@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,23,'9.30'),(324,'MARVIN',NULL,'CAPARROS','9175282818','MARVIN@RSCAMNL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,36,'5.70'),(325,'ADONES',NULL,'BALUYOT','917813550','ATB_DES@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,10,'10.40'),(326,'SMOKEY',NULL,'MANALOTO','9178330844','SMOKEYMANALOTO@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,59,'10.00'),(328,'ABRAHAM',NULL,'CABASAL, JR.','9175114945','JETHROCK888@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL,60,'18.40'),(329,'JERRY',NULL,'YBAEZ','9178250545','JERRYYBANEZ1661@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,23,'NO UNHS        29'),(330,'JOEY',NULL,'ORDINANZA','9177242209','JOSYSTEMENTERPRISES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,23,'NO UNHS          27'),(331,'DON DON',NULL,'DE GUZMAN','9178152425','DDDG32003@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,64,'NH/UNHS.PH'),(332,'GINO',NULL,'BONIFACIO','9989595214','GINOB@MHAWII.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,36,'MANDATORY 10'),(333,'DOMINGO \"DINGO\"',NULL,'BONIFACIO','9088820627','DINGOB@MHAWII.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,19,'21.10'),(334,'LUCIO \"JUN\"',NULL,'HORFILLA','9209291790','LTH1021@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,61,'10.50'),(335,'SALEM',NULL,'VERCIDE','9177141708','JG_VERCIDE@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,62,'N/A @ UNHS  12.5'),(336,'RAMON JAIME',NULL,'TABUENA JR.','9175355620','RJRTABUENA@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'14.80'),(337,'LUIS',NULL,'BONOAN','9175765847','LSBONOAN@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,59,'N/A'),(338,'JEFFREY',NULL,'NAVA','9178552195','JEFF.NAVA@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,56,'14.90'),(339,'JOHN BENEDICT',NULL,'DELOS SANTOS','9178867860','JB.DELOSSANTOS@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,56,'24.50'),(340,'RAYMUND \"TED\"',NULL,'ALMEDA','9178384647',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'16.70'),(341,'FEDERICO \"RICKY\"',NULL,'SANDOVAL  II','9178193206',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,10,'25.50'),(342,'SAMUEL',NULL,'GAN NASIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,16,'14.50'),(343,'BIMBOY',NULL,'ZETHA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,16,'19.90'),(344,'ROMY',NULL,'TAGLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(345,'DANNY',NULL,'TAGLE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(346,'GREGORY',NULL,'WEI','9178075018','GREGORY_WEI@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,40,1,1,NULL,5,'18.5'),(347,'ERIC',NULL,'HO','9175237618','ERICHO5888@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,51,'15.20'),(348,'ELEAZAR \"ELL\"',NULL,'CARSULA','9189059737','ECARSULA@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,63,'11.80'),(349,'JOSE RAMON',NULL,'MAGAT II','9178212624','JRAMON@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,3,'14.30'),(350,'RAFAEL',NULL,'NACINO','9175116307','RALPHMNACINO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,4,'22.10'),(351,'ROCCO',NULL,'NACINO','9178721030','ROCCO_NACINO21@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,59,'N/A'),(352,'KOK HIN',NULL,'LIM','9178974510','KOKHIN_LIM@CANON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,19,'17.10'),(353,'JOJO',NULL,'BOLIMA','9175854516','JOJO_BOLIMA@CANON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,59,'N/A'),(354,'SVEN',NULL,'RITTER',NULL,'SVEN.J.RITTER@ROLLS-ROYCEMOTORS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(355,'GOV. PEDRO \"PETER\"',NULL,'MEDALLA JR.','9209279952','GOV_MEDALLA@YAHOO.COM','9175207383',NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,56,NULL),(356,'MARIO',NULL,'LOPEZ','9175073225','MALOPEZ@TURFCOM.NET.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,15,'13.90'),(357,'JEROME',NULL,'BALDOZ','9177260021',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,60,'18.20'),(358,'VICTORINO',NULL,'FELIPE JR.','9175219853','VIC.FELIPE@RATECHNIC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(359,'DANILO',NULL,'MONTENEJO JR.',NULL,'DGMONTENEJO@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:30',NULL,NULL,NULL,NULL,1,1,NULL,59,'N/A'),(360,'RUDY',NULL,'RAGRAGIO','9209458485','RUDY.RAGRAGIO@RATECHINC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:31',NULL,NULL,NULL,NULL,1,1,NULL,74,'17.9/ SEPT. UNHS'),(361,'ROLANDO',NULL,'TOLORES','9178870357','RTOLORES@TRANSORIENTPH.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:31',NULL,NULL,NULL,NULL,1,1,NULL,2,'16.1/ SEPT. UNHS'),(362,'CHARLES',NULL,'LIM',NULL,'BOBOYLIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:31',NULL,NULL,NULL,NULL,1,1,NULL,4,'35.00'),(363,'ROMEO',NULL,'VILLABONA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:31',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(365,'ADAMSON',NULL,'GO','9985520720','ADAMSON_GO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,50,'NH/UNHS.PH/MANDATORY 10'),(369,'NORMAN',NULL,'SANTIAGO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(371,'EDWIN',NULL,'ABESAMIS','7278960','ECABESAMIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,38,'10.70'),(373,'MARK',NULL,'SAMBAR','9173287468','SAMBAR.ANDERSON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,10,'23.4/ SEPT. UNHS'),(376,'ALLAN',NULL,'CARANDANG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,'MANDATORY 10'),(377,'RAMIL',NULL,'BERNARDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(378,'GENE',NULL,'DE JESUS','9164939599','GCDEJESUS2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,4,'19/ SEPT UNHS'),(379,'DON',NULL,'DE JESUS','9194583002','GCDEJESUS2014@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,47,'18.40'),(380,'ABRAHAM \"DODIE\"',NULL,'CABASAL','9175114945','CRANECAT1995@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,60,'18.3/ UNHS SEPT.'),(381,'JEFFREY',NULL,'DY TAN','9175112288','JET_TAN1982@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,6,'8.30'),(383,'JERRY',NULL,'YBANEZ','9178250545','JSY@JETHROCK.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(387,'WINSTON \"WINNIE\"',NULL,'CHAN','9178948125','WACWINSTON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,65,'27.7/ SEPT. UNHS'),(388,'JEFFERSON',NULL,'BONGAT','9178112690','SONBONGAT@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(389,'ULYSSES',NULL,'GARCES','9998829698',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,64,'NH/UNHS.PH'),(391,'GRAHAM',NULL,'HARRIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'21.6/SEPT.UNHS'),(392,'DINDO',NULL,'REYES','9176851995','DINDOREYES95@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,66,'18.50'),(393,'WILLIAM',NULL,'SEGUN','9175507100','WILLIAM_SEGUN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,66,'10.00'),(394,'JOSEPH',NULL,'ARGUELLES','9175100967','ZANNSTEP@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,67,'7/ SEPT. UNHS'),(395,'ROEL',NULL,'RODOLFO','9170621977','ROEL952001@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,38,'18.4/SEPT. UNHS'),(399,'STEVE',NULL,'JARVIS','9178114117','SJARVIS@VISIONTV.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'15.30'),(400,'CHRISTIAN',NULL,'LOZANO','9285504070','CLOZANO@ICTSI.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,36,'8.60'),(401,'JUN',NULL,'LACSON','9178119645','JOSEJUAN.LACSON@MOL-LINER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'19.20'),(402,'EMILIANO \"EMIL\"',NULL,'JOVEN','9178161122','BONG_JOVEN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,68,'13.7/SEPT. UNHS'),(408,'DENNIS',NULL,'CHAN','9178220075','FSPMI@FAMOUSSECRET.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,69,'12.7/ SEPT. UNHS'),(409,'JESS',NULL,'CABEL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,2,'14.40'),(410,'JOHNNY',NULL,'SHEW',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(411,'MATTHEW',NULL,'BAXTER',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,19,'9.5 /SEPT. UNHS'),(412,'JOSE ROMAN',NULL,'MAGAT II','9178212624','MAGATROMAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'18.7/ SEPT. UNHS'),(413,'EL',NULL,'CARSULA','9189059737',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(414,'MICHAEL',NULL,'AQUINO','9178992693','MAQUINO@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'17.7/ AUG. UNHS'),(415,'MARIO',NULL,'PANGAN','9178931997',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,3,'23'),(416,'JOSEPH  (ROGER)',NULL,'DE GUZMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:38',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(417,'CLARO',NULL,'ARRIOLA','9228429143','CLARO-ONEPITCH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,70,'29.4/ SEPT. UNHS'),(418,'ALEX',NULL,'TY','9178339800',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'23.50'),(419,'HERBERT',NULL,'HUIT','9178468838',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,71,'MANDATORY 10'),(420,'JOCSON',NULL,'GAN','9175940551',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'10.1R'),(421,'PAUL',NULL,'GRUBA','9175249888',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'10.6R'),(422,'CHRIS',NULL,'COCHING',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(424,'FRANCIS',NULL,'GO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'24.00'),(425,'JAKE',NULL,'ONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,71,'18.00'),(426,'DANILO \"DONNIES\"',NULL,'ALAS','9175390878','DONNIESALAS@ALASOPLAS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'22.9/ SEPT UNHS'),(427,'DAVID',NULL,'LIM','9985781370','JCINTLCO@AOL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,72,'20.5/ SEPT UNHS'),(429,'RENE CHESTER',NULL,'PANGAN','9175209626','CHEK.PANGAN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(430,'MARK ANTHONY',NULL,'MEDINA','9175774340','MARKMEDINA@ICLOUD.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'17.2/ SEPT UNHS'),(431,'MARLON',NULL,'BORBON','9989708052','MARLONGBORBON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,71,'23.7/ SEPT. UNHS'),(432,'MELVIN',NULL,'CARLOS','9176521982','DCHING_03@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,73,'15.3/SEPT. UNHS'),(433,'JOHN EDRIC',NULL,'GARCIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,73,'27.10'),(434,'CHEOK PIN',NULL,'LEE','9209706357','CHEOKPIN.LEEY@YCH.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,4,'26.9/SEPT. UNHS'),(435,'ALAN',NULL,'CHNG','9174709336',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,48,'23.00'),(436,'OH LOCK',NULL,'SOON','9178706868','LOCKSOON.OH@KEPPELLAND.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,48,'MANDATORY 10'),(437,'JOAQUIN \"JOAO\"',NULL,'GANCAYCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,5,'21.50'),(438,'CRISPIN',NULL,'TORRES','9178060903','CRISPINETORRES@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(439,'ZALDY',NULL,'VILLA','9175356965','REY_ENGINEERING@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,11,'4.7/ SEPT. UNHS'),(440,'ISABELO/ REPLACED BY ALEKHINE',NULL,'AFRICA',NULL,'OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(441,'RICHIE',NULL,'HERRERA','8111788','OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(442,'DONAVAN',NULL,'YU','9175524496','DWTL30@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,19,'21.2/ SEPT. UNHS'),(443,'ROD',NULL,'PEREZ','8111788','OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'16.10'),(444,'ALLEN RAYMOND',NULL,'QUA','9175327826','ALLENFQUA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'21.8/SEPT UNHS'),(445,'ANTHONY',NULL,'ATENDIDO','9178450714','CHUBBY2001A@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,73,'22.0/SEPT. UNHS'),(448,'TIMOTHY',NULL,'GO','9178988889','TIMMYGO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,4,'10.1/SEPT. UNHS'),(449,'RAYMOND',NULL,'CO','9175960112','RAYMOND_RNC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,4,'5.2/SEPT. UNHS'),(452,'DANILO',NULL,'MONTENEJO JR.','9178670410','DGMONTENEJO@ME.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'NH/UNHS.PH'),(454,'ARNEL',NULL,'RACADIO','9175606710','ARNEL.RACADIO@ANRUNLIMITED.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,145,3,1,1,NULL,3,'17.7'),(455,'DANILO',NULL,'SEBASTIAN - REYES','9175613796','DSLREYES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'16.3/UNHS SEPT'),(456,'GERARD',NULL,'CARIASO','9175295038','GERRY_CARIASO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,36,'23.80'),(457,'JOSEPH EVEREST',NULL,'BUNGAY','9176545300','19EVERESTBUNGAY58@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'18.90'),(458,'LEONIDES',NULL,'TAGLE JR.','9175325959','LEO.TAGLE@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,74,'14.9/UNHS SEPT'),(459,'LEO',NULL,'LACBO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(461,'BENJAMIN',NULL,'BATHAN JR.','9178669227','BENJIE.BATHAN@PH.YUSEN-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,74,'22.6/UNHS SEPT'),(463,'VIC',NULL,'AGU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(464,'ALBERT',NULL,'GARCIA','9178998898','AMGGARCIA@WHEALTH.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,75,'13'),(465,'REX LUIS',NULL,'GOQUINGCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,1,'10.00'),(466,'CARL VINCENT',NULL,'ADAO','9159997487','ADAOCARL@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(467,'ENRICO RAPHAEL',NULL,'NACINO','9178721030','ROCCO.NACINO21@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,4,'20.10'),(468,'AUGUSTO',NULL,'LAGMAN','9178178477','GUSLAGMAN1@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,2,'20.40'),(469,'REX (ED)',NULL,'DRILON II','9178415570','REX@DRILON.COM','9178444091',NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,16,'13.10'),(473,'SAMUEL (MIGUEL ANGEL)',NULL,'BALTAZAR','9177930956','BASA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'19.60'),(475,'RAUL',NULL,'CORRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,3,'18.70'),(476,'DEXTER',NULL,'LIM','9175283990','DEXYULIM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,1,'15.3/ SEPT UNHS'),(477,'CHRISTOPHER',NULL,'OCAMPO','9178540800','OCAMPO.CHRISTOPHER@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,52,'20.7/ SEPT UNHS'),(478,'HUBERT',NULL,'BARLIS','9052333451','HUBERTBARLIS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,73,'15.00'),(479,'JULIUS',NULL,'TEJADA','9179016663',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,73,'27.10'),(480,'ENRICO \"ERIC\"',NULL,'TENSUAN','9173271503',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,36,'12.30'),(481,'ROBERT GERALD',NULL,'NAZAL II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,1,'14.60'),(482,'EDUARD',NULL,'JOSE','9175630392','EDJOSE@VSO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,5,'24.30'),(483,'TONYO',NULL,'CALADO','9088189963','TONYOCALADO@VSO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(484,'JONG',NULL,'ARCANO','9989685101',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'15.30'),(485,'DOROTEO  \"TEY\"',NULL,'SORNET','9175332859',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,47,'16.20'),(486,'STANLEY',NULL,'CHUA','9260685927','STAN_LEY_CHUA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,1,'22.30'),(488,'CESAR',NULL,'MONTANO','9178880009','CESAR77MONTANO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,16,'MANDATORY 10'),(490,'ROSETEN',NULL,'TUGAFF','9951500536',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,78,'7.10'),(491,'ALEJANDRO',NULL,'DANGANAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,78,'22.00'),(492,'GABRIEL',NULL,'NOCUM JR.','9189082900',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,78,'13.40'),(493,'EFREN',NULL,'DE LEON','9175668487',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,78,'10.20'),(494,'CLEMENT',NULL,'CHAN','9175217171','RITE_TECHMKTG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,79,'19.90'),(495,'EUGENIO',NULL,'CHEUNG','9952775754',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,76,'17.20'),(496,'SAMUEL',NULL,'GAN NASIS','9178906698','SGANNASIS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,16,'14.60'),(497,'RAOUL MICHAEL',NULL,'VIRAY JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,5,'15.70'),(498,'RICHARD JAY',NULL,'LISTA','9175366947','RJLISTA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,80,'17.40'),(499,'ROBBIE',NULL,'DINGLASAN III','9175285087','ROBBIEDING@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,19,'18.90'),(500,'ROLANDO',NULL,'BOOL','9209107214','RCBOOL@OSAPHILS.COM',NULL,'OLANBOOL@GMAIL.COM',NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,15,'12.10'),(502,'GENE',NULL,'CASTRO','9175119995',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,64,'NH/UNHS.PH'),(503,'PULO',NULL,'EUSEBIO','9177732779',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,2,NULL),(504,'FERNANDO',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(505,'ALBERT',NULL,'CHONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(506,'MICHAEL',NULL,'TAN TO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(507,'ALEX',NULL,'YU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(508,'VICTOR STUART',NULL,'FERNANDEZ','9158888769',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(509,'COL. NEO',NULL,'ENDOZO','9267530299',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(510,'RENE',NULL,'ARGANDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(512,'ERNEL',NULL,'ESPELETA','9209031857','ERNELESPELETA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(513,'EDMUNDO',NULL,'NAVARRO JR.','9228466751',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(514,'JUDE',NULL,'RACADIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(515,'FERNANDO',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(516,'ALBERT',NULL,'CHONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(517,'MICHAEL',NULL,'TAN TO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(518,'ALEX',NULL,'YU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(519,'GENE',NULL,'CASTRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(520,'PULO',NULL,'EUSEBIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(521,'SAMUEL',NULL,'GAN NASIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(522,'RAOUL MICHAEL',NULL,'VIRAY JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(523,'ABRAHAM \"DODIE\"',NULL,'CABASAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(524,'JEFFREY',NULL,'DY TAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(525,'DON DON',NULL,'DE GUZMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(526,'JERRY',NULL,'YBANEZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(527,'DENNIS',NULL,'CHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(528,'JESS',NULL,'CABEL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(529,'DANILO',NULL,'ROLEDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(530,'RAUL',NULL,'CORRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(531,'CARL VINCENT',NULL,'ADAO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(532,'ENRICO RAPHAEL',NULL,'NACINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(533,'JOSE ROMAN',NULL,'MAGAT II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(534,'MICHAEL',NULL,'AQUINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(535,'EL',NULL,'CARSULA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(536,'MARIO',NULL,'PANGAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(537,'EDUARD',NULL,'JOSE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(538,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(539,'JONG  (FREE)',NULL,'ARCANO  (FREE)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(540,'DOROTEO  \"TEY\"',NULL,'SORNET',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:39',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(541,'DENNIS',NULL,'ABCEDE','9178102932','JUNJUNABCEDE@DAABCEDE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,40,NULL,1,1,NULL,NULL,NULL),(542,'RICKY',NULL,'ALEGRE','9178910800','RICKYALEGRE.BM@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,4,'14'),(543,'TED',NULL,'ALMEDA','9178384647','TED_ALMEDA2000@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(544,'RENE',NULL,'ALMEIDA','9175284017','RENE_ALMEDA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(545,'JERIC',NULL,'ANG','9209264775',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,42,NULL,1,1,NULL,NULL,NULL),(546,'ERIC',NULL,'ANGELES','9175342981','ERICVANGELES@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(547,'GERRY',NULL,'AQUINO','9209253652','GERRYCAQUINO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(548,'MIKE',NULL,'AQUINO','9178992693','MAQUINO@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,3,'17'),(549,'RAYMOND',NULL,'ARANDA','9178400077','MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,44,NULL,1,1,NULL,NULL,NULL),(550,'JONG',NULL,'ARCANO','9178435906','JARCANO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,51,1,1,NULL,2,'13'),(551,'EMY',NULL,'ARCILLA','9178002881','EMYARCILLA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,36,'24'),(552,'GABRIEL',NULL,'ARTAJO',NULL,'BRIX817@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,47,NULL,1,1,NULL,NULL,NULL),(553,'TONY',NULL,'AVILA','9164937393','TONYAVILAII@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,48,NULL,1,1,NULL,NULL,NULL),(554,'JOEY',NULL,'BAINGAN','9188038693','JCBAINGAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,49,NULL,1,1,NULL,NULL,NULL),(555,'FEDERICO',NULL,'BALDOVINO','9178606214','ARDCORP@INFO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,50,NULL,1,1,NULL,NULL,NULL),(556,'EUSEBIO',NULL,'BANATIN','9266363410','LAWIN_EFBANATIN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(557,'GEORGE',NULL,'BARCELON',NULL,'BERNARDCGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,51,NULL,1,1,NULL,NULL,NULL),(558,'ROLANDO',NULL,'BASCO','9188228101','RABASCOJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(559,'JERRY',NULL,'BAUTISTA','9162267823','JRRY_BTST@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(560,'JOJO',NULL,'BAUTISTA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(561,'FRANCISCO',NULL,'BAYOT',NULL,'ABETLTAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,52,NULL,1,1,NULL,NULL,NULL),(562,'RICARDO JR.',NULL,'BERNABE','9178936363','RCBERNABEJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(563,'RAUL',NULL,'BLAY','9178578033','BLAYHAUS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(564,'DR. ED',NULL,'BOLAOS','9233553636','3636GOLF@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,53,NULL,1,1,NULL,NULL,NULL),(565,'PERRY',NULL,'BUCAY','9209625555','GOLDPLAN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,11,'27'),(566,'MIKE',NULL,'BUENDIA','9228066453','MYKBOO.TOURMASTER@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,55,NULL,1,1,NULL,NULL,NULL),(567,'WILLY',NULL,'CABALCE','9228574499','WILLY_CABALCE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,56,NULL,1,1,NULL,NULL,NULL),(568,'ANTHONY',NULL,'CABANGON','9189912510','BMPITAC@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,41,NULL,1,1,NULL,NULL,NULL),(569,'RESTY',NULL,'CABRERA','9178571491','RESTY0527@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(570,'PAOLO',NULL,'CAGALINGAN','9209285759','PCAGALINGAN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,57,NULL,1,1,NULL,NULL,NULL),(571,'MARVIN',NULL,'CAPARROS','7233720','RSCAPARROS@PLDTDSL.COM','7233753',NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,58,NULL,1,1,NULL,NULL,NULL),(572,'RODERIC',NULL,'CASQUEJO','9172479325','RKCASQUEJO@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,3,'10.8'),(573,'MUSONG',NULL,'CASTILLO','9178870625',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,45,NULL,1,1,NULL,NULL,NULL),(574,'ANTONIO',NULL,'CEMBRANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,60,NULL,NULL,NULL,NULL,NULL,NULL),(575,'ARTURO',NULL,'CEMBRANO','9175300130',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,61,NULL,1,1,NULL,NULL,NULL),(576,'MIKE',NULL,'CEMBRANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(578,'TONY',NULL,'CHIEN','9189633586','CHIEN@NISSAN.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,63,NULL,1,1,NULL,NULL,NULL),(579,'JOHNNY',NULL,'CHU','9178283818',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(581,'MARIANO',NULL,'CHUA',NULL,'BERNARDCGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(582,'FELIX',NULL,'CHUNG','9178389595','FELIXGC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,64,NULL,1,1,NULL,NULL,NULL),(584,'KOCHET CHUA',NULL,'CONSTANTINE','9178191966','CONSKC@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(585,'GABBY',NULL,'CUI','9209079309','GRCUI@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(586,'ARJAY',NULL,'DATOC','9209075801',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,65,NULL,1,1,NULL,NULL,NULL),(587,'DANTE',NULL,'DATOR','9175258157','DRDICK.URO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,66,NULL,1,1,NULL,NULL,NULL),(588,'DINO',NULL,'DATU','9228186402',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(589,'EDWARD',NULL,'DAVID','9175905399','EDAVID@LIQUIGAZ.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:52',NULL,NULL,67,NULL,1,1,NULL,NULL,NULL),(590,'FRED',NULL,'DAVID','9178734604','ALDAVID@LINAHEIM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,68,NULL,1,1,NULL,NULL,NULL),(591,'JUN',NULL,'DAVID','9175825756','JBD_DTRUCKING@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,26,'21'),(592,'VAL',NULL,'DE LEON','9285500172','VMDELEON@NISSAN.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,63,NULL,1,1,NULL,NULL,NULL),(593,'EDGAR',NULL,'DE SOTO','9228465829','EDGARDESOTO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,69,NULL,1,1,NULL,NULL,NULL),(594,'BRIX',NULL,'DEL ROSARIO','9178118454','BRIX817@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,47,NULL,1,1,NULL,NULL,NULL),(595,'HENRY',NULL,'DIAZ','9178118454',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(596,'RAFFY',NULL,'DIMALANTA','9189247997','RRDIMALANTA@MAYBANK.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,70,NULL,1,1,NULL,NULL,NULL),(597,'LEO',NULL,'DOMINGUEZ','9178191040','DOMINGUEZ.LEOG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,71,NULL,1,1,NULL,NULL,NULL),(598,'RITCHIE',NULL,'DONES','9209126803','RLDONES@FORTUNEGENERAL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,72,NULL,1,1,NULL,NULL,NULL),(599,'EROL',NULL,'DY','9189425105','EROL_DY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,73,NULL,1,1,NULL,NULL,NULL),(600,'ROBERT',NULL,'DY','9178234811','ROBDY88@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,74,NULL,1,1,NULL,NULL,NULL),(601,'HERNANDEZ',NULL,'EDWIN','9178106958',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,75,NULL,1,1,NULL,NULL,NULL),(602,'JOHN',NULL,'ELEPANO','9176072403','ASIDILYO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,76,NULL,1,1,NULL,NULL,NULL),(603,'JERRY',NULL,'FLORENDO','9175447678','GERRYFLORENDO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(604,'DEXTER',NULL,'FLORES','9175917515','DEXTER.FLORES@TOTAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,77,NULL,1,1,NULL,NULL,NULL),(605,'CIELO',NULL,'FREGIL','9189431416','CIELO.FREGIL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(606,'JERE',NULL,'FREGIL','9178985373',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(607,'REY',NULL,'FUENTEZ','9178115218',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,78,NULL,1,1,NULL,NULL,NULL),(608,'RODERICK',NULL,'FUGOSO','9088623206','BAP@TOURMASTER.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,55,NULL,1,1,NULL,NULL,NULL),(609,'RUDY',NULL,'FULO','9175300933','CFULO@CARGOHAUS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(610,'RAYMUNDO',NULL,'GABRIEL','9209828386','RAYGABS302@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,79,NULL,1,1,NULL,NULL,NULL),(611,'DAX',NULL,'GARCIA',NULL,'ABETLTAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(612,'EDWIN',NULL,'GARCIA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(614,'JB',NULL,'GARCIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(615,'BERNARD',NULL,'GO','9178387858','BERNARDCGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,51,NULL,1,1,NULL,NULL,NULL),(616,'MICHAEL',NULL,'GO','9228200300',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(617,'LOVELL',NULL,'GOPEZ','9189649866',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,81,NULL,1,1,NULL,NULL,NULL),(618,'DANIEL JR.',NULL,'GREGORIO','9178673639','DANNY.GREGORIO@PCPPI.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,82,NULL,1,1,NULL,NULL,NULL),(619,'RENE',NULL,'GUEVARRA','9228330088','NEYNEYGUEVARA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(620,'NIC',NULL,'GUZMAN','9178216425','NIC@GARJUZ.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(621,'JIM',NULL,'HATAMAN','9175281962','ARMELPAULBABAH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(622,'TONY DR.',NULL,'HERRERA','9285591058','RAPHAPH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(623,'VINCE',NULL,'HIZON','9178931170','VINCEHIZON@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,99,'14'),(624,'DENNIS',NULL,'HUANG','9175296005','DBHUANG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(625,'JEFFERSON',NULL,'JUAN',NULL,'SSALDAVIA@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,84,NULL,1,1,NULL,NULL,NULL),(626,'DINDO',NULL,'KATIGBAK','9175349322','DINDOKATIGBAK@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,1,'20.1'),(627,'ANTHONY',NULL,'LAO','9178507194','ANTHONY.LAO@CATS.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,99,'31'),(628,'MAURICE',NULL,'LAUDE','9175222233','CANDYMAN168@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(629,'JB',NULL,'LAUREL','9175215900','JB_LAUREL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,86,NULL,1,1,NULL,NULL,NULL),(630,'ALVIN',NULL,'LEE','9175761286','PHOTOBIKER9@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,87,NULL,1,1,NULL,NULL,NULL),(631,'GILBERT',NULL,'LEE','9175260123','GILBERT.LEE@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(632,'REDMON',NULL,'LEE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(633,'RINGO( COL)',NULL,'LICUP','9178520585','DORING87@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(634,'FRANCIS',NULL,'LIM','9178325302','EVANGELINECHARMAINELIM@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(636,'KG',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(637,'DONATO',NULL,'LISING',NULL,'HPBUILDERSINC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,89,NULL,1,1,NULL,NULL,NULL),(638,'REUJENSON',NULL,'LISTA','9228817105','RJLISTA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,90,NULL,1,1,NULL,NULL,NULL),(639,'RICHARD JAY',NULL,'LISTA','9228754782',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,90,NULL,1,1,NULL,NULL,NULL),(640,'PETER',NULL,'LOH','9398872222','ICARE246@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(641,'HENRISON',NULL,'LU','9179162281','HENRISONLU@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(643,'JOHNNY',NULL,'LU','9175000888','JDLU888@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,185,20,1,1,NULL,76,'20.0'),(644,'REDENTOR',NULL,'MAGAT','9178180804','RDMAGAT@FORTUNEGENERAL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,72,NULL,1,1,NULL,NULL,NULL),(645,'GERARDO',NULL,'MAGDALES','9209814561','GCMAGDALES@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,93,NULL,1,1,NULL,NULL,NULL),(646,'BENJIE',NULL,'MAGSINO','9088850830','BMAGSINO@CLUBCARPHILS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,83,NULL,1,1,NULL,NULL,NULL),(647,'SONNY',NULL,'MANGUNDAYAO','9178987669','SONNY@SALONDEMANILA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,94,NULL,1,1,NULL,NULL,NULL),(648,'ATTY.BEN',NULL,'MALCONTENTO','9178921210','BENEAM@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,95,NULL,1,1,NULL,NULL,NULL),(649,'ART JR.',NULL,'MANUEL','9189065259','AEMANUEL@BANKCOM.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,96,NULL,1,1,NULL,NULL,NULL),(650,'PAUL',NULL,'MARIGOMEN','9178944732','EADELROSARIO@MIGHTYCORP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,97,NULL,1,1,NULL,NULL,NULL),(651,'NAPOLEON',NULL,'MARIGOMEN',NULL,'NAPMARIGOMEN@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(652,'FEDERICO',NULL,'MARQUEZ','9189275130',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(653,'SONNY',NULL,'MAULA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,44,NULL,1,1,NULL,NULL,NULL),(654,'MIGUEL',NULL,'MENDOZA',NULL,'MIKEYJ.MENDOZA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(655,'MIKE',NULL,'MENDOZA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(656,'WILLY',NULL,'MONILLAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(657,'MARIO',NULL,'MONSALVE','9178603184','MONSALVE.MARIO@AYALALAND.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,98,NULL,1,1,NULL,NULL,NULL),(658,'ZAKARIA',NULL,'NASIR','9178376156','ZAKARIANASIR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,99,NULL,1,1,NULL,NULL,NULL),(659,'JEROME',NULL,'NGO','9228898887','JEROME@GERRYSGRILL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,100,NULL,1,1,NULL,NULL,NULL),(660,'JUN',NULL,'NOBLE','9088957786','PCNOBLE@BANKCOM.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,96,NULL,1,1,NULL,NULL,NULL),(661,'HEIKKI',NULL,'NORRO','026362456',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(662,'MIKE',NULL,'ONG','9176205093','MICONG181@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(663,'RONALD',NULL,'ONG','9178561287','TOLNKEL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(664,'SONNY',NULL,'ONGTAO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(665,'JOJO',NULL,'PAZ','9209114820','JZP@2100CBI.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,101,NULL,1,1,NULL,NULL,NULL),(666,'WILFREDO JR.',NULL,'PE','9209129900','JUN.PE@CATS.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,46,NULL,1,1,NULL,NULL,NULL),(667,'EDGAR',NULL,'QUIAO','9202319508','EUROCARPETS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,102,NULL,1,1,NULL,NULL,NULL),(668,'DONNIE',NULL,'RAIES','9167404228','DONNIE8UK@YAHOO.CO.UK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(669,'ROLLY',NULL,'RAMIREZ','7500378','MRS@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,84,NULL,1,1,NULL,NULL,NULL),(670,'JOHANN',NULL,'RAMOS','9175558910','JGRAMOS@LINAHEIM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,68,NULL,1,1,NULL,NULL,NULL),(671,'ROGEL',NULL,'RAYA','9175526158','RAYA.ROGEL@BDO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,103,NULL,1,1,NULL,NULL,NULL),(672,'LES',NULL,'REYES','9088601983','WHENLESISMORE113@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,104,NULL,1,1,NULL,NULL,NULL),(673,'DAVE JR.',NULL,'REYNALDO','9092419157','DOCREY.DAVE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,105,NULL,1,1,NULL,NULL,NULL),(674,'RONALDO',NULL,'RODIL','9217136020','RONNIE_RODIL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(675,'JOSELITO',NULL,'RODRIGO','9193005365','JOSELITORODRIGO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,105,NULL,1,1,NULL,NULL,NULL),(676,'EDWIN',NULL,'RODRIGUEZ','9178307896','EDWINDAYRITRODRIQUEZ@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,106,NULL,1,1,NULL,NULL,NULL),(677,'HONESTO',NULL,'ROQUE','9189244302','HMROQUE@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,93,NULL,1,1,NULL,NULL,NULL),(678,'ALBERTO',NULL,'ROSAL','9178175357','MIKKIBOO@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,107,NULL,1,1,NULL,NULL,NULL),(679,'SEYMOUR',NULL,'SALDAVIA','9188887427','SSALDAVIA@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,84,NULL,1,1,NULL,NULL,NULL),(680,'POL',NULL,'SANCHEZ','9253301','POL.SANCHEZ@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,108,NULL,1,1,NULL,NULL,NULL),(681,'RICKY',NULL,'SANDOVAL','9178193206','RICSANDOVAL@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(682,'PHILIP',NULL,'SANTOS','9228881200',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(683,'JOEL',NULL,'SARMIENTO','9178119691','JOELCHRISTESARMIENTO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,140,3,1,1,NULL,21,'15.8'),(684,'GENE',NULL,'SEBASTIAN','9228408141','GENETRONSC@SKYINET.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(685,'MARK',NULL,'SULTAN','9175286684','MARK@SAMGLO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,16,7,1,1,NULL,3,'23.9'),(686,'BONG',NULL,'TAMONTE','9178596993','ETAMONTE@LINAHEIM.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,99,'31'),(687,'ANDREW',NULL,'TAN','9175268846','ANDREWTAN2562@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(688,'WILBERT',NULL,'TAN','9175928899','ABETLTAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,111,NULL,1,1,NULL,NULL,NULL),(689,'RENAULE',NULL,'TAN',NULL,'CANDYMAN168@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(690,'ROLANDO',NULL,'TANCHANCO','9178242828','ROLLYTANCHANCO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(691,'GERRY',NULL,'TEE','9189999333','GERRYTEE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,117,'33'),(693,'PAUL',NULL,'UY','9178561287','POLNKEL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(694,'RIZA',NULL,'UY','9209835521','RIZGOLF_SPORTSMKTG@YAHOO.CO.UK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,114,NULL,1,1,NULL,NULL,NULL),(695,'WILBERT',NULL,'UY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,114,NULL,1,1,NULL,NULL,NULL),(696,'YANCY',NULL,'UY','9178911314','RIZGOLF_SPORTSMKTG@YAHOO.CO.UK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,53,1,1,NULL,2,'27'),(697,'ARSENIC',NULL,'VILLANUEVA','9175901919','ARSENICV1159@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(698,'ARISTOTLE',NULL,'VIRAY','9188356853','JOTLEVIRAY@MSN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(699,'CHRIS',NULL,'WEBB','9158718032','CJWEBB@ATTGLOBAL.NRT',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,116,NULL,1,1,NULL,NULL,NULL),(700,'ALLAN',NULL,'YAP','9188515555','ALLANYAP29@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,NULL,NULL,1,1,NULL,1,'13'),(702,'RUDY',NULL,'YU','9175358918','RUDYYU@BOACMKTG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,119,NULL,1,1,NULL,NULL,NULL),(703,'ERIC',NULL,'YU','9175303829','ERIC@CELLPRIME.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,120,NULL,1,1,NULL,NULL,NULL),(704,'STEPHEN',NULL,'YU','9178732645',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,121,NULL,1,1,NULL,NULL,NULL),(705,'JUN',NULL,'YUPITUN','9178192037','JUNY@TELESERV.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,122,NULL,1,1,NULL,NULL,NULL),(706,'EDA',NULL,'YUPITUN','9175390874','EDAY@TELESERVE.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:51:53',NULL,NULL,122,NULL,1,1,NULL,NULL,NULL),(712,'NORMAN',NULL,'SANTIAGO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(719,'ALLAN',NULL,'CARANDANG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(720,'RAMIL',NULL,'BERNARDO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(734,'GRAHAM',NULL,'HARRIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,3,'21.6/SEPT.UNHS'),(752,'JESS',NULL,'CABEL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,2,'14.40'),(753,'JOHNNY',NULL,'SHEW',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(754,'MATTHEW',NULL,'BAXTER',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,19,'9.5 /SEPT. UNHS'),(759,'JOSEPH  (ROGER)',NULL,'DE GUZMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(765,'CHRIS',NULL,'COCHING',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(767,'FRANCIS',NULL,'GO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,64,'24.00'),(768,'JAKE',NULL,'ONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,71,'18.00'),(776,'JOHN EDRIC',NULL,'GARCIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,73,'27.10'),(780,'JOAQUIN \"JOAO\"',NULL,'GANCAYCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,5,'21.50'),(783,'ISABELO/ REPLACED BY ALEKHINE',NULL,'AFRICA',NULL,'OP@UCPBGEN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:00',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(802,'LEO',NULL,'LACBO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(806,'VIC',NULL,'AGU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,64,'MANDATORY 10'),(808,'REX LUIS',NULL,'GOQUINGCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,1,'10.00'),(818,'RAUL',NULL,'CORRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,3,'18.70'),(824,'ROBERT GERALD',NULL,'NAZAL II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,1,'14.60'),(834,'ALEJANDRO',NULL,'DANGANAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,78,'22.00'),(840,'RAOUL MICHAEL',NULL,'VIRAY JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,5,'15.70'),(847,'FERNANDO',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(848,'ALBERT',NULL,'CHONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(849,'MICHAEL',NULL,'TAN TO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(850,'ALEX',NULL,'YU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(853,'RENE',NULL,'ARGANDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(857,'JUDE',NULL,'RACADIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(858,'FERNANDO',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(859,'ALBERT',NULL,'CHONG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(860,'MICHAEL',NULL,'TAN TO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(861,'ALEX',NULL,'YU',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(862,'GENE',NULL,'CASTRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(863,'PULO',NULL,'EUSEBIO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(864,'SAMUEL',NULL,'GAN NASIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(865,'RAOUL MICHAEL',NULL,'VIRAY JR.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(866,'ABRAHAM \"DODIE\"',NULL,'CABASAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(867,'JEFFREY',NULL,'DY TAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(868,'DON DON',NULL,'DE GUZMAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(869,'JERRY',NULL,'YBANEZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(870,'DENNIS',NULL,'CHAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(871,'JESS',NULL,'CABEL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(872,'DANILO',NULL,'ROLEDA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(873,'RAUL',NULL,'CORRO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(874,'CARL VINCENT',NULL,'ADAO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(875,'ENRICO RAPHAEL',NULL,'NACINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(876,'JOSE ROMAN',NULL,'MAGAT II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(877,'MICHAEL',NULL,'AQUINO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(878,'EL',NULL,'CARSULA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(879,'MARIO',NULL,'PANGAN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(880,'EDUARD',NULL,'JOSE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(881,'TONYO',NULL,'CALADO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(882,'JONG  (FREE)',NULL,'ARCANO  (FREE)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(883,'DOROTEO  \"TEY\"',NULL,'SORNET',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:01',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(895,'GABRIEL',NULL,'ARTAJO',NULL,'BRIX817@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,47,NULL,1,1,NULL,NULL,NULL),(900,'GEORGE',NULL,'BARCELON',NULL,'BERNARDCGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,51,NULL,1,1,NULL,NULL,NULL),(903,'JOJO',NULL,'BAUTISTA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(904,'FRANCISCO',NULL,'BAYOT',NULL,'ABETLTAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,52,NULL,1,1,NULL,NULL,NULL),(917,'ANTONIO',NULL,'CEMBRANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,60,NULL,1,1,NULL,NULL,NULL),(919,'MIKE',NULL,'CEMBRANO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(924,'MARIANO',NULL,'CHUA',NULL,'BERNARDCGO@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(954,'DAX',NULL,'GARCIA',NULL,'ABETLTAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(955,'EDWIN',NULL,'GARCIA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(957,'JB',NULL,'GARCIA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(968,'JEFFERSON',NULL,'JUAN',NULL,'SSALDAVIA@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,84,NULL,1,1,NULL,NULL,NULL),(975,'REDMON',NULL,'LEE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(979,'KG',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(980,'DONATO',NULL,'LISING',NULL,'HPBUILDERSINC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:11',NULL,NULL,89,NULL,1,1,NULL,NULL,NULL),(994,'NAPOLEON',NULL,'MARIGOMEN',NULL,'NAPMARIGOMEN@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(996,'SONNY',NULL,'MAULA',NULL,'MELVYNALFRED.TABLANG@PAGCOR.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,44,NULL,1,1,NULL,NULL,NULL),(997,'MIGUEL',NULL,'MENDOZA',NULL,'MIKEYJ.MENDOZA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(998,'MIKE',NULL,'MENDOZA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(999,'WILLY',NULL,'MONILLAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(1007,'SONNY',NULL,'ONGTAO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(1032,'RENAULE',NULL,'TAN',NULL,'CANDYMAN168@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(1038,'WILBERT',NULL,'UY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:12',NULL,NULL,114,NULL,1,1,NULL,NULL,NULL),(1050,'RICK',NULL,'ALCASID','9209253329','RIC_ALCASID@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,124,6,1,1,NULL,56,'21.0'),(1051,'THOMAS',NULL,'TRINIDAD','9209700032','TCTPHILS@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,125,6,1,1,NULL,56,'16.0'),(1052,'JIMMY',NULL,'CO','9175466926','JIMMYCO33@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,126,21,1,1,NULL,81,'20.9'),(1053,'EMMANUEL',NULL,'YU','9178116511','BRILLSPH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,126,3,1,1,NULL,52,'17.9'),(1054,'CHRIS',NULL,'CHUA','9178947777','CHRIS_CHUA888@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,127,NULL,1,1,NULL,10,'11.8'),(1055,'TOMAS ADRIAN',NULL,'TAN','9178491683','ADRIAN@DDM.EU',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,128,20,1,1,NULL,10,'23.0'),(1056,'NOEL',NULL,'BONGAT','9189035918','NEBONGAT_CORINTHIANS@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,129,3,1,1,NULL,1,'13.9'),(1057,'MIKE',NULL,'MAGPAYO','9175250387','MIGUELMAGPAYO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,NULL,NULL,1,1,NULL,47,'13.9'),(1058,'TONY',NULL,'SALVADOR','9178842567','TONY_ASAPINDL@PLDTDSL.NET','9209099452',NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,NULL,NULL,1,1,NULL,5,'11.5'),(1059,'JAY',NULL,'SONZA','9198199031','JAY_SONZA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,130,22,1,1,NULL,82,'21.0'),(1060,'CRIS',NULL,'CARREON','9178870467',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,NULL,NULL,1,1,NULL,83,'9.0'),(1061,'DEO',NULL,'MACALMA','9177962658',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:18',NULL,NULL,NULL,22,1,1,NULL,6,NULL),(1064,'GEORGE',NULL,'CABIGON','9173213155','REALWILSON_UY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,131,6,1,1,NULL,7,NULL),(1066,'PETER',NULL,'TAY','9178191372','PETERTAY29@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,132,NULL,1,1,NULL,16,'21.9'),(1067,'LEWIS',NULL,'WONG','9178585568','SING_PHIL_ASSN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,132,NULL,1,1,NULL,21,'9.3'),(1068,'BABES',NULL,'FRANCISCO','0285056830','BABES-F68@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,133,NULL,1,1,NULL,76,'28.0'),(1069,'RAUL',NULL,'OLEA','9175511397','ARAN_RAY11@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,85,'9.0'),(1070,'EDGARDO',NULL,'CAYTON','9178267261','EHCWARM@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,134,NULL,1,1,NULL,86,NULL),(1071,'JUSTIN',NULL,'LIMJAP','9173000960','JJLIMJAP@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,135,23,1,1,NULL,87,'3.0'),(1072,'RODEL',NULL,'MANGULABNAN','9178133264','CEO@SILICON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,54,'3.4'),(1073,'ROBERTO',NULL,'AQUINO','9178613798','RMAQUINO@MAGSAYSAY-LOGISTICS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,136,24,1,1,NULL,88,NULL),(1075,'ROD',NULL,'PEREZ','9175028433','ROD13151@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,25,1,1,NULL,3,'13.2'),(1076,'TONY',NULL,'GATBONTON','9285051865','TONYGATBONTON@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'20.3'),(1078,'BENNY',NULL,'AW','9189297538',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,137,26,1,1,NULL,89,'15.3'),(1080,'JOSEPH',NULL,'HORDEAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,138,NULL,1,1,NULL,NULL,NULL),(1081,'PAULO',NULL,'LEGASPI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,139,NULL,1,1,NULL,NULL,NULL),(1082,'ALBERT',NULL,'NOCOM','9175342268','ALBERT_NOCOM@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,21,'17.2'),(1084,'RANDY',NULL,'CINCO','9175255712','RANDYFCINCO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,21,'11.9'),(1085,'JEFFREY',NULL,'COOJACINTO','9175392693','JCOOJACINTO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,21,'11.4'),(1086,'JOEL',NULL,'DIMAS','9178810317',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,141,1,1,1,NULL,56,'28.0'),(1087,'FREDERICK VINCENT',NULL,'TAGLE','9178582195','VINCETAGLE@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,142,3,1,1,NULL,2,'27.9'),(1088,'RAUL',NULL,'POSADAS','9178941777','RAULRP2@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,27,1,1,NULL,2,'19.9'),(1089,'RIZALDO',NULL,'ROXAS','9178005662','BIGAPPLE.PLASTIC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,27,1,1,NULL,2,'22.9'),(1090,'EAREL',NULL,'GARDIOLA','9209029010','EAREL_LG@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'8.4'),(1092,'SONNY',NULL,'CATACUTAN','9175408060','SONNY_CATACUTAN@CARGILL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,90,'19.4'),(1093,'POLY',NULL,'MACATANGAY','9209895530','NINJ_MAC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'13.1'),(1094,'TATO',NULL,'DIMAYUGA','9189025030','FMD115@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'23.7'),(1095,'TOTIE',NULL,'LEUS','9178984858','TOTIECLEUS@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'15.4'),(1096,'BOY',NULL,'MERCADO','9166829061','THUNDERMERCADO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'19.7'),(1097,'MENG',NULL,'TAN','9177919671','MENGTAN.STEEL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,76,'27.2'),(1098,'RYAN',NULL,'ESTRELLA','9178424653','D_BUILDER77@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,143,28,1,1,NULL,11,'17.8'),(1099,'JB',NULL,'GARCIA','9178496364','JBGARCIA@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'5.2'),(1100,'ERIC',NULL,'BORROMEO','9189105689','EBORROMEO_75@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'9.0'),(1101,'LEONARDO \"DING \"',NULL,'TEE','9488219446','DINGTEE123@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,3,'10.1'),(1104,'JON',NULL,'AEGISSON','9178964455',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,144,29,1,1,NULL,3,'25.1'),(1105,'BARING',NULL,'OLAFSSON','9178045511','BO@HBINTERNATIONAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,144,29,1,1,NULL,3,'11.5'),(1107,'DANILO',NULL,'REYES','9189011615','DSLREYES68@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,146,NULL,1,1,NULL,5,'14.8'),(1108,'NOEL',NULL,'DE LEON','9177777557','NOEL.DELEON@ANRUNLIMITED.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,145,NULL,1,1,NULL,88,NULL),(1109,'ROLAND',NULL,'DELA CRUZ','9178926036','ROLAND.DELACRUZ@ANRUNLIMITED.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,145,NULL,1,1,NULL,5,'22.0'),(1111,'NILO',NULL,'MANGLO','9282387566','MANGLONILO@YAHOO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,86,NULL),(1112,'LOPE',NULL,'DIAMANTE JR.','9209098238','BOY_2456@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,147,3,1,1,NULL,19,'24.7'),(1113,'LINO',NULL,'JARILLA','9175292356','JARILLALINO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,148,30,1,1,NULL,86,NULL),(1114,'DARRYL',NULL,'MODELO','9209549524','DARRYL.MODELO@GSAAERO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,149,3,1,1,NULL,88,NULL),(1115,'GREGG',NULL,'SEBASTIAN','9178118846',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,150,20,1,1,NULL,3,'12.8'),(1116,'ROMY',NULL,'CHONG','9178160561','G2CITC@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,151,3,1,1,NULL,47,'10.2'),(1118,'PAOLO ANTONIO',NULL,'LUNA','9178551030','P_LUNA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,153,NULL,1,1,NULL,88,NULL),(1119,'MARTIN',NULL,'LUNA','9177928792','MARTINLUNAMD@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,154,NULL,1,1,NULL,88,NULL),(1120,'CIG',NULL,'SANTIAGO','9178982113',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,39,NULL,1,1,NULL,56,NULL),(1121,'TIMOTHY JAYSON',NULL,'TAN','9178265468','TIMOTHYJASON@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,155,NULL,1,1,NULL,88,NULL),(1122,'BOYET',NULL,'DEL ROSARIO','9175833381','EDELROSARIO0604@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,156,3,1,1,NULL,88,NULL),(1123,'QUIEL',NULL,'DELGADO','9175298799','QUIEL.DELGADO@HK.VERIZONBUSINESS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,157,32,1,1,NULL,88,NULL),(1124,'ALBERTO \"BRIX\"',NULL,'DEL ROSARIO II','9178118454','BRIX817@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,158,3,1,1,NULL,91,NULL),(1125,'DAVE',NULL,'ONG','9189511225','DAVEONG70@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,158,20,1,1,NULL,59,NULL),(1126,'JIMMY',NULL,'CHAM','9178903328','JIM@MCJIMLEATHER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,10,'19.9'),(1127,'JIMMY',NULL,'DY','9178688229','KTCFANG@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,92,'9.5'),(1129,'ANGEL',NULL,'SERRA','9189157179','SERRA@AFC.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,160,33,1,1,NULL,56,'13.5'),(1130,'LUIS',NULL,'PANER','9172001711','TURNIPS676@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,161,17,1,1,NULL,86,'17.1'),(1131,'RAMON',NULL,'TRINOS','9185918879','RRT_1966@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,162,34,1,1,NULL,86,'8.8'),(1132,'TONY',NULL,'DELA CRUZ','9175002642','ERMA_DLC@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,35,1,1,NULL,76,'25.9'),(1133,'JOSEPH \" BING \"',NULL,'TOLENTINO','9183814296','NDL_KIMKAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,35,1,1,NULL,76,'13.0'),(1134,'TONY',NULL,'CEMBRANO','9175374867','TONY_CEMBRANO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,163,NULL,1,1,NULL,16,'21.3'),(1135,'DICK',NULL,'MARQUEZ','9189275130','DONGMARQUEZ@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,93,'17.6'),(1136,'REY',NULL,'FADULLON','9175087630','RENATO.FADULLON@TOTAL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,164,1,1,1,NULL,94,NULL),(1137,'TITO',NULL,'VELASQUEZ','9175949514','TRVELASQUEZ@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,165,3,1,1,NULL,16,NULL),(1138,'EDWIN',NULL,'CUA','9175763970','EYC128@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,166,3,1,1,NULL,6,'16.2'),(1139,'BENNIE',NULL,'DE LEON','9178400644','BNL@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,7,3,1,1,NULL,1,'17.5'),(1140,'ED',NULL,'MABUTI','9178831301','EBMABUTI@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,167,3,1,1,NULL,52,'13.1'),(1141,'JUN',NULL,'PAGADOR','9178005598','CIMTRONIX@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,168,7,1,1,NULL,4,'14.3'),(1144,'ARMANDO',NULL,'NG','9175300000','ARMANDNG@ASIACARGO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,169,20,1,1,NULL,10,'15.7'),(1145,'RICH',NULL,'QUIN','9175794687','RQUIN@CLOUDWARE.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,170,36,1,1,NULL,88,NULL),(1146,'MARVIN',NULL,'GELISAN','9196691684','NDL_KIMKAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,171,NULL,1,1,NULL,86,NULL),(1147,'MAX',NULL,'OREA','9478262887','NDL_KIMKAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,172,NULL,1,1,NULL,86,NULL),(1148,'JOVEN',NULL,'GUEVARRA','9228568364','ARCH.JOVENGUEVARRA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,173,17,1,1,NULL,86,NULL),(1149,'DENNIS',NULL,'LANZANAS','9284665261',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,173,37,1,1,NULL,86,NULL),(1150,'BUTCH',NULL,'QUEJADA','9176687599','BOSEBUTCH@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,174,NULL,1,1,NULL,NULL,NULL),(1151,'GERALD',NULL,'UY','9188800608','GERALD.UY@NEWTECHMEDIASOLUTIONS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,174,NULL,1,1,NULL,NULL,NULL),(1153,'WINNIE',NULL,'CHAN','9178948125','WINSTON.A.CHAN@PH.EY.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,20,39,1,1,NULL,96,'23.9'),(1154,'TONY',NULL,'LIN','9195684011',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,40,1,1,NULL,5,'18.4'),(1155,'MIKE',NULL,'SHIH','9175089852','MIKESY@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,40,1,1,NULL,5,'16.6'),(1156,'TOM',NULL,'CHANG','9275248283','YOYO9568821@YAHOO.COM.TW',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,40,1,1,NULL,36,NULL),(1158,'JOSELITO',NULL,'GUEVARRA','9189363981','JACK72HAMMER@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:19',NULL,NULL,NULL,NULL,1,1,NULL,86,NULL),(1159,'PETE',NULL,'HEMEDES','9175451842','NDL_KIMKAT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,86,NULL),(1160,'DANTE',NULL,'NATANAUAN','9228930885','TOTOYBIBO_XTB@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,175,6,1,1,NULL,97,NULL),(1161,'HERMIE',NULL,'PEREZ','9228257353','MPPEREZBUILDER31@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,176,6,1,1,NULL,76,'24.5'),(1162,'ROBERT  CHUA',NULL,'TAN','9274505483','TUFFCHEMICAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,177,1,1,1,NULL,2,'20.6'),(1164,'PETER',NULL,'CHUA','9178980228','LG9228229999@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,179,1,1,1,NULL,22,'26.9'),(1165,'EDWARD',NULL,'CHUA','9175262118','EDWARDCAIJIANCHENG@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,180,1,1,1,NULL,1,'22.8'),(1166,'DONDI',NULL,'DELOS SANTOS','9209726575','D.DELOSSANTOS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,181,41,1,1,NULL,4,NULL),(1167,'MIKEE',NULL,'MARQUEZ','9209506803','MHMARQUEZ@LBCEXPRESS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,181,NULL,1,1,NULL,88,NULL),(1168,'DELANO',NULL,'DIMAUNAHAN','9178178688','DELANO_168@YAHOO.COM','9228671688',NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,182,42,1,1,NULL,3,'32.2'),(1169,'ATTY ELMER',NULL,'SANTOS','9178078725','MSDC_ESANTOS@YAHOO.COM','9178686253',NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,183,20,1,1,NULL,47,NULL),(1171,'DOY',NULL,'UBALDO','9178112257','DOYUBALDO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'7.0'),(1172,'ART',NULL,'ZUNIEGA','9177913082','ART_ZUNIEGA@ELOOP.COM.HK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'13.8'),(1174,'JOHN',NULL,'ELEPAO','9266413394','ASIDILYO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,184,20,1,1,NULL,76,'9.2'),(1176,'JOEL',NULL,'ALIHAN','9188885635','JOEL_ALIHAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,56,'20.4'),(1178,'RAMON',NULL,'GARCIA JR','9209721888','RAMONGAR@DFNN.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,187,NULL,1,1,NULL,10,'24.4'),(1179,'GOODY',NULL,'HERNANDEZ','9175297253','GSHFIN@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,52,'14.8'),(1181,'BUDDY',NULL,'MADRIGAL','9188030759','BUDDY.MADRIGAL@PAIRCARGO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,19,3,1,1,NULL,5,'20.4'),(1182,'ROLAND',NULL,'GO','9175608700','RCGO0107@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,189,3,1,1,NULL,2,'23.2'),(1183,'HENRY',NULL,'ONGCHAN','9178416868','CYBER0723@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,190,3,1,1,NULL,47,'36.4'),(1184,'HYLAND',NULL,'SI','9178101166','HYLAND.SI@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,191,3,1,1,NULL,52,NULL),(1185,'JOHNNY',NULL,'TAN','9175261992','TANJOHNNY_5@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,192,3,1,1,NULL,47,NULL),(1186,'ROMEO',NULL,'FUENTES','9228951368','ROMEORHF88@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'18.1'),(1187,'EDY',NULL,'JANG','9273332370','EDYANG@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'5.5'),(1188,'JAMES',NULL,'CHEUNG','9188338366','JAMES@GPMC.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'23.2'),(1189,'JOEL',NULL,'MAHUSAY','9178983500','JOELMAHUSAY@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'15.8'),(1190,'RICHARD',NULL,'NG','9175212886','RICHARDNG@ASIACARGO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'18.7'),(1191,'JASPER',NULL,'ONG','9175353533','JSO7777@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'10.4'),(1192,'ELMER',NULL,'NGO','9179307491','ELMERNGO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'20.9'),(1193,'CARLOS',NULL,'UY','9178952255','UYCARLOS61@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,43,1,1,NULL,1,'25.9'),(1194,'IAN',NULL,'MCINTYRE','9178110259','IAN.MCINTYRE@DEVERE-GROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,44,1,1,NULL,98,'17'),(1195,'DALE ANDREW',NULL,'ROBERTS','9178593806','DALE_ROBERTS@FIL-PACIFIC.COM','9178593714',NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,5,'20'),(1196,'DEREK',NULL,'RAMSAY SR.','9228770002','SR.DEREK@GUARDALL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,193,NULL,1,1,NULL,52,'15'),(1197,'JACK',NULL,'ROXAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(1198,'PHILIP',NULL,'ROBERTS','9178322103','PHILIP.ROBERTS@DEVERE-GROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,45,1,1,NULL,99,'25'),(1199,'JAMES',NULL,'SIMPSON','9156179267','JAMES.SIMPSON@DEVERE-GROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,46,1,1,NULL,100,'16'),(1200,'RUSSELL',NULL,'EVANS','9065654175','MAKIRU82@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,99,'16'),(1201,'WILLIAM',NULL,'WAIROA-HARRISON','9175957217','WILLIAM.WAIROA-HARRISON@UNDSS.ORG',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,194,47,1,1,NULL,82,'23'),(1202,'ED',NULL,'CAPATI',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'30'),(1203,'MARVIN',NULL,'PAGSISIHAN','9177908484','MARVIN.PAGSISIHAN@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,99,'20'),(1204,'RENATO',NULL,'CASTANEDA','9088914140','EASORIANO@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,195,48,1,1,NULL,52,'18'),(1205,'GABRIEL',NULL,'CUI','9209079309','GRCUI@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,101,'16'),(1206,'HERMAN',NULL,'MEDINA-CUE','9175285698','HERMAN.MEDINACUE@COCA-COLA.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,4,'32'),(1207,'TOTI',NULL,'REFORMADO','9175057653','TOTI.REFORMADO@COCA-COLA.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,49,1,1,NULL,82,'16'),(1208,'TONY',NULL,'CASTILLO','9178503786','ARLCASTILLO616@GMAIL.COM','9399052234',NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,196,50,1,1,NULL,102,'33'),(1209,'DANNY',NULL,'GO','9175267619','DANIELGO@MAA.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,103,'16'),(1210,'LOVELL',NULL,'GOPEZ','9179649866','LGOPEZ@MIZUNO.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,5,'15'),(1211,'CHARLES',NULL,'GOZON','9186049123','WILWEYCOPH@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,1,'15'),(1212,'EDWARD',NULL,'JOSE','9175369062','EDWARDJOSE@VSO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,5,'17'),(1213,'RENAN',NULL,'JAYME','9175383376','RPJAYME@VSO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,16,'31'),(1214,'EDWIN',NULL,'ERMITA','9178945595','ERERMITA@RCBC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'19'),(1215,'BRIXTON',NULL,'AW','9178108211','BRIXTON_3333@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,197,3,1,1,NULL,104,'7'),(1217,'JOEL',NULL,'PANGANIBAN','9209065980','JRPANGANIBAN25@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,52,1,1,NULL,4,'15'),(1218,'MANUEL',NULL,'PUZON JR.','9175288758','BUBOY_PUZON@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,198,NULL,1,1,NULL,104,'31'),(1219,'CONRAD',NULL,'LOPEZ','9175308292','CONRADLOPEZIII@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,199,NULL,1,1,NULL,99,'31'),(1220,'RICO',NULL,'UY','9175328875','RICO@GFI-FORCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,54,'18'),(1221,'PATRICK',NULL,'ZUNIGA','9328596830','SPDZUNIGA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,54,'8'),(1222,'DANNY',NULL,'AW YOUNG','9175378485','DYOUNG@PLDTDSL.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,1,'22'),(1223,'EDWARD',NULL,'CO','9228867886','CASAVERDE88@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,1,'18'),(1225,'WILBERT',NULL,'UY','9165025926','RIZGOLF_SPORTSMKTG@YAHOO.CO.UK',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,54,1,1,NULL,2,'23'),(1230,'ALAN',NULL,'SINGSON','9276008360','AJSINGSON@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,106,'31'),(1232,'ALEX',NULL,'ASPILLERE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'36'),(1233,'GODOFREDO',NULL,'TAPIRE','9228325240','GODOFREDO.TAPIRE@WINTERPINEGROUP.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,1,1,1,NULL,NULL,'36'),(1234,'LEO',NULL,'LEI','9228866589','LEO_LEI_YEE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,200,3,1,1,NULL,47,'16'),(1235,'TEY',NULL,'SORNET','9175332859','TEYSORNET@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,55,1,1,NULL,3,'23'),(1236,'LEO',NULL,'SAN JUAN','9228433521','SANJUAN_LEO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,56,1,1,NULL,16,'33'),(1237,'HERBERT',NULL,'TAN','9228665310','HVTAN.NISSANMANTRADE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,56,1,1,NULL,99,'19'),(1238,'HATORI',NULL,'HIROYUKI','9189122181','H.HATORI@JPNBLEASING.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,201,57,1,1,NULL,86,'34'),(1239,'ALFONSO',NULL,'TANSECO','9189072740','A.TANSECO@JPNBLEASING.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,201,3,1,1,NULL,19,'27'),(1240,'ALAN',NULL,'CHNG','9175900521','ALAN_CHNG@CANON.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,202,58,1,1,NULL,19,'28'),(1241,'VINCHY',NULL,'SANCHEZ',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'36'),(1242,'MANNY',NULL,'PONCE','9178252759','MANNY_PONCE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'11'),(1243,'EDGAR',NULL,'VIBAL','9285050320','EDVIBAL@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'16'),(1244,'NESTOR',NULL,'SEVILLA','9178171621',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'12'),(1245,'AWOO',NULL,'LACSON','9178833222','AWOO7@HOTMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:20',NULL,NULL,NULL,NULL,1,1,NULL,3,'24'),(1246,'GENE',NULL,'SEBASTIAN','9179555927','GENETRONSC@SKYINET.NET',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,203,3,1,1,NULL,1,'13'),(1247,'ROLLY',NULL,'BASCO',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,2,'15'),(1249,'LESTER',NULL,'CODOG','9179302156','LESTER@FOILACARMANILA.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,19,'25'),(1250,'JAY',NULL,'CHAVEZ','9178592336','JAY.CHAVEZ@IONICS-EMS.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,59,1,1,NULL,67,'23'),(1251,'MARK LESTER',NULL,'SALVADOR','9178078996','MARK.SALVADOR@CCAC.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,60,1,1,NULL,67,'31'),(1252,'RICKY',NULL,'DE ROCA','9178166681','RICKYDEROCA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,204,61,1,1,NULL,5,'13'),(1253,'ARNEL',NULL,'MAGANTI','9175026613',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'18'),(1254,'JOSE GERARDO \"JAY\"',NULL,'FRANCISCO','9177045138','JGFRANCISCOIII@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,107,'27'),(1255,'JOSE BAYANI \"JB\"',NULL,'LAUREL','9175215900','JBL@MIAA.GOV.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,21,'15'),(1256,'EDGAR',NULL,'GALEA','9175059287','EGALEA@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,108,'17'),(1257,'HENRY',NULL,'SALDAVIA','9178192834','SSALDAVIA@STANDARD-INSURANCE.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,99,'27'),(1258,'ELEAZAR',NULL,'CARSULA','9189059737','ECARSULA@UFREIGHT.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,75,'13'),(1261,'JIM',NULL,'MELO','9173259147','JIM_MELO@PAL.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,3,'12'),(1262,'CHRISTOPHER',NULL,'LIZO','9188878787','CCLIZO@MNTC.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,205,62,1,1,NULL,3,'23'),(1263,'AUGIE',NULL,'PALISOC JR.','9189104374','APJ@MPIC.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,205,NULL,1,1,NULL,36,'5'),(1264,'KENNETH',NULL,'FLAVIER','9175524067','KENNETHFLAVIER@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,36,'5'),(1266,'ROGEL',NULL,'RAYA','9175000617','RAYA.ROGEL@BDO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,206,63,1,1,NULL,99,'31'),(1267,'MIKE',NULL,'BESA','9175277650',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,2,'9'),(1268,'IAN',NULL,'ARCEO','9178508640','RCARCEO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,207,3,1,1,NULL,5,'14'),(1269,'JETHRO',NULL,'DIONISIO','9175324299','LOAD_DEPOT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,208,3,1,1,NULL,109,'26'),(1271,'ANTON',NULL,'CABANGON','9178729000','ANTONCAB12@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,64,1,1,NULL,36,'10'),(1273,'RIC',NULL,'BERNABE','9178936363','BERNABEJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,99,'31'),(1274,'MON',NULL,'CLAVESILLAS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'24'),(1275,'RICKY',NULL,'SANDOVAL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'34'),(1276,'ALBERT',NULL,'DELOS SANTOS','9178252782','AVDELOSSANTOS@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,110,'34'),(1277,'IKE',NULL,'GANGOSO','9189101011','GANGOSO@PLDTDSL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,209,1,1,1,NULL,5,'31'),(1280,'WILSON',NULL,'LIM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL),(1281,'BOYCEE',NULL,'ARGUELLES','9178970703','BOY7CEE@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,76,'5'),(1282,'FREDDIE',NULL,'YUMANG','9175677589','FPYUMANG@PETRON.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,4,'21'),(1283,'ABE',NULL,'AVENA','9285080346','ABE_AVENA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,76,'31'),(1284,'RYAN',NULL,'LORENZO','9175243673','RLOREN12@FORD.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,65,1,1,NULL,2,'13'),(1285,'CESAR',NULL,'ASUNCION','9175012010','CGASUNCION@PILIPINASHINO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,1,'23'),(1286,'EDWIN',NULL,'GARDIOLA','9175446107','CHRISTELPANOGA_30@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,76,'14'),(1287,'DANNY',NULL,'ISLA','9189100185','DANIEL.ISLA@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,5,'17'),(1288,'RAUL',NULL,'MONTEALTO','9209512653','R-MONTEALTO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,14,'10'),(1289,'LUBIN',NULL,'NEPOMUCENO','9178132115','LBNEPOMUCENO@PETRON.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,52,'16'),(1290,'ANDRE',NULL,'BORROMEO','9175288322','ANDRE@BORROMEO.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,66,1,1,NULL,111,'5'),(1293,'JOHN',NULL,'BUECHIERT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'8'),(1294,'MITCH',NULL,'LOCSIN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'30'),(1295,'JOSE RANIER',NULL,'REYES',NULL,'JRAREYES@MERALCO.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,68,1,1,NULL,99,'23'),(1297,'MAO VERGEL',NULL,'DE DIOS','9175940965','RAMON.VERGELDEDIOS@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,69,1,1,NULL,3,'26'),(1298,'JONAS',NULL,'SARMIENTO','9189381866','JONAS.SARMIENTO@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,211,70,1,1,NULL,11,'11'),(1299,'GLENN',NULL,'SAN AGUSTIN','9285011858','GLENN.SANAGUSTIN@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,212,71,1,1,NULL,99,'31'),(1300,'RHODEL',NULL,'NASARA','9998848015','RHODEL.NASARA@SHELL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,71,1,1,NULL,99,'31'),(1301,'FERNANDO',NULL,'PEREZ',NULL,'SBITC@PLDTSUBICTEL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,4,'16'),(1302,'REIMOND',NULL,'SILVESTRE','9189056726','RSILVESTRE@ICTSI.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,213,20,1,1,NULL,4,'22'),(1303,'RUSSEL VINCENT',NULL,'RENTOY','9293433678','VAVITDADIT@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,82,'15'),(1304,'NICANOR',NULL,'SALVADOR','9199908608','NICKSALVADOR_83@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,114,'11'),(1305,'BOY',NULL,'SABLAN','9175632077','RODELSABLAN@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,214,NULL,1,1,NULL,79,'26'),(1306,'RUDY',NULL,'YU','9175369878','RUDYYU@BOACMKTG.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,47,'27'),(1307,'ROY',NULL,'SUZARA','9178528241','ROYSUZARAJR@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,16,'33'),(1308,'ENRIQUE',NULL,'PATAG','9175235587','PCI@POWER-CHEK.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,215,72,1,1,NULL,99,'31'),(1310,'BEN',NULL,'JACINTO','9276301669',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,115,'10'),(1311,'CELESTINO',NULL,'REYES','9088751990','WHENLESISMORE113@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,6,1,1,NULL,38,'10'),(1312,'PANCHO',NULL,'RODRIQUEZ','9209090763','PANCHO-R2008@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,216,73,1,1,NULL,52,'28'),(1313,'DON',NULL,'ROQUE','9175994898','HMROQUE@EASTWESTBANKER.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,74,1,1,NULL,99,'19'),(1314,'MAX',NULL,'BORROMEO','9176210000','MAX@BORROMEO.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,66,1,1,NULL,111,'16.4'),(1315,'LEE CEASAR',NULL,'JUNIA','9476409112',NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,217,75,1,1,NULL,NULL,'31'),(1316,'JIM',NULL,'WU',NULL,'LSJ.PHX@GMAIL.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,217,76,1,1,NULL,NULL,'31'),(1318,'RENE',NULL,'ARGANDA','9175324578','ARGIECERV@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,218,77,1,1,NULL,99,'31'),(1319,'RJ',NULL,'LIWANAG','9175241981','RJLIGHT58@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,78,1,1,NULL,21,'3'),(1320,'JESS',NULL,'CUSTODIO','9178585403','JBCUSTODIO@PSBANK.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,5,'27'),(1322,'JERRY',NULL,'BAUTISTA','9178805865','JERRYBAUTISTA@LEDERLAND.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,47,'23'),(1323,'ROMY',NULL,'CLEMENTE','9189191537','CLEMENTE.ROMY@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,99,'31'),(1324,'LADISLAO (DONG)',NULL,'TAN','9228465301','DONG@GOLDCARSPH.COM','9178472841',NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,219,3,1,1,NULL,116,'25'),(1326,'JESUS(BON)',NULL,'RAMOS JR','9173039084','RAMOSBON@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,220,73,1,1,NULL,47,'25'),(1327,'JONATHAN',NULL,'BALIGOD','9175783333','JSB_LAW@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,79,1,1,NULL,99,'22'),(1328,'DAVE',NULL,'MERCADO','9209195252','DMERCADO@UTASSCO.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,7,1,1,NULL,3,'19'),(1329,'RICKY',NULL,'ANASTACIO','9178211164','RSANASTACIO@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,73,1,1,NULL,16,'19'),(1330,'EDWIN',NULL,'ABESAMIS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'15'),(1331,'ATTY. BEN',NULL,'MALCONTENTO','9178921210','BEN@KBMALAWOFFICES.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,221,NULL,1,1,NULL,3,'10'),(1332,'KENNETH',NULL,'DUREMDES','9192583132','KENDUREMDES19@YAHOO.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,99,'31'),(1334,'CHOLO',NULL,'CAYANGA',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,222,80,1,1,NULL,118,'15'),(1335,'BERT',NULL,'LINA','9178852100','ALINA@AF2100.COM',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,NULL,'17'),(1336,'ERIC',NULL,'ALBERTO','9209012152','ERALBERTO@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,NULL,NULL,1,1,NULL,109,'24'),(1337,'CESAR',NULL,'ENRIQUEZ','9189206792','CENRIQUEZ@PLDT.CPM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,223,81,1,1,NULL,52,'23'),(1338,'LUIGI',NULL,'LOPA','9189026324','LALOPA@PLDT.COM.PH',NULL,NULL,NULL,NULL,NULL,'2022-07-18 12:52:21',NULL,NULL,224,NULL,1,1,NULL,52,'27'),(1339,'Michael','Nojor','Balibrea','9178550134','mbalibrea@autohubgroup.com',NULL,NULL,'khel','$2y$10$WllXm6G1LKwuzyocGyjrWe04DmUbRGXDnsyH3Fmt.IYawAHVZdmuW',1,'2022-07-12 12:52:21',NULL,'2022-07-20 11:11:55',NULL,NULL,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `golf_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `golf_users_login_session_token`
--

DROP TABLE IF EXISTS `golf_users_login_session_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `golf_users_login_session_token` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `token` varchar(95) DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_UNIQUE` (`user_id`),
  KEY `login_token_fk1_idx` (`user_id`),
  CONSTRAINT `login_token_fk1` FOREIGN KEY (`user_id`) REFERENCES `golf_users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `golf_users_login_session_token`
--

LOCK TABLES `golf_users_login_session_token` WRITE;
/*!40000 ALTER TABLE `golf_users_login_session_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `golf_users_login_session_token` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-07-23 11:40:12
