<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['prefix' => '/users'], function () {
        Router::group(['middleware' => \App\Middlewares\Token::class], function () {
            Router::get('/', 'UserController@usersIndex')->setName('users');
            // Router::group(['prefix' => '/import'], function () {
            Router::get('/import', 'UserController@usersImportIndex')->setName('users.import');
            // });
        });

        Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
            Router::match(['get', 'post'], '/sendInvitation', 'UserController@sendInvitation')->setName('users.sms.invitation');
            Router::get('/list', 'UserController@list')->setName('users.list');
            Router::get('/event/list', 'UserController@eventsData')->setName('users.event.list');
            Router::get('/adminList', 'UserController@adminList')->setName('users.admin.list');
            Router::post('/status', 'UserController@updateStatus')->setName('users.status');
            Router::post('/event/status', 'UserController@updateEventStatus')->setName('users.event.status');
            Router::post('/reward', 'UserController@createReward')->setName('users.create.reward');
            Router::post('/reward/count', 'UserController@rewardClaimCount')->setName('users.reward.count');
            Router::post('/mulligan/count', 'UserController@mulliganCount')->setName('users.mulligan.count');
            Router::post('/mulligan/update', 'UserController@updateMulligan')->setName('users.update.mulligan');
            Router::post('/team/status', 'UserController@removeFromTeam')->setName('users.team.status');
            Router::post('/store', 'UserController@store')->setName('users.store');
            Router::post('/fetch', 'UserController@getUser')->setName('users.fetch');
            Router::post('/player/fetch', 'UserController@getPlayer')->setName('users.player.fetch');
            Router::post('/team/store', 'UserController@storeTeam')->setName('users.team.store');
            Router::post('/event/store', 'UserController@storePlayer')->setName('users.event.store');
            Router::get('/options', 'UserController@options')->setName('users.options');
            Router::get('/mate/options', 'UserController@mateOption')->setName('users.mate.options');
            Router::get('/event/team/options', 'UserController@userEventTeamOptions')->setName('users.event.team.options');
            Router::get('/team/options', 'UserController@teamOptions')->setName('users.team.options');
            Router::get('/team/filter/options', 'UserController@teamFilterOptions')->setName('users.team.filter.options');
            Router::post('/event/attendance', 'UserController@setAttendance')->setName('users.event.attendance');
            Router::post('/import', 'UserController@usersImport')->setName('users.import.store');
            //modify
            Router::post('/event/bootClaim', 'UserController@bootClaim')->setName('users.event.bootClaim');
        });
    });
});
