<?php

use App\Router;

Router::group(['middleware' => \App\Middlewares\Auth::class], function () {
    Router::group(['middleware' => \App\Middlewares\Token::class], function () {
        // Download manager
        Router::group(['prefix' => '/download'], function () {
            //lto downloads
            Router::group(['prefix' => '/users'], function () {
                Router::get('/import_summary', 'UserController@usersImportSummaryDownload')->setName('users.import.download');
                Router::get('/qr', 'UserController@usersQR')->setName('users.qr');
                Router::get('/template', 'UserController@usersTemplateDownload')->setName('users.import.template');
            });
            Router::group(['prefix' => '/events'], function () {
                Router::get('/template', 'EventController@usersTemplateDownload')->setName('events.import.template');
            });
        });
    });
});
