<?php

use App\Router;

Router::group(['prefix' => '/api'], function () {
    Router::group(['prefix' => '/v1'], function () {
        // Router::group(['middleware' => \App\Middlewares\Token::class], function () {
        // Router::match(['get', 'post'], '/info', 'UserController@QrPlayerInfo');
        Router::post('/info', 'UserController@QrPlayerInfo');
        Router::post('/device', 'UserController@QrDevice');
        // });
        // Router::group(['middleware' => \App\Middlewares\TokenVerifier::class], function () {
        Router::post('/info/update', 'UserController@QrPlayerUpdate');
        Router::post('/reward/claim', 'UserController@QrPlayerClaim');
        Router::post('/mulligan/update', 'UserController@QrPlayerMulligan');
        // });
        Router::get('/get', function () {
            response()->json($_GET);
        });
        Router::post('/post', function () {
            response()->json($_POST);
        });

        Router::get('/qr', function () {

            header("Content-Type: image/png");

            if (empty(input('data'))) {
                response()->json(array("status" => 0, "message" => "Data is missing."));
            }

            // $encrypt = array(1, 2, 4, array('test' => 'asdsa'));
            // echo \App\Utilities\Encrypt::encode(json_encode($encrypt));
            $data = input('data');
            $json_data = \App\Utilities\Encrypt::decode($data);


            if (empty($json_data)) {
                response()->json(array("status" => 0, "message" => "Invalid data."));
            }

            $array_data = json_decode($json_data, true);
            $user = new \App\Models\User();
            $user_data =   $user->getUser(
                array(
                    $array_data['id'],
                )
            );

            if (empty($user_data)) {
                response()->json(array("status" => 0, "message" => "Invalid data.."));
            }

            $array_data['uri']  = config('api')->qr['uri'];
            $name = $user_data['firstname'] . ' ' . $user_data['lastname'];
            $array_data['parameters'] = array(
                "key" => config('api')->qr['key'],
                "data" => $json_data,
                "logo" => true,
                "label" =>  strlen($name) <= 20 ? $name : $user_data['firstname'],
            );
            // $array_data['header'] = array("Content-Type: image/jpg");

            $response  = \App\Utilities\Utility::curl($array_data);

            echo $response;
        });
    });
});
