 <?php
    ?>
 <!DOCTYPE html>
 <html lang="en">

 <head>
     <?php self::render('common/meta'); ?>
     <!-- insert custom meta here -->

     <title><?= env('APP_NAME') ?></title>

     <?php self::render('common/css'); ?>
     <!-- insert custom css here -->
     <link rel="stylesheet" href="<?= asset_version("/assets/plugins/jstree/themes/default/style.min.css") ?>">
     <!-- Select2 -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/select2/css/select2.min.css") ?>">
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css") ?>">
     <!-- summernote -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/summernote/summernote-bs4.min.css") ?>">
     <!-- dropzone -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/dropzone/min/dropzone.min.css") ?>">
     <!-- DataTables -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css") ?>">
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/datatables-responsive/css/responsive.bootstrap4.min.css") ?>">
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/datatables-buttons/css/buttons.bootstrap4.min.css") ?>">
     <!-- Tempusdominus Bootstrap 4 -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css") ?>">
     <style>

     </style>


 </head>

 <body class="hold-transition sidebar-mini layout-fixed text-sm layout-footer-fixed">
     <div class="wrapper">

         <!-- insert preloader here -->
         <?php self::render('common/preloader'); ?>

         <!-- insert header -->
         <?php self::render('common/header', get_defined_vars()); ?>

         <!-- insert sidebar -->
         <?php self::render('common/sidebar'); ?>

         <!-- Content Wrapper. Contains page content -->

         <div class="content-wrapper">


             <!-- Main content -->
             <section class="content pt-2">
                 <input type="hidden" name="csrf_token" id="csrf_token" value="<?= csrf_token(); ?>">
                 <div id="filter-list-section" class="hidden bg-white p-3 mb-2 ">
                     Filters
                 </div>

                 <div class="bg-white p-3 ">
                     <!-- solid sales graph -->
                     <div class="row pl-2">
                         <div class="col-md-5">
                             <div class="row justify-content-lg-start justify-content-center">
                                 <!-- <button id="filter-list" type="button" title="" class="btn btn-primary px-2 mr-2 btn-sm mb-1"><i class="fa fa-filter"></i> Filters</button> -->

                                 <div class="input-group pl-0 mb-1" style="width:275px;">

                                     <div class="input-group-append cursor">
                                         <div class="input-group-text  px-1 border  form-control-sm">
                                             <div class="tooltip-me" title="Filter by category">
                                                 <button type="button" class="btn btn-sm dropdown-toggle" data-toggle="dropdown">
                                                     <i class="fas fa-search"></i>
                                                     <u>Search</u>
                                                 </button>
                                                 <ul class="dropdown-filter product-search-type dropdown-menu cursor">

                                                 </ul>
                                             </div>
                                         </div>
                                     </div>
                                     <input id="txt_search" type="search" class=" form-control form-control-sm" placeholder="Keywords...">

                                 </div>

                             </div>
                         </div>

                         <div class="col-md-7">
                             <div class="row justify-content-lg-end justify-content-center">

                                 <a id="btn_create" class="btn btn-primary btn-sm mr-2" role="button"><i class="fa fa-plus"></i> Create</a>
                                 <a class="btn btn-primary btn-sm mr-2" href="<?= url('users.import') ?>" role="button"><i class="fas fa-file-import"></i> Import</a>
                                 <a class="btn btn-primary btn-sm mr-2" id="reload-list" role="button"><i class="fas fa-sync"></i> Reload</a>

                             </div>
                         </div>


                     </div>
                     <div class="">
                         <table id="tableList" class="table table-sm table-bordered table-striped">
                         </table>
                     </div>
                 </div>
             </section>
             <!-- /.content -->
         </div>



         <div class="modal_container">
             <div class="modal " id="modal_user">
                 <div class="modal-dialog modal-lg modal-dialog-centered">
                     <div class="modal-content">
                         <div class="overlay modal_user_overlay" style="display:none;">
                             <i class="fas fa-2x fa-sync fa-spin"></i>
                         </div>
                         <form id="UserForm">

                             <div class="modal-header bg-light py-1">
                                 <span class="modal-title text-md font-weight-bold" id="car_club_import_modal_title">Player Information</span>
                                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                     <span aria-hidden="true">&times;</span>
                                 </button>
                             </div>

                             <div class="modal-body">


                                 <div class="row">

                                     <div class="col-sm-6">
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Firstname <span class="text-muted text-sm font-italic" hidden>(Optional)</span></label>
                                             <input name="firstname" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Lastname</label>
                                             <input name="lastname" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Suffix</label>
                                             <select name="suffix" class=" form-control form-control-sm">
                                                 <option value="">None</option>
                                                 <option value="JR">Jr.</option>
                                                 <option value="SR">Sr.</option>
                                                 <option value="I">I</option>
                                                 <option value="II">II</option>
                                                 <option value="III">III</option>
                                                 <option value="IV">IV</option>
                                             </select>
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Mobile</label>
                                             <input name="mobile" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Other Mobile</label>
                                             <input name="other_mobile" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Email</label>
                                             <input name="email" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Other Email</label>
                                             <input name="other_email" type="text" class=" form-control form-control-sm">
                                         </div>
                                     </div>

                                     <div class="col-sm-6">

                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Phone</label>
                                             <input name="phone" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Membership</label>
                                             <input name="membership" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Handicap</label>
                                             <input name="handicap" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Company</label>
                                             <input name="company" type="text" class=" form-control form-control-sm">
                                         </div>
                                         <div class="form-group mb-2">
                                             <label class=" mx-0 my-0 font-weight-normal">Designation</label>
                                             <input name="designation" type="text" class=" form-control form-control-sm">
                                         </div>
                                     </div>





                                 </div>
                             </div>
                             <div class="modal-footer justify-content-between py-1 px-3">
                                 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                                 <button id="btn_save" type="submit" class="btn btn-primary">Save</button>
                             </div>
                         </form>
                     </div>
                     <!-- /.modal-content -->
                 </div>
                 <!-- /.modal-dialog -->
             </div>
             <!-- /.modal -->
             <div class="modal " id="modal_event">
                 <div class="modal-dialog modal-lg modal-dialog-centered">
                     <div class="modal-content">
                         <div class="overlay modal_event_overlay" style="display:none;">
                             <i class="fas fa-2x fa-sync fa-spin"></i>
                         </div>
                         <form id="EventForm">

                             <div class="modal-header bg-light py-1">
                                 <span class="modal-title text-md font-weight-bold" id="selected_user"></span>
                                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                     <span aria-hidden="true">&times;</span>
                                 </button>
                             </div>

                             <div class="modal-body">


                                 <div class="row">

                                     <div class="col-sm-6 mb-2 border-bottom">
                                         <div class="form-group mb-3">
                                             <label class="m-0 text-md font-weight-normal">Select Event</label>
                                             <select class="form-control form-control-sm" id="event" name="event" style="width: 100%;">
                                             </select>
                                         </div>
                                     </div>

                                     <div class="col-sm-6 mb-2 border-bottom">

                                     </div>

                                     <div class="col-sm-6">
                                         <label class="m-0 text-md font-weight-normal">Team</label>
                                         <div class="col-12 p-0">
                                             <div class="row">
                                                 <div class="col-10 pr-0">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm" name="team" style="width: 100%;">
                                                         </select>
                                                     </div>
                                                 </div>
                                                 <div class="col-2">
                                                     <div class="form-group mb-2">
                                                         <input id="btn_add_team" class="btn btn-success mr-2" value="Add" type="button" />
                                                         <!-- <a id="btn_add_team" class="btn btn-success mr-2" role="button"> Add</a> -->
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>

                                     <div class="col-sm-6">
                                         <label class="m-0 text-md font-weight-normal">Flight Mate</label>
                                         <div class="col-12 p-0">
                                             <div class="row">
                                                 <div class="col-10 pr-0">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm" name="mate" style="width: 100%;">
                                                         </select>
                                                     </div>
                                                 </div>
                                                 <div class="col-2">
                                                     <div class="form-group mb-2">
                                                         <!-- <button id="btn_add_mate" class="btn btn-success btn-sm">Add</button> -->
                                                         <!-- <a id="btn_add_mate" class="btn btn-success mr-2" role="button"> Add</a> -->
                                                         <input id="btn_add_mate" class="btn btn-success mr-2" value="Add" type="button" />

                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>



                                     <div class="col-sm-6">
                                         <div class="form-group mb-2">
                                             <label class="m-0 text-md font-weight-normal">Course</label>
                                             <select class="form-control form-control-sm select2bs4_nosearch" name="course" style="width: 100%;">
                                                 <?= $course_options ?>
                                             </select>
                                         </div>
                                     </div>

                                     <div class="col-sm-6">
                                         <div class="form-group mb-2">
                                             <label class="m-0 text-md font-weight-normal">Division</label>
                                             <select class="form-control form-control-sm select2bs4_nosearch" name="division" style="width: 100%;">
                                                 <?= $division_options ?>
                                             </select>
                                         </div>
                                     </div>




                                     <div class="col-sm-6">
                                         <label class="m-0 text-md font-weight-normal">Course/Flight</label>
                                         <div class="col-12 p-0">
                                             <div class="row">
                                                 <div class="col-sm-6">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm select2bs4_nosearch" name="course_n" style="width: 100%;">
                                                             <option value=''>Select</option>
                                                             <?php
                                                                for ($course_n = 1; $course_n <= 19; $course_n++) {
                                                                    echo "<option value='" . $course_n . "'>" . $course_n . "</option>";
                                                                }
                                                                ?>
                                                         </select>
                                                     </div>
                                                 </div>
                                                 <div class="col-sm-6">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm select2bs4_nosearch" name="flight_n" style="width: 100%;">
                                                             <option value=''>Select</option>
                                                             <?php
                                                                for ($flight_n = 'A'; $flight_n <= 'D'; $flight_n++) {
                                                                    echo "<option value='" . $flight_n . "'>" . $flight_n . "</option>";
                                                                }
                                                                ?>
                                                         </select>
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>

                                     <div class="col-sm-6">
                                         <label class="m-0 text-md font-weight-normal">Registration Status</label>
                                         <div class="col-12 p-0">
                                             <div class="row">
                                                 <div class="col-sm-6">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm select2bs4_nosearch" name="registration_type" style="width: 100%;">
                                                             <?php
                                                                $registration_types = array(
                                                                    "unpaid" => "Unpaid",
                                                                    "paid" => "Paid",
                                                                    "invited" => "Invited",
                                                                );

                                                                foreach ($registration_types as $key => $value) {
                                                                    echo "<option value='" . $key . "'>" . $value . "</option>";
                                                                }
                                                                ?>
                                                         </select>
                                                     </div>
                                                 </div>
                                                 <div class="col-sm-6">
                                                     <div class="form-group mb-2">
                                                         <select class="form-control form-control-sm select2bs4_nosearch" name="registration_status" style="width: 100%;">
                                                             <?php
                                                                $registration_status = array(
                                                                    "unregistered" => "Unregistered",
                                                                    "registered" => "Registered",
                                                                );

                                                                foreach ($registration_status as $key => $value) {
                                                                    echo "<option value='" . $key . "'>" . $value . "</option>";
                                                                }
                                                                ?>
                                                         </select>
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>



                                 </div>
                             </div>
                             <div class="modal-footer justify-content-between py-1 px-3">
                                 <button type="button" class="btn btn-default modal-cancel" data-dismiss="modal">Close</button>

                                 <button id="btn_save_event" type="submit" class="btn btn-primary">Save</button>
                             </div>
                         </form>
                     </div>
                     <!-- /.modal-content -->
                 </div>
                 <!-- /.modal-dialog -->
             </div>
             <!-- /.modal -->

             <!-- /.modal -->
             <div class="modal " id="modal_team">
                 <div class="modal-dialog modal-dialog-centered">
                     <div class="modal-content">
                         <div class="overlay modal_team_overlay" style="display:none;">
                             <i class="fas fa-2x fa-sync fa-spin"></i>
                         </div>
                         <form id="TeamForm">

                             <div class="modal-header bg-light py-1">
                                 <span class="modal-title text-md font-weight-bold" id="">Add Team</span>
                                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                     <span aria-hidden="true">&times;</span>
                                 </button>
                             </div>

                             <div class="modal-body">

                                 <div class="col-sm-12">
                                     <div class="form-group mb-2">
                                         <label class=" mx-0 my-0 font-weight-normal">Team Name</label>
                                         <input name="team_name" type="text" class=" form-control form-control-sm">
                                     </div>
                                 </div>

                             </div>
                             <div class="modal-footer justify-content-between py-1 px-3">
                                 <button type="button" class="btn btn-default modal-cancel" data-dismiss="modal">Close</button>

                                 <button id="btn_save_team" type="submit" class="btn btn-primary">Save</button>
                             </div>
                         </form>
                     </div>
                     <!-- /.modal-content -->
                 </div>
                 <!-- /.modal-dialog -->
             </div>
             <!-- /.modal -->



         </div>

         <!-- insert footer -->
         <?php self::render('common/footer'); ?>

         <!-- insert control sidebar -->
         <?php self::render('common/control_sidebar');  ?>

     </div>
     <!-- ./wrapper -->

     <!-- common sctipts -->
     <?php self::render('common/script');  ?>
     <!-- Select2 -->
     <script src="<?= asset_version("/assets/core/plugins/select2/js/select2.full.min.js") ?>"></script>
     <!-- Summernote -->
     <script src="<?= asset_version("/assets/core/plugins/summernote/summernote-bs4.min.js") ?>"></script>
     <!-- JQuery Repeater -->
     <script src="<?= asset_version("/assets/plugins/jquery.repeater/jquery.repeater.min.js") ?>"></script>
     <!-- Dropzone -->
     <script src="<?= asset_version("/assets/core/plugins/dropzone/min/dropzone.min.js") ?>"></script>
     <!-- DataTables  & Plugins -->
     <script src="<?= asset_version("/assets/core/plugins/datatables/jquery.dataTables.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-responsive/js/dataTables.responsive.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-responsive/js/responsive.bootstrap4.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-buttons/js/dataTables.buttons.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-buttons/js/buttons.bootstrap4.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/jszip/jszip.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/pdfmake/pdfmake.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/pdfmake/vfs_fonts.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-buttons/js/buttons.html5.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-buttons/js/buttons.print.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/datatables-buttons/js/buttons.colVis.min.js") ?>"></script>
     <!-- InputMask -->
     <script src="<?= asset_version("/assets/core/plugins/moment/moment.min.js") ?>"></script>
     <script src="<?= asset_version("/assets/core/plugins/inputmask/jquery.inputmask.min.js") ?>"></script>
     <!-- Tempusdominus Bootstrap 4 -->
     <script src="<?= asset_version("/assets/core/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js") ?>"></script>

     <script>
         const list_uri = '<?= url('users.list') ?>';
         const create_users_uri = '<?= url('users.store') ?>';
         const create_team_uri = '<?= url('users.team.store') ?>';
         const create_add_to_evt_uri = '<?= url('users.event.store') ?>';
         const user_mate_options_uri = '<?= url('users.mate.options') ?>';
         const update_user_status_uri = '<?= url('users.status') ?>';
         const fetch_user_uri = '<?= url('users.fetch') ?>';
         const fetch_player_uri = '<?= url('users.player.fetch') ?>';
         const event_options_uri = '<?= url('events.options') ?>';
         const user_options_uri = '<?= url('users.options') ?>';
         const team_options_uri = '<?= url('users.team.options') ?>';
     </script>
     <script src="<?= asset_version("/assets/js/user/list.js") ?>"></script>

 </body>


 </html>