 <?php
    ?>
 <!DOCTYPE html>
 <html lang="en">

 <head>
     <?php self::render('common/meta'); ?>
     <!-- insert custom meta here -->

     <title><?= env('APP_NAME') ?></title>

     <?php self::render('common/css'); ?>
     <!-- insert custom css here -->
     <link rel="stylesheet" href="<?= asset_version("/assets/plugins/jstree/themes/default/style.min.css") ?>">
     <!-- dropzone -->
     <link rel="stylesheet" href="<?= asset_version("/assets/core/plugins/dropzone/min/dropzone.min.css") ?>">
     <style>

     </style>


 </head>

 <body class="hold-transition sidebar-mini layout-fixed text-sm layout-footer-fixed">
     <div class="wrapper">

         <!-- insert preloader here -->
         <?php self::render('common/preloader'); ?>

         <!-- insert header -->
         <?php self::render('common/header', get_defined_vars()); ?>

         <!-- insert sidebar -->
         <?php self::render('common/sidebar'); ?>

         <!-- Content Wrapper. Contains page content -->

         <div class="content-wrapper">


             <!-- Main content -->
             <section class="content pt-2">
                 <div class="col-12">




                     <div class="col-12 " id="error-report-div" style="display:none;">
                         <div class="form-group row mb-0">
                             <label for="" class="col-sm-12 pb-0 pt-0 col-form-label font-weight-bold text-danger">Error:&nbsp;<span class="text-dark" id="span_msg_data"></span> </label>
                         </div>
                         <div id="" class="row mt-1">
                             <div class="col-sm-2 mt-1">
                                 <div class="btn-group w-100">
                                     <span id="btn_error_summary_back" class="btn btn-secondary  col btn-xs">
                                         <i class="fas fa-arrow-left"></i>
                                         <span>Back</span>
                                     </span>
                                 </div>
                             </div>
                         </div>
                     </div>

                     <div class="col-12 " id="summary-report-div" style="display:none;">
                         <div class="form-group row mb-0">
                             <label for="" class="col-sm-12 pb-0 pt-0 col-form-label font-weight-bold">Total Data:&nbsp;<span id="span_total_data"></span> </label>
                         </div>
                         <div class="form-group row mb-0">
                             <label for="" class="col-sm-12 pb-0 pt-0 col-form-label font-weight-bold">Inserted Data:&nbsp;<span id="span_inserted_data"></span></label>
                         </div>
                         <div class="form-group row mb-0">
                             <label for="" class="col-sm-12 pb-0 pt-0 col-form-label font-weight-bold">Not Inserted Data:&nbsp;<span id="span_not_inserted_data"></span> </label>
                         </div>
                         <div id="" class="row mt-1">
                             <div class="col-sm-3 mt-1">
                                 <a href="" id="a_log_file">
                                     <div class="btn-group w-100">
                                         <span class="btn btn-primary  col btn-xs ">
                                             <i class="fas fa-download"></i>
                                             <span>Download Summary</span>
                                         </span>
                                     </div>
                                 </a>
                             </div>
                             <div class="col-sm-2 mt-1">
                                 <div class="btn-group w-100">
                                     <span id="btn_summary_back" class="btn btn-secondary  col btn-xs">
                                         <i class="fas fa-arrow-left"></i>
                                         <span>Back</span>
                                     </span>
                                 </div>
                             </div>
                         </div>
                     </div>

                     <div class="col-12" id="kb-file-dropzone-div">
                         <div class="form-group row mb-1">
                             <label for="" class="col-sm-12 pb-0 pt-1 col-form-label font-weight-bold">Spreadsheet file:</label>
                         </div>

                         <div class="card-body p-0">
                             <div id="ticket_actions" class="row">
                                 <div class="col-lg-3">
                                     <div class="btn-group w-100">
                                         <span class="btn btn-success  col btn-xs kb-modal-button">
                                             <i class="fas fa-plus"></i>
                                             <span>Browse/Drag File</span>
                                         </span>
                                     </div>
                                 </div>

                             </div>
                             <div class="table table-striped files" id="kb_modal_previews">
                                 <div id="kb_modal_template" class="row mt-2">
                                     <div class="col-auto p-0">
                                         <span class="preview"><img src="data:," alt="" data-dz-thumbnail /></span>
                                     </div>
                                     <div class="col d-flex align-items-center word-wrap">
                                         <p class="mb-0">
                                             <span class="lead text-md" data-dz-name></span>
                                             (<span data-dz-size></span>)
                                         </p>
                                         <strong class="error text-danger" data-dz-errormessage></strong>
                                     </div>
                                     <div class="col-6 d-flex align-items-center">
                                         <div class="progress progress-striped active w-100 my-2" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
                                             <div class="progress-bar progress-bar-success" style="width:0%;" data-dz-uploadprogress></div>
                                         </div>
                                     </div>
                                     <div class="col-auto d-flex align-items-center">
                                         <div class="btn-group">

                                             <button data-dz-remove class="btn btn-sm btn-danger delete">
                                                 <i class="fas fa-trash"></i>
                                                 <span>Remove</span>
                                             </button>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                         </div>

                         <button id="btn_import" type="submit" class="btn btn-primary btn-sm mt-2">Import</button>

                         <a href="<?= url('events.import.template') ?>" class="btn btn-primary btn-sm mt-2" role="button"> Template</a>

                         <button id="btn_import_back" class="btn btn-danger btn-sm mt-2">Back</button>
                     </div>

                 </div>
             </section>
             <!-- /.content -->
         </div>



         <div class="modal_container"></div>

         <!-- insert footer -->
         <?php self::render('common/footer'); ?>

         <!-- insert control sidebar -->
         <?php self::render('common/control_sidebar');  ?>

     </div>
     <!-- ./wrapper -->

     <!-- common sctipts -->
     <?php self::render('common/script');  ?>
     <!-- Dropzone -->
     <script src="<?= asset_version("/assets/core/plugins/dropzone/min/dropzone.min.js") ?>"></script>
     <!-- Tempusdominus Bootstrap 4 -->
     <script src="<?= asset_version("/assets/js/event/import.js") ?>"></script>

     <script>
         const event_id = <?= $id ?>;
         const import_uri = '<?= url('events.import.store') ?>';
         const users_uri = '<?= url('users') ?>';
         const events_uri = '<?= url('events.data') ?>' + event_id;
         const import_summary_download = '<?= url('users.import.download') ?>';
     </script>
     <script>
         const $btn_import = $('#btn_import');
         const $btn_import_back = $('#btn_import_back');

         // DROPZONE 2 START
         // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
         var kbNode = document.querySelector("#kb_modal_template")
         kbNode.id = ""
         var kbTemplate = kbNode.parentNode.innerHTML
         kbNode.parentNode.removeChild(kbNode)

         var kbDropzone = new Dropzone("#kb-file-dropzone-div", {
             removedfile: function(file) {
                 if (kbDropzone.getQueuedFiles().length === 0 && kbDropzone.getUploadingFiles().length === 0) {
                     btnImport(false)
                 }
                 var _ref;
                 return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
             },
             url: import_uri,
             paramName: "file",
             maxFilesize: 1024,
             maxFiles: 1,
             autoProcessQueue: false,
             acceptedFiles: '.xls, .csv, .xlsx',
             init: function() {
                 this.on('sending', function(file, xhr, formData) {
                     formData.append("dir", '/tmp');
                     formData.append("log_dir", '/import/users/logs');
                     formData.append("event_id", event_id);
                     formData.append("csrf_token", $("meta[name='csrf-token']").attr("content"));
                 });
                 this.on('addedfile', function(file) {
                     btnImport(true)
                 });
             },
             thumbnailWidth: 50,
             thumbnailHeight: 50,
             parallelUploads: 20,
             previewTemplate: kbTemplate,
             autoQueue: false, // Make sure the files aren't queued until manually added
             previewsContainer: "#kb_modal_previews", // Define the container to display the previews
             clickable: ".kb-modal-button" // Define the element that should be used as click trigger to select files.
         });

         function startUpload() {
             if (kbDropzone.getAcceptedFiles().length < 1) {
                 toastr.remove();
                 toastr.error("Please select file to be import.");
                 return false;
             }
             for (var i = 0; i < kbDropzone.getAcceptedFiles().length; i++) {
                 kbDropzone.processFile(kbDropzone.getAcceptedFiles()[i]);
             }
         }

         kbDropzone.on('success', function(file, result) {
             try {
                 if (kbDropzone.getQueuedFiles().length === 0 && kbDropzone.getUploadingFiles().length === 0) {
                     importDone(result);
                 }
             } catch (e) {
                 Log.d(e)
             }
         });


         function importDone(result) {
             //  refreshOrcrPlateTable();
             kbDropzone.removeAllFiles(true);

             if (result.status == "1") {
                 $('#span_total_data').text(result.total);
                 $('#span_inserted_data').text(result.inserted);
                 $('#span_not_inserted_data').text(result.not_inserted);

                 var a = document.getElementById('a_log_file'); //or grab it by tagname etc
                 a.href = import_summary_download + "?file=" + result.gen_file + "&name=" + result.orig_file;

                 $('#kb-file-dropzone-div').hide();
                 $('#error-report-div').hide();
                 $('#summary-report-div').show();

             } else {
                 $('#kb-file-dropzone-div').hide();
                 $('#error-report-div').show();
                 $('#summary-report-div').hide();
                 $('#span_msg_data').text(result.message);
             }

         }


         function btnImport(status) {
             if (status) {
                 $btn_import.prop('disabled', false);
                 $btn_import.on('click', function(evt) {
                     startUpload();
                 });
             } else {
                 $btn_import.prop('disabled', true);
                 $btn_import.off('click');
             }
         }

         $(function() {
             btnImport(false);
             $('#btn_summary_back,#btn_error_summary_back').on('click', function(evt) {
                 $('#summary-report-div').hide();
                 $('#error-report-div').hide();
                 $('#kb-file-dropzone-div').show();
             });

             $btn_import_back.on('click', function() {
                 window.location.href = events_uri;
             })
         });
     </script>
 </body>


 </html>