<?php
    $page_title = "Player List";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php self::render('common/meta'); ?>
    <!-- insert custom meta here -->
    <title><?= env('APP_NAME') ?></title>

    <?php self::render('common/css'); ?>

    <style>
        .mouse-over {
            cursor: pointer;
        }

        u:hover {
            color: blue;
            text-transform: uppercase;
        }

        .block-quote {
            margin-top: -10px;
            margin-bottom: -10px;
        }

        fieldset {
            margin-left: 2px;
            margin-right: 2px;
            padding-top: 0.35em;
            padding-bottom: 0.625em;
            padding-left: 0.75em;
            padding-right: 0.75em;
            border: 1px solid gray;
            border-radius: 3%;
        }

        legend {
            font-size: 16px;
            font-weight: bold;
            color: blue;
        }

        .compartment {
            margin-left: -5px;
            margin-right: -5px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm layout-footer-fixed">
    <div class="wrapper">

        <!-- insert preloader here -->
        <?php self::render('common/preloader'); ?>
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="/assets/core/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <!-- Bootstrap Table -->
        <link rel="stylesheet" href="/assets/core/plugins/bootstrap-table/css/bootstrap-table.min.css">

        <!-- insert header -->
        <?php self::render('common/header', get_defined_vars()); ?>

        <!-- insert sidebar -->
        <?php self::render('common/sidebar'); ?>

        <!-- Content Wrapper. Contains page content -->

        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="">
                <div class="container-fluid">
                    <div class="row mb-2">
                    </div>
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md">
                            <div id="" class="card card-primary">
                                <div class="card-body">
                                    <input type="hidden" name="csrf_token" id="csrf_token" value="<?= csrf_token(); ?>">
                                    <fieldset class="card card-primary card-outline compartment">
                                        <legend class="w-auto px-2">Player Information</legend>
                                    </fieldset>
                                    <fieldset class="card card-primary card-outline compartment">
                                        <legend class="w-auto px-2">Corporate Information</legend>
                                    </fieldset>
                                    <fieldset class="card card-primary card-outline compartment">
                                        <legend class="w-auto px-2">Other Information</legend>
                                    </fieldset>
                                    <hr><hr>
                                    <fieldset class="card card-primary card-outline compartment">
                                        <legend class="w-auto px-2">Contact Information</legend>
                                    </fieldset>
                                    <fieldset class="card card-primary card-outline compartment">
                                        <legend class="w-auto px-2">Assignments</legend>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>
            <!-- /.content -->
        </div>

        <!-- insert footer -->
        <?php self::render('common/footer'); ?>

        <!-- insert control sidebar -->
        <?php self::render('common/control_sidebar');  ?>
    </div>
    <!-- ./wrapper -->

    <!-- common scripts -->
    <?php self::render('common/script');  ?>

    <!-- CUSTOM SCRIPTS -->
    <!-- Bootstrap Switch -->
    <script src="/assets/core/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
    <!-- Bootstrap Table -->
    <script src="/assets/core/plugins/bootstrap-table/js/tableExport.min.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table.min.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table-en-US.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table-export.min.js"></script>

    <script src="/assets/js/configuration/configuration.js"></script>
</body>

</html>