<?php
    $page_title = "SMS Settings";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php self::render('common/meta'); ?>
    <!-- insert custom meta here -->
    <title><?= env('APP_NAME') ?></title>

    <?php self::render('common/css'); ?>

    <style>
        .mouse-over {
            cursor: pointer;
        }

        u:hover {
            color: blue;
            text-transform: uppercase;
        }

        .block-quote {
            margin-top: -10px;
            margin-bottom: -10px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm layout-footer-fixed">
    <div class="wrapper">

        <!-- insert preloader here -->
        <?php self::render('common/preloader'); ?>
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="/assets/core/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <!-- Bootstrap Table -->
        <link rel="stylesheet" href="/assets/core/plugins/bootstrap-table/css/bootstrap-table.min.css">

        <!-- insert header -->
        <?php self::render('common/header', get_defined_vars()); ?>

        <!-- insert sidebar -->
        <?php self::render('common/sidebar'); ?>

        <!-- Content Wrapper. Contains page content -->

        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="">
                <div class="container-fluid">
                    <div class="row mb-2">
                    </div>
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <section class="content-header">
                <div class="block-quote">
                    <blockquote>
                        <h5 class=""><i class="fas fa-info" style="color: black;"></i> <span style="color: black;">Note:</span></h5>
                        <ul class="mb-2">
                            <li>Maximum character is <strong>600</strong>.</li> 
                            <li>Character length of parameters <strong>may vary</strong> depending on parameters length.</li> 
                            <li>Be <strong>aware</strong> of available parameters.</li> 
                        </ul>
                    </blockquote>
                </div>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md">
                            <div id="" class="card card-primary">
                                <div class="card-body">
                                    <input type="hidden" name="csrf_token" id="csrf_token" value="<?= csrf_token(); ?>">
                                    <div class="form-group row my-1">
                                        <label class="col-sm-1 col-form-label">Type</label>
                                        <div class="col-sm-9">
                                            <select id="message-type" name="message-type" class="form-control form-control-sm report-field" style="width: 100%;">
                                                <!-- <option value="0" hidden selected disabled>-- SELECT TYPE --</option> -->
                                                <option value="1" selected>SMS reminder</option>
                                            </select>
                                        </div>
                                        <label class="col-sm-1 col-form-label">Status</label>
                                        <div class="col-sm-1">
                                            <div id="checkbox-status" class="form-group form-control-sm">
                                                <input type="checkbox" id="auto-txt-status-checkbox" name="auto-txt-status-checkbox" checked data-bootstrap-switch>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="div-remaining-days" class="form-group row my-1" hidden>
                                        <label class="col-sm-1 col-form-label mr-3">Remind in</label>
                                        <div id="days" class="row">
                                            
                                        </div>
                                        <label id="add-day" class="text-primary col-sm-1 col-form-label cursor-pointer"><u>Add</u></label>
                                    </div>
                                    <div class="form-group row my-1">
                                        <label  class="col-sm-1 col-form-label">Header</label>
                                        <div class="col-sm-11">
                                            <input class="form-control" placeholder="Type message header" id="message-header" name="message-header" >
                                        </div>
                                    </div>
                                    <div class="form-group row my-1">
                                        <label  class="col-sm-1 col-form-label">Body</label>
                                        <div class="col-sm-11">
                                            <textarea class="form-control" rows="10" placeholder="Type message body" id="message-body" name="message-body" ></textarea>
                                        </div>
                                    </div>
                                    <div class="form-group row my-1">
                                        <label  class="col-sm-1 col-form-label">Footer</label>
                                        <div class="col-sm-11">
                                            <textarea class="form-control" rows="3" placeholder="Type message footer" id="message-footer" name="message-footer" ></textarea>
                                        </div>
                                    </div>
                                    <div class="row float-right">
                                        <label id="exceed-character-warning" class="dropdown mx-0 my-0 text-danger" hidden>EXCEEDS MAX CHARACTERS</label>&nbsp;
                                        <label id="max-character-warning" class="dropdown mx-0 my-0 text-warning" hidden>MAX CHARACTER REACH!</label>&nbsp;
                                        <span id="character-count" class="dropdown mx-0 my-0">0</span>
                                        <span class="dropdown mx-0 my-0">/</span>
                                        <span id="page-count" class="dropdown mx-0 my-0">1</span>&nbsp;&nbsp;&nbsp;
                                    </div>
                                    <div class="row ml-1 mt-3">
                                        <div class="col">
                                            <div class="form-group my-0 mx-0">
                                                <div class="form-group dropdown-input mb-1">
                                                    <div class="row">
                                                        <label
                                                            class="dropdown mx-0 my-0">Message content parameters:
                                                        </label>
                                                    </div>
                                                    <div id="param-contact-person-1" class="row" hidden>
                                                        <label class="dropdown mx-0 my-0 text-danger">[contact1]</label>&nbsp;
                                                        <span>&nbsp;Contact Person 1</span>
                                                    </div>
                                                    <div id="param-contact-person-2" class="row" hidden>
                                                        <label class="dropdown mx-0 my-0 text-danger">[contact2]</label>&nbsp;
                                                        <span>&nbsp;Contact Person 2</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="col-12"> 
                                            <input type="submit" name="set" id="set" value="Save" class="btn btn-success btn-sm float-right">
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>
            <!-- /.content -->
        </div>

        <!-- insert footer -->
        <?php self::render('common/footer'); ?>

        <!-- insert control sidebar -->
        <?php self::render('common/control_sidebar');  ?>

    </div>
    <!-- ./wrapper -->

    <!-- common scripts -->
    <?php self::render('common/script');  ?>

    <!-- CUSTOM SCRIPTS -->
    <!-- Bootstrap Switch -->
    <script src="/assets/core/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
    <!-- Bootstrap Table -->
    <script src="/assets/core/plugins/bootstrap-table/js/tableExport.min.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table.min.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table-en-US.js"></script>
    <script src="/assets/core/plugins/bootstrap-table/js/bootstrap-table-export.min.js"></script>

    <script src="/assets/js/configuration/configuration.js"></script>
</body>

</html>