/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here

  var myList = null;
  var search_type_filter = [];
  const $eventForm = $("#EventForm");
  const $tableList = $("#tableList");

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        myList.search($("#txt_search").val()).draw();
      }, 500)
    );

    const search_type_default = "Name";
    const search_types = ["ID", "Name"];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        myList.draw(false);
        //  }
      });
    });

    // Delete a record
    $tableList.on("click", "td.table-action > a action-delete", function (e) {
      e.preventDefault();
    });

    var cols = [
      {
        title: "ID",
        data: "id",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "1%",
      },
      {
        title: "User",
        data: "target",
        className: "align-middle p-1 dt-left",
        orderable: true,
        width: "50%",
      },
      {
        title: "Mobile",
        data: "mobile",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
        render: function (data, type, row, meta) {
          return (
            `<a href="tel:` +
            row.mobile +
            `" style="cursor:pointer; text-decoration: underline;">` +
            row.mobile +
            `</a>`
          );
        },
      },
      {
        title: "Status",
        data: "response",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "5%",
        render: function (data, type, row, meta) {
          var progress = `<span class="text-sm badge badge-danger font-weight-normal">Failed</span>`;
          if (row.response == "1") {
            progress = `<span class="text-sm badge badge-success font-weight-normal">Success</span>`;
          }
          return progress;
        },
      },
    ];

    myList = $tableList.DataTable({
      //  fnInitComplete: function() {
      //      initActionRemove();
      //  },
      fnDrawCallback: function () {},
      //  columnDefs: [{
      //      width: 200,
      //      targets: 0
      //  }],
      /* Disable initial sort */
      order: [[1, "asc"]],
      retrieve: true,
      columns: cols,
      //  data: data,
      paging: true,
      lengthChange: false,
      searching: true,
      //  ordering: true,
      pageLength: 10,
      info: true,
      autoWidth: false,
      responsive: true,
      processing: true,
      fixedColumns: true,
      serverSide: true,
      //  ajax: "/admin/products/list",
      ajax: {
        url: sms_data_list_uri,
        data: function (d) {
          return $.extend({}, d, {
            search_type: search_type_filter,
            id: sms_id,
          });
        },
      },
      sDom: "lrtip",
    });
  }

  function getDataCount() {
    $.ajax({
      url: sms_data_status_count_uri,
      data: {
        id: sms_id,
        csrf_token: $("meta[name='csrf-token']").attr("content"),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {},
      success: function (result) {
        $("#span-success").text(result.success);
        $("#span-failed").text(result.failed);
      },

      error: function () {},
    });
  }

  $(function () {
    getDataCount();
    initList();
    $(document).on("click", ".dropdown-filter,.daterangepicker", function (e) {
      e.stopPropagation();
    });

    $("#reload-list").on("click", function () {
      myList.draw(false);
      getDataCount();
    });
    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });
  });
})();
