/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here

  var myList = null;
  var search_type_filter = [];
  var event_id = "";
  const $eventForm = $("#EventForm");
  const $tableList = $("#tableList");

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function initActionRemove() {
    myList.on("click", "[data-action-remove]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-remove]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      const id = data.id; //$(this).attr('data-action-remove');
      Swal.fire({
        title: "Are you sure, you want to remove this event?",
        text: "This action cannot be undone.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, remove it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_event_status_uri,
            data: {
              id: id,
              status: 0,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              toast("success", result.message);
              myList.draw(false);
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
    // });
  }
  function initActionUpdate() {
    myList.on("click", "[data-action-update]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-update]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      event_id = data.id; //$(this).attr('data-action-remove');

      $.ajax({
        url: fetch_event_uri,
        data: {
          id: event_id,
          csrf_token: $("meta[name='csrf-token']").attr("content"),
        },
        type: "POST",
        dataType: "json",
        beforeSend: function () {
          toast("info", "Fetching...");
        },
        success: function (result) {
          // console.log(result);
          toastr.remove();
          $eventForm.trigger("reset");

          $("#txt_name").val(result.name);
          $("#txt_event_date").val(result.date);
          $("#txt_description").val(result.description);

          $("#modal_event").modal("show");
        },
        error: function () {
          toast("error", "Error has occurred. Try again.");
        },
      });
    });
    // });
  }
  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        myList.search($("#txt_search").val()).draw();
      }, 500)
    );

    const search_type_default = "Name";
    const search_types = ["ID", "Name"];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        myList.draw(false);
        //  }
      });
    });

    // Delete a record
    $tableList.on("click", "td.table-action > a action-delete", function (e) {
      e.preventDefault();
    });

    var cols = [
      {
        title: "ID",
        data: "id",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "1%",
      },
      {
        title: "Name",
        data: "name",
        className: "align-middle p-1 dt-left",
        orderable: true,
        render: function (data, type, row, meta) {
          return (
            `<a href="` +
            row.id +
            `" style="cursor:pointer; text-decoration: underline;">` +
            row.name +
            `</a>`
          );
        },
        width: "20%",
      },
      {
        title: "Event Date",
        data: "date",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Joined",
        data: "joined",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "5%",
      },
      {
        title: "Action",
        data: null,
        orderable: false,
        width: "5%",
        className: "align-middle p-1 dt-center",
        render: function (data, type, row, meta) {
          return `
                   <div class="row justify-content-center">
                           <a data-action-update style="cursor:pointer;" class="m-1 btn btn-sm btn-primary btn-icon" title="Edit"><i class="fa fa-pen"></i></a> 
                           <a data-action-remove style="cursor:pointer;" class="m-1 btn btn-sm btn-danger btn-icon" title="Remove"><i class="fa fa-trash"></i></a>
                   </div>
                   `;
        },
      },
    ];

    myList = $tableList.DataTable({
      //  fnInitComplete: function() {
      //      initActionRemove();
      //  },
      fnDrawCallback: function () {},
      //  columnDefs: [{
      //      width: 200,
      //      targets: 0
      //  }],
      /* Disable initial sort */
      order: [[2, "desc"]],
      retrieve: true,
      columns: cols,
      //  data: data,
      paging: true,
      lengthChange: false,
      searching: true,
      //  ordering: true,
      pageLength: 10,
      info: true,
      autoWidth: false,
      responsive: true,
      processing: true,
      fixedColumns: true,
      serverSide: true,
      //  ajax: "/admin/products/list",
      ajax: {
        url: event_list_uri,
        data: function (d) {
          return $.extend({}, d, {
            search_type: search_type_filter,
          });
        },
      },
      sDom: "lrtip",
    });
  }

  function tableEvents() {
    initActionRemove();
    initActionUpdate();
  }
  $(function () {
    initList();
    tableEvents();
    $(document).on("click", ".dropdown-filter,.daterangepicker", function (e) {
      e.stopPropagation();
    });
    const $btn_create = $("#btn_create");
    $btn_create.on("click", function () {
      event_id = "";
      $eventForm.trigger("reset");
      $("#modal_event").modal("show");
    });

    $("#div_event_date").datetimepicker({
      format: "L",
    });
    $("[data-mask]").inputmask();

    $("#reload-list").on("click", function () {
      myList.draw(false);
    });
    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });

    $eventForm.validate({
      rules: {
        txt_name: {
          required: true,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $eventForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("event_id", event_id);
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_event_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");
              $("#modal_event").modal("hide");
              myList.draw(false);
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save").prop("disabled", false);
          },
        });
      },
    });
  });
})();
