/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here

  var myList = null;
  var search_type_filter = [];
  var user_id = "";
  const $UserForm = $("#UserForm");
  const $TeamForm = $("#TeamForm");
  const $AwardForm = $("#AwardForm");
  const $EventForm = $("#EventForm");
  const $tableList = $("#tableList");
  var create_from_mate = false;
  var save_close = false;
  
  

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }
  function initActionAttendance() {
    myList.on("click", "[data-action-attendance]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-attendance]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      // const id = myList.row(row).data().id; //$(this).attr('data-action-remove');
      Swal.fire({
        title: "Are you sure, you want to time in this player to this event?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_user_attendance_uri,
            data: {
              id: data.player_id,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              if (parseInt(result.status) === 1) {
                toast("success", result.message);
                myList.draw(false);
              } else {
                toast("error", result.message);
              }
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
    // });
  }

  function initActionRemoveAttendance() {
    myList.on("click", "[data-action-remove-attendance]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      Swal.fire({
        title:
          "Are you sure, you want to remove this player attendance to this event?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_user_attendance_uri,
            data: {
              id: data.player_id,
              remove: true,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              if (parseInt(result.status) === 1) {
                toast("success", result.message);
                myList.draw(false);
              } else {
                toast("error", result.message);
              }
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
  }
  function initActionRemove() {
    myList.on("click", "[data-action-remove]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }
      // });
      // $("[data-action-remove]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      // const id = myList.row(row).data().id; //$(this).attr('data-action-remove');
      Swal.fire({
        title: "Are you sure, you want to remove this player to this event?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, remove it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_user_event_status_uri,
            data: {
              id: data.player_id,
              status: 0,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              toast("success", result.message);
              myList.draw(false);
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
  }

  function eventFormStatus(status) {
    if (status) {
      $(
        "#EventForm :input:not(#user):not(.modal-cancel):not(.close):not(.btn_add_user)"
      ).prop("disabled", status);
    } else {
      $("#EventForm :input").prop("disabled", status);
    }
  }

  function resetPlayerForm() {
    $('select[name="mate"]').empty().trigger("change");
    $('select[name="team"]').empty().trigger("change");

    $("select[name='course'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='division'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='course_n'] option:first")
      .prop("selected", true)
      .trigger("change");

    $("select[name='flight_n'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_type'] option:first")
      .prop("selected", true)
      .trigger("change");
    $("select[name='registration_status'] option:first")
      .prop("selected", true)
      .trigger("change");
  }
  function initActionQr() {
    myList.on("click", "[data-action-qr]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-qr]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      user_id = data.id;
      $("#user_qr").text("QR Code: " + data.name);
      $("#modal_qr").modal("show");

      $(".modal-qr").attr(
        "src",
        user_qr_uri + "?id=" + user_id + "&event_id=" + id
      );
    });

    $("#modal_qr")
      .off("hidden.bs.modal")
      .on("hidden.bs.modal", function () {
        $(".modal-qr").removeAttr("src");
      });
    // });
  }
  function initActionEvent() {
    myList.on("click", "[data-action-event]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }
      // $("[data-action-event]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      user_id = data.id;
      $("#selected_user").text(data.name);

      $("select[name='user']")
        .empty()
        .append(new Option("selected", user_id, false, false))
        .trigger("change");

      $(".user_section").hide();

      $("#modal_event").modal("show");
    });
  }

  function initActionAward() {
    myList.on("click", "[data-action-award]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }
      user_id = data.id;
      $("#selected_user_award").text(data.name);
      claimCount();
      mulliganCount();

      $("#modal_award").modal("show");
    });
  }

  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        myList.search($("#txt_search").val()).draw();
      }, 500)
    );

    const search_type_default = "Name";
    const search_types = ["ID", "Name", "Email", "Mobile"];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        myList.draw(false);
        //  }
      });
    });

    // Delete a record
    $tableList.on("click", "td.table-action > a action-delete", function (e) {
      e.preventDefault();
    });

    var cols = [
      {
        title: "ID",
        data: "id",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "5%",
      },
      {
        title: "Name",
        data: "name",
        className: "align-middle p-1 dt-left",
        orderable: true,
        render: function (data, type, row, meta) {
          return (
            `<a data-action-qr style="color: #007bff; cursor:pointer; text-decoration: underline;">` +
            row.name +
            `</a>`
          );
        },
        width: "20%",
      },
      {
        title: "Mobile",
        data: "mobile",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
        render: function (data, type, row, meta) {
          return (
            `<a href="tel:` +
            row.mobile +
            `" style="cursor:pointer; text-decoration: underline;">` +
            row.mobile +
            `</a>`
          );
        },
      },
      {
        title: "Email",
        data: "email",
        className: "align-middle p-1 dt-center wrap",
        orderable: true,
        width: "15%",
        render: function (data, type, row, meta) {
          return (
            `<a href="mailto:` +
            row.email +
            `" style="cursor:pointer; text-decoration: underline;">` +
            row.email +
            `</a>`
          );
        },
      },
      {
        title: "Status",
        data: "registration_type",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
        render: function (data, type, row, meta) {
          var rendered_data = "";
          switch (row.registration_type) {
            case "invited":
              rendered_data = `<span class="text-sm badge badge-primary font-weight-normal">Invited</span>`;
              break;
            case "paid":
              rendered_data = `<span class="text-sm badge badge-success font-weight-normal">Paid</span>`;
              break;
            case "unpaid":
              rendered_data = `<span class="text-sm badge badge-danger font-weight-normal">Unpaid</span>`;
              break;
          }
          return rendered_data;
        },
      },
      {
        title: "Registration",
        data: "registration_status",
        className: "align-middle p-1 dt-center",
        orderable: true,
        render: function (data, type, row, meta) {
          var rendered_data = "";
          switch (row.registration_status) {
            case "unregistered":
              rendered_data = `<span class="text-sm badge badge-danger font-weight-normal">Unregistered</span>`;
              break;
            case "registered":
              rendered_data = `<span class="text-sm badge badge-success font-weight-normal">Registered</span>`;
              break;
          }
          return rendered_data;
        },
        width: "10%",
      },
      {
        title: "Date Added",
        data: "created_at",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
      },
      {
        title: "Time In",
        data: "attendance",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "10%",
        render: function (data, type, row, meta) {
          if (row.attendance) {
            return row.attendance;
          } else {
            return `<span data-action-attendance class="text-sm badge badge-primary font-weight-normal cursor-pointer">Time In</span>`;
          }
        },
      },
         {
        title: "Booth",
        data: "attendance",
        className: "align-middle p-1 dt-center " +klas,
        orderable: true,
        width: "10%",
        render: function (data, type, row, meta) {
         
            return `<a id="btn_booth" data-action-booth data-id=`+row.player_id+` class="btn btn-primary btn-sm mr-2" role="button"><i class="fas fa-box"></i> Booth</a>`;
       
        }
      },
      {
        title: "Action",
        data: null,
        orderable: false,
        width: "15%",
        className: "align-middle p-1 dt-center",
        render: function (data, type, row, meta) {
          return `
                   <div class="row justify-content-center">
                           <a data-action-award style="cursor:pointer;" class="text-white m-1 btn btn-sm btn-warning btn-icon" title="Mulligans and Awards"><i class="fa fa-award"></i></a> 
                           <a data-action-event style="cursor:pointer;" class="m-1 btn btn-sm btn-primary btn-icon" title="Edit"><i class="fa fa-pen"></i></a>
                           <a data-action-remove style="cursor:pointer;" class="m-1 btn btn-sm btn-danger btn-icon" title="Remove"><i class="fa fa-trash"></i></a>
                   </div>
                   `;
        },
      },
    ];

    myList = $tableList.DataTable({
      //  fnInitComplete: function() {
      //      initActionRemove();
      //  },
      fnDrawCallback: function () {
        dashboard();
      },
      //  columnDefs: [{
      //      width: 200,
      //      targets: 0
      //  }],
      /* Disable initial sort */
      order: [[1, "asc"]],
      retrieve: true,
      columns: cols,
      //  data: data,
      paging: true,
      lengthChange: false,
      searching: true,
      //  ordering: true,
      pageLength: 10,
      info: true,
      autoWidth: false,
      responsive: true,
      processing: true,
      fixedColumns: true,
      serverSide: true,
      //  ajax: "/admin/products/list",
      ajax: {
        url: list_uri,
        data: function (d) {
          return $.extend({}, d, {
            search_type: search_type_filter,
            id: id,
            course: $('select[name="filter_course"]').val(),
            division: $('select[name="filter_division"]').val(),
            course_n: $('select[name="filter_course_n"]').val(),
            flight_n: $('select[name="filter_flight_n"]').val(),
          });
        },
      },
      sDom: "lrtip",
    });
  }

  function tableEvents() {
    initActionAttendance();
    initActionRemoveAttendance();
    initActionRemove();
    initActionEvent();
    initActionAward();
    initActionQr();
  }

  function claimCount() {
    $.ajax({
      url: claim_count_uri,
      data: {
        player_id: user_id,
        event_id: id,
        csrf_token: $("meta[name='csrf-token']").attr("content"),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {
        $(".claim_counter").text("Loading...");
      },
      success: function (result) {
        $(".claim_counter").text(result.count);
      },
      error: function () {
        toast("error", "Error has occurred. Try again.");
      },
    });
  }

  function mulliganCount() {
    $.ajax({
      url: mulligan_count_uri,
      data: {
        player_id: user_id,
        event_id: id,
        csrf_token: $("meta[name='csrf-token']").attr("content"),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {
        $("#mulligan").val("Loading...");
      },
      success: function (result) {
        $("#mulligan").val(result.count);
      },
      error: function () {
        toast("error", "Error has occurred. Try again.");
      },
    });
  }

  function dashboard() {
    $.ajax({
      url: dashboard_uri,
      data: {
        csrf_token: $("meta[name='csrf-token']").attr("content"),
        course: $('select[name="filter_course"]').val(),
        division: $('select[name="filter_division"]').val(),
        course_n: $('select[name="filter_course_n"]').val(),
        flight_n: $('select[name="filter_flight_n"]').val(),
      },
      type: "POST",
      dataType: "json",
      beforeSend: function () {},
      success: function (result) {
        $.each(result.data, function (i, v) {
          // console.log(i);
          // console.log(v);
          $("#dash_" + i).text(v);
        });
      },
      error: function () {
        toast("error", "Error has occurred. Try again.");
      },
    });
  }

  $(function () {
    initList();
    tableEvents();

    $(
      'select[name="filter_division"],select[name="filter_course"],select[name="filter_course_n"],select[name="filter_flight_n"]'
    ).on("change", function (event) {
      myList.draw(false);
    });

    $('select[name="user"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search name.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: user_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            exclude_id: 0,
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('select[name="mate"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search name.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: user_mate_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            exclude_id: user_id,
            event_id: id,
            limit: 15,
            course: $('select[name="course_n"]').val(),
            flight: $('select[name="flight_n"]').val(),
            course_cat: $('select[name="course"]').val(),
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('select[name="team"]').select2({
      theme: "bootstrap4",
      language: {
        noResults: function () {
          return "Search team.";
        },
      },
      escapeMarkup: function (markup) {
        return markup;
      },
      placeholder: "Please Select",
      ajax: {
        url: team_options_uri,
        dataType: "json",
        delay: 250,
        data: function (data) {
          return {
            search: data.term,
            event_id: id,
            limit: 15,
          };
        },
        processResults: function (response) {
          return {
            results: response,
          };
        },
        cache: true,
      },
    });

    $('select[name="user"]').on("change", function (event) {
      resetPlayerForm();
      if (!isEmpty($(this).val()) && parseInt($(this).val())) {
        user_id = $(this).val();
        eventFormStatus(false);

        // fetch any existing player
        $.ajax({
          url: fetch_player_uri,
          data: {
            user_id: user_id,
            event_id: id,
            csrf_token: $("meta[name='csrf-token']").attr("content"),
          },
          type: "POST",
          dataType: "json",
          beforeSend: function () {},
          success: function (result) {
            if (result.length === 0) {
              return false;
            }
            if (result.team_id) {
              $("select[name='team']")
                .empty()
                .append(
                  new Option(result.team_name, result.team_id, false, false)
                )
                .trigger("change");
            }

            if (result.partner_id) {
              $("select[name='mate']")
                .empty()
                .append(
                  new Option(
                    result.partner_name,
                    result.partner_id,
                    false,
                    false
                  )
                )
                .trigger("change");
            }
            $("select[name='course']").val(result.course_id).trigger("change");
            $("select[name='division']")
              .val(result.division_id)
              .trigger("change");

            $("select[name='course_n']").val(result.course).trigger("change");
            $("select[name='flight_n']").val(result.flight).trigger("change");
            $("select[name='registration_type']")
              .val(result.registration_type)
              .trigger("change");
            $("select[name='registration_status']")
              .val(result.registration_status)
              .trigger("change");
          },
          error: function () {},
        });
      } else {
        eventFormStatus(true);
        // event_id = "";
      }
    });

    $("#btn_add_team").on("click", function () {
      $("input[name=team_name]").val("");
      $("#modal_team").modal("show");
      $("input[name=team_name]").trigger("focus");
    });

    $(document).on("click", ".dropdown-filter,.daterangepicker", function (e) {
      e.stopPropagation();
    });

    const $btn_add_mate = $("#btn_add_mate");
    $btn_add_mate.on("click", function () {
      create_from_mate = true;
      $UserForm.trigger("reset");
      $("#modal_user").modal("show");
      $("input[name=firstname]").trigger("focus");
    });

    const $btn_add_user = $("#btn_add_user");
    $btn_add_user.on("click", function () {
      create_from_mate = false;
      $UserForm.trigger("reset");
      $("#modal_user").modal("show");
      $("input[name=firstname]").trigger("focus");
    });

    const $btn_create = $("#btn_create");
    $btn_create.on("click", function () {
      $(".user_section").show();
      resetPlayerForm();
      $('select[name="user"]').empty().trigger("change");
      eventFormStatus(true);

      $("#modal_event").modal("show");
    });

    $("#div_event_date").datetimepicker({
      format: "L",
    });
    $("[data-mask]").inputmask();

    $("#reload-list").on("click", function () {
      myList.draw(false);
    });
    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });

    $TeamForm.validate({
      rules: {
        team_name: {
          required: true,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $TeamForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("event_id", id);
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_team_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_team").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              var newOption = new Option(
                result.name,
                result.team_id,
                false,
                false
              );
              $("select[name='team']")
                .empty()
                .append(newOption)
                .trigger("change");

              $("#modal_team").modal("hide");
            } else if (parseInt(result.status) === 2) {
              toastr.remove();
              toastr.error(result.message);
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_team").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_team").prop("disabled", false);
          },
        });
      },
    });
    $AwardForm.validate({
      rules: {
        mulligan: {
          digits: true,
          min: 1,
        },
      },
      messages: {
        mulligan: {
          min: "minimum is 1",
        },
      },
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $AwardForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("event_id", id);
        formData.append("player_id", user_id);
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: update_mulligan_count,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_award").prop("disabled", true);
            $("#btn_save_award_close").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              if (save_close) {
                save_close = false;
                $("#modal_award").modal("hide");
              }
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_award").prop("disabled", false);
            $("#btn_save_award_close").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_award").prop("disabled", false);
            $("#btn_save_award_close").prop("disabled", false);
          },
        });
      },
    });
    $UserForm.validate({
      rules: {
        firstname: {
          required: true,
        },
        lastname: {
          required: true,
        },
        email: {
          email: true,
        },
        mobile: {
          digits: true,
          minlength: 5,
        },
      },
      messages: {},
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $UserForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);

        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_users_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");
              $("#modal_user").modal("hide");
              if (create_from_mate) {
                $("select[name='mate']")
                  .empty()
                  .append(new Option(result.name, result.id, false, false))
                  .trigger("change");
              } else {
                $("select[name='user']")
                  .empty()
                  .append(new Option(result.name, result.id, false, false))
                  .trigger("change");
              }
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save").prop("disabled", false);
          },
        });
      },
    });

    $EventForm.validate({
      rules: {
        event: {
          required: true,
          min: 1,
        },
      },
      messages: {
        team: "This field is required.",
      },
      errorElement: "span",
      errorPlacement: function (error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight: function (element, errorClass, validClass) {
        $(element).addClass("is-invalid");
      },
      unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass("is-invalid");
      },
      submitHandler: function () {
        // check has selected type

        var $form = $EventForm[0];
        var formData = new FormData($form);
        // formData.append("add_anyway", orcr_plate_add_anyway);
        formData.append("user_id", user_id);
        formData.append(
          "csrf_token",
          $("meta[name='csrf-token']").attr("content")
        );

        $.ajax({
          url: create_add_to_evt_uri,
          data: formData,
          type: "POST",
          dataType: "json",
          contentType: false, // NEEDED, DON'T OMIT THIS (requires jQuery 1.6+)
          processData: false, // NEEDED, DON'T OMIT THIS
          beforeSend: function () {
            toastr.remove();
            toastr.info("Saving data.");
            $("#btn_save_event").prop("disabled", true);
          },
          success: function (result) {
            if (parseInt(result.status) === 1) {
              toastr.remove();
              toastr.success("Data successfully saved.");

              // var newOption = new Option(result.name, result.id, false, false);
              // $('select[name="team"]').empty().trigger("change");

              // $("select[name='team']").append(newOption).trigger("change");
              myList.draw(false);
              $("#modal_event").modal("hide");
            } else {
              toastr.remove();
              toastr.error(result.message);
            }
            $("#btn_save_event").prop("disabled", false);
          },
          error: function () {
            toastr.remove();
            toastr.error("Error has occurred. Try again.");

            $("#btn_save_event").prop("disabled", false);
          },
        });
      },
    });

    $("#btn_save_award_close").on("click", function () {
      save_close = true;
    });
    $("#btn_claim_gift").on("click", function () {
      Swal.fire({
        title: "Claim participant gift rewards?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, claim it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: create_user_reward,
            data: {
              player_id: user_id,
              event_id: id,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              if (parseInt(result.status) == 1) {
                toast("success", result.message);
                claimCount();
              } else {
                toast("error", result.message);
              }
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });

    $(".add_mulligan").on("click", function () {
      var mulligan = parseInt($("#mulligan").val()) || 0;
      mulligan += 1;
      $("#mulligan").val(mulligan);
    });

    $(".remove_mulligan").on("click", function () {
      var mulligan = parseInt($("#mulligan").val()) || 0;
      mulligan -= 1;
      $("#mulligan").val(mulligan);
    });
    $(".clear_mulligan").on("click", function () {
      $("#mulligan").val("");
    });

    $("#btn_save_qr").on("click", function () {
      saveAs($(".modal-qr").attr("src"), "" + user_id + "_" + id + ".png");
    });

    //comfig
    $(document).on("show.bs.modal", ".modal", function () {
      const zIndex = 1040 + 10 * $(".modal:visible").length;
      $(this).css("z-index", zIndex);
      setTimeout(() =>
        $(".modal-backdrop")
          .not(".modal-stack")
          .css("z-index", zIndex - 1)
          .addClass("modal-stack")
      );
    });
    $(document).on("select2:open", () => {
      document.querySelector(".select2-search__field").focus();
    });
  });
    
    // modify
      function initActionBooth() {
        myList.on("click", "[data-action-booth]", function () { 
            $("#modal_booth").modal("show");
            $.ajax({
                url: load_event_boot_uri,
                  data: {
                      player_id: $(this).data('id'),
                      event_id: id,
                      csrf_token: $("meta[name='csrf-token']").attr("content"),
                  },
                  type: "POST",
                  dataType: "json",
                  beforeSend: function () {
                      // toast("info", "Updating...");
                  },
                  success: function (result) { 
                      // console.log(result);
                      $("#booth_modal_body").empty();
                    
                      var spanBtn='';
                      var divBtn='';
                      var divClaim ='';
                      var lableClaimed = '';
                      $.each(result, function(i, v) {
                
                          let divRow = $('<div></div>').addClass('row');
                          let divTitle = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.boothName).css({
                                                                'font-weight': 'bold',            // Example CSS properties
                                                                'font-size': '20px'
                                                            });
                          if(v.claimed_date==null)
                          {
                            divClaim = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.claimed_date);
                            divBtn = $('<div></div>').addClass('col-md-4 col-sm-6');
                            spanBtn = $('<span></span>').addClass('btn btn-primary btn_claim').text("claim").attr('data-player',v.player_id).attr('data-boot', v.booth_id);
                            
                          }
                          else
                          {
                            lableClaimed =  $('<span></span>').addClass('text-success').text("Claimed");
                            divClaim = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.claimed_date);
                            divBtn = $('<div></div>').addClass('col-md-4 col-sm-6');
                            spanBtn = $('<span></span>').addClass('btn btn-info btn_remove_claim').text("remove").attr('data-player',v.player_id).attr('data-boot', v.booth_id);
                             $(divClaim).append('<br>',lableClaimed);
                          }
                          
    
                          
                        
                          let hr = $('<hr>');
    
                          $(divBtn).append(spanBtn);
                          $(divRow).append(divTitle, divClaim, divBtn);
                          $("#booth_modal_body").append(divRow,hr);
                      });
                  },
                  error: function () {
                      toast("error", "Error has occurred. Try again.");
                  },
              });
          });
      }
  
    function claimBoot(){
   
    $(document).on('click', '.btn_claim',  function(){
       let pid =$(this).data('player');
        Swal.fire({
        title: "Claim participant gift rewards?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, claim it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_user_bootClaim_uri,
            data: {
              player_id: $(this).data('player'),
              event_id: id,
              booth_id : $(this).data('boot'),
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              if (parseInt(result.status) == 1) {
                toast("success", result.message);
                refreshModalBooth(pid);
                // initActionBooth();
                // RemoveclaimBoot();
                
              } else {
                toast("error", result.message);
              }
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });//swal
    });
  }

  function RemoveclaimBoot(){
   
    $(document).on('click', '.btn_remove_claim',  function(){
       let pid =$(this).data('player');
        Swal.fire({
        title: "Are you sure, you want to remove?",
        text: "",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, remove it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: update_user_bootClaim_uri,
            data: {
              player_id: $(this).data('player'),
              event_id: id,
              booth_id : $(this).data('boot'),
              remove:true,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              if (parseInt(result.status) == 1) {
                toast("success", result.message);
                refreshModalBooth(pid);
                // initActionBooth();
                // claimBoot();
                
              } else {
                toast("error", result.message);
              }
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });//swal
    });
  }
  
    function refreshModalBooth(player_id) {
 
        $.ajax({
            url: load_event_boot_uri,
              data: {
                  player_id: player_id,
                  event_id: id,
                  csrf_token: $("meta[name='csrf-token']").attr("content"),
              },
              type: "POST",
              dataType: "json",
              beforeSend: function () {
                  // toast("info", "Updating...");
              },
              success: function (result) { 
                  // console.log(result);
                  $("#booth_modal_body").empty();
                
                  var spanBtn='';
                  var divBtn='';
                  var divClaim ='';
                  var lableClaimed = '';
                  $.each(result, function(i, v) {
              
                      let divRow = $('<div></div>').addClass('row');
                      let divTitle = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.boothName).css({
                                                            'font-weight': 'bold',           
                                                            'font-size': '20px'
                                                        });
                      if(v.claimed_date==null)
                      {
                        divClaim = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.claimed_date);
                        divBtn = $('<div></div>').addClass('col-md-4 col-sm-6');
                        spanBtn = $('<span></span>').addClass('btn btn-primary btn_claim').text("claim").attr('data-player',v.player_id).attr('data-boot', v.booth_id);
                        
                      }
                      else
                      {
                        lableClaimed =  $('<span></span>').addClass('text-success').text("Claimed");
                        divClaim = $('<div></div>').addClass('col-md-4 col-sm-6').text(v.claimed_date);
                        divBtn = $('<div></div>').addClass('col-md-4 col-sm-6');
                        spanBtn = $('<span></span>').addClass('btn btn-info btn_remove_claim').text("remove").attr('data-player',v.player_id).attr('data-boot', v.booth_id);
                         $(divClaim).append('<br>',lableClaimed);
                      }
                      
                      let hr = $('<hr>');

                      $(divBtn).append(spanBtn);
                      $(divRow).append(divTitle, divClaim, divBtn);
                      $("#booth_modal_body").append(divRow,hr);
                  });
              },
              error: function () {
                  toast("error", "Error has occurred. Try again.");
              },
          });
  }
  
    $(document).ready(function(){
    initActionBooth();
    claimBoot();
    RemoveclaimBoot();

     //modify
    // const $btn_booth = $("#btn_booth");
    // $btn_booth.on("click", function () { alert('fire')
    //   // $(".user_section").show();
    //   // resetPlayerForm();
    //   // $('select[name="user"]').empty().trigger("change");
    //   // eventFormStatus(true);

    //   $("#modal_booth").modal("show");
    // });
  });
  
})();
