/*
 * Author: Clarence A Andaya
 * Date: June 08 2022
 */

//Only const Variable Here
(function () {
  "use strict";
  //Logic,Variables, Functions Here

  var myList = null;
  var search_type_filter = [];
  const $tableList = $("#tableList");

  function delay(callback, ms) {
    var timer = 0;
    return function () {
      var context = this,
        args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
  }

  function initActionRemove() {
    myList.on("click", "[data-action-remove]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-remove]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      //  var data = myList.row(row).data().id;
      //  console.log(data);
      //  return false;
      const id = data.id; //$(this).attr('data-action-remove');
      Swal.fire({
        title: "Are you sure, you want to remove this admin?",
        text: "This action cannot be undone.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, remove it!",
        showClass: {
          backdrop: "swal2-noanimation", // disable backdrop animation
          popup: "", // disable popup animation
          icon: "", // disable icon animation
        },
        hideClass: {
          popup: "", // disable popup fade-out animation
        },
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: uri.remove,
            data: {
              id: id,
              csrf_token: $("meta[name='csrf-token']").attr("content"),
            },
            type: "POST",
            dataType: "json",
            beforeSend: function () {
              toast("info", "Updating...");
            },
            success: function (result) {
              toast("success", result.message);
              myList.draw(false);
            },
            error: function () {
              toast("error", "Error has occurred. Try again.");
            },
          });
        }
      });
    });
    // });
  }

  function initActionStatus() {
    myList.on("click", "[data-action-status]", function () {
      var data = myList.row(this).data();
      if (typeof data === "undefined" || data == null) {
        var row = $(this).closest("tr");
        data = myList.row(row).data();
      }

      // $("[data-action-status]").each(function () {
      //   $(this).on("click", function () {
      //     var row = $(this).closest("tr");
      const id = data.id;

      var status = 0;
      if ($(this).is(":checked")) {
        status = 1;
      } else {
        status = null;
      }

      // console.log(status);
      // return false;
      $.ajax({
        url: uri.status,
        data: {
          id: id,
          status: status,
          csrf_token: $("meta[name='csrf-token']").attr("content"),
        },
        type: "POST",
        dataType: "json",
        beforeSend: function () {
          toast("info", "Updating...");
        },
        success: function (result) {
          toastr.remove();
          // toast("success", result.message);
          // myList.draw(false);
        },
        error: function () {
          toast("error", "Error has occurred. Try again.");
        },
      });
    });
    // });
  }
  function initList() {
    //search
    $("#txt_search").on(
      "keyup",
      delay(function (e) {
        myList.search($("#txt_search").val()).draw();
      }, 500)
    );

    const search_type_default = "Description";
    const search_types = ["ID", "Description", "Device ID"];

    $.each(search_types, function (i, n) {
      $(".product-search-type").append(
        `<li class="dropdown-item cursor-pointer py-0"><span class="text-sm">` +
          n +
          `</span></li>`
      );
    });

    $(".product-search-type li").each(function () {
      if ($(this).text() == search_type_default) {
        $(this).removeClass("active").addClass("active");
        var active_items_arr = [];
        active_items_arr.push(search_type_default);
        search_type_filter = JSON.stringify(active_items_arr);
      }

      $(this).on("click", function () {
        //remove all selected menu
        $(".product-search-type")
          .find("li.active")
          .map(function () {
            $(this).removeClass("active");
          });

        $(this).toggleClass("active");

        var active_items = $(".product-search-type")
          .find("li.active")
          .map(function () {
            var item = {};
            // item.id = this.value;
            item.status = $(this).text();
            return item;
          });

        var active_items_arr = [];
        $.each(active_items, function (i, n) {
          active_items_arr.push(n.status);
        });

        search_type_filter = JSON.stringify(active_items_arr);
        //  refreshOrcrPlateTable();
        //  if ($('#txt_search').val() != '') {
        myList.draw(false);
        //  }
      });
    });

    // Delete a record
    $tableList.on("click", "td.table-action > a action-delete", function (e) {
      e.preventDefault();
    });

    var cols = [
      {
        title: "ID",
        data: "id",
        className: "align-middle p-1 dt-center",
        orderable: true,
        width: "1%",
      },
      {
        title: "Description",
        data: "description",
        className: "align-middle p-1 dt-left",
        orderable: true,

        width: "30%",
      },
      {
        title: "Device ID",
        data: "device_id",
        className: "align-middle p-1 dt-left",
        orderable: true,
        width: "30%",
      },
      {
        title: "Date Created",
        data: "created_at",
        className: "align-middle p-1 dt-left",
        orderable: true,
        width: "20%",
      },
      {
        title: "Status",
        data: null,
        orderable: false,
        width: "5%",
        className: "align-middle p-1 dt-center",
        render: function (data, type, row, meta) {
          var checked = "";
          if (row.status == 1) {
            checked = "checked";
          }
          return (
            `
                   <div class="row justify-content-center">
                   <input data-action-status  class="text-lg" type="checkbox" ` +
            checked +
            ` >
                   </div>
                   `
          );
        },
      },
      {
        title: "Action",
        data: null,
        orderable: false,
        width: "5%",
        className: "align-middle p-1 dt-center",
        render: function (data, type, row, meta) {
          return `
                   <div class="row justify-content-center">
                          <!-- <a data-action-update style="cursor:pointer;" class="m-1 btn btn-sm btn-primary btn-icon" title="Edit"><i class="fa fa-pen"></i></a> -->
                           <a data-action-remove style="cursor:pointer;" class="m-1 btn btn-sm btn-danger btn-icon" title="Remove"><i class="fa fa-trash"></i></a>
                   </div>
                   `;
        },
      },
    ];

    myList = $tableList.DataTable({
      //  fnInitComplete: function() {
      //      initActionRemove();
      //  },
      fnDrawCallback: function () {
        // tableEvents();
      },
      //  columnDefs: [{
      //      width: 200,
      //      targets: 0
      //  }],
      /* Disable initial sort */
      order: [[3, "desc"]],
      retrieve: true,
      columns: cols,
      //  data: data,
      paging: true,
      lengthChange: false,
      searching: true,
      //  ordering: true,
      pageLength: 10,
      info: true,
      autoWidth: false,
      responsive: true,
      processing: true,
      fixedColumns: true,
      serverSide: true,
      //  ajax: "/admin/products/list",
      ajax: {
        url: uri.list,
        data: function (d) {
          return $.extend({}, d, {
            search_type: search_type_filter,
          });
        },
      },
      sDom: "lrtip",
    });
  }

  function tableEvents() {
    initActionRemove();
    // initActionUpdate();
    initActionStatus();
  }
  $(function () {
    initList();
    tableEvents();
    $(document).on("click", ".dropdown-filter,.daterangepicker", function (e) {
      e.stopPropagation();
    });

    $("#reload-list").on("click", function () {
      myList.draw(false);
    });
    $("#filter-list").on("click", function () {
      $("#filter-list-section").toggleClass("hidden");
    });
  });
})();
