<?php
error_reporting(E_ALL);
// load composer dependencies
require_once __DIR__ . '/../vendor/autoload.php';
// Load Config
// require_once '../app/config.php';
// Load our helpers
require_once __DIR__ . '/../app/helpers.php';

use GO\Scheduler;

$dotenv = \Dotenv\Dotenv::createImmutable(dirname(__DIR__));
$dotenv->load();

date_default_timezone_set(env('APP_TIMEZONE'));


$scheduler = new Scheduler();
$scheduler_log_dir = __DIR__ . '/../public/' . env('APP_DISK') . '/logs/scheduler/';

if (!file_exists($scheduler_log_dir)) {
	mkdir($scheduler_log_dir, 0777, true);
}

// $scheduler->call(function () {
// 	echo "Execute time is " . date("h:i:sa") . "\n";
// 	$user = new \App\Models\User();
// 	$user_data = $user->getUser(array(1));
// 	print_r($user_data);
// })->output('scheduler.log')->everyMinute();

// $scheduler->call(function () {
// 	echo "The time is " . date("h:i:sa");
// })->output('scheduler1.log')->everyMinute(1);

$scheduler->call(function () {
	\App\Console\Commands\SmsInvitationCron::start();
})
	->output($scheduler_log_dir . 'SmsInvitationCron_' . date('m-d-Y_h_i_a') . '.log')
	->everyMinute();


$scheduler->call(function () {
	\App\Console\Commands\SmsQrCron::start();
})->output($scheduler_log_dir . 'SmsQrCron' . date('m-d-Y_h_i_a') . '.log')->everyMinute();

$scheduler->call(function () {
	\App\Console\Commands\SmsReminderCron::start();
})->output($scheduler_log_dir . 'SmsReminderCron' . date('m-d-Y_h_i_a') . '.log')->everyMinute();


$scheduler->run(); //live
// $scheduler->work(); //local
