<?php

namespace App\Utilities;

class Utility
{
    public static function alphaNumericOnly($data)
    {
        $str = preg_replace("/[^a-zA-Z0-9]+/", "", $data);
        // if (strlen($str) < 5) {
        //     return "";
        // }
        return $str;
    }

    public static function numericOnly($data)
    {
        return preg_replace("/[^0-9]/", "", $data);
    }

    public static function nullEmptyArray($array)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $array[$key]  =  self::nullEmptyArray($value);
            }
            if (empty($value) && !strlen($value)) {
                $array[$key] = NULL;
            }
        }

        return $array;
    }

    public static function emptyNullArray($array)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $array[$key]  =  self::emptyNullArray($value);
            }
            if ($value === null) {
                $array[$key] = "";
            }
        }

        return $array;
    }

    public static function toUpperCase($data)
    {
        if (empty($data)) {
            return null;
        }
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if (is_array($value)) {
                    $data[$key]  =  self::toUpperCase($value);
                } else {
                    $data[$key] = strtoupper(trim($data[$key]));
                }
            }
            return $data;
        } else {
            return strtoupper(trim($data));
        }
    }

    public static function includeFiles($directory)
    {
        if (is_dir($directory)) {
            $scan = scandir($directory);
            unset($scan[0], $scan[1]); //unset . and ..
            foreach ($scan as $file) {
                if (is_dir($directory . "/" . $file)) {
                    self::includeFiles($directory . "/" . $file);
                } else {
                    if (strpos($file, '.php') !== false) {
                        include_once($directory . "/" . $file);
                    }
                }
            }
        }
    }

    public static function numberFormat($number)
    {
        return number_format($number, 2, '.', ',');
    }

    public static function cleanString($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if (is_array($value)) {
                    $data[$key]  =  self::cleanString($value);
                } else {
                    $data[$key] = self::removeNonAscii(self::removeExtraSpace(trim($data[$key])));
                }
            }
            return $data;
        } else {
            return  self::removeNonAscii(self::removeExtraSpace(trim($data)));
        }
    }

    public static function removeNonAscii($string)
    {
        return preg_replace('/[^\r\n[:print:]]/', '', $string);
        // return  preg_replace('/[\x00-\x1F\x7F\xA0]/u', '', $string); bedt
        // return preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $string);
    }

    public static function removeExtraSpace($data)
    {
        // return  preg_replace('/\s+/', ' ', $data);
        return preg_replace('/\h+/', ' ', $data);
        // return preg_replace('/\x20+/', ' ', $data);
    }

    public static function fix_mobile_format($data)
    {
        if (strlen($data) < 5) {
            return "";
        }
        $final_data = "";
        //if area code equal to 639xx it will change to 09xxxxxxxxx
        if (substr($data, 0, 2) === "09") {
            $final_data = "9" . substr($data, 2, strlen($data));
        } else if (substr($data, 0, 3) === "639") {
            $final_data = "9" . substr($data, 3, strlen($data));
        } else if (substr($data, 0, 1) === "9" && strlen($data) == 10) {
            $final_data = "9" . substr($data, 1, strlen($data));
        } else {
            $final_data = $data;
        }

        //if number start with 09xxx, check the length, if length is not 11 return blank, if not 09xxx return it
        if (substr($final_data, 0, 1) === "9") {
            if (strlen($final_data) == 10) {
                return $final_data;
            } else {
                return (strlen($final_data) > 10) ? substr($final_data, 0, 10) : $final_data;
            }
        }
        return $data;
    }

    public static function remove_non_numeric($data)
    {
        return preg_replace("/[^0-9]/", "", $data);
    }

    public static function curl2($array_data)
    {
        // if (empty($array_data['uri'])) {
        //     return "No uri";
        // }
        $ch = \curl_init();
        curl_setopt($ch, CURLOPT_URL, $array_data['uri']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, empty($array_data['parameters']) ? null : $array_data['parameters']);
        if (!empty($array_data['header']) > 0) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $array_data['header']);
        }

        return curl_exec($ch);
    }

    public static function curl($array_data)
    {
        // if (empty($array_data['uri'])) {
        //     return "No uri";
        // }
        // $ch = \curl_init();
        // curl_setopt($ch, CURLOPT_URL, $array_data['uri']);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, empty($array_data['parameters']) ? null : $array_data['parameters']);
        // if (!empty($array_data['header']) > 0) {
        //     curl_setopt($ch, CURLOPT_HTTPHEADER, $array_data['header']);
        // }

        // return curl_exec($ch);
        // $nom = '09263266748';
        // exit;
        try {
                $mobile = $array_data['mobile'] ?? "";
                $message = $array_data['message'] ?? "";
                $ch = curl_init();
                $itexmo = array(
                'Email' => 'aendaya@autohubgroup.com', 
                'Password' => 'JRE@jre0911', 
                'ApiCode' => 'PR-AUTOH172111_IE74I', 
                'SenderId'=> 'AUTOHUB GRP',
                'Recipients' => [$mobile],
                'Message' => $message//$message
                );
                
                curl_setopt($ch, CURLOPT_URL,"https://api.itexmo.com/api/broadcast");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($itexmo));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                
                // curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
                // curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                
                $response = curl_exec($ch);
                if (curl_errno($ch)) {
                    $error_msg = curl_error($ch);
                    curl_close($ch);
                    return 'Curl error: ' . $error_msg;
                }
        
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
        
                if ($httpCode !== 200) {
                    return "HTTP Error: $httpCode - Response: $response";
                }
        
                return $response ?: "Empty response from API";
                
        
                
            }catch (Exception $ex){
                return $ex->getMessage();
                exit;
            }

    }


    public static function validateEmail($email)
    {
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return $email;
        } else {
            return null;
        }
    }
}
