<?php

namespace App\Utilities;

class Encrypt
{

    // public static function safe_b64encode($string = '')
    // {
    //     $data = base64_encode($string);
    //     $data = str_replace(['+', '/', '='], ['-', '_', ''], $data);
    //     return $data;
    // }

    // public static function safe_b64decode($string = '')
    // {
    //     $data = str_replace(['-', '_'], ['+', '/'], $string);
    //     $mod4 = strlen($data) % 4;
    //     if ($mod4) {
    //         $data .= substr('====', $mod4);
    //     }
    //     return base64_decode($data);
    // }

    // public static function encode($value = false)
    // {
    //     if (!$value) return false;
    //     $iv_size = openssl_cipher_iv_length('aes-256-cbc');
    //     $iv = openssl_random_pseudo_bytes($iv_size);
    //     $crypttext = openssl_encrypt($value, 'aes-256-cbc', env('APP_KEY'), OPENSSL_RAW_DATA, $iv);
    //     return self::safe_b64encode($iv . $crypttext);
    // }

    // public static function decode($value = false)
    // {
    //     if (!$value) return false;
    //     $crypttext = self::safe_b64decode($value);
    //     $iv_size = openssl_cipher_iv_length('aes-256-cbc');
    //     $iv = substr($crypttext, 0, $iv_size);
    //     $crypttext = substr($crypttext, $iv_size);
    //     if (!$crypttext) return false;
    //     $decrypttext = openssl_decrypt($crypttext, 'aes-256-cbc', env('APP_KEY'), OPENSSL_RAW_DATA, $iv);
    //     return rtrim($decrypttext);
    // }

    public static function safe_b64encode($string = '')
    {
        $data = base64_encode($string);
        $data = str_replace(['+', '/', '='], ['-', '_', ''], $data);
        return $data;
    }

    public static function safe_b64decode($string = '')
    {
        $data = str_replace(['-', '_'], ['+', '/'], $string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    private static function getKeyAndMethod()
    {
        $rawKey = env('APP_KEY');
        $keyLen = strlen($rawKey);

        if ($keyLen === 16) {
            // 16 bytes → AES-128
            return [$rawKey, 'aes-128-cbc'];
        } elseif ($keyLen === 32) {
            // 32 bytes → AES-256
            return [$rawKey, 'aes-256-cbc'];
        } else {
            // Any other length → expand to 32 bytes (AES-256)
            return [hash('sha256', $rawKey, true), 'aes-256-cbc'];
        }
    }

    public static function encode($value = false)
    {
        if (!$value) return false;
        [$key, $method] = self::getKeyAndMethod();

        $iv_size = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($iv_size);

        $crypttext = openssl_encrypt($value, $method, $key, OPENSSL_RAW_DATA, $iv);

        return self::safe_b64encode($iv . $crypttext);
    }

    public static function decode($value = false)
    {
        if (!$value) return false;
        [$key, $method] = self::getKeyAndMethod();

        $crypttext = self::safe_b64decode($value);
        $iv_size = openssl_cipher_iv_length($method);
        $iv = substr($crypttext, 0, $iv_size);
        $crypttext = substr($crypttext, $iv_size);
        if (!$crypttext) return false;

        $decrypttext = openssl_decrypt($crypttext, $method, $key, OPENSSL_RAW_DATA, $iv);

        return $decrypttext !== false ? rtrim($decrypttext) : false;
    }
}
